/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare;

import com.ibm.pdp.cobolcompare.CobolToken;
import com.ibm.pdp.cobolcompare.Word;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class DualCharWord
extends Word {
    protected int chr1chr0;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public DualCharWord(char chr0, char chr1) {
        this.chr1chr0 = chr1 << 16 | chr0;
    }

    @Override
    public int length() {
        return 2;
    }

    @Override
    public char firstChar() {
        return DualCharWord.char0(this.chr1chr0);
    }

    @Override
    public char lastChar() {
        return DualCharWord.char1(this.chr1chr0);
    }

    @Override
    public char[] chars() {
        return new char[]{DualCharWord.char0(this.chr1chr0), DualCharWord.char1(this.chr1chr0)};
    }

    @Override
    public boolean quoted() {
        return false;
    }

    @Override
    public boolean sameText(CobolToken token) {
        if (token.category == 1) {
            return false;
        }
        CharSequence text = token.text;
        if (token.category == 3) {
            return text.length() == 2 && DualCharWord.char0(this.chr1chr0) == text.charAt(0) && DualCharWord.char1(this.chr1chr0) == text.charAt(1);
        }
        return token.endIdx - token.beginIdx == 2 && DualCharWord.char0(this.chr1chr0) == text.charAt(token.beginIdx) && DualCharWord.char1(this.chr1chr0) == text.charAt(token.beginIdx + 1);
    }

    public int hashCode() {
        return DualCharWord.char0(this.chr1chr0) + 31 * DualCharWord.char1(this.chr1chr0);
    }

    public String toString() {
        return String.valueOf(new char[]{DualCharWord.char0(this.chr1chr0), DualCharWord.char1(this.chr1chr0)});
    }

    @Override
    public void serialize(XMLStreamWriter writer, int pos, int j) throws XMLStreamException {
        this.serialize(writer, "DUAL_CHAR_WORD", pos, j);
    }

    @Override
    protected void serialize(XMLStreamWriter writer, String type, int pos, int j) throws XMLStreamException {
        writer.writeStartElement(type);
        writer.writeAttribute("POS", pos + "," + j);
        writer.writeCharacters("" + this.firstChar() + this.lastChar());
        writer.writeEndElement();
        super.serialize(writer, type, pos, j);
    }

    protected static char char0(int char1char0) {
        return (char)(char1char0 & 0xFFFF);
    }

    protected static char char1(int char1char0) {
        return (char)(char1char0 >> 16);
    }
}

