/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare;

import com.ibm.pdp.cobolcompare.CobolToken;
import com.ibm.pdp.cobolcompare.SingleWordDeletion;
import com.ibm.pdp.cobolcompare.SingleWordInsertion;
import com.ibm.pdp.cobolcompare.SingleWordReplacement;
import com.ibm.pdp.cobolcompare.Word;
import com.ibm.pdp.cobolcompare.WordBank;
import com.ibm.pdp.cobolcompare.WordDeletion;
import com.ibm.pdp.cobolcompare.WordDifference;
import com.ibm.pdp.cobolcompare.WordInsertion;
import com.ibm.pdp.cobolcompare.WordReplacement;
import com.ibm.pdp.util.diff.DiffCursor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class DifferenceBank {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static boolean logComparisonTime = false;
    protected WordBank wordBank;
    protected WordDifference[] differences;
    protected int nbDifferences;
    protected int totalOccurrences;
    private int nbFiles;
    private int nbModifiedFiles;
    private int nbModifiedFilesWithFilter;
    private int nbDifferencesWithFilter;
    private FilteredTemplate[] filteredTemplates;
    private long comparisonTotalTime;
    private ArrayList<TimeForCobol> timesForCobol;
    private static int NB_TIME = 10;
    protected static final Comparator<WordDifference> OCCURENCE_COMPARATOR = new Comparator<WordDifference>(){

        @Override
        public int compare(WordDifference left, WordDifference right) {
            return left.occurrenceCount < right.occurrenceCount ? 1 : -1;
        }
    };

    public DifferenceBank() {
        this.wordBank = new WordBank();
        this.differences = new WordDifference[12];
        this.timesForCobol = new ArrayList(10);
    }

    public DifferenceBank(int nbDiffrences, int totalOccurences, int size) {
        this.nbDifferences = nbDiffrences;
        this.totalOccurrences = totalOccurences;
        this.differences = new WordDifference[size];
        this.timesForCobol = new ArrayList(10);
    }

    public void updateTimeForCobol(String cobolName, Long time) {
        if (!logComparisonTime) {
            return;
        }
        int i = 0;
        while (i < this.timesForCobol.size()) {
            TimeForCobol tfc = this.timesForCobol.get(i);
            if (tfc.getTime() < time) {
                TimeForCobol newTFC = new TimeForCobol(cobolName, time);
                this.timesForCobol.add(i, newTFC);
                if (this.timesForCobol.size() > NB_TIME) {
                    this.timesForCobol.remove(this.timesForCobol.size() - 1);
                }
                return;
            }
            ++i;
        }
        TimeForCobol newTFC = new TimeForCobol(cobolName, time);
        this.timesForCobol.add(newTFC);
        if (this.timesForCobol.size() > NB_TIME) {
            this.timesForCobol.remove(this.timesForCobol.size() - 1);
        }
    }

    public int size() {
        return this.nbDifferences;
    }

    public int occurrences() {
        return this.totalOccurrences;
    }

    public WordDifference getDifference(CobolToken[] refTokens, DiffCursor cursor, CobolToken[] modTokens) {
        int hash = DifferenceBank.differenceHashCode(refTokens, cursor, modTokens);
        int index = DifferenceBank.indexFromHash(hash, this.differences.length);
        WordDifference diff = this.differences[index];
        while (diff != null) {
            if (diff.sameAs(refTokens, cursor, modTokens)) {
                return diff;
            }
            diff = diff.next;
        }
        return null;
    }

    public long getComparisonTotalTime() {
        return this.comparisonTotalTime;
    }

    public void setComparisonTotalTime(long comparisonTotalTime) {
        this.comparisonTotalTime = comparisonTotalTime;
    }

    public ArrayList<TimeForCobol> getTimesForCobol() {
        return this.timesForCobol;
    }

    public void mergeWith(DifferenceBank otherDB) {
        this.setNbFiles(this.getNbFiles() + otherDB.getNbFiles());
        this.setNbModifiedFiles(this.getNbModifiedFiles() + otherDB.getNbModifiedFiles());
        this.setNbModifiedFilesWithFilter(this.getNbModifiedFilesWithFilter() + otherDB.getNbModifiedFilesWithFilter());
        this.wordBank.mergeWith(otherDB.wordBank);
        WordDifference[] otherWordDifferences = otherDB.differences;
        if (otherWordDifferences != null && otherWordDifferences.length != 0) {
            int i = 0;
            while (i < otherWordDifferences.length) {
                WordDifference otherDifference = otherWordDifferences[i];
                while (otherDifference != null) {
                    WordDifference nextDifference = otherDifference.next;
                    this.addDifference(otherDifference);
                    otherDifference = nextDifference;
                }
                ++i;
            }
        }
    }

    public boolean appendAllDifferences(CobolToken[] refTokens, DiffCursor cursor, CobolToken[] modTokens) {
        boolean modified = false;
        if (cursor.hasFoundDifference()) {
            modified |= this.appendDifference(refTokens, cursor, modTokens);
        }
        while (cursor.searchNextDifference()) {
            modified |= this.appendDifference(refTokens, cursor, modTokens);
        }
        return modified;
    }

    private void addDifference(WordDifference newDifference) {
        this.modifyAllWords(newDifference);
        int index = DifferenceBank.indexFromHash(newDifference.hashCode(), this.differences.length);
        WordDifference diff = this.differences[index];
        while (diff != null) {
            if (diff.sameDifference(newDifference)) {
                diff.occurrenceCount += newDifference.occurrenceCount;
                this.totalOccurrences += newDifference.occurrenceCount;
                return;
            }
            diff = diff.next;
        }
        this.totalOccurrences += newDifference.occurrenceCount;
        if (DifferenceBank.tableIsTooBig(this.nbDifferences, this.differences.length)) {
            this.resizeDifferencesTable(DifferenceBank.grow(this.differences.length));
            index = DifferenceBank.indexFromHash(newDifference.hashCode(), this.differences.length);
        }
        newDifference.next = this.differences[index];
        this.differences[index] = newDifference;
        newDifference.rank = this.nbDifferences++;
    }

    private void modifyAllWords(WordDifference newDifference) {
        if (newDifference == null) {
            return;
        }
        Word[] addedWords = newDifference.addedWords();
        int i = 0;
        while (i < addedWords.length) {
            Word sameWord = this.wordBank.getSameWord(addedWords[i]);
            if (sameWord == null) {
                throw new RuntimeException("This word does not exist in the word bank :" + addedWords[i]);
            }
            if (sameWord != addedWords[i]) {
                newDifference.changeAddedWord(i, sameWord);
            }
            ++i;
        }
        Word[] deletedWords = newDifference.deletedWords();
        int i2 = 0;
        while (i2 < deletedWords.length) {
            Word sameWord = this.wordBank.getSameWord(deletedWords[i2]);
            if (sameWord == null) {
                throw new RuntimeException("This word does not exist in the word bank :" + deletedWords[i2]);
            }
            if (sameWord != deletedWords[i2]) {
                newDifference.changeDeletedWord(i2, sameWord);
            }
            ++i2;
        }
    }

    public boolean appendDifference(CobolToken[] refTokens, DiffCursor cursor, CobolToken[] modTokens) {
        ++this.totalOccurrences;
        int hash = DifferenceBank.differenceHashCode(refTokens, cursor, modTokens);
        int index = DifferenceBank.indexFromHash(hash, this.differences.length);
        WordDifference diff = this.differences[index];
        while (diff != null) {
            if (diff.sameAs(refTokens, cursor, modTokens)) {
                ++diff.occurrenceCount;
                return false;
            }
            diff = diff.next;
        }
        if (DifferenceBank.tableIsTooBig(this.nbDifferences, this.differences.length)) {
            this.resizeDifferencesTable(DifferenceBank.grow(this.differences.length));
            index = DifferenceBank.indexFromHash(hash, this.differences.length);
        }
        WordDifference newDifference = this.newDifference(hash, refTokens, cursor, modTokens);
        newDifference.next = this.differences[index];
        this.differences[index] = newDifference;
        newDifference.occurrenceCount = 1;
        newDifference.rank = this.nbDifferences++;
        return true;
    }

    public void copyDifferencesTo(WordDifference[] array) {
        this.copyDifferencesTo(array, true);
    }

    public void copyDifferencesTo(WordDifference[] array, boolean modifyRanks) {
        TreeSet<WordDifference> sortedDifferences = new TreeSet<WordDifference>(OCCURENCE_COMPARATOR);
        int count = this.nbDifferences;
        int index = 0;
        while (count > 0) {
            WordDifference diff = this.differences[index];
            while (diff != null) {
                sortedDifferences.add(diff);
                --count;
                diff = diff.next;
            }
            ++index;
        }
        int rank = 0;
        for (WordDifference diff : sortedDifferences) {
            if (modifyRanks) {
                diff.rank = rank;
            }
            array[rank++] = diff;
        }
    }

    private static int differenceHashCode(CobolToken[] refTokens, DiffCursor cursor, CobolToken[] modTokens) {
        int hash = 0;
        int i = cursor.getReferenceBeginIndex();
        while (i < cursor.getReferenceEndIndex()) {
            hash += refTokens[i].hash;
            ++i;
        }
        i = cursor.getModifiedBeginIndex();
        while (i < cursor.getModifiedEndIndex()) {
            hash += modTokens[i].hash;
            ++i;
        }
        return hash;
    }

    private static int indexFromHash(int hash, int tableLength) {
        return (hash & Integer.MAX_VALUE) % tableLength;
    }

    private static boolean tableIsTooBig(int elementCount, int tableLength) {
        return elementCount * 3 > tableLength << 1;
    }

    private static int grow(int tableLength) {
        return 1 + tableLength << 1;
    }

    protected void resizeDifferencesTable(int newLength) {
        WordDifference[] table = this.differences;
        int length = table.length;
        WordDifference[] newTable = new WordDifference[newLength];
        int idx = 0;
        while (idx < length) {
            WordDifference diff = table[idx];
            while (diff != null) {
                WordDifference nextDifference = diff.next;
                int newIdx = DifferenceBank.indexFromHash(diff.hashCode(), newLength);
                diff.next = newTable[newIdx];
                newTable[newIdx] = diff;
                diff = nextDifference;
            }
            ++idx;
        }
        this.differences = newTable;
    }

    protected WordDifference newDifference(int hash, CobolToken[] refTokens, DiffCursor cursor, CobolToken[] modTokens) {
        int deletedCount = cursor.getReferenceEndIndex() - cursor.getReferenceBeginIndex();
        int addedCount = cursor.getModifiedEndIndex() - cursor.getModifiedBeginIndex();
        if (deletedCount == 0) {
            if (addedCount == 1) {
                Word insertedWord = this.registerToken(modTokens[cursor.getModifiedBeginIndex()]);
                return new SingleWordInsertion(insertedWord);
            }
            Word[] insertedWords = new Word[addedCount];
            int i = 0;
            while (i < addedCount) {
                insertedWords[i] = this.registerToken(modTokens[cursor.getModifiedBeginIndex() + i]);
                ++i;
            }
            return new WordInsertion(hash, insertedWords);
        }
        if (addedCount == 0) {
            if (deletedCount == 1) {
                Word deletedWord = this.registerToken(refTokens[cursor.getReferenceBeginIndex()]);
                return new SingleWordDeletion(deletedWord);
            }
            Word[] deletedWords = new Word[deletedCount];
            int i = 0;
            while (i < deletedCount) {
                deletedWords[i] = this.registerToken(refTokens[cursor.getReferenceBeginIndex() + i]);
                ++i;
            }
            return new WordDeletion(hash, deletedWords);
        }
        if (deletedCount == 1 && addedCount == 1) {
            Word deletedWord = this.registerToken(refTokens[cursor.getReferenceBeginIndex()]);
            Word addedWord = this.registerToken(modTokens[cursor.getModifiedBeginIndex()]);
            return new SingleWordReplacement(deletedWord, addedWord);
        }
        Word[] deletedWords = new Word[deletedCount];
        int i = 0;
        while (i < deletedCount) {
            deletedWords[i] = this.registerToken(refTokens[cursor.getReferenceBeginIndex() + i]);
            ++i;
        }
        Word[] addedWords = new Word[addedCount];
        int i2 = 0;
        while (i2 < addedCount) {
            addedWords[i2] = this.registerToken(modTokens[cursor.getModifiedBeginIndex() + i2]);
            ++i2;
        }
        return new WordReplacement(hash, deletedWords, addedWords);
    }

    protected Word registerToken(CobolToken token) {
        return this.wordBank.putWord(token);
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        if (this.wordBank != null) {
            writer.writeAttribute("NB_DIFFERENCES", "" + this.nbDifferences);
            writer.writeAttribute("NB_FILES", "" + this.nbFiles);
            writer.writeAttribute("NB_MODIF_FILES", "" + this.nbModifiedFiles);
            writer.writeAttribute("TOTAL_OCCURENCES", "" + this.totalOccurrences);
            writer.writeAttribute("HASH_ARRAY_SIZE", "" + this.differences.length);
            writer.writeAttribute("COMPARISON_TIME", "" + this.comparisonTotalTime);
            if (this.filteredTemplates != null && this.filteredTemplates.length != 0) {
                writer.writeAttribute("NB_MODIF_FILES_FILTERED", "" + this.nbModifiedFilesWithFilter);
                writer.writeAttribute("NB_DIFFERENCES_FILTERED", "" + this.nbDifferencesWithFilter);
            }
            for (TimeForCobol timeForCobol : this.timesForCobol) {
                if (timeForCobol == null) continue;
                timeForCobol.serialize(writer);
            }
            this.wordBank.serialize(writer);
            int i = 0;
            while (i < this.differences.length) {
                WordDifference diff = this.differences[i];
                if (diff != null) {
                    diff.serialize(writer, i, 0);
                }
                ++i;
            }
            if (this.filteredTemplates != null && this.filteredTemplates.length != 0) {
                writer.writeStartElement("FILTERED_TEMPLATES");
                FilteredTemplate[] filteredTemplateArray = this.filteredTemplates;
                int n = this.filteredTemplates.length;
                int n2 = 0;
                while (n2 < n) {
                    FilteredTemplate filteredTemplate = filteredTemplateArray[n2];
                    filteredTemplate.serialize(writer);
                    ++n2;
                }
                writer.writeEndElement();
            }
        }
    }

    public void deserialize(XMLStreamReader xmlReader, String differenceBankVersion) throws NumberFormatException, XMLStreamException {
        String localName = "";
        int hash = 0;
        int occurenceCount = 0;
        int rank = 0;
        int posArray = 0;
        int posLinked = 0;
        ArrayList<Word> insertedWordList = null;
        ArrayList<Word> deletedWordList = null;
        ArrayList<FilteredTemplate> filteredTemplates = null;
        String cobolName = null;
        long cobolComparisonTime = 0L;
        while (xmlReader.hasNext()) {
            int eventType = xmlReader.next();
            if (eventType == 1) {
                localName = xmlReader.getLocalName();
                if (localName.equalsIgnoreCase("WORD_BANK")) {
                    int nbWord = 0;
                    int arraySize = 0;
                    int nbOfAtt = xmlReader.getAttributeCount();
                    int i = 0;
                    while (i < nbOfAtt) {
                        String name = xmlReader.getAttributeLocalName(i);
                        String value = xmlReader.getAttributeValue(i);
                        if (name.equalsIgnoreCase("NB_WORD")) {
                            nbWord = Integer.parseInt(value);
                        }
                        if (name.equalsIgnoreCase("HASH_ARRAY_SIZE")) {
                            arraySize = Integer.parseInt(value);
                        }
                        ++i;
                    }
                    this.wordBank = new WordBank(nbWord, arraySize);
                    this.wordBank.deserialize(xmlReader, differenceBankVersion);
                    continue;
                }
                if (localName.equalsIgnoreCase("SINGLE_WORD_DELETION") || localName.equalsIgnoreCase("SINGLE_WORD_INSERTION") || localName.equalsIgnoreCase("SINGLE_WORD_REPLACMENT") || localName.equalsIgnoreCase("WORD_DELETION") || localName.equalsIgnoreCase("WORD_INSERTION") || localName.equalsIgnoreCase("WORD_REPLACEMENT")) {
                    int nbOfAtt = xmlReader.getAttributeCount();
                    int i = 0;
                    while (i < nbOfAtt) {
                        String name = xmlReader.getAttributeLocalName(i);
                        String value = xmlReader.getAttributeValue(i);
                        if (name.equalsIgnoreCase("HASH")) {
                            hash = Integer.parseInt(value);
                        } else if (name.equalsIgnoreCase("OCCURENCE_COUNT")) {
                            occurenceCount = Integer.parseInt(value);
                        } else if (name.equalsIgnoreCase("RANK")) {
                            rank = Integer.parseInt(value);
                        } else if (name.equalsIgnoreCase("POS")) {
                            int separatorIndex = value.indexOf(44);
                            posArray = Integer.parseInt(value.substring(0, separatorIndex));
                            posLinked = Integer.parseInt(value.substring(separatorIndex + 1));
                        }
                        ++i;
                    }
                    continue;
                }
                if (localName.equalsIgnoreCase("INSERTED_WORDS")) {
                    insertedWordList = this.deserializeWordList(xmlReader);
                    continue;
                }
                if (localName.equalsIgnoreCase("DELETED_WORDS")) {
                    deletedWordList = this.deserializeWordList(xmlReader);
                    continue;
                }
                if (localName.equalsIgnoreCase("COBOL_COMP_TIME")) {
                    int nbOfAtt = xmlReader.getAttributeCount();
                    int i = 0;
                    while (i < nbOfAtt) {
                        String name = xmlReader.getAttributeLocalName(i);
                        String value = xmlReader.getAttributeValue(i);
                        if (name.equalsIgnoreCase("NAME")) {
                            cobolName = value;
                        }
                        if (name.equalsIgnoreCase("TIME")) {
                            cobolComparisonTime = Long.parseLong(value);
                        }
                        ++i;
                    }
                    continue;
                }
                if (!localName.equalsIgnoreCase("FILTERED_TEMPLATE")) continue;
                int addedNB = 0;
                int deletedNB = 0;
                String added = null;
                String deleted = null;
                int nbOfAtt = xmlReader.getAttributeCount();
                int i = 0;
                while (i < nbOfAtt) {
                    String name = xmlReader.getAttributeLocalName(i);
                    String value = xmlReader.getAttributeValue(i);
                    if (name.equalsIgnoreCase("ADDED_NB")) {
                        addedNB = Integer.parseInt(value);
                    }
                    if (name.equalsIgnoreCase("DELETED_NB")) {
                        deletedNB = Integer.parseInt(value);
                    }
                    if (name.equalsIgnoreCase("ADDED")) {
                        added = value;
                    }
                    if (name.equalsIgnoreCase("DELETED")) {
                        deleted = value;
                    }
                    ++i;
                }
                FilteredTemplate ft = new FilteredTemplate(added, deleted, addedNB, deletedNB);
                if (filteredTemplates == null) {
                    filteredTemplates = new ArrayList<FilteredTemplate>();
                }
                filteredTemplates.add(ft);
                continue;
            }
            if (eventType != 2) continue;
            String qname = xmlReader.getName().getLocalPart();
            if (qname.equalsIgnoreCase("DIFFERENCE_BANK")) {
                return;
            }
            if (qname.equalsIgnoreCase("SINGLE_WORD_DELETION") || qname.equalsIgnoreCase("SINGLE_WORD_INSERTION") || qname.equalsIgnoreCase("SINGLE_WORD_REPLACMENT") || qname.equalsIgnoreCase("WORD_DELETION") || qname.equalsIgnoreCase("WORD_INSERTION") || qname.equalsIgnoreCase("WORD_REPLACEMENT")) {
                WordDifference wordDif;
                if (qname.equalsIgnoreCase("SINGLE_WORD_DELETION")) {
                    wordDif = new SingleWordDeletion((Word)deletedWordList.get(0));
                } else if (qname.equalsIgnoreCase("SINGLE_WORD_INSERTION")) {
                    wordDif = new SingleWordInsertion((Word)insertedWordList.get(0));
                } else if (qname.equalsIgnoreCase("SINGLE_WORD_REPLACMENT")) {
                    wordDif = new SingleWordReplacement((Word)deletedWordList.get(0), (Word)insertedWordList.get(0));
                } else if (qname.equalsIgnoreCase("WORD_DELETION")) {
                    Word[] deleted = deletedWordList.toArray(new Word[0]);
                    wordDif = new WordDeletion(hash, deleted);
                } else if (qname.equalsIgnoreCase("WORD_INSERTION")) {
                    Word[] inserted = insertedWordList.toArray(new Word[0]);
                    wordDif = new WordInsertion(hash, inserted);
                } else {
                    Word[] deleted = deletedWordList.toArray(new Word[0]);
                    Word[] inserted = insertedWordList.toArray(new Word[0]);
                    wordDif = new WordReplacement(hash, deleted, inserted);
                }
                wordDif.occurrenceCount = occurenceCount;
                wordDif.rank = rank;
                if (posLinked == 0) {
                    this.differences[posArray] = wordDif;
                    continue;
                }
                WordDifference reference = this.differences[posArray];
                while (posLinked > 1) {
                    reference = reference.next;
                    --posLinked;
                }
                reference.next = wordDif;
                continue;
            }
            if (qname.equalsIgnoreCase("COBOL_COMP_TIME")) {
                TimeForCobol tfc = new TimeForCobol(cobolName, cobolComparisonTime);
                this.getTimesForCobol().add(tfc);
                continue;
            }
            if (!qname.equalsIgnoreCase("FILTERED_TEMPLATES") || filteredTemplates == null || filteredTemplates.size() == 0) continue;
            FilteredTemplate[] ftArray = new FilteredTemplate[filteredTemplates.size()];
            ftArray = filteredTemplates.toArray(ftArray);
            this.setFilteredTemplates(ftArray);
        }
    }

    private ArrayList<Word> deserializeWordList(XMLStreamReader xmlReader) throws NumberFormatException, XMLStreamException {
        ArrayList<Word> result = new ArrayList<Word>();
        String localName = "";
        while (xmlReader.hasNext()) {
            String qname;
            int eventType = xmlReader.next();
            if (eventType == 1) {
                localName = xmlReader.getLocalName();
                if (!localName.equalsIgnoreCase("WORD_REFERENCE")) continue;
                int nbOfAtt = xmlReader.getAttributeCount();
                int i = 0;
                while (i < nbOfAtt) {
                    String name = xmlReader.getAttributeLocalName(i);
                    String value = xmlReader.getAttributeValue(i);
                    if (name.equalsIgnoreCase("POS")) {
                        int separatorIndex = value.indexOf(44);
                        int posArray = Integer.parseInt(value.substring(0, separatorIndex));
                        int posLinked = Integer.parseInt(value.substring(separatorIndex + 1));
                        Word word = this.wordBank.words[posArray];
                        while (posLinked != 0) {
                            word = word.next;
                            --posLinked;
                        }
                        result.add(word);
                    }
                    ++i;
                }
                continue;
            }
            if (eventType != 2 || !(qname = xmlReader.getName().getLocalPart()).equalsIgnoreCase("INSERTED_WORDS") && !qname.equalsIgnoreCase("DELETED_WORDS")) continue;
            return result;
        }
        return result;
    }

    public int getNbFiles() {
        return this.nbFiles;
    }

    public void setNbFiles(int nbFiles) {
        this.nbFiles = nbFiles;
    }

    public int getNbModifiedFiles() {
        return this.nbModifiedFiles;
    }

    public void setNbModifiedFiles(int nbModifiedFiles) {
        this.nbModifiedFiles = nbModifiedFiles;
    }

    public void setNbModifiedFilesWithFilter(int i) {
        this.nbModifiedFilesWithFilter = i;
    }

    public int getNbModifiedFilesWithFilter() {
        return this.nbModifiedFilesWithFilter;
    }

    public FilteredTemplate[] getFilteredTemplates() {
        return this.filteredTemplates;
    }

    public void setFilteredTemplates(FilteredTemplate[] filteredTemplates) {
        this.filteredTemplates = filteredTemplates;
    }

    public boolean isFilteredTemplate(WordDifference wordDiff, char quote) {
        if (this.filteredTemplates == null || this.filteredTemplates.length == 0) {
            return false;
        }
        FilteredTemplate[] filteredTemplateArray = this.filteredTemplates;
        int n = this.filteredTemplates.length;
        int n2 = 0;
        while (n2 < n) {
            FilteredTemplate filteredTemplate = filteredTemplateArray[n2];
            String deletedWordsString = null;
            String addedWordsString = null;
            if (filteredTemplate.hasIdenticalCountersTo(wordDiff)) {
                if (deletedWordsString == null) {
                    deletedWordsString = DifferenceBank.getStringForCSVFile(wordDiff.deletedWords(), quote);
                }
                if (deletedWordsString.equals(filteredTemplate._deleted)) {
                    if (addedWordsString == null) {
                        addedWordsString = DifferenceBank.getStringForCSVFile(wordDiff.addedWords(), quote);
                    }
                    if (addedWordsString.equals(filteredTemplate._added)) {
                        return true;
                    }
                }
            }
            ++n2;
        }
        return false;
    }

    public static String getStringForCSVFile(Word[] words, char quote) {
        if (words.length == 0) {
            return "";
        }
        int leftCut = 0;
        int nbChars = 0;
        while (leftCut < words.length) {
            if ((nbChars += 1 + words[leftCut++].length()) >= 80) break;
        }
        int rightCut = leftCut;
        nbChars = 0;
        int wordCount = leftCut;
        while (wordCount < words.length) {
            nbChars += 1 + words[wordCount].length();
            while (nbChars >= 80) {
                nbChars -= 1 + words[rightCut++].length();
            }
            ++wordCount;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(quote);
        DifferenceBank.appendTo(sb, "|", quote);
        if (leftCut + 1 >= words.length) {
            int i = 0;
            while (i < words.length - 1) {
                DifferenceBank.appendWord(sb, words[i], quote);
                DifferenceBank.appendTo(sb, ' ', quote);
                ++i;
            }
        } else {
            int i = 0;
            while (i < leftCut) {
                DifferenceBank.appendWord(sb, words[i], quote);
                DifferenceBank.appendTo(sb, ' ', quote);
                ++i;
            }
            DifferenceBank.appendTo(sb, " ...\n... ", quote);
            i = rightCut;
            while (i < words.length - 1) {
                DifferenceBank.appendWord(sb, words[i], quote);
                DifferenceBank.appendTo(sb, ' ', quote);
                ++i;
            }
        }
        DifferenceBank.appendWord(sb, words[words.length - 1], quote);
        DifferenceBank.appendTo(sb, '|', quote);
        sb.append(quote);
        return sb.toString();
    }

    private static void appendTo(StringBuilder sb, String textToAppend, char quote) {
        int beginIdx = 0;
        int endIdx = textToAppend.length();
        int nextIdx = DifferenceBank.findQuote(textToAppend, beginIdx, endIdx, quote);
        while (nextIdx < endIdx) {
            sb.append(textToAppend.subSequence(beginIdx, nextIdx));
            sb.append(quote);
            sb.append(quote);
            beginIdx = nextIdx + 1;
            nextIdx = DifferenceBank.findQuote(textToAppend, beginIdx, endIdx, quote);
        }
        sb.append(textToAppend.subSequence(beginIdx, nextIdx));
    }

    private static void appendTo(StringBuilder sb, char charToAppend, char quote) {
        if (charToAppend == quote) {
            sb.append(quote);
            sb.append(quote);
            return;
        }
        sb.append(charToAppend);
    }

    private static int findQuote(String str, int beginIdx, int endIdx, char quote) {
        while (beginIdx < endIdx) {
            if (str.charAt(beginIdx) == quote) break;
            ++beginIdx;
        }
        return beginIdx;
    }

    protected static StringBuilder appendWord(StringBuilder sb, Word word, char quote) {
        switch (word.length()) {
            case 1: {
                if (!word.quoted()) {
                    DifferenceBank.appendTo(sb, word.firstChar(), quote);
                    return sb;
                }
                DifferenceBank.appendTo(sb, '\'', quote);
                DifferenceBank.appendTo(sb, word.firstChar(), quote);
                DifferenceBank.appendTo(sb, '\'', quote);
                return sb;
            }
            case 2: {
                if (!word.quoted()) {
                    DifferenceBank.appendTo(sb, word.firstChar(), quote);
                    DifferenceBank.appendTo(sb, word.lastChar(), quote);
                    return sb;
                }
                DifferenceBank.appendTo(sb, '\'', quote);
                DifferenceBank.appendTo(sb, word.firstChar(), quote);
                DifferenceBank.appendTo(sb, word.lastChar(), quote);
                DifferenceBank.appendTo(sb, '\'', quote);
                return sb;
            }
        }
        if (!word.quoted()) {
            DifferenceBank.appendTo(sb, new String(word.chars()), quote);
            return sb;
        }
        DifferenceBank.appendTo(sb, '\'', quote);
        DifferenceBank.appendTo(sb, new String(word.chars()), quote);
        DifferenceBank.appendTo(sb, '\'', quote);
        return sb;
    }

    public int getNbDifferencesWithFilter() {
        return this.nbDifferencesWithFilter;
    }

    public void setNbDifferencesWithFilter(int nbDifferencesWithFilter) {
        this.nbDifferencesWithFilter = nbDifferencesWithFilter;
    }

    public static class FilteredTemplate {
        String _added;
        String _deleted;
        int _addedNumber;
        int _deletedNumber;

        public FilteredTemplate(String added, String deleted, int addedNumber, int deletedNumber) {
            this._added = added;
            this._deleted = deleted;
            this._addedNumber = addedNumber;
            this._deletedNumber = deletedNumber;
        }

        public String getAdded() {
            return this._added;
        }

        public void setAdded(String added) {
            this._added = added;
        }

        public int getAddedNumber() {
            return this._addedNumber;
        }

        public void set_addedNumber(int addedNumber) {
            this._addedNumber = addedNumber;
        }

        public int getDeletedNumber() {
            return this._deletedNumber;
        }

        public void set_deletedNumber(int deletedNumber) {
            this._deletedNumber = deletedNumber;
        }

        public void serialize(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeStartElement("FILTERED_TEMPLATE");
            writer.writeAttribute("ADDED_NB", "" + this._addedNumber);
            writer.writeAttribute("DELETED_NB", "" + this._deletedNumber);
            writer.writeAttribute("ADDED", this._added);
            writer.writeAttribute("DELETED", this._deleted);
            writer.writeEndElement();
        }

        public boolean hasIdenticalCountersTo(WordDifference wordDifference) {
            if (wordDifference == null) {
                return false;
            }
            int deletedWordsCount = wordDifference.deletedWordsCount();
            if (deletedWordsCount != this._deletedNumber) {
                return false;
            }
            int addedWordsCount = wordDifference.addedWordsCount();
            return addedWordsCount == this._addedNumber;
        }
    }

    public static class TimeForCobol {
        String _cobolName;
        long _time;

        public TimeForCobol(String name, long time) {
            this._cobolName = name;
            this._time = time;
        }

        public void serialize(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeStartElement("COBOL_COMP_TIME");
            writer.writeAttribute("NAME", this._cobolName);
            writer.writeAttribute("TIME", "" + this._time);
            writer.writeEndElement();
        }

        public String getCobolName() {
            return this._cobolName;
        }

        public long getTime() {
            return this._time;
        }
    }
}

