/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare;

import com.ibm.pdp.cobolcompare.CobolToken;
import com.ibm.pdp.cobolcompare.DifferenceBank;
import com.ibm.pdp.cobolcompare.PacbaseCobolDifferencer;
import com.ibm.pdp.cobolcompare.WordDifference;
import com.ibm.pdp.util.Strings;
import com.ibm.pdp.util.Util;
import com.ibm.pdp.util.diff.DiffCursor;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Formatter;
import java.util.HashMap;

public class DiffPlus {
    protected static final boolean LINES_DIFF = true;
    protected static final DifferenceBank diffBank = new DifferenceBank();
    protected static final FileFilter CBL_FILE = new FileFilter(){

        @Override
        public boolean accept(File path) {
            return !path.isDirectory();
        }
    };
    protected static final FileFilter DIRECTORY = new FileFilter(){

        @Override
        public boolean accept(File path) {
            return path.isDirectory();
        }
    };
    protected static Formatter fmt;
    protected static Formatter fmtOverview;
    protected static Formatter fmtTemplates;
    protected static Formatter fmtDiffList;
    protected static final CobolToken PROCEDURE_TOKEN;
    protected static final CobolToken DIVISION_TOKEN;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        fmtOverview = fmt = new Formatter(System.out);
        fmtTemplates = fmt;
        fmtDiffList = fmt;
        PROCEDURE_TOKEN = new CobolToken(1, "PROCEDURE");
        DIVISION_TOKEN = new CobolToken(1, "DIVISION");
    }

    public static void main(String[] args) {
        try {
            String rightFileOrDir;
            String leftFileOrDir;
            String resultDir = null;
            switch (args.length) {
                case 3: {
                    resultDir = args[2];
                }
                case 2: {
                    leftFileOrDir = args[0];
                    rightFileOrDir = args[1];
                    break;
                }
                default: {
                    fmt.format("Usage: DiffPlus LeftFileOrDirectory RightFileOrDirectory [ResultDirectory]", new Object[0]);
                    return;
                }
            }
            File left = new File(leftFileOrDir);
            if (!left.exists()) {
                throw new RuntimeException("File or directory " + leftFileOrDir + " doesn't exist");
            }
            File right = new File(rightFileOrDir);
            if (!right.exists()) {
                throw new RuntimeException("File or directory " + rightFileOrDir + " doesn't exist");
            }
            if (resultDir != null) {
                try {
                    String messageFilename = String.valueOf(resultDir) + "\\Messages.txt";
                    fmt = new Formatter(messageFilename);
                    String overviewFilename = String.valueOf(resultDir) + "\\Overview.txt";
                    fmtOverview = new Formatter(overviewFilename);
                    String templatesFilename = String.valueOf(resultDir) + "\\Templates.txt";
                    fmtTemplates = new Formatter(templatesFilename);
                    String diffListFilename = String.valueOf(resultDir) + "\\DiffList.txt";
                    fmtDiffList = new Formatter(diffListFilename);
                }
                catch (FileNotFoundException fnfe) {
                    throw Util.rethrow((Throwable)fnfe);
                }
            }
            DiffPlus.extractTemplates(left, right);
            DiffPlus.diff(left, right);
            fmt.close();
            fmtOverview.close();
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            fmt.format("%s", sw.toString());
        }
    }

    protected static void diff(File left, File right) {
        boolean dir = left.isDirectory();
        if (dir != right.isDirectory()) {
            throw new RuntimeException("Unable to compare a directory and a file: " + left.toString() + ", " + right.toString());
        }
        if (dir) {
            String commonPath = DiffPlus.extractCommonPath(left, right);
            fmtDiffList.format("Root directory = %s\n", commonPath);
            fmtDiffList.format("Left = %s\n", left.toString().substring(commonPath.length()));
            fmtDiffList.format("Right = %s\n", right.toString().substring(commonPath.length()));
            if (fmtOverview != fmtDiffList) {
                fmtOverview.format("Root directory = %s\n", commonPath);
                fmtOverview.format("Left = %s\n", left.toString().substring(commonPath.length()));
                fmtOverview.format("Right = %s\n", right.toString().substring(commonPath.length()));
            }
            DiffPlus.directoryDiff(commonPath.length(), left, right, CBL_FILE);
        } else {
            DiffPlus.fileDiff(0, left, right);
        }
        fmtDiffList.close();
        if (fmtOverview != fmtDiffList) {
            fmtOverview.close();
        }
    }

    protected static void extractTemplates(File left, File right) {
        boolean dir = left.isDirectory();
        if (dir != right.isDirectory()) {
            throw new RuntimeException("Unable to compare a directory and a file: " + left.toString() + ", " + right.toString());
        }
        if (dir) {
            DiffPlus.directoryExtractTemplates(left, right, CBL_FILE);
        } else {
            DiffPlus.fileExtractTemplates(left, right);
        }
        fmtTemplates.format("Number of templates=%d\n", diffBank.size());
        fmtTemplates.format("Number of occurrences=%d\n", diffBank.occurrences());
        WordDifference[] differences = new WordDifference[diffBank.size()];
        diffBank.copyDifferencesTo(differences);
        WordDifference[] wordDifferenceArray = differences;
        int n = differences.length;
        int n2 = 0;
        while (n2 < n) {
            WordDifference diff = wordDifferenceArray[n2];
            fmtTemplates.format("%s\n", "--------------------------------------------------------------------");
            fmtTemplates.format("%s\n", diff.toString());
            ++n2;
        }
        fmtTemplates.close();
    }

    protected static void directoryExtractTemplates(File leftDir, File rightDir, FileFilter filter) {
        DiffPlus.filesExtractTemplates(leftDir, rightDir, filter);
        HashMap<String, File> leftSubDirectoriesByName = DiffPlus.filesByName(leftDir, DIRECTORY);
        File[] fileArray = rightDir.listFiles(DIRECTORY);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File rightSubDir = fileArray[n2];
            File leftSubDir = leftSubDirectoriesByName.get(rightSubDir.getName());
            if (leftSubDir != null) {
                DiffPlus.directoryExtractTemplates(leftSubDir, rightSubDir, filter);
            }
            ++n2;
        }
    }

    protected static void filesExtractTemplates(File leftDir, File rightDir, FileFilter filter) {
        HashMap<String, File> leftFilesByName = DiffPlus.filesByName(leftDir, filter);
        File[] fileArray = rightDir.listFiles(filter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File rightFile = fileArray[n2];
            File leftFile = leftFilesByName.get(rightFile.getName());
            if (leftFile != null) {
                DiffPlus.fileExtractTemplates(leftFile, rightFile);
            }
            ++n2;
        }
    }

    protected static void fileExtractTemplates(File left, File right) {
        String leftCobol = Strings.fileToString((File)left);
        String rightCobol = Strings.fileToString((File)right);
        PacbaseCobolDifferencer differencer = new PacbaseCobolDifferencer(leftCobol, rightCobol);
        DiffCursor cursor = differencer.newTokenDifferencesCursor();
        diffBank.appendAllDifferences(differencer.getReferenceTokens(), cursor, differencer.getModifiedTokens());
    }

    protected static String extractCommonPath(File left, File right) {
        String leftStr = left.toString();
        String rightStr = right.toString();
        int max = Math.min(leftStr.length(), rightStr.length());
        int i = 0;
        while (i < max) {
            if (leftStr.charAt(i) != rightStr.charAt(i)) break;
            ++i;
        }
        while (--i >= 0) {
            char c = leftStr.charAt(i);
            if (c == '/' || c == '\\') break;
        }
        return leftStr.substring(0, i);
    }

    protected static void directoryDiff(int commonPathLength, File leftDir, File rightDir, FileFilter filter) {
        DiffPlus.filesDiff(commonPathLength, leftDir, rightDir, filter);
        HashMap<String, File> leftSubDirectoriesByName = DiffPlus.filesByName(leftDir, DIRECTORY);
        File[] fileArray = rightDir.listFiles(DIRECTORY);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File rightSubDir = fileArray[n2];
            File leftSubDir = leftSubDirectoriesByName.get(rightSubDir.getName());
            if (leftSubDir != null) {
                DiffPlus.directoryDiff(commonPathLength, leftSubDir, rightSubDir, filter);
            }
            ++n2;
        }
    }

    protected static void filesDiff(int commonPathLength, File leftDir, File rightDir, FileFilter filter) {
        HashMap<String, File> leftFilesByName = DiffPlus.filesByName(leftDir, filter);
        File[] fileArray = rightDir.listFiles(filter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File rightFile = fileArray[n2];
            File leftFile = leftFilesByName.get(rightFile.getName());
            if (leftFile != null) {
                DiffPlus.fileDiff(commonPathLength, leftFile, rightFile);
            }
            ++n2;
        }
    }

    protected static HashMap<String, File> filesByName(File directory, FileFilter filter) {
        File[] files = directory.listFiles(filter);
        HashMap<String, File> filesByName = new HashMap<String, File>(files.length << 1);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            filesByName.put(file.getName(), file);
            ++n2;
        }
        return filesByName;
    }

    protected static void fileDiff(int commonPathLength, File left, File right) {
        fmtDiffList.format("\n********** %s <==> %s **********\n", left.toString().substring(commonPathLength), right.toString().substring(commonPathLength));
        if (fmtOverview != fmtDiffList) {
            fmtOverview.format("* %s <==> %s ", left.toString().substring(commonPathLength), right.toString().substring(commonPathLength));
        }
        String leftCobol = Strings.fileToString((File)left);
        String rightCobol = Strings.fileToString((File)right);
        PacbaseCobolDifferencer differencer = new PacbaseCobolDifferencer(leftCobol, rightCobol);
        int procedureDivisionFirstTokenRank = DiffPlus.procedureDivisionFirstTokenRank(differencer);
        DiffCursor cursor = differencer.newTokenDifferencesCursor();
        int diffCount = 0;
        int procedureDiffCount = 0;
        while (cursor.searchNextDifference()) {
            if (cursor.getReferenceEndIndex() >= procedureDivisionFirstTokenRank) {
                ++procedureDiffCount;
            }
            DiffPlus.showTokenDifference(++diffCount, differencer, cursor);
        }
        if (diffCount == 0) {
            fmtDiffList.format("= No real difference\n", new Object[0]);
        } else {
            fmtDiffList.format("= %d real differences, %d in procedure division\n", diffCount, procedureDiffCount);
        }
        if (fmtOverview != fmtDiffList) {
            if (diffCount == 0) {
                fmtOverview.format(" = No real difference\n", new Object[0]);
            } else {
                fmtOverview.format(" = %d real differences, %d in procedure division\n", diffCount, procedureDiffCount);
            }
        }
    }

    protected static int procedureDivisionFirstTokenRank(PacbaseCobolDifferencer differencer) {
        CobolToken[] refTokens = differencer.getReferenceTokens();
        int rank = 0;
        int max = refTokens.length - 1;
        while (rank < max) {
            if (refTokens[rank].equals(PROCEDURE_TOKEN) && refTokens[rank + 1].equals(DIVISION_TOKEN)) {
                return rank + 2;
            }
            ++rank;
        }
        return refTokens.length;
    }

    protected static void showTokenDifference(int count, PacbaseCobolDifferencer differencer, DiffCursor cursor) {
        String leftCobol = differencer.getReferenceCobol();
        int[] leftLineStartIndex = differencer.getReferenceLineIndexes();
        CobolToken[] leftTokens = differencer.getReferenceTokens();
        String rightCobol = differencer.getModifiedCobol();
        int[] rightLineStartIndex = differencer.getModifiedLineIndexes();
        CobolToken[] rightTokens = differencer.getModifiedTokens();
        WordDifference template = diffBank.getDifference(leftTokens, cursor, rightTokens);
        if (template != null) {
            fmtDiffList.format("---------------------------------- %d = Template#%d ----------------------------------\n", count, template.getRank());
        } else {
            fmtDiffList.format("----------------------------------------- %d -----------------------------------------\n", count);
        }
        int leftBeginLineRank = DiffPlus.refBeginLineRank(differencer, cursor);
        int leftEndLineRank = DiffPlus.refEndLineRank(differencer, cursor);
        int rightBeginLineRank = DiffPlus.modBeginLineRank(differencer, cursor);
        int rightEndLineRank = DiffPlus.modEndLineRank(differencer, cursor);
        int leftBeginIdx = DiffPlus.beginingOfLine(leftCobol, leftLineStartIndex, leftBeginLineRank);
        int leftEndIdx = DiffPlus.endOfLine(leftCobol, leftLineStartIndex, leftEndLineRank);
        int rightBeginIdx = DiffPlus.beginingOfLine(rightCobol, rightLineStartIndex, rightBeginLineRank);
        int rightEndIdx = DiffPlus.endOfLine(rightCobol, rightLineStartIndex, rightEndLineRank);
        fmtDiffList.format("<Left[%d,%d]\n", 1 + leftBeginLineRank, 1 + leftEndLineRank);
        fmtDiffList.format("%s\n", leftCobol.substring(leftBeginIdx, leftEndIdx));
        fmtDiffList.format(">Right[%d,%d]\n", 1 + rightBeginLineRank, 1 + rightEndLineRank);
        fmtDiffList.format("%s\n", rightCobol.substring(rightBeginIdx, rightEndIdx));
    }

    protected static int refBeginLineRank(PacbaseCobolDifferencer differencer, DiffCursor cursor) {
        int refBeginTokenRank = cursor.getReferenceBeginIndex();
        if (refBeginTokenRank == 0) {
            return 0;
        }
        int previousTokenEndIdx = differencer.getReferenceTokens()[refBeginTokenRank - 1].endIdx;
        return differencer.referenceLineRankFromCharIndex(previousTokenEndIdx);
    }

    protected static int refEndLineRank(PacbaseCobolDifferencer differencer, DiffCursor cursor) {
        CobolToken[] refTokens = differencer.getReferenceTokens();
        int refEndTokenRank = cursor.getReferenceEndIndex();
        if (refEndTokenRank == refTokens.length) {
            return differencer.getReferenceLineIndexes().length;
        }
        int nextTokenBeginIdx = refTokens[refEndTokenRank].beginIdx;
        return differencer.referenceLineRankFromCharIndex(nextTokenBeginIdx);
    }

    protected static int modBeginLineRank(PacbaseCobolDifferencer differencer, DiffCursor cursor) {
        int modBeginTokenRank = cursor.getModifiedBeginIndex();
        if (modBeginTokenRank == 0) {
            return 0;
        }
        int previousTokenEndIdx = differencer.getModifiedTokens()[modBeginTokenRank - 1].endIdx;
        return differencer.modifiedLineRankFromCharIndex(previousTokenEndIdx);
    }

    protected static int modEndLineRank(PacbaseCobolDifferencer differencer, DiffCursor cursor) {
        CobolToken[] modTokens = differencer.getModifiedTokens();
        int modEndTokenRank = cursor.getModifiedEndIndex();
        if (modEndTokenRank == modTokens.length) {
            return differencer.getModifiedLineIndexes().length;
        }
        int nextTokenBeginIdx = modTokens[modEndTokenRank].beginIdx;
        return differencer.modifiedLineRankFromCharIndex(nextTokenBeginIdx);
    }

    protected static int beginingOfLine(String cobol, int[] linesStartIndexes, int lineRank) {
        return linesStartIndexes[lineRank];
    }

    protected static int endOfLine(String cobol, int[] linesStartIndexes, int lineRank) {
        return lineRank >= linesStartIndexes.length - 1 ? cobol.length() : linesStartIndexes[lineRank + 1];
    }
}

