/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare;

import com.ibm.pdp.cobolcompare.CobolDifferencer;
import com.ibm.pdp.util.Strings;
import com.ibm.pdp.util.Util;
import com.ibm.pdp.util.diff.DiffCursor;
import com.ibm.pdp.util.diff.DifferenceNature;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.util.Formatter;
import java.util.HashMap;

public class Diff {
    protected static final boolean LINES_DIFF = true;
    protected static final FileFilter CBL_FILE = new FileFilter(){

        @Override
        public boolean accept(File path) {
            return !path.isDirectory();
        }
    };
    protected static final FileFilter DIRECTORY = new FileFilter(){

        @Override
        public boolean accept(File path) {
            return path.isDirectory();
        }
    };
    protected static Formatter fmt = new Formatter(System.out);
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static void main(String[] args) {
        String rightFileOrDir;
        String leftFileOrDir;
        String resultFile = null;
        switch (args.length) {
            case 3: {
                resultFile = args[2];
            }
            case 2: {
                leftFileOrDir = args[0];
                rightFileOrDir = args[1];
                break;
            }
            default: {
                fmt.format("Usage: Diff LeftFileOrDirectory RightFileOrDirectory [ResultFileName]", new Object[0]);
                return;
            }
        }
        File left = new File(leftFileOrDir);
        if (!left.exists()) {
            throw new RuntimeException("File or directory " + leftFileOrDir + " doesn't exist");
        }
        File right = new File(rightFileOrDir);
        if (!right.exists()) {
            throw new RuntimeException("File or directory " + rightFileOrDir + " doesn't exist");
        }
        if (resultFile != null) {
            try {
                fmt = new Formatter(resultFile);
            }
            catch (FileNotFoundException fnfe) {
                throw Util.rethrow((Throwable)fnfe);
            }
        }
        Diff.diff(left, right);
        fmt.close();
    }

    protected static void diff(File left, File right) {
        boolean dir = left.isDirectory();
        if (dir != right.isDirectory()) {
            throw new RuntimeException("Unable to compare a directory and a file: " + left.toString() + ", " + right.toString());
        }
        if (dir) {
            String commonPath = Diff.extractCommonPath(left, right);
            fmt.format("Root directory = %s\n", commonPath);
            Diff.directoryDiff(commonPath.length(), left, right, CBL_FILE);
        } else {
            Diff.fileDiff(0, left, right);
        }
    }

    protected static String extractCommonPath(File left, File right) {
        String leftStr = left.toString();
        String rightStr = right.toString();
        int max = Math.min(leftStr.length(), rightStr.length());
        int i = 0;
        while (i < max) {
            if (leftStr.charAt(i) != rightStr.charAt(i)) break;
            ++i;
        }
        while (--i >= 0) {
            char c = leftStr.charAt(i);
            if (c == '/' || c == '\\') break;
        }
        return leftStr.substring(0, i);
    }

    protected static void directoryDiff(int commonPathLength, File leftDir, File rightDir, FileFilter filter) {
        Diff.filesDiff(commonPathLength, leftDir, rightDir, filter);
        HashMap<String, File> leftSubDirectoriesByName = Diff.filesByName(leftDir, DIRECTORY);
        File[] fileArray = rightDir.listFiles(DIRECTORY);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File rightSubDir = fileArray[n2];
            File leftSubDir = leftSubDirectoriesByName.get(rightSubDir.getName());
            if (leftSubDir != null) {
                Diff.directoryDiff(commonPathLength, leftSubDir, rightSubDir, filter);
            }
            ++n2;
        }
    }

    protected static void filesDiff(int commonPathLength, File leftDir, File rightDir, FileFilter filter) {
        HashMap<String, File> leftFilesByName = Diff.filesByName(leftDir, filter);
        File[] fileArray = rightDir.listFiles(filter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File rightFile = fileArray[n2];
            File leftFile = leftFilesByName.get(rightFile.getName());
            if (leftFile != null) {
                Diff.fileDiff(commonPathLength, leftFile, rightFile);
            }
            ++n2;
        }
    }

    protected static HashMap<String, File> filesByName(File directory, FileFilter filter) {
        File[] files = directory.listFiles(filter);
        HashMap<String, File> filesByName = new HashMap<String, File>(files.length << 1);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            filesByName.put(file.getName(), file);
            ++n2;
        }
        return filesByName;
    }

    protected static void fileDiff(int commonPathLength, File left, File right) {
        fmt.format("\n********** %s <==> %s **********\n", left.toString().substring(commonPathLength), right.toString().substring(commonPathLength));
        String leftCobol = Strings.fileToString((File)left);
        String rightCobol = Strings.fileToString((File)right);
        int diffCount = Diff.diffLines(leftCobol, rightCobol);
        if (diffCount == 0) {
            fmt.format("= No real difference\n", new Object[0]);
        } else {
            fmt.format("= %d real differences\n", diffCount);
        }
    }

    protected static int diffChars(String leftCobol, String rightCobol) {
        CobolDifferencer differencer = new CobolDifferencer(leftCobol, rightCobol);
        DiffCursor cursor = differencer.newCharDifferencesCursor();
        int diffCount = 0;
        while (cursor.searchNextDifference()) {
            Diff.showCharsDifference(differencer, ++diffCount, leftCobol, rightCobol, cursor);
        }
        return diffCount;
    }

    protected static void showCharsDifference(CobolDifferencer differencer, int count, String leftCobol, String rightCobol, DiffCursor cursor) {
        int leftBeginIdx = cursor.getReferenceBeginIndex();
        int leftEndIdx = cursor.getReferenceEndIndex();
        int rightBeginIdx = cursor.getModifiedBeginIndex();
        int rightEndIdx = cursor.getModifiedEndIndex();
        fmt.format("------------------------------------ %d ---------------------------------------------\n", count);
        fmt.format("%s\n", cursor.getDifferenceNature().toString());
        fmt.format("<Left[%d,%d[\n", leftBeginIdx, leftEndIdx);
        if (cursor.getDifferenceNature() != DifferenceNature.Insertion) {
            fmt.format("\"%s\"\n", leftCobol.substring(leftBeginIdx, leftEndIdx));
        }
        fmt.format(">Right[%d,%d[\n", rightBeginIdx, rightEndIdx);
        if (cursor.getDifferenceNature() != DifferenceNature.Deletion) {
            fmt.format("\"%s\"\n", rightCobol.substring(rightBeginIdx, rightEndIdx));
        }
    }

    protected static int diffLines(String leftCobol, String rightCobol) {
        CobolDifferencer differencer = new CobolDifferencer(leftCobol, rightCobol);
        DiffCursor cursor = differencer.newLineDifferencesCursor();
        int diffCount = 0;
        while (cursor.searchNextDifference()) {
            Diff.showLinesDifference(differencer, ++diffCount, leftCobol, rightCobol, cursor);
        }
        return diffCount;
    }

    protected static void showLinesDifference(CobolDifferencer differencer, int count, String leftCobol, String rightCobol, DiffCursor cursor) {
        int leftBeginLineRank = cursor.getReferenceBeginIndex();
        int leftEndLineRank = cursor.getReferenceEndIndex();
        int rightBeginLineRank = cursor.getModifiedBeginIndex();
        int rightEndLineRank = cursor.getModifiedEndIndex();
        int[] leftLineStartIndexes = differencer.getReferenceLineIndexes();
        int[] rightLineStartIndexes = differencer.getModifiedLineIndexes();
        fmt.format("------------------------------------ %d ---------------------------------------------\n", count);
        fmt.format("<Left[%d,%d[\n", 1 + leftBeginLineRank, 1 + leftEndLineRank);
        if (cursor.getDifferenceNature() != DifferenceNature.Insertion) {
            fmt.format("%s\n", leftCobol.substring(leftLineStartIndexes[leftBeginLineRank], leftLineStartIndexes[leftEndLineRank]));
        }
        fmt.format(">Right[%d,%d[\n", 1 + rightBeginLineRank, 1 + rightEndLineRank);
        if (cursor.getDifferenceNature() != DifferenceNature.Deletion) {
            fmt.format("%s\n", rightCobol.substring(rightLineStartIndexes[rightBeginLineRank], rightLineStartIndexes[rightEndLineRank]));
        }
    }
}

