/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare;

import com.ibm.pdp.cobolcompare.CobolToken;

public class CobolTokenizer {
    protected static final byte OTHER_CHR = 0;
    protected static final byte WORD_CHR = 1;
    protected static final byte HYPHEN_CHR = 2;
    protected static final byte WHITE_CHR = 3;
    protected static final byte EOL_CHR = 4;
    protected static final byte QUOTE_CHR = 5;
    protected static final char[] wordChars;
    protected static final char[] hyphen;
    protected static final char[] whites;
    protected static final char[] eols;
    protected static final char[] quotes;
    protected static byte[] charCategory;
    protected static char minRegisteredChar;
    protected static char maxRegisteredChar;
    public static boolean handleCommentChars;
    public static int indicatorColumn;
    public static int defaultMaxLineLength;
    private static boolean fullLinePartitionnerWithFormatControl;
    public static final int SPECIAL = 0;
    public static final int WORD = 1;
    public static final int LINE = 1;
    public static final int QUOTED = 2;
    public static final int QUOTED_SPECIAL = 3;
    protected CharSequence cobol;
    protected int lastTokenEndIdx = -1;
    protected int column;
    protected char[] line;
    protected int lineBeginIdx;
    protected int lineLength;
    protected boolean blankLine;
    protected int maximumLineLength;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        String compIndicatorColumn;
        wordChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        hyphen = new char[]{'-'};
        whites = new char[]{' '};
        eols = new char[]{'\n', '\r'};
        quotes = new char[]{'\"', '\''};
        handleCommentChars = true;
        minRegisteredChar = (char)65535;
        maxRegisteredChar = '\u0000';
        CobolTokenizer.updateMinMaxChar(wordChars);
        CobolTokenizer.updateMinMaxChar(hyphen);
        CobolTokenizer.updateMinMaxChar(whites);
        CobolTokenizer.updateMinMaxChar(eols);
        CobolTokenizer.updateMinMaxChar(quotes);
        charCategory = new byte[maxRegisteredChar - minRegisteredChar + 1];
        CobolTokenizer.setCategory(wordChars, (byte)1);
        CobolTokenizer.setCategory(hyphen, (byte)2);
        CobolTokenizer.setCategory(whites, (byte)3);
        CobolTokenizer.setCategory(eols, (byte)4);
        CobolTokenizer.setCategory(quotes, (byte)5);
        indicatorColumn = 6;
        defaultMaxLineLength = 72;
        String compMaxCobolLineLength = System.getProperty("compMaxCobolLineLength");
        if (compMaxCobolLineLength != null) {
            defaultMaxLineLength = Integer.parseInt(compMaxCobolLineLength);
        }
        if ((compIndicatorColumn = System.getProperty("compIndicatorColumn")) != null) {
            indicatorColumn = Integer.parseInt(compIndicatorColumn);
        }
        fullLinePartitionnerWithFormatControl = "true".equals(System.getProperty("fullLinePartitionnerWithFormatControl"));
    }

    protected static void updateMinMaxChar(char[] chars) {
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c < minRegisteredChar) {
                minRegisteredChar = c;
            } else if (c > maxRegisteredChar) {
                maxRegisteredChar = c;
            }
            ++n2;
        }
    }

    protected static void setCategory(char[] chars, byte category) {
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            CobolTokenizer.charCategory[c - CobolTokenizer.minRegisteredChar] = category;
            ++n2;
        }
    }

    public CobolTokenizer() {
        this.maximumLineLength = defaultMaxLineLength;
        this.line = new char[this.maximumLineLength];
    }

    public CobolTokenizer(CharSequence cobol) {
        this.cobol = cobol;
        this.maximumLineLength = defaultMaxLineLength;
        this.line = new char[this.maximumLineLength];
    }

    public CobolTokenizer(CharSequence cobol, int maxLineLength) {
        this.cobol = cobol;
        this.maximumLineLength = maxLineLength <= 0 ? defaultMaxLineLength : maxLineLength;
        this.line = new char[this.maximumLineLength];
    }

    public CharSequence getCobol() {
        return this.cobol;
    }

    public void setCobol(String cobol) {
        this.cobol = cobol;
        this.lastTokenEndIdx = -1;
        this.column = 0;
        this.lineBeginIdx = 0;
        this.lineLength = 0;
        this.blankLine = true;
    }

    public CobolToken newToken() {
        return new CobolToken();
    }

    /*
     * Unable to fully structure code
     */
    public boolean nextToken(CobolToken token) {
        if (this.lastTokenEndIdx == token.endIdx || this.startFrom(token.endIdx)) ** GOTO lbl14
        return false;
lbl-1000:
        // 1 sources

        {
            if (CobolTokenizer.fullLinePartitionnerWithFormatControl) {
                return this.lineToken(token);
            }
            switch (CobolTokenizer.category(this.line[this.column])) {
                case 1: {
                    return this.wordToken(token);
                }
                case 5: {
                    return this.quotedToken(token);
                }
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    return this.singleCharToken(token);
                }
            }
lbl14:
            // 2 sources

            ** while (this.searchNextToken())
        }
lbl15:
        // 1 sources

        return false;
    }

    protected boolean startFrom(int startIdx) {
        if (startIdx == 0) {
            return this.firstSignificantLine();
        }
        throw new RuntimeException("Not yet implemented");
    }

    protected boolean firstSignificantLine() {
        if (!this.findFirstLine()) {
            return false;
        }
        if (this.significantLine()) {
            this.column = indicatorColumn;
            return true;
        }
        return this.nextSignificantLine();
    }

    protected boolean nextSignificantLine() {
        while (this.findNextLine()) {
            if (!this.significantLine()) continue;
            this.column = indicatorColumn;
            return true;
        }
        return false;
    }

    protected boolean significantLine() {
        return !this.blankLine && !CobolTokenizer.isCommentChar(this.line[indicatorColumn]);
    }

    protected static boolean isCommentChar(char chr) {
        return handleCommentChars && (chr == '*' || chr == '/');
    }

    protected boolean searchNextToken() {
        if (!fullLinePartitionnerWithFormatControl && this.nextSignificantCharOnCurrentLine()) {
            return true;
        }
        if (!this.nextSignificantLine()) {
            return false;
        }
        if (!fullLinePartitionnerWithFormatControl) {
            this.nextSignificantCharOnCurrentLine();
        }
        return true;
    }

    protected boolean nextSignificantCharOnCurrentLine() {
        while (this.column < this.lineLength) {
            if (this.line[this.column] != ' ') {
                return true;
            }
            ++this.column;
        }
        return false;
    }

    protected boolean findFirstLine() {
        int length = this.cobol.length();
        int index = 0;
        while (index < length) {
            if (!CobolTokenizer.isEol(this.cobol.charAt(index))) {
                this.lineBeginIdx = index;
                this.lineLength = this.fillLine(index);
                return true;
            }
            ++index;
        }
        this.lineBeginIdx = length;
        this.lineLength = 0;
        this.blankLine = true;
        return false;
    }

    protected boolean findNextLine() {
        int length = this.cobol.length();
        int index = this.lineBeginIdx + this.lineLength;
        while (index < length) {
            if (CobolTokenizer.isEol(this.cobol.charAt(index))) {
                while (++index != length) {
                    if (CobolTokenizer.isEol(this.cobol.charAt(index))) continue;
                    this.lineBeginIdx = index;
                    this.lineLength = this.fillLine(index);
                    return true;
                }
                break;
            }
            ++index;
        }
        this.lineBeginIdx = length;
        this.lineLength = 0;
        this.blankLine = true;
        return false;
    }

    protected static boolean isEol(char chr) {
        return chr == '\r' || chr == '\n';
    }

    protected int fillLine(int index) {
        int col = 0;
        int length = this.cobol.length();
        while (index < length && col < indicatorColumn) {
            char chr;
            if (CobolTokenizer.isEol(chr = this.cobol.charAt(index++))) {
                this.blankLine = true;
                return col;
            }
            this.line[col++] = chr;
        }
        boolean blank = true;
        while (index < length && col < this.maximumLineLength) {
            char chr;
            if (CobolTokenizer.isEol(chr = this.cobol.charAt(index++))) break;
            this.line[col++] = chr;
            if (!blank || chr == ' ') continue;
            if (this.maximumLineLength == 72) {
                blank = false;
                continue;
            }
            if (col >= 72) continue;
            blank = false;
        }
        this.blankLine = blank;
        return col;
    }

    protected boolean singleCharToken(CobolToken token) {
        if (this.isIndivisibleCharToken(token)) {
            boolean isDot = this.line[this.column] == '.';
            token.text = this.cobol;
            token.beginIdx = this.lineBeginIdx + this.column;
            token.category = 1;
            int hash = 0;
            int multiplier = 1;
            char previousChr = this.line[this.column];
            while (++this.column < this.lineLength) {
                char chr = this.line[this.column];
                int charCategory = CobolTokenizer.category(chr);
                if (charCategory == 3 || isDot && charCategory != 1) break;
                hash += CobolTokenizer.ignoreCaseHash(previousChr) * multiplier;
                multiplier = (multiplier << 5) - multiplier;
                previousChr = chr;
            }
            if (previousChr == '-') {
                --this.column;
            } else {
                hash += CobolTokenizer.ignoreCaseHash(previousChr) * multiplier;
            }
            token.endIdx = this.lastTokenEndIdx = this.lineBeginIdx + this.column;
            token.hash = hash;
            return true;
        }
        token.text = this.cobol;
        token.beginIdx = this.lineBeginIdx + this.column;
        token.category = 0;
        token.endIdx = this.lastTokenEndIdx = token.beginIdx + 1;
        token.hash = this.line[this.column++];
        return true;
    }

    private boolean isIndivisibleCharToken(CobolToken token) {
        char chr;
        return this.column + 1 < this.lineLength && this.line[this.column + 1] != ' ' && ((chr = this.line[this.column]) == '^' || chr == '.');
    }

    protected boolean lineToken(CobolToken token) {
        token.text = this.cobol;
        token.beginIdx = this.lineBeginIdx + this.column;
        token.category = 1;
        int hash = 0;
        int multiplier = 1;
        char previousChr = this.line[this.column];
        while (++this.column < this.lineLength) {
            char chr = this.line[this.column];
            hash += previousChr * multiplier;
            multiplier = (multiplier << 5) - multiplier;
            previousChr = chr;
        }
        token.endIdx = this.lastTokenEndIdx = this.lineBeginIdx + this.column;
        token.hash = hash += previousChr * multiplier;
        return true;
    }

    protected boolean wordToken(CobolToken token) {
        token.text = this.cobol;
        token.beginIdx = this.lineBeginIdx + this.column;
        token.category = 1;
        int hash = 0;
        int multiplier = 1;
        char previousChr = this.line[this.column];
        while (++this.column < this.lineLength) {
            char chr = this.line[this.column];
            int charCategory = CobolTokenizer.category(chr);
            if (!fullLinePartitionnerWithFormatControl && charCategory != 1 && charCategory != 2) break;
            hash += CobolTokenizer.ignoreCaseHash(previousChr) * multiplier;
            multiplier = (multiplier << 5) - multiplier;
            previousChr = chr;
        }
        if (previousChr == '-') {
            --this.column;
        } else {
            hash += CobolTokenizer.ignoreCaseHash(previousChr) * multiplier;
        }
        token.endIdx = this.lastTokenEndIdx = this.lineBeginIdx + this.column;
        token.hash = hash;
        return true;
    }

    protected static int ignoreCaseHash(char c) {
        return c >= 97 ? c - 97 + 65 : c;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean quotedToken(CobolToken token) {
        quoteChar = this.line[this.column++];
        token.text = this.cobol;
        token.beginIdx = this.lineBeginIdx + this.column;
        token.category = 2;
        hash = 0;
        multiplier = 1;
        chars = null;
        while (this.column < this.lineLength) {
            if ((chr = this.line[this.column++]) == quoteChar) {
                if (this.column == this.lineLength || this.line[this.column] != quoteChar) {
                    token.endIdx = this.lastTokenEndIdx = this.lineBeginIdx + this.column - 1;
                    token.hash = hash;
                    if (chars != null) {
                        token.category = 3;
                        token.text = chars.toString();
                    }
                    return true;
                }
                if (chars == null) {
                    chars = new StringBuilder();
                    chars.append(this.cobol, token.beginIdx, this.lineBeginIdx + this.column);
                } else {
                    chars.append(chr);
                }
                ++this.column;
            } else if (chars != null) {
                chars.append(chr);
            }
            hash += chr * multiplier;
            multiplier = (multiplier << 5) - multiplier;
        }
        if (chars == null) {
            chars = new StringBuilder();
            chars.append(this.cobol, token.beginIdx, this.lineBeginIdx + this.column);
        }
        c = this.column;
        while (c < this.maximumLineLength) {
            chars.append(' ');
            hash += 32 * multiplier;
            multiplier = (multiplier << 5) - multiplier;
            ++c;
        }
        endIdx = this.lineBeginIdx + this.column;
        ** GOTO lbl69
        {
            if ((chr = this.line[this.column++]) == quoteChar) {
                if (this.column == this.lineLength || this.line[this.column] != quoteChar) {
                    token.endIdx = this.lastTokenEndIdx = this.lineBeginIdx + this.column - 1;
                    token.hash = hash;
                    token.category = 3;
                    token.text = chars.toString();
                    return true;
                }
                ++this.column;
            }
            chars.append(chr);
            hash += chr * multiplier;
            multiplier = (multiplier << 5) - multiplier;
            do {
                if (this.column < this.lineLength) continue block2;
                c = this.column;
                while (c < this.maximumLineLength) {
                    chars.append(' ');
                    hash += 32 * multiplier;
                    multiplier = (multiplier << 5) - multiplier;
                    ++c;
                }
                endIdx = this.lineBeginIdx + this.column;
lbl69:
                // 2 sources

            } while (this.validQuotedTokenContinuationLine(quoteChar));
        }
        token.endIdx = this.lastTokenEndIdx = endIdx;
        token.hash = hash;
        token.category = 3;
        token.text = chars.toString();
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean validQuotedTokenContinuationLine(char quoteChar) {
        col = CobolTokenizer.indicatorColumn;
        if (this.nextSignificantLine() && this.line[col] == '-') ** GOTO lbl9
        return false;
lbl-1000:
        // 1 sources

        {
            chr = this.line[col];
            if (chr == quoteChar) {
                this.column = col + 1;
                return true;
            }
            if (chr != ' ') break;
lbl9:
            // 2 sources

            ** while (++col < this.lineLength)
        }
lbl10:
        // 2 sources

        this.column = CobolTokenizer.indicatorColumn;
        return false;
    }

    protected static int category(char c) {
        return c >= minRegisteredChar && c <= maxRegisteredChar ? charCategory[c - minRegisteredChar] : 0;
    }
}

