/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare;

import com.ibm.pdp.util.Strings;

public class CobolToken
implements Cloneable {
    protected static final int SPECIAL = 0;
    protected static final int WORD = 1;
    protected static final int QUOTED = 2;
    protected static final int QUOTED_SPECIAL = 3;
    public int beginIdx;
    public int endIdx;
    protected int hash;
    protected int category;
    protected CharSequence text;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public CobolToken() {
    }

    public CobolToken(int category, CharSequence text) {
        this(0, text.length(), category, CobolToken.computeHashCode(category, text, 0, text.length()), text);
    }

    public CobolToken(int beginIdx, int endIdx, int category, CharSequence text) {
        this.beginIdx = beginIdx;
        this.endIdx = endIdx;
        this.category = category;
        this.hash = CobolToken.computeHashCode(category, text, beginIdx, endIdx);
        this.text = text;
    }

    public CobolToken(int beginIdx, int endIdx, int category, int hash, CharSequence text) {
        this.beginIdx = beginIdx;
        this.endIdx = endIdx;
        this.category = category;
        this.hash = hash;
        this.text = text;
    }

    protected static int computeHashCode(int category, CharSequence sequence, int begin, int end) {
        return category == 1 ? CobolToken.hashCodeIgnoreCase(sequence, begin, end) : CobolToken.hashCode(sequence, begin, end);
    }

    protected static int hashCode(CharSequence str, int begin, int end) {
        int hash = 0;
        int multiplier = 1;
        int i = begin;
        while (i < end) {
            hash += str.charAt(i) * multiplier;
            multiplier = (multiplier << 5) - multiplier;
            ++i;
        }
        return hash;
    }

    protected static int hashCodeIgnoreCase(CharSequence str, int begin, int end) {
        int hash = 0;
        int multiplier = 1;
        int i = begin;
        while (i < end) {
            hash += CobolToken.ignoreCaseHash(str.charAt(i)) * multiplier;
            multiplier = (multiplier << 5) - multiplier;
            ++i;
        }
        return hash;
    }

    protected static int ignoreCaseHash(char c) {
        return c >= 97 ? c - 97 + 65 : c;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object other) {
        if (!(other instanceof CobolToken)) {
            return false;
        }
        CobolToken token = (CobolToken)other;
        if (token.hash != this.hash) {
            return false;
        }
        switch (this.category) {
            case 0: {
                return token.category == 0 && this.sameText(this, token);
            }
            case 1: {
                return token.category == 1 && this.sameTextIgnoreCase(this, token);
            }
            case 2: 
            case 3: {
                return (token.category == 2 || token.category == 3) && this.sameQuotedLiterals(this, token);
            }
        }
        return false;
    }

    public CobolToken clone() {
        try {
            return (CobolToken)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        if (this.category == 3) {
            return "'" + this.text.toString() + "'";
        }
        if (this.category == 2) {
            return "'" + this.text.subSequence(this.beginIdx, this.endIdx).toString() + "'";
        }
        return this.text.subSequence(this.beginIdx, this.endIdx).toString();
    }

    protected boolean sameText(CobolToken left, CobolToken right) {
        int rightIdx = right.beginIdx;
        int leftIdx = left.beginIdx;
        int nbChar = left.endIdx - leftIdx;
        if (right.endIdx - rightIdx != nbChar) {
            return false;
        }
        return Strings.sameSubSequences((CharSequence)left.text, (int)leftIdx, (CharSequence)right.text, (int)rightIdx, (int)nbChar);
    }

    protected boolean sameTextIgnoreCase(CobolToken left, CobolToken right) {
        int rightIdx = right.beginIdx;
        int leftIdx = left.beginIdx;
        int nbChar = left.endIdx - leftIdx;
        if (right.endIdx - rightIdx != nbChar) {
            return false;
        }
        CharSequence leftText = left.text;
        CharSequence rightText = right.text;
        while (nbChar-- > 0) {
            char rightChar;
            char leftChar;
            if ((leftChar = leftText.charAt(leftIdx++)) == (rightChar = rightText.charAt(rightIdx++)) || CobolToken.uppercaseChar(leftChar) == CobolToken.uppercaseChar(rightChar)) continue;
            return false;
        }
        return true;
    }

    protected static char uppercaseChar(char c) {
        if (c >= 'a' && c <= 'z') {
            return (char)(c - 97 + 65);
        }
        return c;
    }

    protected boolean sameQuotedLiterals(CobolToken left, CobolToken right) {
        if (this.getQuoteChar(left) != this.getQuoteChar(right)) {
            return false;
        }
        if (left.category == 2 && right.category == 2) {
            return this.sameText(left, right);
        }
        CharSequence leftText = left.category == 2 ? left.text.subSequence(left.beginIdx, left.endIdx) : left.text;
        CharSequence rightText = right.category == 2 ? right.text.subSequence(right.beginIdx, right.endIdx) : right.text;
        return Strings.sameCharSequences((CharSequence)leftText, (CharSequence)rightText);
    }

    protected char getQuoteChar(CobolToken token) {
        try {
            if (token.text != null) {
                return token.text.charAt(token.beginIdx - 1);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        return '\'';
    }
}

