/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare;

import com.ibm.pdp.cobolcompare.CharDiffCursor;
import com.ibm.pdp.cobolcompare.CobolToken;
import com.ibm.pdp.cobolcompare.CobolTokenizer;
import com.ibm.pdp.cobolcompare.LinesDiffCursor;
import com.ibm.pdp.util.containers.Appender;
import com.ibm.pdp.util.diff.DiffCursor;

public class CobolDifferencer {
    protected String referenceCobol;
    protected String modifiedCobol;
    protected int[] referenceLineIndexes;
    protected int[] modifiedLineIndexes;
    protected CobolToken[] referenceTokens;
    protected CobolToken[] modifiedTokens;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public CobolDifferencer() {
        this(null, null);
    }

    public CobolDifferencer(String reference, String modified) {
        this.referenceCobol = reference;
        this.modifiedCobol = modified;
    }

    public String getReferenceCobol() {
        return this.referenceCobol;
    }

    public void setReferenceCobol(String reference) {
        this.referenceCobol = reference;
        this.referenceLineIndexes = null;
        this.referenceTokens = null;
    }

    public String getModifiedCobol() {
        return this.modifiedCobol;
    }

    public void setModifiedCobol(String modified) {
        this.modifiedCobol = modified;
        this.modifiedLineIndexes = null;
        this.modifiedTokens = null;
    }

    public int[] getReferenceLineIndexes() {
        if (this.referenceLineIndexes == null) {
            this.referenceLineIndexes = this.computeLineIndexes(this.referenceCobol);
        }
        return this.referenceLineIndexes;
    }

    public int referenceLineRankFromCharIndex(int charIndex) {
        int[] lineStartIndexes = this.getReferenceLineIndexes();
        return CobolDifferencer.lineRankFromIndex(charIndex, lineStartIndexes, 0, lineStartIndexes.length);
    }

    public int[] getModifiedLineIndexes() {
        if (this.modifiedLineIndexes == null) {
            this.modifiedLineIndexes = this.computeLineIndexes(this.modifiedCobol);
        }
        return this.modifiedLineIndexes;
    }

    public int modifiedLineRankFromCharIndex(int charIndex) {
        int[] lineStartIndexes = this.getModifiedLineIndexes();
        return CobolDifferencer.lineRankFromIndex(charIndex, lineStartIndexes, 0, lineStartIndexes.length);
    }

    protected static int lineRankFromIndex(int index, int[] lineStartIndex, int begin, int end) {
        while (begin < end) {
            int middle = begin + end >> 1;
            int value = lineStartIndex[middle];
            if (index > value) {
                begin = middle + 1;
                continue;
            }
            if (index < value) {
                end = middle;
                continue;
            }
            return middle;
        }
        return ~begin;
    }

    protected int[] computeLineIndexes(String s) {
        if (s.length() == 0) {
            return new int[0];
        }
        int[] lines = new int[1 + s.length() / 80];
        lines[0] = 0;
        int nbLines = 1;
        int index = this.nextLineStartIndex(s, 0);
        while (index != -1) {
            if (nbLines == lines.length) {
                int[] newLines = new int[nbLines + (nbLines >> 3) + 10];
                System.arraycopy(lines, 0, newLines, 0, nbLines);
                lines = newLines;
            }
            lines[nbLines++] = index;
            index = this.nextLineStartIndex(s, index);
        }
        if (nbLines != lines.length) {
            int[] newLines = new int[nbLines];
            System.arraycopy(lines, 0, newLines, 0, nbLines);
            lines = newLines;
        }
        return lines;
    }

    protected int nextLineStartIndex(String s, int index) {
        int length = s.length();
        while (index < length) {
            char c = s.charAt(index);
            if (c == '\r') {
                if (++index < length && s.charAt(index) == '\n') {
                    ++index;
                }
                return index;
            }
            if (c == '\n') {
                if (++index < length && s.charAt(index) == '\r') {
                    ++index;
                }
                return index;
            }
            ++index;
        }
        return -1;
    }

    public CobolToken[] getReferenceTokens() {
        if (this.referenceTokens == null) {
            this.referenceTokens = this.buildTokens(this.referenceCobol);
        }
        return this.referenceTokens;
    }

    public CobolToken[] getModifiedTokens() {
        if (this.modifiedTokens == null) {
            this.modifiedTokens = this.buildTokens(this.modifiedCobol);
        }
        return this.modifiedTokens;
    }

    protected CobolToken[] buildTokens(String cobol) {
        Appender tokens = new Appender();
        CobolTokenizer tokenizer = new CobolTokenizer(cobol);
        CobolToken token = tokenizer.newToken();
        while (tokenizer.nextToken(token)) {
            tokens.append((Object)token.clone());
        }
        Object[] result = new CobolToken[tokens.size()];
        tokens.copyTo(result);
        return result;
    }

    public boolean sameCobols() {
        CobolTokenizer tokenizer1 = new CobolTokenizer(this.referenceCobol);
        CobolTokenizer tokenizer2 = new CobolTokenizer(this.modifiedCobol);
        CobolToken token1 = tokenizer1.newToken();
        CobolToken token2 = tokenizer2.newToken();
        while (tokenizer1.nextToken(token1)) {
            if (tokenizer2.nextToken(token2) && token1.equals(token2)) continue;
            return false;
        }
        return !tokenizer2.nextToken(token2);
    }

    public int[] firstDifferenceIndexes() {
        CobolTokenizer tokenizer1 = new CobolTokenizer(this.referenceCobol);
        CobolTokenizer tokenizer2 = new CobolTokenizer(this.modifiedCobol);
        CobolToken token1 = tokenizer1.newToken();
        CobolToken token2 = tokenizer2.newToken();
        while (tokenizer1.nextToken(token1)) {
            if (!tokenizer2.nextToken(token2)) {
                return new int[]{token1.beginIdx, this.modifiedCobol.length()};
            }
            if (token1.equals(token2)) continue;
            return new int[]{token1.beginIdx, token2.beginIdx};
        }
        if (tokenizer2.nextToken(token2)) {
            return new int[]{this.referenceCobol.length(), token2.beginIdx};
        }
        return null;
    }

    public DiffCursor newTokenDifferencesCursor() {
        return this.newTokenDiffCursor();
    }

    public DiffCursor newCharDifferencesCursor() {
        return this.newCharDiffCursor();
    }

    public DiffCursor newLineDifferencesCursor() {
        return this.newLinesDiffCursor();
    }

    protected DiffCursor newTokenDiffCursor() {
        return new CharDiffCursor(this.referenceCobol, this.getReferenceTokens(), this.modifiedCobol, this.getModifiedTokens());
    }

    protected DiffCursor newCharDiffCursor() {
        return new CharDiffCursor(this.referenceCobol, this.getReferenceTokens(), this.modifiedCobol, this.getModifiedTokens());
    }

    protected DiffCursor newLinesDiffCursor() {
        return new LinesDiffCursor(this.referenceCobol, this.getReferenceTokens(), this.getReferenceLineIndexes(), this.modifiedCobol, this.getModifiedTokens(), this.getModifiedLineIndexes());
    }
}

