/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare;

import com.ibm.pdp.cobolcompare.CobolToken;
import com.ibm.pdp.util.diff.DefaultArrayDifferencer;
import com.ibm.pdp.util.diff.DiffCursor;
import com.ibm.pdp.util.diff.DifferenceNature;

class CharDiffCursor
implements DiffCursor {
    protected CharSequence reference;
    protected CharSequence modified;
    protected CobolToken[] refTokens;
    protected CobolToken[] modTokens;
    protected DiffCursor cursor;
    protected int refBeginIdx;
    protected int refEndIdx;
    protected int modBeginIdx;
    protected int modEndIdx;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected CharDiffCursor(CharSequence reference, CobolToken[] referenceTokens, CharSequence modified, CobolToken[] modifiedTokens) {
        this.reference = reference;
        this.modified = modified;
        this.refTokens = referenceTokens;
        this.modTokens = modifiedTokens;
        this.cursor = new DefaultArrayDifferencer((Object[])this.refTokens, (Object[])this.modTokens).newDiffCursor();
    }

    public boolean searchNextDifference() {
        if (!this.cursor.searchNextDifference()) {
            return false;
        }
        this.computeIndexes();
        return true;
    }

    public boolean moveToReferenceIndex(int referenceIndex) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean moveToModifiedIndex(int modifiedIndex) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean hasFoundDifference() {
        return this.cursor.hasFoundDifference();
    }

    public DifferenceNature getDifferenceNature() {
        if (!this.cursor.hasFoundDifference()) {
            return DifferenceNature.Identical;
        }
        return this.refBeginIdx == this.refEndIdx ? (this.modBeginIdx == this.modEndIdx ? DifferenceNature.Identical : DifferenceNature.Insertion) : (this.modBeginIdx == this.modEndIdx ? DifferenceNature.Deletion : DifferenceNature.Replacement);
    }

    public int getReferenceBeginIndex() {
        return this.refBeginIdx;
    }

    public int getReferenceEndIndex() {
        return this.refEndIdx;
    }

    public int getModifiedBeginIndex() {
        return this.modBeginIdx;
    }

    public int getModifiedEndIndex() {
        return this.modEndIdx;
    }

    protected void computeIndexes0() {
        int refBeginTokenRank = this.cursor.getReferenceBeginIndex();
        int refEndTokenRank = this.cursor.getReferenceEndIndex();
        int modBeginTokenRank = this.cursor.getModifiedBeginIndex();
        int modEndTokenRank = this.cursor.getModifiedEndIndex();
        switch (this.cursor.getDifferenceNature()) {
            case Deletion: {
                this.refBeginIdx = this.refTokens[refBeginTokenRank].beginIdx;
                this.refEndIdx = this.refTokens[refEndTokenRank - 1].endIdx;
                this.modBeginIdx = modBeginTokenRank > 0 ? this.modTokens[modBeginTokenRank - 1].endIdx : 0;
                this.modEndIdx = modEndTokenRank < this.modTokens.length ? this.modTokens[modEndTokenRank].beginIdx : this.modified.length();
                return;
            }
            case Insertion: {
                this.refBeginIdx = refBeginTokenRank > 0 ? this.refTokens[refBeginTokenRank - 1].endIdx : 0;
                this.refEndIdx = refEndTokenRank < this.refTokens.length ? this.refTokens[refEndTokenRank].beginIdx : this.reference.length();
                this.modBeginIdx = this.modTokens[modBeginTokenRank].beginIdx;
                this.modEndIdx = this.modTokens[modEndTokenRank - 1].endIdx;
                return;
            }
            case Replacement: {
                this.refBeginIdx = this.refTokens[refBeginTokenRank].beginIdx;
                this.refEndIdx = this.refTokens[refEndTokenRank - 1].endIdx;
                this.modBeginIdx = this.modTokens[modBeginTokenRank].beginIdx;
                this.modEndIdx = this.modTokens[modEndTokenRank - 1].endIdx;
                return;
            }
        }
    }

    protected void computeIndexes() {
        switch (this.cursor.getDifferenceNature()) {
            case Deletion: {
                this.computeIndexesForDeletion();
                return;
            }
            case Insertion: {
                this.computeIndexesForInsertion();
                return;
            }
            case Replacement: {
                this.computeIndexesForReplacement();
                return;
            }
        }
    }

    protected void computeIndexesForDeletion() {
        int refBeginTokenRank = this.cursor.getReferenceBeginIndex();
        int refEndTokenRank = this.cursor.getReferenceEndIndex();
        int modTokenRank = this.cursor.getModifiedBeginIndex();
        int modSpaceBeginIdx = modTokenRank == 0 ? 0 : this.modTokens[modTokenRank - 1].endIdx;
        int modSpaceEndIdx = modTokenRank == this.modTokens.length ? this.modified.length() : this.modTokens[modTokenRank].beginIdx;
        int refLeftSpaceBeginIdx = refBeginTokenRank == 0 ? 0 : this.refTokens[refBeginTokenRank - 1].endIdx;
        int refLeftSpaceEndIdx = this.refTokens[refBeginTokenRank].beginIdx;
        int refRightSpaceBeginIdx = this.refTokens[refEndTokenRank - 1].endIdx;
        int refRightSpaceEndIdx = refEndTokenRank == this.refTokens.length ? this.reference.length() : this.refTokens[refEndTokenRank].beginIdx;
        int leftMatchingCount = this.leftMatchingChars(refLeftSpaceBeginIdx, refLeftSpaceEndIdx, modSpaceBeginIdx, modSpaceEndIdx);
        int rightMatchingCount = this.rightMatchingChars(refRightSpaceBeginIdx, refRightSpaceEndIdx, modSpaceBeginIdx + leftMatchingCount, modSpaceEndIdx);
        this.refBeginIdx = refLeftSpaceBeginIdx + leftMatchingCount;
        this.refEndIdx = refRightSpaceEndIdx - rightMatchingCount;
        this.modBeginIdx = modSpaceBeginIdx + leftMatchingCount;
        this.modEndIdx = modSpaceEndIdx - rightMatchingCount;
    }

    protected void computeIndexesForInsertion() {
        int refTokenRank = this.cursor.getReferenceBeginIndex();
        int modBeginTokenRank = this.cursor.getModifiedBeginIndex();
        int modEndTokenRank = this.cursor.getModifiedEndIndex();
        int refSpaceBeginIdx = refTokenRank == 0 ? 0 : this.refTokens[refTokenRank - 1].endIdx;
        int refSpaceEndIdx = refTokenRank == this.refTokens.length ? this.reference.length() : this.refTokens[refTokenRank].beginIdx;
        int modLeftSpaceBeginIdx = modBeginTokenRank == 0 ? 0 : this.modTokens[modBeginTokenRank - 1].endIdx;
        int modLeftSpaceEndIdx = this.modTokens[modBeginTokenRank].beginIdx;
        int modRightSpaceBeginIdx = this.modTokens[modEndTokenRank - 1].endIdx;
        int modRightSpaceEndIdx = modEndTokenRank == this.modTokens.length ? this.modified.length() : this.modTokens[modEndTokenRank].beginIdx;
        int leftMatchingCount = this.leftMatchingChars(refSpaceBeginIdx, refSpaceEndIdx, modLeftSpaceBeginIdx, modLeftSpaceEndIdx);
        int rightMatchingCount = this.rightMatchingChars(refSpaceBeginIdx + leftMatchingCount, refSpaceEndIdx, modRightSpaceBeginIdx, modRightSpaceEndIdx);
        this.refBeginIdx = refSpaceBeginIdx + leftMatchingCount;
        this.refEndIdx = refSpaceEndIdx - rightMatchingCount;
        this.modBeginIdx = modLeftSpaceBeginIdx + leftMatchingCount;
        this.modEndIdx = modRightSpaceEndIdx - rightMatchingCount;
    }

    protected void computeIndexesForReplacement() {
        int refBeginTokenRank = this.cursor.getReferenceBeginIndex();
        int refEndTokenRank = this.cursor.getReferenceEndIndex();
        int modBeginTokenRank = this.cursor.getModifiedBeginIndex();
        int modEndTokenRank = this.cursor.getModifiedEndIndex();
        int refLeftSpaceBeginIdx = refBeginTokenRank == 0 ? 0 : this.refTokens[refBeginTokenRank - 1].endIdx;
        int refLeftSpaceEndIdx = this.refTokens[refBeginTokenRank].beginIdx;
        int refRightSpaceBeginIdx = this.refTokens[refEndTokenRank - 1].endIdx;
        int refRightSpaceEndIdx = refEndTokenRank == this.refTokens.length ? this.reference.length() : this.refTokens[refEndTokenRank].beginIdx;
        int modLeftSpaceBeginIdx = modBeginTokenRank == 0 ? 0 : this.modTokens[modBeginTokenRank - 1].endIdx;
        int modLeftSpaceEndIdx = this.modTokens[modBeginTokenRank].beginIdx;
        int modRightSpaceBeginIdx = this.modTokens[modEndTokenRank - 1].endIdx;
        int modRightSpaceEndIdx = modEndTokenRank == this.modTokens.length ? this.modified.length() : this.modTokens[modEndTokenRank].beginIdx;
        int leftMatchingCount = this.leftMatchingChars(refLeftSpaceBeginIdx, refLeftSpaceEndIdx, modLeftSpaceBeginIdx, modLeftSpaceEndIdx);
        int rightMatchingCount = this.rightMatchingChars(refRightSpaceBeginIdx, refRightSpaceEndIdx, modRightSpaceBeginIdx, modRightSpaceEndIdx);
        this.refBeginIdx = refLeftSpaceBeginIdx + leftMatchingCount;
        this.refEndIdx = refRightSpaceEndIdx - rightMatchingCount;
        this.modBeginIdx = modLeftSpaceBeginIdx + leftMatchingCount;
        this.modEndIdx = modRightSpaceEndIdx - rightMatchingCount;
    }

    protected int leftMatchingChars(int refBeginIdx, int refEndIdx, int modBeginIdx, int modEndIdx) {
        int min = Math.min(refEndIdx - refBeginIdx, modEndIdx - modBeginIdx);
        int i = 0;
        while (i < min) {
            if (this.reference.charAt(refBeginIdx + i) != this.modified.charAt(modBeginIdx + i)) {
                return i;
            }
            ++i;
        }
        return min;
    }

    protected int rightMatchingChars(int refBeginIdx, int refEndIdx, int modBeginIdx, int modEndIdx) {
        int min = Math.min(refEndIdx - refBeginIdx, modEndIdx - modBeginIdx);
        int i = 0;
        while (i < min) {
            if (this.reference.charAt(refEndIdx - i - 1) != this.modified.charAt(modEndIdx - i - 1)) {
                return i;
            }
            ++i;
        }
        return min;
    }
}

