/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare.tools.model;

import com.ibm.pdp.cobolcompare.tools.model.Cobol;
import com.ibm.pdp.cobolcompare.tools.model.MetaTemplate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Template {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2012, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    int hashCode;
    private boolean hasDuplicates = false;
    private State state = State.DIRTY;
    private List<Cobol> cobols = new ArrayList<Cobol>();
    private int number;
    private String nature;
    private String added;
    private String deleted;
    private int nbAdded;
    private int nbDeleted;
    Template opposite;
    private int cobolGap;
    private int differenceGap;
    private boolean isCloned = false;
    private Template realTemplate;
    private MetaTemplate cloneMetaTemplateOwner;

    public Template(int number) {
        this.number = number;
    }

    public boolean isHasDuplicates() {
        return this.hasDuplicates;
    }

    public void setHasDuplicates(boolean hasDuplicates) {
        this.hasDuplicates = hasDuplicates;
    }

    public String toString() {
        return String.valueOf(Integer.toString(this.number)) + " - " + this.getNature() + (this.state != State.DIRTY ? " - " + (Object)((Object)this.state) + " " : "") + "  (COBOLs : " + this.getCobols().size() + " Diff : " + this.getTotalDifferences() + ")";
    }

    public int getTotalDifferences() {
        int diff = 0;
        for (Cobol cobol : this.getCobols()) {
            diff += cobol.getDifferences().size();
        }
        return diff;
    }

    public int getTotalDifferences(String text) {
        int diff = 0;
        for (Cobol cobol : this.getCobols()) {
            if (!cobol.getFilename().contains(text)) continue;
            diff += cobol.getDifferences().size();
        }
        return diff;
    }

    public Cobol getCobol(String fileName) {
        String idFileName = fileName.intern();
        for (Cobol cobol : this.getCobols()) {
            if (cobol.getFilename() != idFileName) continue;
            return cobol;
        }
        return null;
    }

    public List<Cobol> getCobols() {
        return this.cobols;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public String getNature() {
        return this.nature;
    }

    public void setNature(String nature) {
        this.nature = nature.intern();
    }

    public int getNbAdded() {
        return this.nbAdded;
    }

    public void setNbAdded(int nbAdded) {
        this.nbAdded = nbAdded;
    }

    public int getNbDeleted() {
        return this.nbDeleted;
    }

    public void setNbDeleted(int nbDeleted) {
        this.nbDeleted = nbDeleted;
    }

    public String getAdded() {
        return this.added;
    }

    public void setAdded(String added) {
        this.added = added;
    }

    public String getDeleted() {
        return this.deleted;
    }

    public void setDeleted(String deleted) {
        this.deleted = deleted;
    }

    public int getTotalCobols() {
        HashSet<String> set = new HashSet<String>();
        for (Cobol cobol : this.getCobols()) {
            String key = cobol.getFilename();
            if (cobol.getDifferences().size() <= 0) continue;
            set.add(key);
        }
        return set.size();
    }

    public int getTotalCobols(String text) {
        return 0;
    }

    public String getCobolFileNames() {
        HashSet<String> set = new HashSet<String>();
        String result = "";
        for (Cobol cobol : this.getCobols()) {
            String key = cobol.getFilename();
            if (set.contains(key)) continue;
            set.add(key);
            result = String.valueOf(result) + key + ";" + cobol.getEntityName() + ";" + cobol.getLibraryName() + "\r\n";
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof Template) {
            Template template = (Template)o;
            if (this.getHashCode() != 0 && template.getHashCode() != 0) {
                boolean result;
                boolean bl = result = this.getHashCode() == template.getHashCode();
                if (result) {
                    if (!this.hasDuplicates && !template.hasDuplicates) {
                        return this.isCloned == template.isCloned && this.state == template.getState() && this.isSameMetatemplate(template);
                    }
                } else {
                    return result;
                }
            }
            return template.getAdded().equals(this.getAdded()) && template.getDeleted().equals(this.getDeleted()) && template.getNature().equals(this.getNature()) && this.isCloned == template.isCloned && this.state == template.getState() && this.isSameMetatemplate(template);
        }
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private boolean isSameMetatemplate(Template template) {
        if (this.cloneMetaTemplateOwner == template.cloneMetaTemplateOwner) {
            return true;
        }
        if (this.cloneMetaTemplateOwner != null && template.cloneMetaTemplateOwner != null) {
            return this.cloneMetaTemplateOwner.getName().equals(template.getCloneMetaTemplateOwner().getName());
        }
        return false;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    public void setHashCode(int hashCode) {
        this.hashCode = hashCode;
    }

    public Template getOpposite() {
        return this.opposite;
    }

    public void setOpposite(Template opposite) {
        this.opposite = opposite;
    }

    public int getCobolGap() {
        return this.cobolGap;
    }

    public void setCobolGap(int cobolGap) {
        this.cobolGap = cobolGap;
    }

    public int getDifferenceGap() {
        return this.differenceGap;
    }

    public void setDifferenceGap(int differenceGap) {
        this.differenceGap = differenceGap;
    }

    public void setCobols(List<Cobol> cobols) {
        this.cobols = cobols;
    }

    public boolean isCloned() {
        return this.isCloned;
    }

    public Template getRealTemplate() {
        return this.realTemplate;
    }

    public static Template cloneForMetaTemplate(Template template, MetaTemplate cloneMetaTemplateOwner) {
        Template clone = Template.cloneTemplate(template);
        clone.isCloned = true;
        clone.realTemplate = template;
        clone.cloneMetaTemplateOwner = cloneMetaTemplateOwner;
        return clone;
    }

    public static Template cloneTemplate(Template template) {
        Template clone = new Template(template.getNumber());
        clone.setAdded(template.getAdded());
        clone.setDeleted(template.getDeleted());
        clone.setNature(template.getNature());
        clone.setHashCode(template.getHashCode());
        clone.setNbAdded(template.getNbAdded());
        clone.setNbDeleted(template.getNbDeleted());
        clone.setHashCode(template.getHashCode());
        clone.hasDuplicates = template.hasDuplicates;
        return clone;
    }

    public String getId() {
        if (this.getHashCode() != 0 && !this.hasDuplicates) {
            return Integer.toString(this.getHashCode());
        }
        return String.valueOf(this.getAdded()) + this.getDeleted() + this.getNature() + this.getNumber();
    }

    public MetaTemplate getCloneMetaTemplateOwner() {
        return this.cloneMetaTemplateOwner;
    }

    public static enum State {
        DIRTY,
        NEW,
        MODIFY,
        DELETED;

    }
}

