/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare.tools.model;

import com.ibm.pdp.cobolcompare.tools.model.GeneratedTag;
import com.ibm.pdp.util.containers.HashedSet;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TagReport {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    Map<String, Set<GeneratedTag>> newTags = new HashMap<String, Set<GeneratedTag>>();
    Map<String, Set<GeneratedTag>> treeTags = new HashMap<String, Set<GeneratedTag>>();
    Map<String, Set<GeneratedTag>> orderTags = new HashMap<String, Set<GeneratedTag>>();
    Map<String, Set<GeneratedTag>> deletedTags = new HashMap<String, Set<GeneratedTag>>();
    Map<String, Set<GeneratedTag>> unkownTags = new HashMap<String, Set<GeneratedTag>>();
    Set<GeneratedTag> tags = null;
    Map<String, Integer> differences;
    Map<String, Set<GeneratedTag>> modelsTags;
    Map<String, Integer> uniqueTemplates;

    public void setTags(Set<GeneratedTag> tags, boolean populateDiffAndTagsCountMap) {
        this.tags = tags;
        for (GeneratedTag tag : tags) {
            HashedSet tags2;
            Map<String, Set<GeneratedTag>> currentMap = this.unkownTags;
            if (tag.getState() == GeneratedTag.State.NEW) {
                currentMap = this.newTags;
            } else if (tag.getState() == GeneratedTag.State.PARENT) {
                currentMap = this.treeTags;
            } else if (tag.getState() == GeneratedTag.State.ORDER) {
                currentMap = this.orderTags;
            } else if (tag.getState() == GeneratedTag.State.DELETED) {
                currentMap = this.deletedTags;
            }
            Set<GeneratedTag> generatedTags = currentMap.get(tag.getTagName());
            if (generatedTags == null) {
                generatedTags = new HashSet<GeneratedTag>();
                currentMap.put(tag.getTagName(), generatedTags);
            }
            generatedTags.add(tag);
            if (!populateDiffAndTagsCountMap) continue;
            if (this.differences == null) {
                this.differences = new HashMap<String, Integer>();
            }
            if (!this.differences.containsKey(tag.getModelFileName())) {
                this.differences.put(tag.getModelFileName(), tag.differences);
            }
            if (this.uniqueTemplates == null) {
                this.uniqueTemplates = new HashMap<String, Integer>();
            }
            if (!this.uniqueTemplates.containsKey(tag.getModelFileName())) {
                this.uniqueTemplates.put(tag.getModelFileName(), tag.uniqueTemplates);
            }
            if (this.modelsTags == null) {
                this.modelsTags = new HashMap<String, Set<GeneratedTag>>();
            }
            if ((tags2 = this.modelsTags.get(tag.modelFileName)) == null) {
                tags2 = new HashedSet();
                this.modelsTags.put(tag.getModelFileName(), (Set<GeneratedTag>)tags2);
            }
            tags2.add((GeneratedTag)tag);
        }
    }

    public void generateOverview(String reportFolder) throws IOException {
        this.generateOverview(reportFolder, this.newTags, GeneratedTag.State.NEW);
        this.generateOverview(reportFolder, this.treeTags, GeneratedTag.State.PARENT);
        this.generateOverview(reportFolder, this.orderTags, GeneratedTag.State.ORDER);
        this.generateOverview(reportFolder, this.deletedTags, GeneratedTag.State.DELETED);
        if (!this.unkownTags.isEmpty()) {
            this.generateOverview(reportFolder, this.unkownTags, GeneratedTag.State.UNKNOWN);
        }
    }

    public void generateOverview(String reportFolder, Map<String, Set<GeneratedTag>> map, GeneratedTag.State state) throws IOException {
        String outputFileName = String.valueOf(reportFolder) + "/MigrationMiaAndRppGenInfoOverview_" + state.toString() + ".csv";
        FileWriter fstream = new FileWriter(outputFileName);
        BufferedWriter writer = new BufferedWriter(fstream);
        writer.write("State;Name;Occurs\r\n");
        TreeMap<Set<GeneratedTag>, String> treeMap = new TreeMap<Set<GeneratedTag>, String>(new ValueComparator());
        for (String tagName : map.keySet()) {
            Set<GeneratedTag> key = map.get(tagName);
            treeMap.put(key, tagName);
        }
        for (String tagName : treeMap.values()) {
            writer.write(String.valueOf(state.toString().toLowerCase()) + ";" + tagName + ";" + map.get(tagName).size() + "\r\n");
        }
        writer.close();
    }

    public void generateStatesOverview(String reportFolder) throws Exception {
        StatesStats stats;
        if (this.tags == null) {
            return;
        }
        int totNewTags = this.getTagsNamesForState(GeneratedTag.State.NEW).length;
        int totDeletedTags = this.getTagsNamesForState(GeneratedTag.State.DELETED).length;
        int totOrderTags = this.getTagsNamesForState(GeneratedTag.State.ORDER).length;
        int totTreeTags = this.getTagsNamesForState(GeneratedTag.State.PARENT).length;
        int totDifferences = this.getTagsNamesForState(GeneratedTag.State.NEW).length;
        String outputFileName = String.valueOf(reportFolder) + "/MigrationMiaAndRppGenInfoOverviewStates.csv";
        FileWriter fstream = new FileWriter(outputFileName);
        BufferedWriter writer = new BufferedWriter(fstream);
        writer.write("Model;Cobol;Order;Parent;Deleted;New;Total;Differences;;Nb Tags Order;Nb Tags Parent;Nb Tags Deleted;Nb Tags New;Nb Tags Total;Total Differences\r\n");
        HashMap<Object, StatesStats> map = new HashMap<Object, StatesStats>();
        HashSet<Object> models = new HashSet<Object>();
        for (GeneratedTag tag : this.tags) {
            String key = tag.getModelFileName();
            stats = (StatesStats)map.get(key);
            boolean totalInc = false;
            if (!models.contains(key)) {
                totalInc = true;
                models.add(key);
            }
            if (stats == null) {
                stats = new StatesStats();
                map.put(key, stats);
            }
            if (tag.state == GeneratedTag.State.DELETED) {
                ++stats.deletedTags;
            } else if (tag.state == GeneratedTag.State.NEW) {
                ++stats.newTags;
            } else if (tag.state == GeneratedTag.State.ORDER) {
                ++stats.orderTags;
            } else if (tag.state == GeneratedTag.State.PARENT) {
                ++stats.treeTags;
            }
            stats.differences = tag.differences;
            if (!totalInc) continue;
            totDifferences += stats.differences;
        }
        TreeMap<StatesStats, String> treeMap = new TreeMap<StatesStats, String>(new StateComparator());
        for (String model : map.keySet()) {
            stats = (StatesStats)map.get(model);
            treeMap.put(stats, model);
        }
        boolean firtLine = true;
        for (String model : treeMap.values()) {
            StatesStats stats2 = (StatesStats)map.get(model);
            writer.write(String.valueOf(model) + ";" + this.getCobolForModel(model) + ";" + stats2.orderTags + ";" + stats2.treeTags + ";" + stats2.deletedTags + ";" + stats2.newTags + ";" + stats2.getTotal() + ";" + stats2.differences);
            if (firtLine) {
                firtLine = false;
                writer.write(";;" + totOrderTags + ";" + totTreeTags + ";" + totDeletedTags + ";" + totNewTags + ";" + (totOrderTags + totTreeTags + totDeletedTags + totNewTags) + ";" + totDifferences);
            }
            writer.write("\r\n");
        }
        writer.close();
    }

    private String getCobolForModel(String modelName) {
        for (GeneratedTag tag : this.tags) {
            if (tag.modelFileName != modelName) continue;
            return tag.cobolFileName;
        }
        return null;
    }

    public String[] getTagsNamesForState(GeneratedTag.State state) {
        Map<String, Set<GeneratedTag>> currentMap = this.unkownTags;
        if (state == GeneratedTag.State.NEW) {
            currentMap = this.newTags;
        } else if (state == GeneratedTag.State.PARENT) {
            currentMap = this.treeTags;
        } else if (state == GeneratedTag.State.DELETED) {
            currentMap = this.deletedTags;
        } else if (state == GeneratedTag.State.ORDER) {
            currentMap = this.orderTags;
        }
        TreeMap<Set<GeneratedTag>, String> treeMap = new TreeMap<Set<GeneratedTag>, String>(new ValueComparator());
        for (String tagName : currentMap.keySet()) {
            Set<GeneratedTag> key = currentMap.get(tagName);
            treeMap.put(key, tagName);
        }
        return treeMap.values().toArray(new String[treeMap.keySet().size()]);
    }

    public Set<GeneratedTag> getTagsForState(GeneratedTag.State state, String tagName) {
        Map<String, Set<GeneratedTag>> currentMap = this.unkownTags;
        if (state == GeneratedTag.State.NEW) {
            currentMap = this.newTags;
        } else if (state == GeneratedTag.State.PARENT) {
            currentMap = this.treeTags;
        } else if (state == GeneratedTag.State.DELETED) {
            currentMap = this.deletedTags;
        } else if (state == GeneratedTag.State.ORDER) {
            currentMap = this.orderTags;
        }
        Set<GeneratedTag> tags = currentMap.get(tagName);
        return tags;
    }

    public int getNbModels() {
        HashedSet models = new HashedSet();
        for (GeneratedTag tag : this.tags) {
            models.add(tag.getModelFileName());
        }
        return models.size();
    }

    public Set<String> getModels() {
        if (this.differences != null) {
            return this.differences.keySet();
        }
        return new HashedSet();
    }

    public Set<GeneratedTag> getGeneratedTagFor(String modelFileName, GeneratedTag.State state) {
        if (this.modelsTags == null || !this.modelsTags.containsKey(modelFileName)) {
            return new HashedSet();
        }
        HashedSet tags = new HashedSet();
        for (GeneratedTag tag : this.modelsTags.get(modelFileName)) {
            if (tag.state != state) continue;
            tags.add(tag);
        }
        return tags;
    }

    public int getDifferences(String modelFileName) {
        if (this.differences == null) {
            return 0;
        }
        Integer result = this.differences.get(modelFileName);
        return result == null ? 0 : result;
    }

    public int getNbTags(String modelFileName) {
        if (this.modelsTags == null || !this.modelsTags.containsKey(modelFileName)) {
            return 0;
        }
        return this.modelsTags.get(modelFileName).size();
    }

    public int getUniqueTemplates(String modelFileName) {
        if (this.uniqueTemplates == null) {
            return 0;
        }
        Integer result = this.uniqueTemplates.get(modelFileName);
        return result == null ? 0 : result;
    }

    class StateComparator
    implements Comparator<StatesStats> {
        @Override
        public int compare(StatesStats a, StatesStats b) {
            if (a.getTotal() >= b.getTotal()) {
                return -1;
            }
            return 1;
        }
    }

    private static class StatesStats {
        int newTags;
        int deletedTags;
        int orderTags;
        int treeTags;
        int differences;

        private StatesStats() {
        }

        public int getTotal() {
            return this.newTags + this.deletedTags + this.orderTags + this.treeTags;
        }
    }

    class ValueComparator
    implements Comparator<Set<GeneratedTag>> {
        @Override
        public int compare(Set<GeneratedTag> a, Set<GeneratedTag> b) {
            if (a.size() > b.size()) {
                return -1;
            }
            if (a.size() == b.size()) {
                if (a.isEmpty()) {
                    return -1;
                }
                GeneratedTag tag1 = a.iterator().next();
                GeneratedTag tag2 = b.iterator().next();
                if (tag1.getTagName().compareTo(tag2.getTagName()) < 0) {
                    return -1;
                }
                return 1;
            }
            return 1;
        }
    }
}

