/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare.tools.model;

import com.ibm.pdp.cobolcompare.CobolDifferencer;
import com.ibm.pdp.cobolcompare.tools.analyser.ReportAnalyser;
import com.ibm.pdp.cobolcompare.tools.model.Cobol;
import com.ibm.pdp.cobolcompare.tools.model.Difference;
import com.ibm.pdp.cobolcompare.tools.model.MetaTemplate;
import com.ibm.pdp.cobolcompare.tools.model.PatternGroup;
import com.ibm.pdp.cobolcompare.tools.model.Template;
import com.ibm.pdp.util.csv.CsvWriter;
import com.ibm.pdp.util.diff.DiffCursor;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Report {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String BAD_CONSTANT = "BAD_CONSTANT";
    public static final String PROCEDURE = "PROCEDURE";
    public static final String WORKING = "WORKING";
    public static final String BUG_PAC = "BUGPAC";
    public static final String WONT_DO = "WONTDO";
    public static final String OPPOSITEDIFF = "OPPOSITEDIFF";
    public static final String OPPOSITETMPL = "OPPOSITETMPL";
    public static final String OTHER = "(OTHER)";
    public static final String RPP = "(RPP)";
    public static final String COB = "cob(";
    public static final String ISOCOB = "isoCob(";
    public static final String ISOCOB_ID = "COBISO_";
    public static final String COB_ID = "COB_";
    public static final String DIFF = "(DIFF)";
    public static final String PAIRED = "(PAIRED)";
    public static final String TMPLINFO = "(TMPLINFO";
    public static final String TMPLHC = "(TMPLHC";
    public static final String TMPLPAT = "(TMPLPAT";
    public static final String PROCEDURE_DIFF = "(PROCEDURE)";
    public static final String WORKING_DIFF = "(WORKING)";
    public static final String WRONGINDEX_LEFT = "WRONGINDEX_LEFT";
    public static final String WRONGINDEX_RIGHT = "WRONGINDEX_RIGHT";
    public static final String WRONG_DIFFERENCE_BUG = "WRONG_DIFFERENCE_BUG";
    public static final String LITERAL_WHITE_SPACE = "LITERAL_WHITE_SPACE";
    public static final String LITERAL_DOT = "LITERAL_DOT";
    public static final String GEO_WHITE_LINE = "GEO_WHITE_LINE";
    public static final String NOT_CATEGORIZED = "NOT_CATEGORIZED_TEMPLATES";
    public static final String NOT_CATEGORIZED_PATTERNS = "NOT_CATEGORIZED_PATTERNS";
    public static final String QUOTE_DIFFER = "QUOTE_DIFFER";
    public static final String WHITE_SPACE_DIFFER = "WHITE_SPACE_DIFFER";
    public static final String QUOTE_WHITE_SPACE_DIFFER = "QUOTE_WHITE_SPACE_DIFFER";
    public static final String VIRTUAL_MACRO_TAG = "VIRTUAL_MACRO_TAG";
    public static final String RIGHT_MARK_DIFFER = "RIGHT_MARK_DIFFER";
    private Map<String, List<Template>> ignoredTemplates = null;
    private Map<MetaTemplate, List<Difference>> pairedMetatemplates = null;
    private List<Template> analyzedTemplates = null;
    private List<Template> templates = new ArrayList<Template>();
    private List<Template> deletedTemplates = new ArrayList<Template>();
    private List<Template> deletedModifiedTemplates = new ArrayList<Template>();
    private List<MetaTemplate> metaTemplates = new ArrayList<MetaTemplate>();
    private List<PatternGroup> patternGroups = new ArrayList<PatternGroup>();
    private List<Cobol> noDiffCobols = new ArrayList<Cobol>();
    private List<Cobol> diffCobols = new ArrayList<Cobol>();
    private List<String> ignoredPatternsList = new ArrayList<String>();
    private int nbFiles;
    private int nbTotalFiles = -1;
    private int nbNotMigratedFiles = -1;
    private double migAverageTime = -1.0;
    private int nbExcludedCobol;
    boolean ignoreBugPac = false;
    boolean ignoreWontDo = false;
    boolean ignorePatterns = false;
    List<Template> clonedTemplates = null;
    private boolean isOptimized;
    private String buildLabel;
    private String priority;
    private String extracVersion;
    private boolean isInCompare;
    private int nbRealDifferences;
    private Set<String> nbIsoCobols = null;
    public static boolean debug = false;
    private static String EOL = System.getProperty("line.separator");
    private static DecimalFormat df = new DecimalFormat("#00,00");
    private boolean hasBadConstant = false;
    private int nbBadConstants;
    private int nbIsoCobolsDifferences;
    private String locationName;
    public static final Map<String, String> SPECIAL_CHARS;

    static {
        debug = "true".equals(System.getProperty("debugCompTools"));
        SPECIAL_CHARS = new HashMap<String, String>();
        SPECIAL_CHARS.put("#", "\\u23");
        SPECIAL_CHARS.put("%", "\\u25");
    }

    public boolean hasBadConstant() {
        return this.hasBadConstant;
    }

    public void setHasBadConstant(boolean hasBadConstant) {
        this.hasBadConstant = hasBadConstant;
    }

    public List<Template> getTemplates() {
        return this.templates;
    }

    public int getNbTemplates() {
        int nbTemplates = 0;
        for (Template template : this.getTemplates()) {
            if (template.isCloned()) continue;
            ++nbTemplates;
        }
        return nbTemplates;
    }

    public int getNbIsoCobols() {
        return this.nbIsoCobols == null ? 0 : this.nbIsoCobols.size();
    }

    public List<MetaTemplate> getMetaTemplates() {
        return this.metaTemplates;
    }

    public Template getTemplate(int templateId) {
        for (Template template : this.getAllTemplates()) {
            if (template.getNumber() != templateId) continue;
            return template;
        }
        return null;
    }

    public Template getTemplateByHashCode(int hashCode) {
        for (Template template : this.getAllTemplates()) {
            if (template.getHashCode() != hashCode) continue;
            return template;
        }
        return null;
    }

    public int getDifferencesCount() {
        int diff = 0;
        for (Template template : this.getTemplates()) {
            for (Cobol cobol : template.getCobols()) {
                diff += cobol.getDifferences().size();
            }
        }
        return diff;
    }

    public int getDifferencesControlCount() {
        int diff = 0;
        for (Template template : this.getTemplates()) {
            for (Cobol cobol : template.getCobols()) {
                diff += cobol.getDifferences().size();
            }
        }
        if (this.ignoredTemplates != null) {
            for (List list : this.ignoredTemplates.values()) {
                if (list == null) continue;
                for (Template template : list) {
                    for (Cobol cobol : template.getCobols()) {
                        diff += cobol.getDifferences().size();
                    }
                }
            }
        }
        return diff;
    }

    public List<Template> getDeletedModifiedTemplates() {
        return this.deletedModifiedTemplates;
    }

    private void filterCobolsPatternTemplates(List<MetaTemplate> _metaTemplates, boolean ignoreCobols, String ID, String COBID, String locationName) {
        HashSet<MetaTemplate> metaTemplatesToRemove = new HashSet<MetaTemplate>();
        ArrayList<Template> _clonedTemplates = new ArrayList<Template>();
        for (MetaTemplate metaTemplate : _metaTemplates) {
            ArrayList<Template> templatesToRemove = new ArrayList<Template>();
            if (metaTemplate.getGroupPatternName() != null && metaTemplate.getGroupPatternName().contains(ID)) {
                for (String cobolName : this.getCobolsFromMetaTemplateName(metaTemplate, COBID)) {
                    this.removeTemplatesForCobol(cobolName, metaTemplate, templatesToRemove, _clonedTemplates, ISOCOB_ID.equals(ID), locationName);
                }
                metaTemplatesToRemove.add(metaTemplate);
                this.getMetaTemplates().add(metaTemplate);
            }
            if (templatesToRemove.isEmpty()) continue;
            this.templates.removeAll(templatesToRemove);
        }
        if (!ignoreCobols && !_clonedTemplates.isEmpty()) {
            this.getTemplates().addAll(_clonedTemplates);
        }
        if (ISOCOB_ID.equals(ID)) {
            for (MetaTemplate metaTemplate : metaTemplatesToRemove) {
                this.nbIsoCobolsDifferences += metaTemplate.getTotalDifferences();
            }
        }
        if (ignoreCobols) {
            this.metaTemplates.removeAll(metaTemplatesToRemove);
            this.ignoredTemplates.put(ID, _clonedTemplates);
        }
    }

    private void removeTemplatesForCobol(String cobolName, MetaTemplate metaTemplate, List<Template> templatesToRemove, List<Template> _clonedTemplates, boolean isIsoCob, String locationName) {
        for (Template template : this.getTemplates()) {
            HashSet<Cobol> cobolsToRemove = new HashSet<Cobol>();
            for (Cobol cobol : template.getCobols()) {
                if (!this.isSameIsoCobol(cobol, cobolName, locationName)) continue;
                cobolsToRemove.add(cobol);
                if (!isIsoCob) continue;
                this.nbIsoCobols.add(cobolName);
            }
            if (cobolsToRemove.isEmpty()) continue;
            template.getCobols().removeAll(cobolsToRemove);
            if (template.getCobols().size() == 0) {
                templatesToRemove.add(template);
            }
            Template cloneTemplate = null;
            for (Template clone : this.clonedTemplates) {
                if (clone.getCloneMetaTemplateOwner() != metaTemplate || !template.getId().equals(clone.getId())) continue;
                cloneTemplate = clone;
                break;
            }
            if (cloneTemplate == null) {
                cloneTemplate = Template.cloneForMetaTemplate(template, metaTemplate);
                this.clonedTemplates.add(cloneTemplate);
                metaTemplate.getTemplates().add(cloneTemplate);
                _clonedTemplates.add(cloneTemplate);
            }
            cloneTemplate.getCobols().addAll(cobolsToRemove);
        }
    }

    private boolean isSameIsoCobol(Cobol cobol, String cobolName, String locationName) {
        String mainLocation;
        String[] items;
        boolean result;
        String fileName = cobol.getFilename();
        boolean bl = result = fileName.equals(cobolName) || fileName.contains(cobolName) || fileName.replace('/', '\\').contains(cobolName);
        if (locationName != null && !result && (items = locationName.split("_")).length > 2 && cobolName.contains(mainLocation = String.valueOf(items[0]) + '_' + items[1])) {
            String tempFileName = fileName.replace(locationName, mainLocation);
            result = tempFileName.contains(cobolName) || tempFileName.replace('/', '\\').contains(cobolName);
        }
        return result;
    }

    private void filterPatternTemplates(String patternFolder) {
        for (String ignore : this.getIgnoredPatterns(patternFolder)) {
            ArrayList<Template> _ignoredTemplates = new ArrayList<Template>();
            for (MetaTemplate metaTemplate : this.metaTemplates) {
                if (!ignore.equals(metaTemplate.getGroupPatternName())) continue;
                _ignoredTemplates.addAll(metaTemplate.getTemplates());
                metaTemplate.getTemplates().clear();
            }
            if (_ignoredTemplates.isEmpty()) continue;
            this.templates.removeAll(_ignoredTemplates);
            this.ignoredTemplates.put(ignore, _ignoredTemplates);
        }
    }

    private List<String> getIgnoredPatterns(String patternFolder) {
        File file;
        this.ignoredPatternsList.clear();
        ArrayList<String> list = new ArrayList<String>();
        if (this.ignoreBugPac) {
            list.add(BUG_PAC);
        }
        if (this.ignoreWontDo) {
            list.add(WONT_DO);
        }
        if (this.ignorePatterns && (file = this.getPatternFile(patternFolder, "ignored_patterns.txt")) != null && file.exists()) {
            try {
                for (String line : ReportAnalyser.readFile(file)) {
                    int idx = line.indexOf(35);
                    if (idx > 0) {
                        String group = line.substring(0, idx).trim();
                        if (group.length() <= 0) continue;
                        this.ignoredPatternsList.add(group);
                        continue;
                    }
                    this.ignoredPatternsList.add(line);
                }
                list.addAll(this.ignoredPatternsList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public boolean applyPatterns(String patternDirName, boolean filterOpposites, boolean filterOthers, boolean ignoreBugPac, boolean ignoreWontDo, boolean ignoreIsoCobols, String locationName, boolean ignorePatterns, boolean optimize, boolean isQuiet) throws Exception {
        if (this.analyzedTemplates == null) {
            this.backupTemplates();
        } else {
            this.restoreTemplates();
        }
        this.ignoreBugPac = ignoreBugPac;
        this.ignoreWontDo = ignoreWontDo;
        this.ignorePatterns = ignorePatterns;
        this.ignoredTemplates = new HashMap<String, List<Template>>();
        this.clonedTemplates = new ArrayList<Template>();
        this.pairedMetatemplates = new HashMap<MetaTemplate, List<Difference>>();
        this.nbIsoCobols = new HashSet<String>();
        this.nbIsoCobolsDifferences = 0;
        List<Template> allTemplates = this.getAllTemplates();
        File file = this.getPatternFile(patternDirName, "pattern.txt");
        List<MetaTemplate> _metaTemplates = this.readMetaTemplates(file, locationName);
        this.metaTemplates.clear();
        HashSet<Template> matchedTempates = new HashSet<Template>();
        HashSet<MetaTemplate> matchedOtherMetaTempates = new HashSet<MetaTemplate>();
        for (MetaTemplate metaTemplate : _metaTemplates) {
            if (debug) {
                System.err.println("Apply : " + metaTemplate.getName());
            }
            String[] detetedPatterns = null;
            String[] addedPatterns = null;
            if (metaTemplate.getDeletedPattern().indexOf("%") > 0) {
                StringTokenizer tokenizer = new StringTokenizer(metaTemplate.getDeletedPattern(), "%");
                int nbTokens = tokenizer.countTokens();
                detetedPatterns = new String[nbTokens];
                int i = 0;
                while (i < nbTokens) {
                    detetedPatterns[i] = tokenizer.nextToken();
                    ++i;
                }
                tokenizer = new StringTokenizer(metaTemplate.getAddedPattern(), "%");
                nbTokens = tokenizer.countTokens();
                addedPatterns = new String[nbTokens];
                i = 0;
                while (i < nbTokens) {
                    addedPatterns[i] = tokenizer.nextToken();
                    ++i;
                }
            } else {
                detetedPatterns = new String[]{metaTemplate.getDeletedPattern()};
                addedPatterns = new String[]{metaTemplate.getAddedPattern()};
            }
            if (!optimize && filterOpposites && metaTemplate.getDeletedPattern().contains(OPPOSITEDIFF)) {
                this.filterOppositeDiffMetaTemplates(metaTemplate, allTemplates, matchedTempates);
                if (metaTemplate.getTemplates().size() <= 0) continue;
                matchedTempates.addAll(metaTemplate.getTemplates());
                this.getMetaTemplates().add(0, metaTemplate);
                continue;
            }
            if (!optimize && filterOpposites && metaTemplate.getDeletedPattern().contains(OPPOSITETMPL)) {
                this.filterOppositeTmplMetaTemplates(metaTemplate, allTemplates, matchedTempates);
                if (metaTemplate.getTemplates().size() <= 0) continue;
                matchedTempates.addAll(metaTemplate.getTemplates());
                this.getMetaTemplates().add(0, metaTemplate);
                continue;
            }
            if (!optimize && metaTemplate.getDeletedPattern().contains(WRONGINDEX_LEFT)) {
                this.filterWrongPlacedCodeInRpp(metaTemplate, allTemplates, matchedTempates, true);
                if (metaTemplate.getTemplates().size() <= 0) continue;
                matchedTempates.addAll(metaTemplate.getTemplates());
                this.getMetaTemplates().add(0, metaTemplate);
                continue;
            }
            if (!optimize && metaTemplate.getDeletedPattern().contains(WRONGINDEX_RIGHT)) {
                this.filterWrongPlacedCodeInRpp(metaTemplate, allTemplates, matchedTempates, false);
                if (metaTemplate.getTemplates().size() <= 0) continue;
                matchedTempates.addAll(metaTemplate.getTemplates());
                this.getMetaTemplates().add(0, metaTemplate);
                continue;
            }
            if (!optimize && metaTemplate.getDeletedPattern().contains(WRONG_DIFFERENCE_BUG)) {
                this.filterWrongDifferenceBug(metaTemplate, allTemplates, matchedTempates);
                if (metaTemplate.getTemplates().size() <= 0) continue;
                matchedTempates.addAll(metaTemplate.getTemplates());
                this.getMetaTemplates().add(0, metaTemplate);
                continue;
            }
            if (metaTemplate.getDeletedPattern().contains(LITERAL_WHITE_SPACE)) {
                this.filterSameLiteralContent(metaTemplate, allTemplates, matchedTempates);
                if (metaTemplate.getTemplates().size() <= 0) continue;
                matchedTempates.addAll(metaTemplate.getTemplates());
                this.getMetaTemplates().add(0, metaTemplate);
                continue;
            }
            if (metaTemplate.getDeletedPattern().contains(VIRTUAL_MACRO_TAG)) {
                this.filterVirtualMacroTag(metaTemplate, allTemplates, matchedTempates);
                if (metaTemplate.getTemplates().size() <= 0) continue;
                matchedTempates.addAll(metaTemplate.getTemplates());
                this.getMetaTemplates().add(0, metaTemplate);
                continue;
            }
            if (metaTemplate.getDeletedPattern().contains(RIGHT_MARK_DIFFER)) {
                this.filterRigthMarkDiffer(metaTemplate, allTemplates, matchedTempates);
                if (metaTemplate.getTemplates().size() <= 0) continue;
                matchedTempates.addAll(metaTemplate.getTemplates());
                this.getMetaTemplates().add(0, metaTemplate);
                continue;
            }
            if (metaTemplate.getDeletedPattern().contains(LITERAL_DOT)) {
                this.filterSameLiteralContentDot(metaTemplate, allTemplates, matchedTempates);
                if (metaTemplate.getTemplates().size() <= 0) continue;
                matchedTempates.addAll(metaTemplate.getTemplates());
                this.getMetaTemplates().add(0, metaTemplate);
                continue;
            }
            if (metaTemplate.getDeletedPattern().contains(GEO_WHITE_LINE)) {
                this.filterGeoBlankLines(metaTemplate, allTemplates, matchedTempates);
                if (metaTemplate.getTemplates().size() <= 0) continue;
                matchedTempates.addAll(metaTemplate.getTemplates());
                this.getMetaTemplates().add(0, metaTemplate);
                continue;
            }
            if (metaTemplate.getDeletedPattern().contains(QUOTE_DIFFER)) {
                this.filterQuoteDifferLines(metaTemplate, allTemplates, matchedTempates);
                if (metaTemplate.getTemplates().size() <= 0) continue;
                matchedTempates.addAll(metaTemplate.getTemplates());
                this.getMetaTemplates().add(0, metaTemplate);
                continue;
            }
            if (metaTemplate.getDeletedPattern().contains(QUOTE_WHITE_SPACE_DIFFER)) {
                this.filterQuoteDifferAndWhiteSpaceLines(metaTemplate, allTemplates, matchedTempates);
                if (metaTemplate.getTemplates().size() <= 0) continue;
                matchedTempates.addAll(metaTemplate.getTemplates());
                this.getMetaTemplates().add(0, metaTemplate);
                continue;
            }
            if (metaTemplate.getDeletedPattern().contains(WHITE_SPACE_DIFFER)) {
                this.filterWhiteSpaceDifferLines(metaTemplate, allTemplates, matchedTempates);
                if (metaTemplate.getTemplates().size() <= 0) continue;
                matchedTempates.addAll(metaTemplate.getTemplates());
                this.getMetaTemplates().add(0, metaTemplate);
                continue;
            }
            if (metaTemplate.getDeletedPattern().contains("DASH_LINE_RPP_EXACT")) {
                this.filterDashLines(metaTemplate, allTemplates, matchedTempates, false, true, false);
                if (metaTemplate.getTemplates().size() <= 0) continue;
                matchedTempates.addAll(metaTemplate.getTemplates());
                this.getMetaTemplates().add(0, metaTemplate);
                continue;
            }
            if (metaTemplate.getDeletedPattern().contains("DASH_LINE_MIA_EXACT")) {
                this.filterDashLines(metaTemplate, allTemplates, matchedTempates, true, true, false);
                if (metaTemplate.getTemplates().size() <= 0) continue;
                matchedTempates.addAll(metaTemplate.getTemplates());
                this.getMetaTemplates().add(0, metaTemplate);
                continue;
            }
            if (metaTemplate.getDeletedPattern().contains("DASH_LINE_RPP_MISSING_END")) {
                this.filterDashLines(metaTemplate, allTemplates, matchedTempates, false, false, false);
                if (metaTemplate.getTemplates().size() <= 0) continue;
                matchedTempates.addAll(metaTemplate.getTemplates());
                this.getMetaTemplates().add(0, metaTemplate);
                continue;
            }
            if (metaTemplate.getDeletedPattern().contains("DASH_LINE_MIA_MISSING_END")) {
                this.filterDashLines(metaTemplate, allTemplates, matchedTempates, true, false, false);
                if (metaTemplate.getTemplates().size() <= 0) continue;
                matchedTempates.addAll(metaTemplate.getTemplates());
                this.getMetaTemplates().add(0, metaTemplate);
                continue;
            }
            if (metaTemplate.getDeletedPattern().contains("DASH_LINE_RPP_MISSING_BEGINNING")) {
                this.filterDashLines(metaTemplate, allTemplates, matchedTempates, false, false, true);
                if (metaTemplate.getTemplates().size() <= 0) continue;
                matchedTempates.addAll(metaTemplate.getTemplates());
                this.getMetaTemplates().add(0, metaTemplate);
                continue;
            }
            if (metaTemplate.getDeletedPattern().contains("DASH_LINE_MIA_MISSING_BEGINNING")) {
                this.filterDashLines(metaTemplate, allTemplates, matchedTempates, true, false, true);
                if (metaTemplate.getTemplates().size() <= 0) continue;
                matchedTempates.addAll(metaTemplate.getTemplates());
                this.getMetaTemplates().add(0, metaTemplate);
                continue;
            }
            int i = 0;
            while (i < detetedPatterns.length) {
                if (detetedPatterns[i] != null) {
                    String detetedPattern;
                    String string = detetedPattern = detetedPatterns[i].length() == 0 ? "^$" : detetedPatterns[i];
                    if (addedPatterns.length >= i - 1) {
                        String addedPattern = addedPatterns[i].length() == 0 ? "^$" : addedPatterns[i];
                        Pattern dP = detetedPattern.startsWith("uT") ? null : Pattern.compile(detetedPattern);
                        Pattern aP = null;
                        aP = addedPattern.contains("deleted") ? Pattern.compile(detetedPattern) : (addedPattern.startsWith("uT") ? null : Pattern.compile(addedPattern));
                        for (Template template : allTemplates) {
                            this.applyPattern(metaTemplate, template, dP, aP, detetedPattern, addedPattern, matchedTempates, allTemplates, matchedOtherMetaTempates, optimize, filterOthers);
                        }
                    }
                }
                ++i;
            }
            if (!metaTemplate.getTemplates().isEmpty()) {
                this.getMetaTemplates().add(metaTemplate);
            }
            if (this.isCanceled()) break;
        }
        for (MetaTemplate metaTemplate : this.pairedMetatemplates.keySet()) {
            List<Difference> differences = this.pairedMetatemplates.get(metaTemplate);
            ArrayList<Difference> pairedDifferences = new ArrayList<Difference>();
            Iterator detetedPattern = differences.iterator();
            while (detetedPattern.hasNext()) {
                Difference difference = (Difference)detetedPattern.next();
                this.findPairedDifferences(difference, differences, pairedDifferences);
            }
            if (pairedDifferences.isEmpty()) continue;
            this.getMetaTemplates().add(metaTemplate);
            for (Difference difference : pairedDifferences) {
                Cobol clonedCobol;
                Cobol cobol = difference.getCobol();
                cobol.getDifferences().remove(difference);
                Template cloneTemplate = null;
                for (Template clone : this.clonedTemplates) {
                    if (clone.getCloneMetaTemplateOwner() != metaTemplate || !difference.getCobol().getTemplate().getId().equals(clone.getId())) continue;
                    cloneTemplate = clone;
                    break;
                }
                if (cloneTemplate == null) {
                    cloneTemplate = Template.cloneForMetaTemplate(difference.getCobol().getTemplate(), metaTemplate);
                    this.clonedTemplates.add(cloneTemplate);
                }
                if ((clonedCobol = cloneTemplate.getCobol(cobol.getFilename())) == null) {
                    clonedCobol = new Cobol(cobol, cloneTemplate);
                    clonedCobol.setEntityName(cobol.getEntityName());
                    clonedCobol.setLibraryName(cobol.getLibraryName());
                    cloneTemplate.getCobols().add(clonedCobol);
                }
                clonedCobol.getDifferences().add(difference);
                if (metaTemplate.getTemplates().contains(cloneTemplate)) continue;
                metaTemplate.getTemplates().add(cloneTemplate);
            }
        }
        ArrayList<Template> unmachedTemplates = new ArrayList<Template>();
        for (Template template : allTemplates) {
            if (matchedTempates.contains(template)) continue;
            unmachedTemplates.add(template);
        }
        MetaTemplate metaTemplate = new MetaTemplate(NOT_CATEGORIZED, "", "", null);
        metaTemplate.setTemplates(unmachedTemplates);
        this.getMetaTemplates().add(0, metaTemplate);
        if (!this.clonedTemplates.isEmpty()) {
            this.getTemplates().addAll(this.clonedTemplates);
        }
        this.filterPatternTemplates(patternDirName);
        this.filterCobolsPatternTemplates(_metaTemplates, ignoreIsoCobols, ISOCOB_ID, ISOCOB, locationName);
        this.filterCobolsPatternTemplates(_metaTemplates, false, COB_ID, COB, locationName);
        this.applyPatternsGroup(patternDirName);
        HashSet<String> names = new HashSet<String>();
        for (MetaTemplate metaTemplate2 : this.getMetaTemplates()) {
            if (names.contains(metaTemplate2.getName())) {
                System.err.println("Error Duplicate meta template should be merged : " + metaTemplate2.getName());
            } else {
                names.add(metaTemplate2.getName());
            }
            if (this.getAnalyzedFiles() <= 0) continue;
            int cobolCount = this.getCobolsCount();
            int cobolCountWithout = this.getCobolsCountWithout(metaTemplate2);
            double totalRatio = 1.0 - (double)cobolCount / (double)this.getAnalyzedFiles();
            double ratio = 1.0 - (double)cobolCountWithout / (double)this.getAnalyzedFiles();
            metaTemplate2.setExpressGainRatio((ratio - totalRatio) * 10000.0);
            metaTemplate2.setExpressGainCobols(cobolCount - cobolCountWithout);
            metaTemplate2.setIsoCobolsNames(this.getIsoCobols(metaTemplate2));
            ratio = (double)metaTemplate2.getTotalCobols() / (double)this.getAnalyzedFiles();
            metaTemplate2.setTauxRatio(ratio * 10000.0);
        }
        if (debug) {
            System.out.println("#########Used MetaTemplates##############");
            for (MetaTemplate metaTemplate2 : _metaTemplates) {
                if (metaTemplate2.getTotalCobols() == 0) continue;
                for (String line : metaTemplate2.getLines()) {
                    System.out.println(line);
                }
            }
            System.out.println("#########Not Used MetaTemplates##############");
            for (MetaTemplate metaTemplate2 : _metaTemplates) {
                if (metaTemplate2.getTotalCobols() != 0) continue;
                for (String line : metaTemplate2.getLines()) {
                    System.out.println(line);
                }
            }
            System.out.println("############################################################################################################");
        }
        if (!isQuiet) {
            System.out.print(this.displayLog());
        }
        return this.getNbRealDifferences() == this.getDifferencesControlCount();
    }

    private void filterWhiteSpaceDifferLines(MetaTemplate metaTemplate, List<Template> inputTemplates, Set<Template> matchedTempates) {
        for (Template template : inputTemplates) {
            if (matchedTempates.contains(template)) continue;
            String deleted = template.getDeleted().replaceAll("\\s+", " ");
            String added = template.getAdded().replaceAll("\\s+", " ");
            if (deleted.length() == 0 || added.length() == 0 || !deleted.equals(added)) continue;
            metaTemplate.getTemplates().add(template);
            matchedTempates.add(template);
        }
    }

    private boolean isDashLineDifferenceOnly(String mia, String rpp, boolean exactWords, boolean missingBeginning) {
        StringTokenizer stMIA = new StringTokenizer(mia);
        StringTokenizer stRpp = new StringTokenizer(rpp);
        boolean continu = true;
        boolean dashFound = false;
        if (missingBeginning) {
            String tmpTokenRpp = stRpp.nextToken();
            String tmpTokenMia = stMIA.nextToken();
            while (!tmpTokenMia.equals(tmpTokenRpp) && stMIA.hasMoreTokens()) {
                tmpTokenMia = stMIA.nextToken();
            }
            if (stMIA.hasMoreTokens()) {
                StringBuilder tmpMia = new StringBuilder(tmpTokenMia);
                while (stMIA.hasMoreTokens()) {
                    tmpMia.append(" ").append(stMIA.nextToken());
                }
                StringBuilder tmpRpp = new StringBuilder(tmpTokenRpp);
                while (stRpp.hasMoreTokens()) {
                    tmpRpp.append(" ").append(stRpp.nextToken());
                }
                stMIA = new StringTokenizer(tmpMia.toString());
                stRpp = new StringTokenizer(tmpRpp.toString());
            } else {
                stMIA = new StringTokenizer(mia);
                stRpp = new StringTokenizer(rpp);
                tmpTokenRpp = stRpp.nextToken();
                tmpTokenMia = stMIA.nextToken();
                while (!tmpTokenRpp.equals(tmpTokenMia) && stRpp.hasMoreTokens()) {
                    tmpTokenRpp = stRpp.nextToken();
                }
                if (stRpp.hasMoreTokens()) {
                    StringBuilder tmpRpp = new StringBuilder(tmpTokenRpp);
                    while (stRpp.hasMoreTokens()) {
                        tmpRpp.append(" ").append(stRpp.nextToken());
                    }
                    StringBuilder tmpMia = new StringBuilder(tmpTokenMia);
                    while (stMIA.hasMoreTokens()) {
                        tmpMia.append(" ").append(stMIA.nextToken());
                    }
                    stMIA = new StringTokenizer(tmpMia.toString());
                    stRpp = new StringTokenizer(tmpRpp.toString());
                } else {
                    stMIA = new StringTokenizer(mia);
                    stRpp = new StringTokenizer(rpp);
                }
            }
        }
        while (stMIA.hasMoreTokens() && continu) {
            String tokenMIA = stMIA.nextToken();
            if (stRpp.hasMoreTokens()) {
                String tokenRpp = stRpp.nextToken();
                if (tokenMIA.equals(tokenRpp)) continue;
                if ("-".equals(tokenRpp)) {
                    dashFound = true;
                    tokenRpp = stRpp.hasMoreTokens() ? stRpp.nextToken() : "";
                    if ("'".equals(tokenRpp) || "\"".equals(tokenRpp)) {
                        tokenRpp = stRpp.nextToken();
                    } else if (tokenRpp.startsWith("'") || tokenRpp.startsWith("\"")) {
                        tokenRpp = tokenRpp.substring(1);
                    } else {
                        continu = false;
                        continue;
                    }
                    if (tokenMIA.equals(tokenRpp)) continue;
                }
                String lastTokenRpp = tokenRpp;
                tokenRpp = stRpp.hasMoreTokens() ? stRpp.nextToken() : "";
                if ("-".equals(tokenRpp)) {
                    dashFound = true;
                    if (stRpp.hasMoreTokens() && ((tokenRpp = stRpp.nextToken()).startsWith("'") || tokenRpp.startsWith("\"")) && tokenMIA.equals(tokenRpp = String.valueOf(lastTokenRpp) + tokenRpp.substring(1))) {
                        continue;
                    }
                } else if (tokenRpp.startsWith("-")) {
                    dashFound = true;
                    if (((tokenRpp = tokenRpp.substring(1)).startsWith("'") || tokenRpp.startsWith("\"")) && tokenMIA.equals(tokenRpp = String.valueOf(lastTokenRpp) + tokenRpp.substring(1))) continue;
                }
                continu = false;
                continue;
            }
            boolean bl = continu = !exactWords;
        }
        if (exactWords) {
            return !stRpp.hasMoreTokens() && dashFound && continu;
        }
        return dashFound && continu;
    }

    private void filterDashLines(MetaTemplate metaTemplate, List<Template> inputTemplates, Set<Template> matchedTemplates, boolean miaBefore, boolean exactWords, boolean missingBeginning) {
        for (Template template : inputTemplates) {
            if (matchedTemplates.contains(template)) continue;
            ArrayList<Difference> differences = new ArrayList<Difference>();
            ArrayList<Difference> otherDifferences = new ArrayList<Difference>();
            for (Cobol cobol : template.getCobols()) {
                for (Difference difference : cobol.getDifferences()) {
                    String mia = difference.getCroppedMiaCobolCode();
                    int index = 0;
                    while (index != -1) {
                        if ((index = (mia = String.valueOf(mia.substring(0, index)) + "      " + mia.substring(index + 6)).indexOf("\n", index + 1)) == -1) continue;
                        ++index;
                    }
                    String rpp = difference.getCroppedRppCobolCode();
                    if (miaBefore) {
                        if (this.isDashLineDifferenceOnly(mia, rpp, exactWords, missingBeginning)) {
                            differences.add(difference);
                            continue;
                        }
                        otherDifferences.add(difference);
                        continue;
                    }
                    if (this.isDashLineDifferenceOnly(rpp, mia, exactWords, missingBeginning)) {
                        differences.add(difference);
                        continue;
                    }
                    otherDifferences.add(difference);
                }
            }
            if (otherDifferences.isEmpty()) {
                metaTemplate.getTemplates().add(template);
                matchedTemplates.add(template);
                continue;
            }
            if (differences.isEmpty()) continue;
            this.reAffectDifferences(differences, metaTemplate, template);
        }
    }

    private void reAffectDifferences(List<Difference> differences, MetaTemplate metaTemplate, Template template) {
        for (Difference difference : differences) {
            Cobol clonedCobol;
            Cobol cobol = difference.getCobol();
            cobol.getDifferences().remove(difference);
            Template cloneTemplate = null;
            for (Template clone : this.clonedTemplates) {
                if (clone.getCloneMetaTemplateOwner() != metaTemplate || !template.getId().equals(clone.getId())) continue;
                cloneTemplate = clone;
                break;
            }
            if (cloneTemplate == null) {
                cloneTemplate = Template.cloneForMetaTemplate(template, metaTemplate);
                this.clonedTemplates.add(cloneTemplate);
            }
            if ((clonedCobol = cloneTemplate.getCobol(cobol.getFilename())) == null) {
                clonedCobol = new Cobol(cobol, cloneTemplate);
                clonedCobol.setEntityName(cobol.getEntityName());
                clonedCobol.setLibraryName(cobol.getLibraryName());
                cloneTemplate.getCobols().add(clonedCobol);
            }
            clonedCobol.getDifferences().add(difference);
            if (metaTemplate.getTemplates().contains(cloneTemplate)) continue;
            metaTemplate.getTemplates().add(cloneTemplate);
        }
    }

    private void filterQuoteDifferLines(MetaTemplate metaTemplate, List<Template> inputTemplates, Set<Template> matchedTempates) {
        for (Template template : inputTemplates) {
            if (matchedTempates.contains(template)) continue;
            String deleted = template.getDeleted().replaceAll("['\"]", "");
            String added = template.getAdded().replaceAll("['\"]", "");
            if (deleted.length() == 0 || added.length() == 0 || !deleted.equals(added)) continue;
            metaTemplate.getTemplates().add(template);
            matchedTempates.add(template);
        }
    }

    private void filterQuoteDifferAndWhiteSpaceLines(MetaTemplate metaTemplate, List<Template> inputTemplates, Set<Template> matchedTempates) {
        for (Template template : inputTemplates) {
            if (matchedTempates.contains(template)) continue;
            String deleted = template.getDeleted().replaceAll("['\"]", "").replaceAll("\\s+", " ");
            String added = template.getAdded().replaceAll("['\"]", "").replaceAll("\\s+", " ");
            if (deleted.length() == 0 || added.length() == 0 || !deleted.equals(added)) continue;
            metaTemplate.getTemplates().add(template);
            matchedTempates.add(template);
        }
    }

    private void filterGeoBlankLines(MetaTemplate metaTemplate, List<Template> _inputTemplates, Set<Template> matchedTempates) {
        ArrayList<Template> templates = new ArrayList<Template>();
        block0: for (Template template : _inputTemplates) {
            if (matchedTempates.contains(template)) continue;
            for (Cobol cobol : template.getCobols()) {
                for (Difference difference : cobol.getDifferences()) {
                    if (difference.getRppCobolCode() == null || difference.getMiaCobolCode() == null) continue;
                    String[] rppLines = difference.getRppCobolCode().split("\n");
                    String[] miaLines = difference.getMiaCobolCode().split("\n");
                    if (rppLines.length == 0 || rppLines[0].length() < 17) continue;
                    if (rppLines.length != miaLines.length) {
                        if (miaLines.length <= rppLines.length) continue;
                        ArrayList<String> list = new ArrayList<String>();
                        boolean isSame = true;
                        int i = 0;
                        while (i < miaLines.length) {
                            if (miaLines[i].length() < 17) {
                                isSame = false;
                                break;
                            }
                            if (miaLines[i].substring(17).trim().length() > 0) {
                                list.add(miaLines[i]);
                            } else {
                                int j = 0;
                                while (j < rppLines.length) {
                                    if (rppLines[j].equals(miaLines[i])) {
                                        list.add(miaLines[i]);
                                        break;
                                    }
                                    ++j;
                                }
                            }
                            ++i;
                        }
                        if (!isSame || list.size() != rppLines.length) continue;
                        miaLines = list.toArray(new String[rppLines.length]);
                    }
                    String rppRightCode = "";
                    String miaRightCode = "";
                    boolean isSame = true;
                    int i = 0;
                    while (i < rppLines.length) {
                        String miaLeftCode;
                        if (rppLines[i].length() < 17 || miaLines[i].length() < 17) {
                            isSame = false;
                            break;
                        }
                        String rppLeftCode = rppLines[i].substring(0, 17);
                        if (!rppLeftCode.equals(miaLeftCode = miaLines[i].substring(0, 17))) {
                            isSame = false;
                            break;
                        }
                        rppRightCode = String.valueOf(rppRightCode) + rppLines[i].substring(17);
                        miaRightCode = String.valueOf(miaRightCode) + miaLines[i].substring(17);
                        ++i;
                    }
                    if (!isSame || !rppRightCode.trim().equals(miaRightCode.trim())) continue;
                    templates.add(template);
                    matchedTempates.add(template);
                    if (matchedTempates.contains(template)) break;
                }
                if (matchedTempates.contains(template)) continue block0;
            }
        }
        if (templates.size() > 0) {
            metaTemplate.setTemplates(templates);
        }
    }

    protected void applyPattern(MetaTemplate metaTemplate, Template template, Pattern dP, Pattern aP, String detetedPattern, String addedPattern, Set<Template> matchedTempates, List<Template> allTemplates, Set<MetaTemplate> matchedOtherMetaTempates, boolean optimize, boolean filterOthers) {
        boolean isRppRef;
        int idx;
        boolean isDiffPattern;
        if (matchedTempates.contains(template)) {
            return;
        }
        int start = detetedPattern.indexOf("hC(");
        if (start >= 0) {
            int end = detetedPattern.indexOf(")");
            if (end > 0) {
                String hashCodes = detetedPattern.substring(start + 3, end);
                StringTokenizer tokenizer = new StringTokenizer(hashCodes.toString(), ",");
                while (tokenizer.hasMoreTokens()) {
                    String hashCode = tokenizer.nextToken().trim();
                    if (!Integer.toString(template.getHashCode()).equals(hashCode)) continue;
                    metaTemplate.getTemplates().add(template);
                    matchedTempates.add(template);
                }
            }
            return;
        }
        if (metaTemplate.getName().indexOf(TMPLINFO) >= 0) {
            int type = 82;
            int nbAdded = -1;
            int nbDeleted = -1;
            int idx2 = metaTemplate.getName().indexOf(TMPLINFO);
            String info = metaTemplate.getName().substring(idx2 + TMPLINFO.length() + 1);
            idx2 = info.indexOf(41);
            if (idx2 > 0) {
                info = info.substring(0, idx2);
                StringTokenizer stringTokenizer = new StringTokenizer(info, ":");
                type = stringTokenizer.nextToken().charAt(0);
                nbDeleted = Integer.parseInt(stringTokenizer.nextToken());
                nbAdded = Integer.parseInt(stringTokenizer.nextToken());
                boolean found = false;
                if (template.getNature() == "Deletion" && type == 68 || template.getNature() == "Insertion" && type == 73 || template.getNature() == "Replacement" && type == 82) {
                    found = true;
                }
                if (found && nbAdded != -1 && template.getNbAdded() != nbAdded) {
                    found = false;
                }
                if (found && nbDeleted != -1 && template.getNbDeleted() != nbDeleted) {
                    found = false;
                }
                if (found) {
                    metaTemplate.getTemplates().add(template);
                    matchedTempates.add(template);
                }
                return;
            }
        }
        if ((start = detetedPattern.indexOf("uT(")) >= 0) {
            int end = detetedPattern.indexOf(")");
            if (end > 0) {
                String cobols = detetedPattern.substring(start + 3, end);
                StringTokenizer tokenizer = new StringTokenizer(cobols.toString(), ",");
                while (tokenizer.hasMoreTokens()) {
                    String cobol = Cobol.getCobolFileName(tokenizer.nextToken().trim());
                    if (template.getCobols().size() != 1 || !template.getCobols().get(0).getFilename().equals(cobol)) continue;
                    metaTemplate.getTemplates().add(template);
                    matchedTempates.add(template);
                }
            }
            return;
        }
        boolean bl = isDiffPattern = !optimize && metaTemplate.getName().indexOf(DIFF) >= 0;
        if (isDiffPattern && metaTemplate.getName().indexOf(TMPLHC) > 0) {
            idx = metaTemplate.getName().indexOf(TMPLHC);
            String hCs = metaTemplate.getName().substring(idx + TMPLHC.length());
            idx = hCs.indexOf(41);
            if (idx > 0) {
                isDiffPattern = false;
                hCs = hCs.substring(0, idx);
                StringTokenizer stringTokenizer = new StringTokenizer(hCs, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    int hC = Integer.parseInt(stringTokenizer.nextToken().trim());
                    if (template.getHashCode() != hC) continue;
                    isDiffPattern = true;
                    break;
                }
            }
        } else if (isDiffPattern && metaTemplate.getName().indexOf(TMPLPAT) > 0) {
            idx = metaTemplate.getName().indexOf(TMPLPAT);
            String patterns = metaTemplate.getName().substring(idx + TMPLPAT.length());
            idx = patterns.indexOf(41);
            if (idx > 0) {
                isDiffPattern = false;
                patterns = patterns.substring(0, idx);
                StringTokenizer stringTokenizer = new StringTokenizer(patterns, "/");
                String deleted = stringTokenizer.nextToken().trim();
                String added = stringTokenizer.nextToken().trim();
                boolean match = Report.findPatterns(Report.stripCode(template.getDeleted()), Report.stripCode(template.getAdded()), Pattern.compile(deleted), Pattern.compile(added), deleted, added, false);
                if (match) {
                    isDiffPattern = true;
                }
            }
        }
        boolean includeOnlyWorking = metaTemplate.getName().indexOf(WORKING_DIFF) > 0;
        boolean includeOnlyProcedure = metaTemplate.getName().indexOf(PROCEDURE_DIFF) > 0;
        boolean bl2 = isRppRef = metaTemplate.getName().indexOf(RPP) > 0;
        if (isDiffPattern || includeOnlyWorking || includeOnlyProcedure) {
            int diffMatch = 0;
            boolean mach = false;
            if (!isDiffPattern) {
                mach = Report.findPatterns(Report.stripCode(template.getDeleted()), Report.stripCode(template.getAdded()), dP, aP, detetedPattern, addedPattern, isRppRef);
            }
            ArrayList<Difference> differences = new ArrayList<Difference>();
            if (isDiffPattern || mach) {
                for (Cobol cobol : template.getCobols()) {
                    for (Difference difference : cobol.getDifferences()) {
                        boolean isDiffPaired;
                        if (includeOnlyProcedure && !difference.isProcedure() || includeOnlyWorking && difference.isProcedure()) continue;
                        if (isDiffPattern) {
                            String rppCode = difference.getCroppedRppCobolCode();
                            String pacCode = difference.getCroppedMiaCobolCode();
                            if (rppCode != null && pacCode != null && rppCode.indexOf("id=") > 0 && pacCode.indexOf("id=") == -1) {
                                rppCode = rppCode.replaceAll(" id=[0-9]*", "");
                            }
                            mach = Report.findPatterns(pacCode, rppCode, dP, aP, detetedPattern, addedPattern, isRppRef);
                        }
                        boolean bl3 = isDiffPaired = !optimize && metaTemplate.getName().indexOf(PAIRED) >= 0;
                        if (!mach) continue;
                        if (!isDiffPaired) {
                            differences.add(difference);
                            ++diffMatch;
                            continue;
                        }
                        List<Difference> pairedDifferences = this.pairedMetatemplates.get(metaTemplate);
                        if (pairedDifferences == null) {
                            pairedDifferences = new ArrayList<Difference>();
                            this.pairedMetatemplates.put(metaTemplate, pairedDifferences);
                        }
                        pairedDifferences.add(difference);
                    }
                }
            }
            if (diffMatch > 0) {
                if (diffMatch == template.getTotalDifferences()) {
                    if (!metaTemplate.getTemplates().contains(template)) {
                        metaTemplate.getTemplates().add(template);
                    }
                    matchedTempates.add(template);
                } else {
                    for (Difference difference : differences) {
                        Cobol clonedCobol;
                        Cobol cobol = difference.getCobol();
                        cobol.getDifferences().remove(difference);
                        Template cloneTemplate = null;
                        for (Template clone : this.clonedTemplates) {
                            if (clone.getCloneMetaTemplateOwner() != metaTemplate || !template.getId().equals(clone.getId())) continue;
                            cloneTemplate = clone;
                            break;
                        }
                        if (cloneTemplate == null) {
                            cloneTemplate = Template.cloneForMetaTemplate(template, metaTemplate);
                            this.clonedTemplates.add(cloneTemplate);
                        }
                        if ((clonedCobol = cloneTemplate.getCobol(cobol.getFilename())) == null) {
                            clonedCobol = new Cobol(cobol, cloneTemplate);
                            clonedCobol.setEntityName(cobol.getEntityName());
                            clonedCobol.setLibraryName(cobol.getLibraryName());
                            cloneTemplate.getCobols().add(clonedCobol);
                        }
                        clonedCobol.getDifferences().add(difference);
                        if (metaTemplate.getTemplates().contains(cloneTemplate)) continue;
                        metaTemplate.getTemplates().add(cloneTemplate);
                    }
                }
            }
        } else if (filterOthers && !matchedOtherMetaTempates.contains(metaTemplate) && metaTemplate.getName().indexOf(OTHER) >= 0) {
            matchedOtherMetaTempates.add(metaTemplate);
            ArrayList<Template> inputTemplates = new ArrayList<Template>();
            for (Template template2 : allTemplates) {
                if (matchedTempates.contains(template2)) continue;
                inputTemplates.add(template2);
            }
            block8: for (Template dTemplate : inputTemplates) {
                if (!this.isCanceled()) {
                    if (matchedTempates.contains(dTemplate) || dTemplate.getAdded().length() > 0) continue;
                    for (Template aTemplate : inputTemplates) {
                        if (this.isCanceled()) continue block8;
                        if (aTemplate == dTemplate || matchedTempates.contains(aTemplate) || aTemplate.getDeleted().length() != 0 || !Report.findPatterns(Report.stripCode(dTemplate.getDeleted()), Report.stripCode(aTemplate.getAdded()), dP, aP, detetedPattern, addedPattern, isRppRef)) continue;
                        if (!metaTemplate.getTemplates().contains(aTemplate)) {
                            metaTemplate.getTemplates().add(aTemplate);
                        }
                        if (!metaTemplate.getTemplates().contains(dTemplate)) {
                            metaTemplate.getTemplates().add(dTemplate);
                        }
                        aTemplate.setOpposite(dTemplate);
                        dTemplate.setOpposite(aTemplate);
                        matchedTempates.add(aTemplate);
                        matchedTempates.add(dTemplate);
                    }
                    continue;
                }
                break;
            }
        } else if (Report.findPatterns(Report.stripCode(template.getDeleted()), Report.stripCode(template.getAdded()), dP, aP, detetedPattern, addedPattern, isRppRef)) {
            metaTemplate.getTemplates().add(template);
            matchedTempates.add(template);
        }
    }

    private void findPairedDifferences(Difference difference, List<Difference> differences, List<Difference> pairedDifferences) {
        for (Difference current : differences) {
            if (pairedDifferences.contains(current) || current == difference || current.getCobol().getFilename() != difference.getCobol().getFilename() || Report.diffChars(current.getCroppedMiaCobolCode(), difference.getCroppedRppCobolCode()) || Report.diffChars(difference.getCroppedMiaCobolCode(), current.getCroppedRppCobolCode())) continue;
            if (!pairedDifferences.contains(difference)) {
                pairedDifferences.add(difference);
            }
            if (pairedDifferences.contains(current)) break;
            pairedDifferences.add(current);
            break;
        }
    }

    private static boolean diffChars(String leftCobol, String rightCobol) {
        CobolDifferencer differencer = new CobolDifferencer(leftCobol, rightCobol);
        DiffCursor cursor = differencer.newCharDifferencesCursor();
        return cursor.searchNextDifference();
    }

    private void restoreTemplates() {
        if (!this.isInCompare) {
            this.templates = new ArrayList<Template>();
            for (Template template : this.analyzedTemplates) {
                Template cloneTemplate = Template.cloneTemplate(template);
                this.templates.add(cloneTemplate);
                for (Cobol cobol : template.getCobols()) {
                    Cobol clonedCobol = new Cobol(cobol.getFilename());
                    clonedCobol.setEntityName(cobol.getEntityName());
                    clonedCobol.setLibraryName(cobol.getLibraryName());
                    clonedCobol.setDesignId(cobol.getDesignId());
                    clonedCobol.setTemplate(cloneTemplate);
                    for (Difference difference : cobol.getDifferences()) {
                        clonedCobol.getDifferences().add(Difference.cloneDifference(difference, clonedCobol));
                    }
                    cloneTemplate.getCobols().add(clonedCobol);
                }
            }
        }
    }

    private void backupTemplates() {
        this.analyzedTemplates = this.templates;
        this.restoreTemplates();
    }

    private Set<String> getCobolsFromMetaTemplateName(MetaTemplate metaTemplate, String COBID) {
        HashSet<String> cobols = new HashSet<String>();
        String tmp = metaTemplate.getDeletedPattern();
        int idx = tmp.indexOf(COBID);
        if (idx < 0 && (idx = (tmp = metaTemplate.getName()).indexOf(COBID)) < 0) {
            return cobols;
        }
        if ((idx = (tmp = tmp.substring(idx + COBID.length())).indexOf(")")) > 0) {
            tmp = tmp.substring(0, idx);
            StringTokenizer stringTokenizer = new StringTokenizer(tmp, ",");
            while (stringTokenizer.hasMoreTokens()) {
                cobols.add(stringTokenizer.nextToken().intern());
            }
        }
        return cobols;
    }

    public List<Template> getAllDiffTemplates() {
        if (this.clonedTemplates == null || this.clonedTemplates.isEmpty()) {
            return this.getTemplates();
        }
        ArrayList<Template> templates = new ArrayList<Template>(this.getTemplates().size() + this.clonedTemplates.size() + 10);
        templates.addAll(this.getTemplates());
        templates.addAll(this.clonedTemplates);
        return templates;
    }

    public List<Template> getAllTemplates() {
        if (this.getDeletedTemplates().isEmpty()) {
            return this.getTemplates();
        }
        ArrayList<Template> templates = new ArrayList<Template>(this.getTemplates().size() + this.getDeletedTemplates().size() + 10);
        templates.addAll(this.getTemplates());
        templates.addAll(this.getDeletedTemplates());
        return templates;
    }

    public static boolean findPatterns(String pacCode, String rppCode, Pattern pacPattern, Pattern rppPattern, String pacRegex, String rppRegex, boolean isRppRef) {
        if (!isRppRef) {
            return Report.findPatterns(pacCode, rppCode, pacPattern, rppPattern, rppRegex);
        }
        return Report.findPatterns(rppCode, pacCode, rppPattern, pacPattern, pacRegex);
    }

    private static boolean findPatterns(String refCode, String compCode, Pattern refPattern, Pattern compPattern, String regex) {
        boolean result = false;
        if (refCode == null || compCode == null) {
            return result;
        }
        Matcher m = refPattern.matcher(refCode);
        if (m.matches()) {
            boolean match = false;
            if (m.groupCount() > 0) {
                String rppToComp = regex == null ? "" : new String(regex);
                int j = 1;
                while (j <= m.groupCount()) {
                    String replacement = m.group(j);
                    if (replacement != null) {
                        replacement = replacement.replace("(", "\\(").replace(")", "\\)").replace("[", "\\[").replace("]", "\\]").replace("{", "\\{").replace("}", "\\}").replace("*", "\\*").replace("$", "\\$").replace("+", "\\+").replace("?", "\\?").replace(".", "\\.");
                        rppToComp = rppToComp.replace("(g" + j + ")", replacement);
                    }
                    ++j;
                }
                try {
                    Pattern groupP = Pattern.compile(rppToComp);
                    Matcher groupM = groupP.matcher(compCode);
                    match = groupM.matches();
                }
                catch (Exception exception) {
                    match = false;
                }
            } else {
                m = compPattern.matcher(compCode);
                match = m.matches();
            }
            if (match) {
                result = true;
            }
        }
        return result;
    }

    public static String stripCode(String template) {
        if (template != null) {
            int idx = template.indexOf("|");
            if (idx > 0) {
                template = template.substring(idx + 1);
            }
            if ((idx = template.indexOf("|")) > 0) {
                template = template.substring(0, idx);
            }
            return template;
        }
        return null;
    }

    private void filterWrongPlacedCodeInRpp(MetaTemplate metaTemplate, List<Template> _inputTemplates, Set<Template> matchedTempates, boolean isLeft) {
        ArrayList<Template> templates = new ArrayList<Template>();
        block0: for (Template template : _inputTemplates) {
            if (matchedTempates.contains(template)) continue;
            for (Cobol cobol : template.getCobols()) {
                for (Difference difference : cobol.getDifferences()) {
                    if (difference.getRppCobolCode() == null) continue;
                    StringTokenizer tokenizer = new StringTokenizer(difference.getRppCobolCode(), "\n");
                    while (tokenizer.hasMoreTokens()) {
                        String line = tokenizer.nextToken().replace("\r", "");
                        if (line.length() > 5) {
                            if (line.substring(0, 5).trim().length() > 0 && isLeft) {
                                templates.add(template);
                                matchedTempates.add(template);
                                break;
                            }
                            if (line.length() <= 72 || isLeft) continue;
                            String text = line.substring(72).trim();
                            if (text == null || text.startsWith("lv") || "DOT".equals(text)) break;
                            templates.add(template);
                            matchedTempates.add(template);
                            break;
                        }
                        if (line.trim().length() <= 0 || !isLeft) continue;
                        templates.add(template);
                        matchedTempates.add(template);
                        break;
                    }
                    if (matchedTempates.contains(template)) break;
                }
                if (matchedTempates.contains(template)) continue block0;
            }
        }
        if (templates.size() > 0) {
            metaTemplate.setTemplates(templates);
        }
    }

    private void filterWrongDifferenceBug(MetaTemplate metaTemplate, List<Template> _inputTemplates, Set<Template> matchedTempates) {
        ArrayList<Template> templates = new ArrayList<Template>();
        block0: for (Template template : _inputTemplates) {
            if (matchedTempates.contains(template)) continue;
            for (Cobol cobol : template.getCobols()) {
                for (Difference difference : cobol.getDifferences()) {
                    if (difference.getRppCobolCode() != null && difference.getMiaCobolCode() != null && difference.getMiaCobolCode().equals(difference.getRppCobolCode())) {
                        templates.add(template);
                        matchedTempates.add(template);
                    }
                    if (matchedTempates.contains(template)) break;
                }
                if (matchedTempates.contains(template)) continue block0;
            }
        }
        if (templates.size() > 0) {
            metaTemplate.setTemplates(templates);
        }
    }

    private void filterVirtualMacroTag(MetaTemplate metaTemplate, List<Template> _inputTemplates, Set<Template> matchedTempates) {
        ArrayList<Template> templates = new ArrayList<Template>();
        block0: for (Template template : _inputTemplates) {
            if (matchedTempates.contains(template) || template.getDeleted() == null || template.getAdded() == null || template.getAdded().trim().length() > 0 || !template.getDeleted().endsWith("SP|\"")) continue;
            String mpTag = template.getDeleted().replace("|", "").replace("\"", "");
            for (Cobol cobol : template.getCobols()) {
                for (Difference difference : cobol.getDifferences()) {
                    if (difference.getRppCobolCode() != null && difference.getMiaCobolCode() != null && difference.getMiaCobolCode().indexOf(mpTag) >= 0) {
                        String miaCode = Difference.trimDiffRight(difference.getMiaCobolCode().replace(mpTag, ""));
                        String rppCode = difference.getRppCobolCode();
                        if (rppCode.equals(miaCode)) {
                            templates.add(template);
                            matchedTempates.add(template);
                        }
                    }
                    if (matchedTempates.contains(template)) break;
                }
                if (matchedTempates.contains(template)) continue block0;
            }
        }
        if (templates.size() > 0) {
            metaTemplate.setTemplates(templates);
        }
    }

    private void filterRigthMarkDiffer(MetaTemplate metaTemplate, List<Template> _inputTemplates, Set<Template> matchedTempates) {
        ArrayList<Template> templates = new ArrayList<Template>();
        block0: for (Template template : _inputTemplates) {
            if (matchedTempates.contains(template)) continue;
            for (Cobol cobol : template.getCobols()) {
                for (Difference difference : cobol.getDifferences()) {
                    if (difference.getRppCobolCode() != null && difference.getMiaCobolCode() != null) {
                        String miaCode = difference.getCroppedMiaCobolCode();
                        String rppCode = difference.getCroppedRppCobolCode();
                        if (rppCode.equals(miaCode)) {
                            templates.add(template);
                            matchedTempates.add(template);
                        }
                    }
                    if (matchedTempates.contains(template)) break;
                }
                if (matchedTempates.contains(template)) continue block0;
            }
        }
        if (templates.size() > 0) {
            metaTemplate.setTemplates(templates);
        }
    }

    private void filterSameLiteralContent(MetaTemplate metaTemplate, List<Template> inputTemplates, Set<Template> matchedTempates) {
        for (Template template : inputTemplates) {
            if (matchedTempates.contains(template)) continue;
            String deleted = template.getDeleted();
            String added = template.getAdded();
            if (!deleted.startsWith("\"|'") || !deleted.endsWith("'|\"") || !added.startsWith("\"|'") || !added.endsWith("'|\"")) continue;
            try {
                String del = deleted.substring(3, deleted.length() - 3).replaceAll(" ", "");
                String add = added.substring(3, added.length() - 3).replaceAll(" ", "");
                if (!del.equals(add)) continue;
                metaTemplate.getTemplates().add(template);
                matchedTempates.add(template);
            }
            catch (Exception exception) {}
        }
    }

    private void filterSameLiteralContentDot(MetaTemplate metaTemplate, List<Template> inputTemplates, Set<Template> matchedTempates) {
        for (Template template : inputTemplates) {
            if (matchedTempates.contains(template)) continue;
            String deleted = template.getDeleted();
            String added = template.getAdded();
            if (!deleted.startsWith("\"|'") || !deleted.endsWith("'|\"") || !added.startsWith("\"|'") || !added.endsWith("'|\"")) continue;
            try {
                String delOrig = deleted.substring(3, deleted.length() - 3);
                String del = delOrig.replaceAll("\\.", " ");
                String addOrig = added.substring(3, added.length() - 3);
                String add = addOrig.replaceAll("\\.", " ");
                if (!delOrig.equals(del) || addOrig.equals(add) || !del.equals(add)) continue;
                metaTemplate.getTemplates().add(template);
                matchedTempates.add(template);
            }
            catch (Exception exception) {}
        }
    }

    private void filterOppositeTmplMetaTemplates(MetaTemplate metaTemplate, List<Template> inputTemplates, Set<Template> matchedTempates) {
        for (Template dTemplate : inputTemplates) {
            if (matchedTempates.contains(dTemplate)) continue;
            if (this.isCanceled()) {
                return;
            }
            String deleted = dTemplate.getDeleted();
            String added = dTemplate.getAdded();
            for (Template aTemplate : inputTemplates) {
                if (this.isCanceled()) {
                    return;
                }
                if (aTemplate == dTemplate || matchedTempates.contains(aTemplate) || !aTemplate.getAdded().equals(deleted) || !aTemplate.getDeleted().equals(added)) continue;
                if (!metaTemplate.getTemplates().contains(aTemplate)) {
                    metaTemplate.getTemplates().add(aTemplate);
                }
                if (!metaTemplate.getTemplates().contains(dTemplate)) {
                    metaTemplate.getTemplates().add(dTemplate);
                }
                aTemplate.setOpposite(dTemplate);
                dTemplate.setOpposite(aTemplate);
                matchedTempates.add(aTemplate);
                matchedTempates.add(dTemplate);
            }
        }
    }

    protected void filterOppositeDiffMetaTemplates(MetaTemplate metaTemplate, List<Template> inputTemplates, Set<Template> matchedTempates) {
        for (Template template : inputTemplates) {
            Template cloneTemplate;
            Cobol cobol;
            if (matchedTempates.contains(template)) continue;
            boolean diffMatch = false;
            ArrayList<Difference> differences = new ArrayList<Difference>();
            ArrayList<Difference> otherDifferences = new ArrayList<Difference>();
            for (Cobol cobol2 : template.getCobols()) {
                if (this.isCanceled()) {
                    return;
                }
                for (Difference difference : cobol2.getDifferences()) {
                    if (this.isCanceled()) {
                        return;
                    }
                    String rppCode = difference.getRppCobolCode();
                    String miaCode = difference.getMiaCobolCode();
                    block3: for (Template otherTemplate : inputTemplates) {
                        if (matchedTempates.contains(template)) continue;
                        if (this.isCanceled()) {
                            return;
                        }
                        if (otherTemplate == template) continue;
                        if (this.isCanceled()) {
                            return;
                        }
                        for (Cobol otherCobol : otherTemplate.getCobols()) {
                            if (otherCobol.getFilename() == cobol2.getFilename()) {
                                for (Difference otherDifference : otherCobol.getDifferences()) {
                                    if (!rppCode.equals(otherDifference.getMiaCobolCode()) || !miaCode.equals(otherDifference.getRppCobolCode())) continue;
                                    differences.add(difference);
                                    otherDifferences.add(otherDifference);
                                    diffMatch = true;
                                    break;
                                }
                            }
                            if (diffMatch) continue block3;
                        }
                    }
                }
            }
            if (!diffMatch) continue;
            if (template.getTotalDifferences() == differences.size()) {
                if (!metaTemplate.getTemplates().contains(template)) {
                    metaTemplate.getTemplates().add(template);
                }
                matchedTempates.add(template);
                continue;
            }
            for (Difference difference : differences) {
                Cobol clonedCobol;
                cobol = difference.getCobol();
                cobol.getDifferences().remove(difference);
                cloneTemplate = null;
                for (Template clone : this.clonedTemplates) {
                    if (clone.getCloneMetaTemplateOwner() != metaTemplate || !template.getId().equals(clone.getId())) continue;
                    cloneTemplate = clone;
                    break;
                }
                if (cloneTemplate == null) {
                    cloneTemplate = Template.cloneForMetaTemplate(template, metaTemplate);
                    this.clonedTemplates.add(cloneTemplate);
                }
                if ((clonedCobol = cloneTemplate.getCobol(cobol.getFilename())) == null) {
                    clonedCobol = new Cobol(cobol, cloneTemplate);
                    clonedCobol.setEntityName(cobol.getEntityName());
                    clonedCobol.setLibraryName(cobol.getLibraryName());
                    cloneTemplate.getCobols().add(clonedCobol);
                }
                clonedCobol.getDifferences().add(difference);
                if (metaTemplate.getTemplates().contains(cloneTemplate)) continue;
                metaTemplate.getTemplates().add(cloneTemplate);
            }
            for (Difference difference : otherDifferences) {
                Cobol clonedCobol;
                cobol = difference.getCobol();
                cobol.getDifferences().remove(difference);
                cloneTemplate = null;
                Template otherTemplate = difference.getCobol().getTemplate();
                for (Template clone : this.clonedTemplates) {
                    if (clone.getCloneMetaTemplateOwner() != metaTemplate || !otherTemplate.getId().equals(clone.getId())) continue;
                    cloneTemplate = clone;
                    break;
                }
                if (cloneTemplate == null) {
                    cloneTemplate = Template.cloneForMetaTemplate(otherTemplate, metaTemplate);
                    this.clonedTemplates.add(cloneTemplate);
                }
                if ((clonedCobol = cloneTemplate.getCobol(cobol.getFilename())) == null) {
                    clonedCobol = new Cobol(cobol, cloneTemplate);
                    clonedCobol.setEntityName(cobol.getEntityName());
                    clonedCobol.setLibraryName(cobol.getLibraryName());
                    cloneTemplate.getCobols().add(clonedCobol);
                }
                clonedCobol.getDifferences().add(difference);
                if (metaTemplate.getTemplates().contains(cloneTemplate)) continue;
                metaTemplate.getTemplates().add(cloneTemplate);
            }
        }
    }

    private void applyPatternsGroup(String patternDirName) throws Exception {
        this.patternGroups.clear();
        HashSet<MetaTemplate> matchedMetaTemplates = new HashSet<MetaTemplate>();
        File file = this.getPatternFile(patternDirName, "patterngroup.txt");
        for (String line : ReportAnalyser.readFile(file)) {
            int idx;
            if (line.trim().length() == 0 || line.charAt(0) == '#' || (idx = line.indexOf(35)) <= 0) continue;
            String name = line.substring(0, idx);
            String id = null;
            int vIdx = line.indexOf(35, idx + 1);
            String version = "";
            if (vIdx > 0) {
                id = line.substring(idx + 1, vIdx);
                version = line.substring(vIdx + 1);
            } else {
                id = line.substring(idx + 1);
            }
            PatternGroup patternGroup = new PatternGroup(name, id);
            patternGroup.setVersion(version);
            for (MetaTemplate metaTemplate : this.getMetaTemplates()) {
                if (metaTemplate.getGroupPatternName() == null || !metaTemplate.getGroupPatternName().equals(id.trim())) continue;
                patternGroup.getMetaTemplates().add(metaTemplate);
                matchedMetaTemplates.add(metaTemplate);
            }
            if (patternGroup.getMetaTemplates().isEmpty()) continue;
            this.getPatternGroups().add(patternGroup);
        }
        ArrayList<MetaTemplate> unmachedMetaTemplates = new ArrayList<MetaTemplate>();
        for (MetaTemplate metatemplate : this.getMetaTemplates()) {
            if (matchedMetaTemplates.contains(metatemplate)) continue;
            unmachedMetaTemplates.add(metatemplate);
        }
        PatternGroup patternGroup = null;
        for (PatternGroup group : this.getPatternGroups()) {
            if (!group.getName().equals(NOT_CATEGORIZED_PATTERNS)) continue;
            patternGroup = group;
            break;
        }
        if (patternGroup == null) {
            patternGroup = new PatternGroup(NOT_CATEGORIZED_PATTERNS, null);
            this.getPatternGroups().add(patternGroup);
        }
        patternGroup.setVersion("");
        patternGroup.getMetaTemplates().addAll(unmachedMetaTemplates);
    }

    public List<PatternGroup> getPatternGroups() {
        return this.patternGroups;
    }

    /*
     * WARNING - void declaration
     */
    public void exportStats(String dirName) throws Exception {
        try {
            void var20_40;
            Object metaTemplate;
            HashSet<String> diffCobols = new HashSet<String>();
            String fileSuffix = ".csv";
            if (this.ignoreBugPac) {
                fileSuffix = "NoBugPac" + fileSuffix;
            }
            if (this.ignoreWontDo) {
                fileSuffix = "NoWontDo" + fileSuffix;
            }
            CsvWriter csvCobolIsoCodeDeclaredOut = new CsvWriter((Writer)new FileWriter(String.valueOf(dirName) + "/StatCobolsIsoCodeDeclared" + fileSuffix), ';', '\"');
            CsvWriter csvCobolOut = new CsvWriter((Writer)new FileWriter(String.valueOf(dirName) + "/StatCobols" + fileSuffix), ';', '\"');
            CsvWriter csvTemplateOut = new CsvWriter((Writer)new FileWriter(String.valueOf(dirName) + "/StatTemplates" + fileSuffix), ';', '\"');
            csvCobolOut.addTextCell("Cobol").addTextCell("Differences").addTextCell("Templates").addTextCell("Unique Templates").addTextCell("Model").addTextCell("Lib").endOfRow();
            csvCobolIsoCodeDeclaredOut.addTextCell("Cobol").addTextCell("Differences").addTextCell("Model").addTextCell("Lib").endOfRow();
            csvTemplateOut.addTextCell("Templates").addTextCell("Cobols").addTextCell("Difference").addTextCell("Nature").addTextCell("Deleted").addTextCell("Added").addTextCell("Hashcode").endOfRow();
            HashMap<Iterator<Cobol>, CobolStat> map = new HashMap<Iterator<Cobol>, CobolStat>();
            HashMap<Template, HashSet<String>> mapTmpl = new HashMap<Template, HashSet<String>>();
            HashSet<String> isoCobNames = new HashSet<String>();
            for (MetaTemplate metaTemplate2 : this.getMetaTemplates()) {
                isoCobNames.addAll(this.getCobolsFromMetaTemplateName(metaTemplate2, ISOCOB));
            }
            for (Template template : this.getTemplates()) {
                int differences = 0;
                for (Cobol cobol : template.getCobols()) {
                    Iterator<Cobol> key = cobol.getFilename();
                    differences += cobol.getDifferences().size();
                    CobolStat cobolStat = (CobolStat)map.get(key);
                    if (cobolStat == null) {
                        cobolStat = new CobolStat();
                        cobolStat.differences = cobol.getDifferences().size();
                        cobolStat.entityName = cobol.getEntityName();
                        cobolStat.libraryName = cobol.getLibraryName();
                        cobolStat.fileName = cobol.getFilename();
                        if (!template.isCloned()) {
                            cobolStat.templates.add(template);
                        }
                        map.put(key, cobolStat);
                    } else {
                        cobolStat.differences += cobol.getDifferences().size();
                        if (!template.isCloned()) {
                            cobolStat.templates.add(template);
                        }
                    }
                    HashSet<String> cobols = (HashSet<String>)mapTmpl.get(template);
                    if (cobols == null) {
                        cobols = new HashSet<String>();
                        mapTmpl.put(template, cobols);
                    }
                    cobols.add(cobol.getFilename());
                }
                csvTemplateOut.addIntegerCell(template.getNumber()).addIntegerCell(template.getCobols().size()).addIntegerCell(differences).addTextCell(template.getNature()).addTextCell(template.getDeleted()).addTextCell(template.getAdded()).addIntegerCell(template.getHashCode()).endOfRow();
            }
            for (String key : map.keySet()) {
                CobolStat cobolStat = (CobolStat)map.get(key);
                int uniqueCobolTemplate = 0;
                for (Template template : cobolStat.templates) {
                    Set cobols = (Set)mapTmpl.get(template);
                    if (cobols == null || cobols.size() != 1) continue;
                    ++uniqueCobolTemplate;
                }
                if (cobolStat.differences == 0) continue;
                csvCobolOut.addTextCell(key).addIntegerCell(cobolStat.differences).addIntegerCell(cobolStat.templates.size()).addIntegerCell(uniqueCobolTemplate).addTextCell(cobolStat.entityName == null ? "" : cobolStat.entityName).addTextCell(cobolStat.libraryName == null ? "" : cobolStat.libraryName).endOfRow();
                if (this.isDeclaredIsoCobol(cobolStat, isoCobNames)) {
                    csvCobolIsoCodeDeclaredOut.addTextCell(key).addIntegerCell(cobolStat.differences).addTextCell(cobolStat.entityName == null ? "" : cobolStat.entityName).addTextCell(cobolStat.libraryName == null ? "" : cobolStat.libraryName).endOfRow();
                }
                diffCobols.add(key);
            }
            csvCobolOut.close();
            csvCobolIsoCodeDeclaredOut.close();
            csvTemplateOut.close();
            CsvWriter csvMetaTmplOut = new CsvWriter((Writer)new FileWriter(String.valueOf(dirName) + "/StatMetaTemplates" + fileSuffix), ';', '\"');
            csvMetaTmplOut.addTextCell("Meta Templates").addTextCell("Templates").addTextCell("Cobols").addTextCell("Differences").addTextCell("Deleted Pattern").addTextCell("Added Pattern").addTextCell("Group Pattern Name").addTextCell("Work Items").endOfRow();
            TreeMap<String, MetaTemplate> treeMap = new TreeMap<String, MetaTemplate>();
            for (MetaTemplate metaTemplate3 : this.getMetaTemplates()) {
                treeMap.put(metaTemplate3.getName(), metaTemplate3);
            }
            for (String key : treeMap.keySet()) {
                metaTemplate = (MetaTemplate)treeMap.get(key);
                csvMetaTmplOut.addTextCell(((MetaTemplate)metaTemplate).getName());
                csvMetaTmplOut.addIntegerCell(((MetaTemplate)metaTemplate).getTemplates().size());
                csvMetaTmplOut.addIntegerCell(((MetaTemplate)metaTemplate).getTotalCobols());
                csvMetaTmplOut.addIntegerCell(((MetaTemplate)metaTemplate).getTotalDifferences());
                csvMetaTmplOut.addTextCell(((MetaTemplate)metaTemplate).getDeletedPattern());
                csvMetaTmplOut.addTextCell(((MetaTemplate)metaTemplate).getAddedPattern());
                csvMetaTmplOut.addTextCell(((MetaTemplate)metaTemplate).getGroupPatternName() == null ? "" : ((MetaTemplate)metaTemplate).getGroupPatternName());
                csvMetaTmplOut.addTextCell(((MetaTemplate)metaTemplate).getWorkItemsAsString());
                csvMetaTmplOut.endOfRow();
            }
            csvMetaTmplOut.close();
            csvMetaTmplOut = new CsvWriter((Writer)new FileWriter(String.valueOf(dirName) + "/StatMetaTemplatesWithRealDiffs" + fileSuffix), ';', '\"');
            csvMetaTmplOut.addTextCell("Meta Templates").addTextCell("Templates").addTextCell("Cobols").addTextCell("Differences").addTextCell("Deleted Pattern").addTextCell("Added Pattern").addTextCell("Group Pattern Name").addTextCell("Work Items").endOfRow();
            treeMap = new TreeMap();
            for (MetaTemplate metaTemplate4 : this.getMetaTemplates()) {
                if (this.ignoreBugPac && BUG_PAC.equals(metaTemplate4.getGroupPatternName()) || this.ignoreWontDo && WONT_DO.equals(metaTemplate4.getGroupPatternName())) continue;
                treeMap.put(metaTemplate4.getName(), metaTemplate4);
            }
            for (String key : treeMap.keySet()) {
                metaTemplate = (MetaTemplate)treeMap.get(key);
                csvMetaTmplOut.addTextCell(((MetaTemplate)metaTemplate).getName());
                csvMetaTmplOut.addIntegerCell(((MetaTemplate)metaTemplate).getTemplates().size());
                csvMetaTmplOut.addIntegerCell(((MetaTemplate)metaTemplate).getTotalCobols());
                csvMetaTmplOut.addIntegerCell(((MetaTemplate)metaTemplate).getTotalDifferences());
                csvMetaTmplOut.addTextCell(((MetaTemplate)metaTemplate).getDeletedPattern());
                csvMetaTmplOut.addTextCell(((MetaTemplate)metaTemplate).getAddedPattern());
                csvMetaTmplOut.addTextCell(((MetaTemplate)metaTemplate).getGroupPatternName() == null ? "" : ((MetaTemplate)metaTemplate).getGroupPatternName());
                csvMetaTmplOut.addTextCell(((MetaTemplate)metaTemplate).getWorkItemsAsString());
                csvMetaTmplOut.endOfRow();
            }
            csvMetaTmplOut.close();
            csvMetaTmplOut = new CsvWriter((Writer)new FileWriter(String.valueOf(dirName) + "/StatMetaTemplatesWithNoDiff" + fileSuffix), ';', '\"');
            csvMetaTmplOut.addTextCell("Meta Templates").addTextCell("Templates").addTextCell("Cobols").addTextCell("Differences").addTextCell("Deleted Pattern").addTextCell("Added Pattern").addTextCell("Group Pattern Name").addTextCell("Work Items").endOfRow();
            treeMap = new TreeMap();
            for (MetaTemplate metaTemplate5 : this.getMetaTemplates()) {
                if (!BUG_PAC.equals(metaTemplate5.getGroupPatternName()) && !WONT_DO.equals(metaTemplate5.getGroupPatternName())) continue;
                treeMap.put(metaTemplate5.getName(), metaTemplate5);
            }
            for (String key : treeMap.keySet()) {
                metaTemplate = (MetaTemplate)treeMap.get(key);
                csvMetaTmplOut.addTextCell(((MetaTemplate)metaTemplate).getName());
                csvMetaTmplOut.addIntegerCell(((MetaTemplate)metaTemplate).getTemplates().size());
                csvMetaTmplOut.addIntegerCell(((MetaTemplate)metaTemplate).getTotalCobols());
                csvMetaTmplOut.addIntegerCell(((MetaTemplate)metaTemplate).getTotalDifferences());
                csvMetaTmplOut.addTextCell(((MetaTemplate)metaTemplate).getDeletedPattern());
                csvMetaTmplOut.addTextCell(((MetaTemplate)metaTemplate).getAddedPattern());
                csvMetaTmplOut.addTextCell(((MetaTemplate)metaTemplate).getGroupPatternName() == null ? "" : ((MetaTemplate)metaTemplate).getGroupPatternName());
                csvMetaTmplOut.addTextCell(((MetaTemplate)metaTemplate).getWorkItemsAsString());
                csvMetaTmplOut.endOfRow();
            }
            csvMetaTmplOut.close();
            CsvWriter csvPatternOut = new CsvWriter((Writer)new FileWriter(String.valueOf(dirName) + "/StatPatternGroup" + fileSuffix), ';', '\"');
            csvPatternOut.addTextCell("Group Name").addTextCell("Templates").addTextCell("Cobols").addTextCell("Differences").addTextCell("Version").addTextCell("Group Pattern Name").endOfRow();
            for (PatternGroup patternGroup : this.getPatternGroups()) {
                if (patternGroup.getMetaTemplates().isEmpty()) continue;
                csvPatternOut.addTextCell(patternGroup.getName().replace(NOT_CATEGORIZED_PATTERNS, "Sans cat\u00e9gorie"));
                csvPatternOut.addIntegerCell(patternGroup.getTotalTemplates());
                csvPatternOut.addIntegerCell(patternGroup.getTotalCobols());
                csvPatternOut.addIntegerCell(patternGroup.getTotalDifferences());
                csvPatternOut.addTextCell(patternGroup.getVersion());
                csvPatternOut.addTextCell(patternGroup.getId() == null ? "" : patternGroup.getId());
                csvPatternOut.endOfRow();
            }
            csvPatternOut.close();
            CsvWriter csvCobolNoDiffOut = new CsvWriter((Writer)new FileWriter(String.valueOf(dirName) + "/StatCobolsNoDiff" + fileSuffix), ';', '\"');
            csvCobolNoDiffOut.addTextCell("Cobol").addTextCell("Model").addTextCell("Lib").endOfRow();
            for (Cobol cobol : this.getCobolsWithDifferences()) {
                if (diffCobols.contains(cobol.getFilename())) continue;
                csvCobolNoDiffOut.addTextCell(cobol.getFilename()).addTextCell(cobol.getEntityName() == null ? "" : cobol.getEntityName()).addTextCell(cobol.getLibraryName() == null ? "" : cobol.getLibraryName()).endOfRow();
            }
            for (Cobol cobol : this.getCobolsWithNoDifferences()) {
                csvCobolNoDiffOut.addTextCell(cobol.getFilename()).addTextCell(cobol.getEntityName() == null ? "" : cobol.getEntityName()).addTextCell(cobol.getLibraryName() == null ? "" : cobol.getLibraryName()).endOfRow();
            }
            csvCobolNoDiffOut.close();
            CsvWriter csvOut = new CsvWriter((Writer)new FileWriter(String.valueOf(dirName) + "/StatMetaTemplates_Templates" + fileSuffix), ';', '\"');
            int max = 0;
            ArrayList cols = new ArrayList();
            int index = 1;
            for (MetaTemplate metaTemplate6 : this.getMetaTemplates()) {
                if (metaTemplate6.getTemplates().isEmpty()) continue;
                csvOut.addCell("#" + index++);
                ArrayList<Integer> arrayList = new ArrayList<Integer>(metaTemplate6.getTemplates().size() + 1);
                cols.add(arrayList);
                for (Template template : metaTemplate6.getTemplates()) {
                    int number = template.getNumber();
                    if (arrayList.contains(number)) continue;
                    arrayList.add(number);
                }
                max = Math.max(max, arrayList.size());
            }
            csvOut.endOfCell().endOfRow();
            int line = 1;
            index = 1;
            ArrayList<MetaTemplate> _metaTemplates = new ArrayList<MetaTemplate>();
            for (MetaTemplate metaTemplate2 : this.getMetaTemplates()) {
                if (metaTemplate2.getTemplates().isEmpty()) continue;
                _metaTemplates.add(metaTemplate2);
            }
            while (line <= max) {
                for (List list : cols) {
                    if (list.size() >= line) {
                        int number = (Integer)list.get(line - 1);
                        csvOut.addIntegerCell(number);
                        continue;
                    }
                    csvOut.addTextCell("");
                }
                if (_metaTemplates.size() >= index) {
                    csvOut.addCell("").addCell("#" + index).addCell(((MetaTemplate)_metaTemplates.get(index - 1)).getName()).addCell("");
                    ++index;
                }
                csvOut.endOfCell().endOfRow();
                ++line;
            }
            int n = index - 1;
            while (var20_40 < _metaTemplates.size()) {
                Iterator<MetaTemplate> iterator = cols.iterator();
                while (iterator.hasNext()) {
                    List cfr_ignored_0 = (List)((Object)iterator.next());
                    csvOut.addTextCell("");
                }
                csvOut.addCell("").addCell("#" + (int)(var20_40 + true)).addCell(((MetaTemplate)_metaTemplates.get((int)var20_40)).getName()).addCell("");
                csvOut.endOfCell().endOfRow();
                ++var20_40;
            }
            csvOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private boolean isDeclaredIsoCobol(CobolStat cobolStat, Set<String> isoCobNames) {
        for (String cobName : isoCobNames) {
            if (cobolStat.fileName == null || !cobolStat.fileName.endsWith(cobName)) continue;
            return true;
        }
        return false;
    }

    public void exportNotCategorizedTemplatesStat(String dirName) throws Exception {
        CsvWriter csvOut = new CsvWriter((Writer)new FileWriter(String.valueOf(dirName) + "/StatNotCategorizedTemplates.csv"), ';', '\"');
        csvOut.addTextCell("Template").addTextCell("HashCode").addTextCell("Cobols").addTextCell("Differences").addTextCell("Deleted").addTextCell("Added").endOfRow();
        for (MetaTemplate metaTemplate : this.getMetaTemplates()) {
            if (!NOT_CATEGORIZED.equals(metaTemplate.getName())) continue;
            for (Template template : metaTemplate.getTemplates()) {
                csvOut.addIntegerCell(template.getNumber()).addIntegerCell(template.getHashCode()).addIntegerCell(template.getCobols().size()).addIntegerCell(template.getTotalDifferences()).addTextCell(template.getDeleted()).addTextCell(template.getAdded()).endOfRow();
            }
        }
        csvOut.close();
    }

    public void exportNotCategorizedCobolsStat(String dirName) throws Exception {
        CsvWriter csvOut = new CsvWriter((Writer)new FileWriter(String.valueOf(dirName) + "/StatNotCategorizedCobols.csv"), ';', '\"');
        csvOut.addTextCell("Cobol").addTextCell("Differences").addTextCell("Templates").addTextCell("Unique Templates").addTextCell("Model").addTextCell("Lib").endOfRow();
        for (MetaTemplate metaTemplate : this.getMetaTemplates()) {
            HashSet<String> cobols;
            if (!NOT_CATEGORIZED.equals(metaTemplate.getName())) continue;
            HashMap<String, CobolStat> map = new HashMap<String, CobolStat>();
            HashMap<Template, HashSet<String>> mapTmpl = new HashMap<Template, HashSet<String>>();
            for (Template template : metaTemplate.getTemplates()) {
                for (Cobol cobol : template.getCobols()) {
                    String key = cobol.getFilename();
                    CobolStat cobolStat = (CobolStat)map.get(key);
                    if (cobolStat == null) {
                        cobolStat = new CobolStat();
                        cobolStat.differences = cobol.getDifferences().size();
                        cobolStat.entityName = cobol.getEntityName();
                        cobolStat.libraryName = cobol.getLibraryName();
                        cobolStat.fileName = cobol.getFilename();
                        cobolStat.templates.add(template);
                        map.put(key, cobolStat);
                    } else {
                        cobolStat.differences += cobol.getDifferences().size();
                        cobolStat.templates.add(template);
                    }
                    cobols = (Set)mapTmpl.get(template);
                    if (cobols == null) {
                        cobols = new HashSet<String>();
                        mapTmpl.put(template, cobols);
                    }
                    cobols.add(cobol.getFilename());
                }
            }
            for (String key : map.keySet()) {
                CobolStat cobolStat = (CobolStat)map.get(key);
                int uniqueCobolTemplate = 0;
                for (Template template : cobolStat.templates) {
                    cobols = (HashSet<String>)mapTmpl.get(template);
                    if (cobols == null || cobols.size() != 1) continue;
                    ++uniqueCobolTemplate;
                }
                csvOut.addTextCell(key).addIntegerCell(cobolStat.differences).addIntegerCell(cobolStat.templates.size()).addIntegerCell(uniqueCobolTemplate).addTextCell(cobolStat.entityName == null ? "" : cobolStat.entityName).addTextCell(cobolStat.libraryName == null ? "" : cobolStat.libraryName).endOfRow();
            }
        }
        csvOut.close();
    }

    public int getCobolsCount() {
        HashSet<String> set = new HashSet<String>();
        for (Template template : this.getTemplates()) {
            for (Cobol cobol : template.getCobols()) {
                if (cobol.getDifferences().size() <= 0) continue;
                String key = cobol.getFilename();
                set.add(key);
            }
        }
        return set.size();
    }

    public Set<String> getIsoCobols(MetaTemplate metaTemplate) {
        HashSet<String> set = new HashSet<String>();
        for (Template template : this.getTemplates()) {
            for (Cobol cobol : template.getCobols()) {
                if (cobol.getDifferences().size() <= 0) continue;
                String key = cobol.getFilename();
                set.add(key);
            }
        }
        set.removeAll(this.getCobolsWithout(metaTemplate));
        return set;
    }

    public int getCobolsCountWithout(MetaTemplate metaTemplateToExclude) {
        return this.getCobolsWithout(metaTemplateToExclude).size();
    }

    public Set<String> getCobolsWithout(MetaTemplate metaTemplateToExclude) {
        HashSet<String> set = new HashSet<String>();
        for (MetaTemplate metaTemplate : this.getMetaTemplates()) {
            if (metaTemplate.getName().equals(metaTemplateToExclude.getName())) continue;
            for (Template template : metaTemplate.getTemplates()) {
                for (Cobol cobol : template.getCobols()) {
                    if (cobol.getDifferences().size() <= 0) continue;
                    String key = cobol.getFilename();
                    set.add(key);
                }
            }
        }
        return set;
    }

    public Set<String> getIsoCobolsWithout(MetaTemplate metaTemplateToExclude) {
        Set<String> diffCobols = this.getCobolsWithout(metaTemplateToExclude);
        HashSet<String> result = new HashSet<String>();
        for (Template template : metaTemplateToExclude.getTemplates()) {
            for (Cobol cobol : template.getCobols()) {
                String key = cobol.getFilename();
                if (diffCobols.contains(key)) continue;
                result.add(key);
            }
        }
        return result;
    }

    public double getTemplateExpressGainRatio(Template template) {
        double totalRatio = 1.0 - (double)this.getCobolsCount() / (double)this.getAnalyzedFiles();
        double ratio = 1.0 - (double)this.getCobolsCountWithout(template) / (double)this.getAnalyzedFiles();
        return (ratio - totalRatio) * 10000.0;
    }

    public double getTemplateTauxRatio(Template template) {
        double ratio = (double)template.getTotalCobols() / (double)this.getAnalyzedFiles();
        return ratio * 10000.0;
    }

    public int getCobolsCountWithout(Template templateToExclude) {
        HashSet<String> set = new HashSet<String>();
        for (MetaTemplate metaTemplate : this.getMetaTemplates()) {
            for (Template template : metaTemplate.getTemplates()) {
                if (template == templateToExclude) continue;
                for (Cobol cobol : template.getCobols()) {
                    if (cobol.getDifferences().size() <= 0) continue;
                    String key = cobol.getFilename();
                    set.add(key);
                }
            }
        }
        return set.size();
    }

    public int getCobolsMiaLinesCount() {
        HashSet<String> set = new HashSet<String>();
        for (Template template : this.getTemplates()) {
            for (Cobol cobol : template.getCobols()) {
                for (Difference difference : cobol.getDifferences()) {
                    if (difference.getEndMia() >= difference.getStartMia()) {
                        int line = difference.getStartMia();
                        while (line <= difference.getEndMia()) {
                            set.add(String.valueOf(cobol.getFilename()) + "#" + line);
                            ++line;
                        }
                        continue;
                    }
                    System.out.println("Error!!!!");
                }
            }
        }
        return set.size();
    }

    public int getCobolsRppLinesCount() {
        HashSet<String> set = new HashSet<String>();
        for (Template template : this.getTemplates()) {
            for (Cobol cobol : template.getCobols()) {
                for (Difference difference : cobol.getDifferences()) {
                    if (difference.getEndRpp() >= difference.getStartRpp()) {
                        int line = difference.getStartRpp();
                        while (line <= difference.getEndRpp()) {
                            set.add(String.valueOf(cobol.getFilename()) + "#" + line);
                            ++line;
                        }
                        continue;
                    }
                    System.out.println("Error!!!!");
                }
            }
        }
        return set.size();
    }

    public void compare(Report compareReport, String patternFolder, String reportFolder, boolean applyPattern, boolean filterOpposites, boolean filterOthers, boolean ignoreBugPac, boolean ignoreWontDo, boolean ignoreIsoCobols, String prefix, String locationName) throws Exception {
        this.resetTemplatesState();
        this.deletedModifiedTemplates.clear();
        if (applyPattern) {
            this.applyPatterns(patternFolder, filterOpposites, filterOthers, ignoreBugPac, ignoreWontDo, ignoreIsoCobols, locationName, false, true, false);
            compareReport.applyPatterns(patternFolder, filterOpposites, filterOthers, ignoreBugPac, ignoreWontDo, ignoreIsoCobols, locationName, false, true, false);
        }
        HashSet<MetaTemplate> _newMetaTemplates = new HashSet<MetaTemplate>();
        HashSet<MetaTemplate> _deletedMetaTemplates = new HashSet<MetaTemplate>();
        CsvWriter csvCompOut = new CsvWriter((Writer)new FileWriter(String.valueOf(reportFolder) + "/" + prefix + "MetaTemplateOnTemplatesOnlyReports.csv"), ';', '\"');
        csvCompOut.addTextCell("Meta Template Name").addTextCell("New Templates").addTextCell("Old Templates").addTextCell("Templates Gap").addTextCell("New Cobols").addTextCell("Old Cobols").addTextCell("Cobol Gap").addTextCell("New Differences").addTextCell("Old Differences").addTextCell("Differences Gap").endOfRow();
        for (MetaTemplate compMetaTemplate : compareReport.getMetaTemplates()) {
            MetaTemplate metaTemplate = this.getMetaTemplate(compMetaTemplate.getName());
            if (metaTemplate != null) {
                int tmpl = metaTemplate.getTemplates().size();
                int compTmpl = compMetaTemplate.getTemplates().size();
                int cobols = metaTemplate.getTotalCobols();
                int compCobols = compMetaTemplate.getTotalCobols();
                int diffs = metaTemplate.getTotalDifferences();
                int compDiffs = compMetaTemplate.getTotalDifferences();
                csvCompOut.addTextCell(metaTemplate.getName());
                if (tmpl != compTmpl) {
                    csvCompOut.addIntegerCell(tmpl).addIntegerCell(compTmpl).addIntegerCell(tmpl - compTmpl);
                } else {
                    csvCompOut.addIntegerCell(tmpl).addIntegerCell(compTmpl).addIntegerCell(0);
                }
                if (cobols != compCobols) {
                    csvCompOut.addIntegerCell(cobols).addIntegerCell(compCobols).addIntegerCell(cobols - compCobols);
                } else {
                    csvCompOut.addIntegerCell(cobols).addIntegerCell(compCobols).addIntegerCell(0);
                }
                if (diffs != compDiffs) {
                    csvCompOut.addIntegerCell(diffs).addIntegerCell(compDiffs).addIntegerCell(diffs - compDiffs);
                } else {
                    csvCompOut.addIntegerCell(diffs).addIntegerCell(compDiffs).addIntegerCell(0);
                }
                csvCompOut.endOfRow();
                continue;
            }
            _deletedMetaTemplates.add(compMetaTemplate);
        }
        for (MetaTemplate metaTemplate : this.getMetaTemplates()) {
            if (compareReport.getMetaTemplate(metaTemplate.getName()) != null) continue;
            _newMetaTemplates.add(metaTemplate);
        }
        for (MetaTemplate metaTemplate : _deletedMetaTemplates) {
            csvCompOut.addTextCell("Deleted Meta Template : " + metaTemplate.getName()).addIntegerCell(0).addIntegerCell(metaTemplate.getTemplates().size()).addIntegerCell(-metaTemplate.getTemplates().size()).addIntegerCell(0).addIntegerCell(metaTemplate.getTotalCobols()).addIntegerCell(-metaTemplate.getTotalCobols()).addIntegerCell(0).addIntegerCell(metaTemplate.getTotalDifferences()).addIntegerCell(-metaTemplate.getTotalDifferences()).endOfRow();
        }
        for (MetaTemplate metaTemplate : _newMetaTemplates) {
            csvCompOut.addTextCell("New Meta Template : " + metaTemplate.getName()).addIntegerCell(metaTemplate.getTemplates().size()).addIntegerCell(0).addIntegerCell(metaTemplate.getTemplates().size()).addIntegerCell(metaTemplate.getTotalCobols()).addIntegerCell(0).addIntegerCell(metaTemplate.getTotalCobols()).addIntegerCell(metaTemplate.getTotalDifferences()).addIntegerCell(0).addIntegerCell(metaTemplate.getTotalDifferences()).endOfRow();
        }
        csvCompOut.close();
        csvCompOut = new CsvWriter((Writer)new FileWriter(String.valueOf(reportFolder) + "/" + prefix + "CobolsWithDifferencesOnTemplatesOnlyReports.csv"), ';', '\"');
        csvCompOut.addTextCell("Cobol Name").addTextCell("Entity").addTextCell("Lib").addTextCell("State").endOfRow();
        Set<String> compCobolsNames = compareReport.getCobolsFileNamesWithDiffs(null);
        Set<String> cobolsNames = this.getCobolsFileNamesWithDiffs(null);
        Collection<Cobol> compCobols = compareReport.getCobolsWithDiffs(null);
        Collection<Cobol> cobols = this.getCobolsWithDiffs(null);
        for (Cobol cobol : cobols) {
            if (compCobolsNames.contains(cobol.getFilename())) continue;
            if (BAD_CONSTANT.equals(cobol.getEntityName())) {
                cobol.setLibraryName(BAD_CONSTANT);
            }
            csvCompOut.addTextCell(cobol.getFilename()).addTextCell(cobol.getEntityName()).addTextCell(cobol.getLibraryName()).addTextCell("new").endOfRow();
        }
        for (Cobol cobol : compCobols) {
            if (cobolsNames.contains(cobol.getFilename())) continue;
            if (BAD_CONSTANT.equals(cobol.getEntityName())) {
                cobol.setLibraryName(BAD_CONSTANT);
            }
            csvCompOut.addTextCell(cobol.getFilename()).addTextCell(cobol.getEntityName()).addTextCell(cobol.getLibraryName()).addTextCell("deleted").endOfRow();
        }
        csvCompOut.close();
        csvCompOut = new CsvWriter((Writer)new FileWriter(String.valueOf(reportFolder) + "/" + prefix + "AnalyzedCobolsReports.csv"), ';', '\"');
        csvCompOut.addTextCell("Cobol Name").addTextCell("Entity").addTextCell("Lib").addTextCell("State").endOfRow();
        compCobolsNames = new HashSet<String>();
        cobolsNames = new HashSet<String>();
        compCobols = compareReport.getAllCobols(true);
        cobols = this.getAllCobols(true);
        System.err.println(compCobols.size());
        System.err.println(cobols.size());
        for (Cobol cobol : compCobols) {
            compCobolsNames.add(cobol.getFilename());
        }
        for (Cobol cobol : cobols) {
            cobolsNames.add(cobol.getFilename());
        }
        for (Cobol cobol : cobols) {
            if (compCobolsNames.contains(cobol.getFilename())) continue;
            csvCompOut.addTextCell(cobol.getFilename()).addTextCell(cobol.getEntityName()).addTextCell(cobol.getLibraryName()).addTextCell("new").endOfRow();
        }
        for (Cobol cobol : compCobols) {
            if (cobolsNames.contains(cobol.getFilename())) continue;
            csvCompOut.addTextCell(cobol.getFilename()).addTextCell(cobol.getEntityName()).addTextCell(cobol.getLibraryName()).addTextCell("deleted").endOfRow();
        }
        csvCompOut.close();
        csvCompOut = new CsvWriter((Writer)new FileWriter(String.valueOf(reportFolder) + "/" + prefix + "TemplateReports.csv"), ';', '\"');
        csvCompOut.addTextCell("Template Name").addTextCell("Hash Code").addTextCell("New Cobols").addTextCell("Old Cobols").addTextCell("Cobol Gap").addTextCell("New Differences").addTextCell("Old Differences").addTextCell("Differences Gap").addTextCell("State").addTextCell("Deleted").addTextCell("Added").endOfRow();
        HashSet<Template> analysedTemplates = new HashSet<Template>();
        HashSet<Template> analysedCompTemplates = new HashSet<Template>();
        for (Template template : this.getAllDiffTemplates()) {
            if (analysedTemplates.contains(template)) continue;
            if (this.isCanceled()) break;
            for (Template compTemplate : compareReport.getAllDiffTemplates()) {
                if (analysedCompTemplates.contains(compTemplate) || !compTemplate.equals(template)) continue;
                analysedTemplates.add(template);
                analysedCompTemplates.add(compTemplate);
                if (template.getTotalCobols() == compTemplate.getTotalCobols() && template.getTotalDifferences() == compTemplate.getTotalDifferences()) continue;
                int cobolGap = template.getTotalCobols() - compTemplate.getTotalCobols();
                int differenceGap = template.getTotalDifferences() - compTemplate.getTotalDifferences();
                template.setCobolGap(cobolGap);
                template.setDifferenceGap(differenceGap);
                csvCompOut.addIntegerCell(template.getNumber()).addIntegerCell(template.getHashCode()).addIntegerCell(template.getTotalCobols()).addIntegerCell(compTemplate.getTotalCobols()).addIntegerCell(cobolGap).addIntegerCell(template.getTotalDifferences()).addIntegerCell(compTemplate.getTotalDifferences()).addIntegerCell(differenceGap).addTextCell("modified").addTextCell(template.getDeleted()).addTextCell(template.getAdded()).endOfRow();
                HashSet<Integer> compListId = new HashSet<Integer>();
                for (Cobol cobol : compTemplate.getCobols()) {
                    for (Difference difference : cobol.getDifferences()) {
                        int hashCode = (String.valueOf(difference.getMiaCobolCode()) + difference.getRppCobolCode() + cobol.getFilename()).hashCode();
                        compListId.add(hashCode);
                        difference.setId(hashCode);
                    }
                }
                HashSet<Integer> listId = new HashSet<Integer>();
                for (Cobol cobol : template.getCobols()) {
                    for (Difference difference3 : cobol.getDifferences()) {
                        int hashCode = (String.valueOf(difference3.getMiaCobolCode()) + difference3.getRppCobolCode() + cobol.getFilename()).hashCode();
                        if (!compListId.contains(hashCode)) {
                            difference3.setNew(true);
                        }
                        listId.add(hashCode);
                    }
                }
                Template removedTemplate = null;
                for (Cobol cobol : compTemplate.getCobols()) {
                    ArrayList<Difference> removedDiffs = new ArrayList<Difference>();
                    for (Difference difference4 : cobol.getDifferences()) {
                        int hashCode = difference4.getId();
                        if (listId.contains(hashCode)) continue;
                        difference4.setDelete(true);
                        removedDiffs.add(difference4);
                    }
                    if (removedDiffs.isEmpty()) continue;
                    if (removedTemplate == null) {
                        removedTemplate = Template.cloneForMetaTemplate(compTemplate, null);
                        removedTemplate.setState(Template.State.MODIFY);
                        this.deletedModifiedTemplates.add(removedTemplate);
                    }
                    Cobol clonedCobol = new Cobol(cobol, removedTemplate);
                    clonedCobol.setEntityName(cobol.getEntityName());
                    clonedCobol.setLibraryName(cobol.getLibraryName());
                    removedTemplate.getCobols().add(clonedCobol);
                    clonedCobol.getDifferences().addAll(removedDiffs);
                }
                template.setState(Template.State.MODIFY);
            }
        }
        for (Template template : this.getAllDiffTemplates()) {
            if (analysedTemplates.contains(template)) continue;
            csvCompOut.addIntegerCell(template.getNumber()).addIntegerCell(template.getHashCode()).addIntegerCell(template.getTotalCobols()).addIntegerCell(0).addIntegerCell(template.getTotalCobols()).addIntegerCell(template.getTotalDifferences()).addIntegerCell(0).addIntegerCell(template.getTotalDifferences()).addTextCell("new").addTextCell(template.getDeleted()).addTextCell(template.getAdded()).endOfRow();
            template.setState(Template.State.NEW);
        }
        for (Template template : compareReport.getAllDiffTemplates()) {
            if (analysedCompTemplates.contains(template)) continue;
            csvCompOut.addIntegerCell(template.getNumber()).addIntegerCell(template.getHashCode()).addIntegerCell(0).addIntegerCell(template.getTotalCobols()).addIntegerCell(-template.getTotalCobols()).addIntegerCell(0).addIntegerCell(template.getTotalDifferences()).addIntegerCell(-template.getTotalDifferences()).addTextCell("deleted").addTextCell(template.getDeleted()).addTextCell(template.getAdded()).endOfRow();
            template.setState(Template.State.DELETED);
            this.getDeletedTemplates().add(template);
        }
        csvCompOut.close();
        if (applyPattern) {
            this.isInCompare = true;
            this.applyPatterns(patternFolder, filterOpposites, filterOthers, ignoreBugPac, ignoreWontDo, ignoreIsoCobols, locationName, false, true, false);
            this.isInCompare = false;
        }
    }

    public void resetTemplatesState() {
        this.deletedTemplates.clear();
        for (Template template : this.getTemplates()) {
            template.setState(Template.State.DIRTY);
            template.setCobolGap(0);
            template.setDifferenceGap(0);
            for (Cobol cobol : template.getCobols()) {
                for (Difference difference : cobol.getDifferences()) {
                    difference.setNew(false);
                    difference.setDelete(false);
                }
            }
        }
    }

    public MetaTemplate getMetaTemplate(String name) {
        for (MetaTemplate metaTemplate : this.getMetaTemplates()) {
            if (!metaTemplate.getName().equals(name)) continue;
            return metaTemplate;
        }
        return null;
    }

    public List<Template> getTemplates(Template.State state) {
        ArrayList<Template> templates = new ArrayList<Template>();
        for (Template template : this.getAllTemplates()) {
            if (state != null && template.getState() != state) continue;
            templates.add(template);
        }
        return templates;
    }

    public Set<String> getCobolsFileNamesWithDiffs(Template.State state) {
        String key;
        List<Template> templates = this.getTemplates(state);
        HashSet<String> set = new HashSet<String>();
        for (Template template : templates) {
            for (Cobol cobol : template.getCobols()) {
                if (cobol.getDifferences().size() <= 0) continue;
                key = cobol.getFilename();
                set.add(key);
            }
        }
        for (Template template : this.getDeletedTemplates()) {
            for (Cobol cobol : template.getCobols()) {
                if (cobol.getDifferences().size() <= 0) continue;
                key = cobol.getFilename();
                set.add(key);
            }
        }
        return set;
    }

    public Set<Cobol> getCobolsWithDiffs(Template.State state) {
        String key;
        List<Template> templates = this.getTemplates(state);
        HashSet<Cobol> set = new HashSet<Cobol>();
        HashSet<String> setName = new HashSet<String>();
        for (Template template : templates) {
            for (Cobol cobol : template.getCobols()) {
                if (cobol.getDifferences().size() <= 0 || setName.contains(key = cobol.getFilename())) continue;
                set.add(cobol);
                setName.add(key);
            }
        }
        for (Template template : this.getDeletedTemplates()) {
            for (Cobol cobol : template.getCobols()) {
                if (cobol.getDifferences().size() <= 0 || setName.contains(key = cobol.getFilename())) continue;
                set.add(cobol);
                setName.add(key);
            }
        }
        return set;
    }

    public int getDifferences(Template.State state) {
        int diff = 0;
        List<Template> templates = this.getTemplates(state);
        for (Template template : templates) {
            if (state == Template.State.MODIFY) {
                diff += template.getDifferenceGap();
                continue;
            }
            for (Cobol cobol : template.getCobols()) {
                diff += cobol.getDifferences().size();
            }
        }
        return diff;
    }

    public List<Template> getDeletedTemplates() {
        return this.deletedTemplates;
    }

    public List<Cobol> getCobolsWithNoDifferences() {
        return this.noDiffCobols;
    }

    public void setAnalyzedFiles(int nbFiles) {
        this.nbFiles = nbFiles;
    }

    public int getAnalyzedFiles() {
        return this.nbFiles;
    }

    public int getNbExcludedCobol() {
        return this.nbExcludedCobol;
    }

    public void setNbExcludedCobol(int nbExcludedCobol) {
        this.nbExcludedCobol = nbExcludedCobol;
    }

    public int getControlAnalyzedFiles() {
        return this.getCobolsCount() + this.getCobolsWithNoDifferences().size();
    }

    public String displayLog() {
        StringBuilder builder = new StringBuilder();
        if (this.ignoreBugPac && this.ignoreWontDo) {
            builder.append("Sans WontDo / Sans BugPac");
        } else if (this.ignoreWontDo) {
            builder.append("Sans WontDo");
        } else if (this.ignoreBugPac) {
            builder.append("Sans BugPac");
        } else {
            builder.append("Toutes les diff\u00e9rences");
        }
        for (String pattern : this.ignoredPatternsList) {
            builder.append(" " + pattern);
        }
        builder.append(EOL);
        builder.append(" - Nombre de Cobols analys\u00e9                         -> " + this.getAnalyzedFiles() + EOL);
        builder.append(" - Nombre de Cobols ignor\u00e9                          -> " + this.getNbExcludedCobol() + EOL);
        builder.append(" - Nombre de Cobols analys\u00e9 - ignor\u00e9                -> " + (this.getAnalyzedFiles() - this.getNbExcludedCobol()) + EOL);
        builder.append(" - Nombre de Cobols modifi\u00e9                         -> " + this.getCobolsCount() + EOL);
        builder.append(" - Nombre de Templates                              -> " + this.getNbTemplates() + EOL);
        builder.append(" - Nombre de Differences                            -> " + this.getDifferencesCount() + EOL);
        builder.append(" - Nombre de COBOLs Consid\u00e9r\u00e9s ISO CODE             -> " + this.getNbIsoCobols() + EOL);
        builder.append(" - Nombre de Diff\u00e9rences COBOLs Consid\u00e9r\u00e9s ISO CODE -> " + this.getNbIsoCobolsDifferences() + EOL);
        if (this.getAnalyzedFiles() > 0) {
            builder.append(" - Ratio ISO Code                                   -> " + (1.0 - (double)this.getCobolsCount() / (double)(this.getAnalyzedFiles() - this.getNbExcludedCobol())) + EOL);
        }
        builder.append(" - Diff\u00e9rences r\u00e9elles                              -> " + this.getNbRealDifferences() + EOL);
        builder.append(" - Diff\u00e9rences calcul\u00e9es                            -> " + this.getDifferencesControlCount() + EOL);
        builder.append(" - Contr\u00f4le de diff\u00e9rences                          -> " + (this.getNbRealDifferences() == this.getDifferencesControlCount()) + EOL);
        return builder.toString();
    }

    public int getNbIsoCobolsDifferences() {
        return this.nbIsoCobolsDifferences;
    }

    public boolean isOptimized() {
        return this.isOptimized;
    }

    public void setOptimized(boolean isOptimized) {
        this.isOptimized = isOptimized;
    }

    private List<MetaTemplate> readMetaTemplates(File file, String locationName) throws Exception {
        ArrayList<MetaTemplate> metaTemplates = new ArrayList<MetaTemplate>();
        HashMap<String, MetaTemplate> names = new HashMap<String, MetaTemplate>();
        for (String line : ReportAnalyser.readFile(file)) {
            String[] items;
            if (line.trim().length() == 0 || line.charAt(0) == '#' || locationName != null && line.contains(ISOCOB_ID) && !line.contains(ISOCOB_ID + locationName) && ((items = locationName.split("_")).length <= 2 || !line.contains(ISOCOB_ID + items[0] + '_' + items[1]))) continue;
            int end = line.indexOf("#");
            String patternName = line.substring(0, end);
            int start = end;
            end = line.indexOf("#", start + 1);
            String deleted = Report.decodeRegex(line.substring(start + 1, end));
            start = end + 1;
            end = line.indexOf("#", start);
            String added = null;
            added = end > 0 ? Report.decodeRegex(line.substring(start, end)) : Report.decodeRegex(line.substring(start));
            MetaTemplate metaTemplate = new MetaTemplate(patternName, deleted, added, line);
            if (end > 0) {
                String last;
                start = end + 1;
                if ((end = line.indexOf("#", start)) > 0) {
                    last = line.substring(start, end);
                    last = this.decodeTemplateAndLocation(last, locationName);
                    metaTemplate.setGroupPatternName(last);
                    start = end + 1;
                    end = line.indexOf("#", start);
                    if (end > 0) {
                        metaTemplate.setVersion(line.substring(start, end));
                        start = end + 1;
                        metaTemplate.setWorkItems(line.substring(start));
                    } else {
                        metaTemplate.setVersion(line.substring(start));
                    }
                } else {
                    last = line.substring(start);
                    last = this.decodeTemplateAndLocation(last, locationName);
                    metaTemplate.setGroupPatternName(last);
                }
            }
            if (names.containsKey(metaTemplate.getName())) {
                if (debug) {
                    System.err.println("Duplicate meta template will be merged : " + metaTemplate.getName());
                }
                MetaTemplate firtMetaTemplate = (MetaTemplate)names.get(metaTemplate.getName());
                String firstAdded = firtMetaTemplate.getAddedPattern();
                String firstDeletted = firtMetaTemplate.getDeletedPattern();
                if (firstAdded.length() == 0) {
                    firstAdded = "^$";
                }
                if (firstDeletted.length() == 0) {
                    firstDeletted = "^$";
                }
                if (added.length() == 0) {
                    added = "^$";
                }
                if (deleted.length() == 0) {
                    deleted = "^$";
                }
                firtMetaTemplate.setAddedPattern(String.valueOf(firstAdded) + "%" + added);
                firtMetaTemplate.setDeletedPattern(String.valueOf(firstDeletted) + "%" + deleted);
                firtMetaTemplate.getLines().addAll(metaTemplate.getLines());
                continue;
            }
            names.put(metaTemplate.getName(), metaTemplate);
            metaTemplates.add(metaTemplate);
        }
        return metaTemplates;
    }

    private String decodeTemplateAndLocation(String templateName, String locationName) {
        String lastModif;
        String lastModif2;
        if (locationName == null) {
            return templateName;
        }
        if (templateName.startsWith(locationName) && (BUG_PAC.equals(lastModif2 = templateName.substring(locationName.length() + 1)) || WONT_DO.equals(lastModif2))) {
            return lastModif2;
        }
        int index = locationName.indexOf("_");
        if (index == -1) {
            return templateName;
        }
        if (templateName.startsWith(locationName = locationName.substring(0, index)) && (BUG_PAC.equals(lastModif = templateName.substring(locationName.length() + 1)) || WONT_DO.equals(lastModif))) {
            return lastModif;
        }
        return templateName;
    }

    public Collection<Cobol> getAllCobolsFromMetaTemplates(boolean isNoDiffCobols) {
        HashMap<String, Cobol> cobols = new HashMap<String, Cobol>();
        if (isNoDiffCobols) {
            for (MetaTemplate metaTemplate : this.getMetaTemplates()) {
                for (Template template : metaTemplate.getTemplates()) {
                    for (Cobol cobol : template.getCobols()) {
                        if (cobol.getDifferences().size() == 0) continue;
                        String key = cobol.getFilename();
                        Cobol clonedCobol = (Cobol)cobols.get(key);
                        if (clonedCobol == null) {
                            clonedCobol = new Cobol(cobol, null);
                            clonedCobol.setLibraryName(cobol.getLibraryName());
                            clonedCobol.setEntityName(cobol.getEntityName());
                            cobols.put(key, clonedCobol);
                        }
                        clonedCobol.getDifferences().addAll(cobol.getDifferences());
                    }
                }
            }
        } else {
            for (Cobol cobol : this.getCobolsWithNoDifferences()) {
                String key = cobol.getFilename();
                Cobol clonedCobol = (Cobol)cobols.get(key);
                if (clonedCobol != null) continue;
                clonedCobol = new Cobol(cobol, null);
                if (cobol.getLibraryName() != null) {
                    clonedCobol.setLibraryName(cobol.getLibraryName());
                }
                if (cobol.getEntityName() != null) {
                    clonedCobol.setEntityName(cobol.getEntityName());
                }
                cobols.put(key, clonedCobol);
            }
        }
        return cobols.values();
    }

    public Collection<Cobol> getAllCobols(boolean isNoDiffCobols) {
        HashMap<String, Cobol> cobols;
        block10: {
            block9: {
                Cobol clonedCobol;
                String key;
                List<Template> templates = this.getTemplates();
                cobols = new HashMap<String, Cobol>();
                if (!isNoDiffCobols) break block9;
                for (Template template : templates) {
                    for (Cobol cobol : template.getCobols()) {
                        key = cobol.getFilename();
                        clonedCobol = (Cobol)cobols.get(key);
                        if (clonedCobol == null) {
                            clonedCobol = new Cobol(cobol, null);
                            clonedCobol.setLibraryName(cobol.getLibraryName());
                            clonedCobol.setEntityName(cobol.getEntityName());
                            cobols.put(key, clonedCobol);
                        }
                        clonedCobol.getDifferences().addAll(cobol.getDifferences());
                    }
                }
                if (this.clonedTemplates == null) break block10;
                for (Template template : this.clonedTemplates) {
                    for (Cobol cobol : template.getCobols()) {
                        key = cobol.getFilename();
                        clonedCobol = (Cobol)cobols.get(key);
                        if (clonedCobol == null) {
                            clonedCobol = new Cobol(cobol, null);
                            clonedCobol.setLibraryName(cobol.getLibraryName());
                            clonedCobol.setEntityName(cobol.getEntityName());
                            cobols.put(key, clonedCobol);
                        }
                        clonedCobol.getDifferences().addAll(cobol.getDifferences());
                    }
                }
                break block10;
            }
            for (Cobol cobol : this.getCobolsWithNoDifferences()) {
                String key = cobol.getFilename();
                Cobol clonedCobol = (Cobol)cobols.get(key);
                if (clonedCobol != null) continue;
                clonedCobol = new Cobol(cobol, null);
                if (cobol.getLibraryName() != null) {
                    clonedCobol.setLibraryName(cobol.getLibraryName());
                }
                if (cobol.getEntityName() != null) {
                    clonedCobol.setEntityName(cobol.getEntityName());
                }
                cobols.put(key, clonedCobol);
            }
        }
        return cobols.values();
    }

    public synchronized void exportMetaTemplatesRatioGainImpact(String reportDir) throws Exception {
        if (this.getAnalyzedFiles() <= 0) {
            return;
        }
        double totalRatio = 1.0 - (double)this.getCobolsCount() / (double)this.getAnalyzedFiles();
        CsvWriter csvOut = new CsvWriter((Writer)new FileWriter(String.valueOf(reportDir) + "/StatCobolMetaTemplatesGainRatioImpact.csv"), ';', '\"');
        csvOut.addTextCell("Cobol");
        csvOut.addTextCell("Ratio");
        csvOut.endOfRow();
        for (MetaTemplate metaTemplate : this.getMetaTemplates()) {
            csvOut.addCell(metaTemplate.getName());
            double ratio = 1.0 - (double)this.getCobolsCountWithout(metaTemplate) / (double)this.getAnalyzedFiles();
            csvOut.addCell(String.valueOf(df.format((ratio - totalRatio) * 10000.0)) + "%");
            csvOut.endOfRow();
        }
        csvOut.close();
    }

    public void exportMetaTemplatesStat(String reportDir) throws Exception {
        int index = 1;
        HashMap<String, Integer> mapNumber = new HashMap<String, Integer>();
        CsvWriter csvOut = new CsvWriter((Writer)new FileWriter(String.valueOf(reportDir) + "/MetaTemplatesList.csv"), ';', '\"');
        csvOut.addCell("Number").addCell("Name").endOfCell().endOfRow();
        ArrayList<MetaTemplate> _metaTemplates = new ArrayList<MetaTemplate>();
        for (MetaTemplate metaTemplate : this.getMetaTemplates()) {
            if (metaTemplate.getTemplates().isEmpty()) continue;
            _metaTemplates.add(metaTemplate);
        }
        for (MetaTemplate metaTemplate : _metaTemplates) {
            csvOut.addIntegerCell(index);
            csvOut.addCell(metaTemplate.getName());
            csvOut.endOfRow();
            mapNumber.put(metaTemplate.getName(), index);
            ++index;
        }
        csvOut.close();
        HashMap mapStat = new HashMap();
        for (MetaTemplate metaTemplate : _metaTemplates) {
            for (Template template : metaTemplate.getTemplates()) {
                for (Cobol cobol : template.getCobols()) {
                    CobolStat cobolStat;
                    String key = cobol.getFilename();
                    HashMap<Integer, CobolStat> cobolStatMap = (HashMap<Integer, CobolStat>)mapStat.get(key);
                    if (cobolStatMap == null) {
                        cobolStatMap = new HashMap<Integer, CobolStat>();
                        cobolStat = new CobolStat();
                        cobolStat.differences = cobol.getDifferences().size();
                        cobol.getDifferences().size();
                        cobolStatMap.put((Integer)mapNumber.get(metaTemplate.getName()), cobolStat);
                        mapStat.put(key, cobolStatMap);
                        continue;
                    }
                    cobolStat = (CobolStat)cobolStatMap.get(mapNumber.get(metaTemplate.getName()));
                    if (cobolStat == null) {
                        cobolStat = new CobolStat();
                        cobolStatMap.put((Integer)mapNumber.get(metaTemplate.getName()), cobolStat);
                    }
                    cobolStat.differences += cobol.getDifferences().size();
                    cobol.getDifferences().size();
                }
            }
        }
        ArrayList numbers = new ArrayList();
        numbers.addAll(mapNumber.values());
        Collections.sort(numbers);
        csvOut = new CsvWriter((Writer)new FileWriter(String.valueOf(reportDir) + "/StatCobolMetaTemplates.csv"), ';', '\"');
        csvOut.addCell("Cobol");
        for (Integer number : numbers) {
            csvOut.addIntegerCell(number.intValue());
        }
        csvOut.addCell("Total");
        csvOut.endOfRow();
        for (String cobol : mapStat.keySet()) {
            CobolStat cobolStat;
            Map cobolStatMap = (Map)mapStat.get(cobol);
            int totalDiff = 0;
            for (Integer number : numbers) {
                cobolStat = (CobolStat)cobolStatMap.get(number);
                int differences = 0;
                if (cobolStat != null) {
                    differences = cobolStat.differences;
                }
                totalDiff += differences;
            }
            if (totalDiff == 0) continue;
            csvOut.addTextCell(cobol);
            for (Integer number : numbers) {
                cobolStat = (CobolStat)cobolStatMap.get(number);
                int differences = 0;
                if (cobolStat != null) {
                    differences = cobolStat.differences;
                }
                csvOut.addIntegerCell(differences);
            }
            csvOut.addIntegerCell(totalDiff);
            csvOut.endOfRow();
        }
        csvOut.close();
    }

    public int getNbTotalFiles() {
        return this.nbTotalFiles;
    }

    public void setNbTotalFiles(int nbTotalFiles) {
        this.nbTotalFiles = nbTotalFiles;
    }

    public int getNbNotMigratedFiles() {
        return this.nbNotMigratedFiles;
    }

    public void setNbNotMigratedFiles(int nbNotMigratedFiles) {
        this.nbNotMigratedFiles = nbNotMigratedFiles;
    }

    public void setMigrationAvgTime(double migAverageTime) {
        this.migAverageTime = migAverageTime;
    }

    public double getMigrationAvgTime() {
        return this.migAverageTime;
    }

    public String getBuildLabel() {
        return this.buildLabel;
    }

    public void setBuildLabel(String buildLabel) {
        this.buildLabel = buildLabel;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public void setExtracVersion(String extracVersion) {
        this.extracVersion = extracVersion;
    }

    public String getExtracVersion() {
        return this.extracVersion;
    }

    public void setNbRealDifferences(int nbRealDifferences) {
        this.nbRealDifferences = nbRealDifferences;
    }

    public int getNbRealDifferences() {
        return this.nbRealDifferences;
    }

    public void setNbBadConstants(int nbBadConstants) {
        this.nbBadConstants = nbBadConstants;
    }

    public int getNbBadConstants() {
        return this.nbBadConstants;
    }

    public Collection<Cobol> getAllCobolsTemplates(List<Template> templates) {
        HashMap<String, Cobol> cobols = new HashMap<String, Cobol>();
        for (Template template : templates) {
            for (Cobol cobol : template.getCobols()) {
                String key = cobol.getFilename();
                Cobol clonedCobol = (Cobol)cobols.get(key);
                if (clonedCobol == null) {
                    clonedCobol = new Cobol(cobol, null);
                    clonedCobol.setLibraryName(cobol.getLibraryName());
                    clonedCobol.setEntityName(cobol.getEntityName());
                    cobols.put(key, clonedCobol);
                }
                clonedCobol.getDifferences().addAll(cobol.getDifferences());
            }
        }
        return cobols.values();
    }

    public List<Cobol> getCobolsWithDifferences() {
        return this.diffCobols;
    }

    public static String decodeRegex(String regex) {
        String result = regex;
        for (String key : SPECIAL_CHARS.keySet()) {
            result = result.replace(SPECIAL_CHARS.get(key), key);
        }
        return result;
    }

    public static String encodeRegex(String regex) {
        String result = regex;
        for (String key : SPECIAL_CHARS.keySet()) {
            result = result.replace(key, SPECIAL_CHARS.get(key));
        }
        return result;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public String getLocationName() {
        return this.locationName;
    }

    protected boolean isCanceled() {
        return false;
    }

    protected File getPatternFile(String patternDirName, String patternFileName) {
        return ReportAnalyser.getPatternFileJava(patternDirName, patternFileName);
    }

    private static class CobolStat {
        String entityName;
        String libraryName;
        String fileName;
        int differences;
        Set<Template> templates = new HashSet<Template>();

        private CobolStat() {
        }
    }
}

