/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare.tools.model;

import com.ibm.pdp.cobolcompare.tools.model.Cobol;
import com.ibm.pdp.cobolcompare.tools.model.MetaTemplate;
import com.ibm.pdp.cobolcompare.tools.model.Template;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class PatternGroup {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<MetaTemplate> metaTemplates = new ArrayList<MetaTemplate>();
    private String name;
    private String id;
    private String version;

    public PatternGroup(String name, String id) {
        this.name = name;
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public List<MetaTemplate> getMetaTemplates() {
        return this.metaTemplates;
    }

    public int getTotalTemplates() {
        return this.getTotalTemplates(null);
    }

    public int getTotalDifferences() {
        return this.getTotalDifferences(null);
    }

    public int getTotalCobols() {
        return this.getTotalCobols(null);
    }

    public String toString() {
        return String.valueOf(this.name) + (this.getId() == null ? "" : " (" + this.getId() + ")");
    }

    public String getName() {
        return this.name;
    }

    public int getTotalTemplates(List<Template.State> states) {
        int tmpl = 0;
        for (MetaTemplate metaTemplate : this.getMetaTemplates()) {
            List<Template> templates = metaTemplate.getTemplates(states);
            for (Template template : templates) {
                if (template.getState() == Template.State.DELETED) {
                    --tmpl;
                    continue;
                }
                ++tmpl;
            }
        }
        return tmpl;
    }

    public int getTotalDifferences(List<Template.State> states) {
        int diff = 0;
        for (MetaTemplate metaTemplate : this.getMetaTemplates()) {
            for (Template template : metaTemplate.getTemplates(states)) {
                if (template.getState() == Template.State.DELETED) {
                    diff += -template.getTotalDifferences();
                    continue;
                }
                if (template.getState() == Template.State.MODIFY) {
                    diff += template.getDifferenceGap();
                    continue;
                }
                diff += template.getTotalDifferences();
            }
        }
        return diff;
    }

    public int getTotalCobols(List<Template.State> states) {
        HashSet<String> set = new HashSet<String>();
        int cobols = 0;
        for (MetaTemplate metaTemplate : this.getMetaTemplates()) {
            block1: for (Template template : metaTemplate.getTemplates(states)) {
                for (Cobol cobol : template.getCobols()) {
                    if (template.getState() == Template.State.MODIFY) {
                        cobols += template.getCobolGap();
                        continue block1;
                    }
                    String key = cobol.getFilename();
                    if (set.contains(key)) continue;
                    set.add(key);
                    ++cobols;
                }
            }
        }
        return cobols;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

