/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare.tools.model;

import com.ibm.pdp.cobolcompare.tools.model.Cobol;
import com.ibm.pdp.cobolcompare.tools.model.Template;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class MetaTemplate {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<Template> templates = new ArrayList<Template>();
    private String name;
    private String deletedPattern;
    private String addedPattern;
    private String groupPatternName;
    private String version;
    private String workItems;
    private List<String> lines = new ArrayList<String>();
    private double expressGainRatio;
    private double tauxRatio;
    private int expressGainCobols;
    private Set<String> isoCobolsNames = new HashSet<String>();

    public MetaTemplate(String name, String deletedPattern, String addedPattern, String line) {
        this.name = name;
        this.deletedPattern = deletedPattern;
        this.addedPattern = addedPattern;
        this.lines.add(line);
    }

    public List<Template> getTemplates() {
        return this.templates;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTemplates(List<Template> templates) {
        this.templates = templates;
    }

    public String getDeletedPattern() {
        return this.deletedPattern;
    }

    public void setDeletedPattern(String detetedPattern) {
        this.deletedPattern = detetedPattern;
    }

    public String getAddedPattern() {
        return this.addedPattern;
    }

    public void setAddedPattern(String addedPattern) {
        this.addedPattern = addedPattern;
    }

    public int getTotalDifferences() {
        return this.getTotalDifferences(null);
    }

    public String getGroupPatternName() {
        return this.groupPatternName;
    }

    public void setGroupPatternName(String groupPatternName) {
        this.groupPatternName = groupPatternName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getWorkItemsAsString() {
        if (this.workItems == null || this.workItems.trim().length() == 0) {
            return "";
        }
        return this.workItems;
    }

    public List<String> getWorkItems() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.workItems == null || this.workItems.trim().length() == 0) {
            return result;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.workItems, ",");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken().replaceAll("WI", "").replaceAll("wi", "").trim());
        }
        return result;
    }

    public void setWorkItems(String workItems) {
        this.workItems = workItems;
    }

    public String toString() {
        return String.valueOf(this.getGroupPatternName() == null || this.getGroupPatternName().length() == 0 ? "" : "(" + this.getGroupPatternName() + ")  ") + this.name;
    }

    public int getTotalCobols() {
        return this.getTotalCobols(null);
    }

    public String getCobolFileNames() {
        HashSet<String> set = new HashSet<String>();
        String result = "";
        for (Template template : this.getTemplates()) {
            for (Cobol cobol : template.getCobols()) {
                String key = cobol.getFilename();
                if (set.contains(key)) continue;
                set.add(key);
                result = String.valueOf(result) + key + ";" + cobol.getEntityName() + ";" + cobol.getLibraryName() + "\r\n";
            }
        }
        return result;
    }

    public String getIsoCobolFileNames() {
        String result = "";
        for (String cobolName : this.isoCobolsNames) {
            result = String.valueOf(result) + cobolName + ",";
        }
        return result;
    }

    public List<Template> getTemplates(List<Template.State> states) {
        if (states == null) {
            return this.getTemplates();
        }
        ArrayList<Template> templates = new ArrayList<Template>();
        for (Template template : this.getTemplates()) {
            if (!states.contains((Object)template.getState())) continue;
            templates.add(template);
        }
        return templates;
    }

    public List<Template> getTemplates(List<Template.State> states, String text) {
        ArrayList<Template> templates = new ArrayList<Template>();
        return templates;
    }

    public int getTotalDifferences(List<Template.State> states) {
        int diff = 0;
        for (Template template : this.getTemplates(states)) {
            if (template.getState() == Template.State.DELETED) {
                diff -= template.getTotalDifferences();
                continue;
            }
            if (template.getState() == Template.State.MODIFY) {
                diff += template.getDifferenceGap();
                continue;
            }
            diff += template.getTotalDifferences();
        }
        return diff;
    }

    public int getTotalDifferences(List<Template.State> states, String text) {
        int diff = 0;
        for (Template template : this.getTemplates(states)) {
            if (template.getState() == Template.State.DELETED) {
                diff -= template.getTotalDifferences();
                continue;
            }
            if (template.getState() == Template.State.MODIFY) {
                diff += template.getDifferenceGap();
                continue;
            }
            diff += template.getTotalDifferences(text);
        }
        return diff;
    }

    public int getTotalCobols(List<Template.State> states) {
        HashSet<String> set = new HashSet<String>();
        int cobols = 0;
        block0: for (Template template : this.getTemplates(states)) {
            for (Cobol cobol : template.getCobols()) {
                if (template.getState() == Template.State.MODIFY) {
                    cobols += template.getCobolGap();
                    continue block0;
                }
                String key = cobol.getFilename();
                if (cobol.getDifferences().size() <= 0 || set.contains(key)) continue;
                set.add(key);
                ++cobols;
            }
        }
        return cobols;
    }

    public List<String> getLines() {
        return this.lines;
    }

    public double getExpressGainRatio() {
        return this.expressGainRatio;
    }

    public void setExpressGainRatio(double expressGainRatio) {
        this.expressGainRatio = expressGainRatio;
    }

    public Object getTauxRatio() {
        return this.tauxRatio;
    }

    public void setTauxRatio(double tauxRatio) {
        this.tauxRatio = tauxRatio;
    }

    public void setExpressGainCobols(int expressGainCobols) {
        this.expressGainCobols = expressGainCobols;
    }

    public int getExpressGainCobols() {
        return this.expressGainCobols;
    }

    public void setIsoCobolsNames(Set<String> isoCobolsNames) {
        this.isoCobolsNames = isoCobolsNames;
    }

    public Set<String> getIsoCobolsNames() {
        return this.isoCobolsNames;
    }
}

