/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare.tools.model;

import java.util.StringTokenizer;

public class GeneratedTag {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    String modelFileName;
    String cobolFileName;
    String entityName;
    String libraryName;
    String tagName;
    String extraInfo;
    State state;
    boolean isLeaf;
    boolean isGeneratedCode;
    int differences = 0;
    int uniqueTemplates = 0;

    public int getUniqueTemplates() {
        return this.uniqueTemplates;
    }

    public void setUniqueTemplates(int uniqueTemplates) {
        this.uniqueTemplates = uniqueTemplates;
    }

    public int getDifferences() {
        return this.differences;
    }

    public void setDifferences(int differences) {
        this.differences = differences;
    }

    public String getModelFileName() {
        return this.modelFileName;
    }

    public String getTagName() {
        return this.tagName;
    }

    public State getState() {
        return this.state;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public boolean isGeneratedCode() {
        return this.isGeneratedCode;
    }

    public void setModelFileName(String model) {
        this.modelFileName = model.intern();
        this.libraryName = GeneratedTag.getLibName(model);
        this.entityName = GeneratedTag.getModelName(model);
    }

    public void setTagName(String tagName) {
        if (this.state == State.ORDER && tagName.contains("#")) {
            StringTokenizer stringTokenizer = new StringTokenizer(tagName, "#");
            this.tagName = stringTokenizer.nextToken();
            this.extraInfo = "RPP-> " + stringTokenizer.nextToken() + "/" + stringTokenizer.nextToken();
            this.extraInfo = String.valueOf(this.extraInfo) + " MIA-> " + stringTokenizer.nextToken() + "/" + stringTokenizer.nextToken();
        } else if (this.state == State.PARENT && tagName.contains("#")) {
            StringTokenizer stringTokenizer = new StringTokenizer(tagName, "#");
            this.tagName = stringTokenizer.nextToken();
            this.extraInfo = "RPP-> " + stringTokenizer.nextToken();
            this.extraInfo = String.valueOf(this.extraInfo) + " MIA-> " + stringTokenizer.nextToken();
        } else {
            this.tagName = tagName.intern();
        }
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public void setGeneratedCode(boolean isGeneratedCode) {
        this.isGeneratedCode = isGeneratedCode;
    }

    public void setStringState(String stringState) {
        if ("new".equals(stringState)) {
            this.state = State.NEW;
        } else if ("parent".equals(stringState)) {
            this.state = State.PARENT;
        } else if ("order".equals(stringState)) {
            this.state = State.ORDER;
        } else if ("deleted".equals(stringState)) {
            this.state = State.DELETED;
        }
    }

    public String getCobolFileName() {
        return this.cobolFileName;
    }

    public void setCobolFileName(String cobol) {
        this.cobolFileName = cobol.intern();
    }

    public static String getModelName(String modelFileName) {
        int start = modelFileName.indexOf("rpp/");
        int end = modelFileName.indexOf(46, start);
        return modelFileName.substring(start + "rpp/".length(), end).intern();
    }

    public static String getLibName(String modelFileName) {
        int start = modelFileName.indexOf(46);
        int end = modelFileName.indexOf(47, start);
        return modelFileName.substring(start + 1, end).intern();
    }

    public String toString() {
        return String.valueOf(GeneratedTag.getModelName(this.modelFileName)) + "/" + GeneratedTag.getLibName(this.getModelFileName()) + " (TagName: " + this.tagName + " Type: " + (Object)((Object)this.state) + (this.extraInfo == null ? "" : " " + this.extraInfo) + " Terminal: " + this.isLeaf + " Code G\u00e9n\u00e9r\u00e9: " + this.isGeneratedCode + ")";
    }

    public String getDetail() {
        return String.valueOf(GeneratedTag.getModelName(this.modelFileName)) + "/" + GeneratedTag.getLibName(this.getModelFileName()) + " (TagName: " + this.tagName + " Type: " + (Object)((Object)this.state) + (this.extraInfo == null ? "" : " " + this.extraInfo) + " Terminal: " + this.isLeaf + " Code G\u00e9n\u00e9r\u00e9: " + this.isGeneratedCode + " Diff\u00e9rences: " + this.differences + " Templates Uniques: " + this.uniqueTemplates + ")";
    }

    public String getEntityName() {
        if (this.entityName == null) {
            this.entityName = GeneratedTag.getModelName(this.modelFileName);
        }
        return this.entityName;
    }

    public String getLibraryName() {
        if (this.libraryName == null) {
            this.libraryName = GeneratedTag.getLibName(this.modelFileName);
        }
        return this.libraryName;
    }

    public static enum State {
        NEW,
        DELETED,
        PARENT,
        ORDER,
        UNKNOWN;

    }
}

