/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare.tools.model;

import com.ibm.pdp.cobolcompare.tools.model.Cobol;
import java.util.StringTokenizer;

public class Difference {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String miaCobolCode = null;
    private String rppCobolCode = null;
    private String miaCroppedCobolCode = null;
    private String rppCroppedCobolCode = null;
    private int startMia;
    private int endMia;
    private int startRpp;
    private int endRpp;
    private Cobol cobol;
    private boolean isNew = false;
    private boolean isDelete = false;
    private int id = -1;
    private boolean isProcedure = false;
    private boolean cropEndOfLine = false;

    public static Difference cloneDifference(Difference difference, Cobol cobol) {
        Difference result = new Difference(cobol);
        result.miaCobolCode = difference.miaCobolCode;
        result.rppCobolCode = difference.rppCobolCode;
        result.miaCroppedCobolCode = difference.miaCroppedCobolCode;
        result.rppCroppedCobolCode = difference.rppCroppedCobolCode;
        result.startMia = difference.startMia;
        result.endMia = difference.endMia;
        result.startRpp = difference.startRpp;
        result.endRpp = difference.endRpp;
        result.isProcedure = difference.isProcedure;
        result.cropEndOfLine = difference.cropEndOfLine;
        return result;
    }

    public Difference(Cobol cobol, String miaCobolCode, String rppCobolCode, boolean isProcedure, boolean cropEndOfLine) {
        this(cobol);
        this.miaCobolCode = Difference.trimDiffRight(miaCobolCode);
        this.rppCobolCode = Difference.trimDiffRight(rppCobolCode);
        this.cropEndOfLine = cropEndOfLine;
        if (this.cropEndOfLine() && miaCobolCode != null) {
            this.miaCroppedCobolCode = Difference.modifyRightColumn(this.miaCobolCode);
        }
        if (this.cropEndOfLine() && rppCobolCode != null) {
            this.rppCroppedCobolCode = Difference.modifyRightColumn(this.rppCobolCode);
        }
        this.isProcedure = isProcedure;
    }

    public static String trimDiffRight(String sourceCode) {
        if (sourceCode != null && sourceCode.indexOf(" \n") > 0) {
            StringTokenizer tokenizer = new StringTokenizer(sourceCode, "\n");
            StringBuilder builder = new StringBuilder(sourceCode.length());
            while (tokenizer.hasMoreTokens()) {
                String line = tokenizer.nextToken();
                builder.append(line.replaceAll("\\s+$", ""));
                if (!tokenizer.hasMoreTokens()) continue;
                builder.append("\n");
            }
            return builder.toString();
        }
        return sourceCode;
    }

    public Difference(Cobol cobol) {
        this.cobol = cobol;
    }

    public String getCroppedMiaCobolCode() {
        if (this.cropEndOfLine()) {
            return this.miaCroppedCobolCode;
        }
        return this.miaCobolCode;
    }

    private boolean cropEndOfLine() {
        return this.cropEndOfLine;
    }

    public String getCroppedRppCobolCode() {
        if (this.cropEndOfLine()) {
            return this.rppCroppedCobolCode;
        }
        return this.rppCobolCode;
    }

    public String getMiaCobolCode() {
        return this.miaCobolCode;
    }

    public String getRppCobolCode() {
        return this.rppCobolCode;
    }

    public void setMiaCobolCode(String miaCobolCode) {
        this.miaCobolCode = miaCobolCode;
    }

    public void setRppCobolCode(String rppCobolCode) {
        this.rppCobolCode = rppCobolCode;
    }

    public int getStartMia() {
        return this.startMia;
    }

    public void setStartMia(int startMia) {
        this.startMia = startMia;
    }

    public int getEndMia() {
        return this.endMia;
    }

    public void setEndMia(int endMia) {
        this.endMia = endMia;
    }

    public int getStartRpp() {
        return this.startRpp;
    }

    public void setStartRpp(int startRpp) {
        this.startRpp = startRpp;
    }

    public int getEndRpp() {
        return this.endRpp;
    }

    public void setEndRpp(int endRpp) {
        this.endRpp = endRpp;
    }

    public Cobol getCobol() {
        return this.cobol;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isDelete() {
        return this.isDelete;
    }

    public void setDelete(boolean isDelete) {
        this.isDelete = isDelete;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String toString() {
        return "Difference (Procedure: " + this.isProcedure + ", New: " + this.isNew + ", Deleted: " + this.isDelete + ")";
    }

    private static String modifyRightColumn(String code) {
        StringTokenizer tokenizer = new StringTokenizer(code, "\n");
        StringBuilder builder = new StringBuilder(code.length());
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            if (line.length() <= 72) {
                builder.append(line);
            } else {
                String rightMargin = line.substring(72);
                if (rightMargin.equals("DOT") || rightMargin.length() == 4 && rightMargin.startsWith("lv") && Character.isDigit(rightMargin.charAt(2)) && Character.isDigit(rightMargin.charAt(3))) {
                    builder.append(line);
                } else if (line.charAt(72) != ' ' && rightMargin.length() <= 6) {
                    line = line.substring(0, 72);
                    line = Difference.trimRight(line);
                    builder.append(line);
                } else {
                    builder.append(line);
                }
            }
            if (!tokenizer.hasMoreTokens()) continue;
            builder.append("\n");
        }
        String result = builder.toString();
        return result;
    }

    public static String trimRight(String name) {
        int end = name.length() - 1;
        char[] value = name.toCharArray();
        while (end >= 0 && value[end] <= ' ') {
            --end;
        }
        return new String(value, 0, end + 1);
    }

    public boolean isProcedure() {
        return this.isProcedure;
    }
}

