/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare.tools.model;

import com.ibm.pdp.cobolcompare.tools.model.Difference;
import com.ibm.pdp.cobolcompare.tools.model.Template;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Cobol {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<Difference> differences = new ArrayList<Difference>();
    private String filename;
    private String entityName;
    private String libraryName;
    private Template template;
    private String designId;

    public static String getCobolFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        String temp = new File(fileName).getAbsolutePath().replace('\\', '/').replaceAll(";", "");
        int idx = temp.indexOf("CONTROL_COBOL_FOLDER");
        if (idx > 0) {
            return temp.substring(idx + "CONTROL_COBOL_FOLDER".length() + 1).intern();
        }
        idx = temp.indexOf("com.ibm.pdp.pacbase.junit.Rpp_Customer_Base_Test");
        if (idx > 0) {
            return temp.substring(idx + "com.ibm.pdp.pacbase.junit.Rpp_Customer_Base_Test".length() + 1).intern();
        }
        idx = temp.indexOf("Rpp_ReGenerated_Backup");
        if (idx > 0) {
            if ((idx = (temp = temp.substring(idx + "Rpp_ReGenerated_Backup".length() + 1).intern()).indexOf("/")) > 0) {
                temp = temp.substring(idx + 1).intern();
            }
            return temp;
        }
        return fileName.intern();
    }

    public Cobol(String fileName) {
        this.filename = Cobol.getCobolFileName(fileName);
    }

    public Cobol(Cobol cobol, Template cloneTemplate) {
        this.filename = cobol.getFilename() == null ? null : cobol.getFilename().intern();
        this.designId = cobol.getDesignId() == null ? null : cobol.getDesignId().intern();
        this.template = cloneTemplate;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public void setLibraryName(String libraryName) {
        this.libraryName = libraryName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName.intern();
    }

    public List<Difference> getDifferences() {
        return this.differences;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public Template getTemplate() {
        return this.template;
    }

    public String toString() {
        return String.valueOf(new File(this.filename).getName()) + " ( Lib -> " + this.libraryName + " Model -> " + this.entityName + " DesignId -> " + this.designId + ")";
    }

    public void setDesignId(String designId) {
        if (designId == null) {
            return;
        }
        this.designId = designId.intern();
    }

    public String getDesignId() {
        return this.designId;
    }
}

