/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.cobolcompare.tools.analyser;

import com.ibm.pdp.cobolcompare.PacbaseCobolDifferencerWithSignificantDots;
import com.ibm.pdp.cobolcompare.tools.model.Cobol;
import com.ibm.pdp.cobolcompare.tools.model.Difference;
import com.ibm.pdp.cobolcompare.tools.model.Report;
import com.ibm.pdp.cobolcompare.tools.model.Template;
import com.ibm.pdp.util.csv.CsvWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ReportAnalyser {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2023.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String BAD_CONSTANT = "BAD_CONSTANT";
    public static final String PROCEDURE = "PROCEDURE";
    public static final String WORKING = "WORKING";
    static boolean filterSameMiaRppCode = "true".equals(System.getProperty("filterSameMiaRppCode"));
    private static final String DESIGN_PATTERN = "design=/";
    private String rppFolder;
    int nbSameDiffs = 0;
    List<String> cobolsToIgnore = null;
    private static final int DIFFERENCES_LIMITS = 800000;
    int nbFiles = -1;
    int nbModifiedFiles = -1;
    int nbTemplates = -1;
    int nbDifferences = -1;
    private Map<String, String[]> cololsToEntittiesNames = new HashMap<String, String[]>();
    private Map<String, String> designIds = new HashMap<String, String>();
    private static String EOL = System.getProperty("line.separator");
    static char SEMI_COLON = (char)59;

    public ReportAnalyser(String rppFolder) {
        this.rppFolder = rppFolder;
    }

    public int getNbFiles() {
        return this.nbFiles;
    }

    public int getNbSameDifferences() {
        return this.nbSameDiffs;
    }

    public void analyze(Report report, boolean ignoreCobolWithDifferentConstants, boolean optimize, boolean rppCompareInput, boolean isBatch) throws Exception {
        this.analyze(report, ignoreCobolWithDifferentConstants, optimize, rppCompareInput, isBatch, false);
    }

    public void analyze(Report report, boolean ignoreCobolWithDifferentConstants, boolean optimize, boolean rppCompareInput, boolean isBatch, boolean isQuiet) throws Exception {
        this.analyze(report, ignoreCobolWithDifferentConstants, optimize, rppCompareInput, isBatch, isQuiet, null);
    }

    public void analyze(Report report, boolean ignoreCobolWithDifferentConstants, boolean optimize, boolean rppCompareInput, boolean isBatch, boolean isQuiet, List<String> typesToInclude) throws Exception {
        int idx;
        this.designIds.clear();
        boolean _optimize = optimize || isBatch && this.nbDifferences > 800000;
        report.setOptimized(_optimize);
        boolean _rppCompareInput = rppCompareInput || new File(String.valueOf(this.rppFolder) + "/Templates.csv").exists();
        long start = System.currentTimeMillis();
        File templateFile = new File(String.valueOf(this.rppFolder) + (_rppCompareInput ? "/Templates.csv" : "/MigrationTemplates.csv"));
        File diffListFile = new File(String.valueOf(this.rppFolder) + (_rppCompareInput ? "/DiffList.csv" : "/MigrationDiffList.csv"));
        File overviewFile = new File(String.valueOf(this.rppFolder) + (_rppCompareInput ? "/Overview.csv" : "/MigrationControlOverview.csv"));
        File ignoredCobolsFile = new File(String.valueOf(this.rppFolder) + "/ExcludedCobols.txt");
        File summaryFile = new File(String.valueOf(this.rppFolder) + "/Summarize.csv");
        List<String> lines = null;
        if (summaryFile.exists() && (lines = ReportAnalyser.readFile(summaryFile)).size() > 1) {
            int endIndex;
            String line2;
            for (String line2 : lines) {
                idx = line2.indexOf("Location=");
                if (idx <= 0) continue;
                String locationName = line2.substring(idx + "Location=".length()).trim();
                report.setLocationName(locationName);
            }
            line2 = lines.get(1);
            int beginIndex = line2.indexOf(59);
            if (beginIndex > 0 && (endIndex = (line2 = line2.substring(beginIndex + 1)).indexOf(59)) > 0) {
                String totalCobol = line2.substring(0, endIndex);
                try {
                    report.setNbTotalFiles(Integer.parseInt(totalCobol));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                beginIndex = endIndex + 1;
                line2 = line2.substring(beginIndex);
                endIndex = line2.indexOf(59);
                if (endIndex > 0) {
                    String totalNotMig = line2.substring(0, endIndex);
                    report.setNbNotMigratedFiles(Integer.parseInt(totalNotMig));
                }
                int i = 0;
                while (i < 5) {
                    beginIndex = line2.indexOf(59);
                    if (beginIndex <= 0) break;
                    line2 = line2.substring(beginIndex + 1);
                    ++i;
                }
                if (beginIndex > 0) {
                    beginIndex = line2.indexOf(59);
                    if (beginIndex > 0) {
                        report.setMigrationAvgTime(Double.parseDouble(line2.substring(0, beginIndex)));
                        line2 = line2.substring(beginIndex + 1);
                        beginIndex = line2.indexOf(59);
                        if (beginIndex > 0) {
                            report.setBuildLabel(line2.substring(0, beginIndex));
                            line2 = line2.substring(beginIndex + 1);
                            beginIndex = line2.indexOf(59);
                            if (beginIndex > 0) {
                                report.setPriority(line2.substring(0, beginIndex));
                                line2 = line2.substring(beginIndex + 1);
                                report.setExtracVersion(line2.trim());
                            } else {
                                report.setPriority(line2.trim());
                            }
                        }
                    } else {
                        report.setMigrationAvgTime(Double.parseDouble(line2));
                    }
                }
            }
        }
        this.cobolsToIgnore = new ArrayList<String>();
        if (ignoredCobolsFile.exists()) {
            lines = ReportAnalyser.readFile(ignoredCobolsFile);
        } else {
            File file = ReportAnalyser.getPlugingFileNameJava("ExcludedCobols.txt");
            if (file.exists()) {
                lines = ReportAnalyser.readFile(file);
            }
        }
        if (lines != null) {
            for (String line2 : lines) {
                idx = line2.indexOf(59);
                if (idx > 0) {
                    this.cobolsToIgnore.add(line2.substring(0, idx).replace("\"", ""));
                    continue;
                }
                this.cobolsToIgnore.add(line2.replace("\"", ""));
            }
        }
        List<String> overViewlines = ReportAnalyser.readFile(overviewFile);
        BufferedWriter constError = new BufferedWriter(new FileWriter(String.valueOf(this.rppFolder) + "/ConstantsDiffer.csv"));
        CsvWriter cvsNoDiffCobols = new CsvWriter((Writer)new FileWriter(String.valueOf(this.rppFolder) + "/CobolsWithNoDifference.csv"), ';', '\"');
        cvsNoDiffCobols.addTextCell("Cobol").addTextCell("Model").addTextCell("Lib").endOfRow();
        CsvWriter cvsWithDiffCobols = new CsvWriter((Writer)new FileWriter(String.valueOf(this.rppFolder) + "/CobolsWithDifference.csv"), ';', '\"');
        cvsWithDiffCobols.addTextCell("Cobol").addTextCell("Model").addTextCell("Lib").endOfRow();
        int setNbBadConstants = 0;
        for (String line : overViewlines) {
            try {
                Cobol cobol;
                int idx2;
                String[] result = this.decodeOverviewLine(line, true);
                if (result[0] != null) {
                    int idx3;
                    String tmp = result[0];
                    if (!_rppCompareInput) {
                        constError.write(String.valueOf(tmp) + "\n");
                    }
                    report.setHasBadConstant(true);
                    ++setNbBadConstants;
                    if (ignoreCobolWithDifferentConstants && (idx3 = tmp.indexOf(59)) > 0 && (idx3 = (tmp = tmp.substring(idx3 + 1)).indexOf(59)) > 0 && !this.cobolsToIgnore.contains(tmp = tmp.substring(0, idx3))) {
                        this.cobolsToIgnore.add(tmp);
                    }
                }
                if ((idx2 = line.indexOf("RPP cobol after generation;0;0;")) < 0) {
                    idx2 = line.indexOf(";RPP generated cobol;0;0;");
                }
                if (idx2 > 0) {
                    result = this.decodeOverviewLine(line, false);
                    cobol = new Cobol(line.substring(line.indexOf(59) + 1, idx2));
                    if (result[0] != null && result[1] != null) {
                        cobol.setLibraryName(result[0]);
                        cobol.setEntityName(result[1]);
                        cvsNoDiffCobols.addTextCell(cobol.getFilename()).addTextCell(result[1]).addTextCell(result[0]).endOfRow();
                    } else {
                        cobol.setLibraryName(BAD_CONSTANT);
                        cobol.setEntityName(BAD_CONSTANT);
                        cvsNoDiffCobols.addTextCell(cobol.getFilename()).addTextCell(BAD_CONSTANT).addTextCell(BAD_CONSTANT).endOfRow();
                    }
                    idx2 = line.indexOf("design=");
                    if (idx2 > 0) {
                        String designId = line.substring(idx2 + "design=".length()).replaceAll("\".*", "");
                        cobol.setDesignId(designId);
                        this.designIds.put(cobol.getFilename(), designId);
                        this.filterTypes(report, cobol, typesToInclude);
                    }
                    report.getCobolsWithNoDifferences().add(cobol);
                    continue;
                }
                idx2 = line.indexOf("RPP cobol after generation;");
                if (idx2 < 0) {
                    idx2 = line.indexOf(";RPP generated cobol;");
                }
                if (idx2 > 0) {
                    result = this.decodeOverviewLine(line, false);
                    cobol = new Cobol(line.substring(line.indexOf(59) + 1, idx2));
                    if (result[0] != null && result[1] != null) {
                        cobol.setLibraryName(result[0]);
                        cobol.setEntityName(result[1]);
                        cvsWithDiffCobols.addTextCell(cobol.getFilename()).addTextCell(result[1]).addTextCell(result[0]).endOfRow();
                    } else {
                        cobol.setLibraryName(BAD_CONSTANT);
                        cobol.setEntityName(BAD_CONSTANT);
                        cvsWithDiffCobols.addTextCell(cobol.getFilename()).addTextCell(BAD_CONSTANT).addTextCell(BAD_CONSTANT).endOfRow();
                    }
                    report.getCobolsWithDifferences().add(cobol);
                    idx2 = line.indexOf("design=");
                    if (idx2 <= 0) continue;
                    String designId = line.substring(idx2 + "design=".length()).replaceAll("\".*", "");
                    cobol.setDesignId(designId);
                    this.designIds.put(cobol.getFilename(), designId);
                    this.filterTypes(report, cobol, typesToInclude);
                    continue;
                }
                String[] items = line.split(";");
                if (items.length != 7) continue;
                try {
                    int nbDiff = Integer.parseInt(items[3]);
                    Cobol cobol2 = new Cobol(items[1].replace(".pac", "").replace(".bak", "").replace(".before.val", ".cbl"));
                    cobol2.setLibraryName(result[0]);
                    cobol2.setEntityName(result[1]);
                    if (nbDiff == 0) {
                        report.getCobolsWithNoDifferences().add(cobol2);
                        cvsNoDiffCobols.addTextCell(cobol2.getFilename()).addTextCell(result[1]).addTextCell(result[0]).endOfRow();
                        continue;
                    }
                    report.getCobolsWithDifferences().add(cobol2);
                    cvsWithDiffCobols.addTextCell(cobol2.getFilename()).addTextCell(result[1]).addTextCell(result[0]).endOfRow();
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (setNbBadConstants > 0) {
            report.setNbBadConstants(setNbBadConstants);
        }
        cvsNoDiffCobols.close();
        cvsWithDiffCobols.close();
        constError.close();
        this.beginTask("Decodes templates ...", -1);
        lines = ReportAnalyser.readFile(templateFile);
        this.decodeTemplates(report, lines, _rppCompareInput);
        lines = _optimize ? ReportAnalyser.readOptimizedDiffFile(diffListFile) : ReportAnalyser.readFile(diffListFile);
        this.endTask();
        this.decodeDiffList(report, lines, overViewlines, _optimize, _rppCompareInput);
        report.setAnalyzedFiles(this.nbFiles);
        report.setNbExcludedCobol(this.cobolsToIgnore.size());
        long end = System.currentTimeMillis();
        if (Report.debug) {
            System.out.println("Analyse done in : " + (end - start) / 1000L);
        }
        if (isQuiet) {
            new File(String.valueOf(this.rppFolder) + "/ConstantsDiffer.csv").deleteOnExit();
            new File(String.valueOf(this.rppFolder) + "/CobolsWithNoDifference.csv").deleteOnExit();
            new File(String.valueOf(this.rppFolder) + "/CobolsWithDifference.csv").deleteOnExit();
        }
    }

    private void filterTypes(Report report, Cobol cobol, List<String> typesToInclude) {
        if (typesToInclude == null || typesToInclude.isEmpty()) {
            return;
        }
        for (String type : typesToInclude) {
            if (cobol.getDesignId() != null && cobol.getDesignId().endsWith(type) || this.cobolsToIgnore.contains(cobol.getFilename())) continue;
            this.cobolsToIgnore.add(cobol.getFilename());
        }
    }

    private void countTemplates(Report report) {
        try {
            HashSet<Integer> templatesIdsFound = new HashSet<Integer>();
            for (Template template : report.getTemplates()) {
                templatesIdsFound.add(template.getNumber());
            }
            if (this.nbTemplates != report.getTemplates().size()) {
                System.out.println("ERROR : CVS Template number : " + this.nbTemplates + " Decoded Templates : " + report.getTemplates().size());
            }
            int i = 1;
            while (i <= this.nbTemplates) {
                if (!templatesIdsFound.contains(i)) {
                    System.out.println("ERROR : Template id not found (may be with no COBOL in diff file) : " + i);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void decodeTemplates(Report report, List<String> lines, boolean rppCompareInput) {
        long startTime = System.currentTimeMillis();
        StringBuilder builder = new StringBuilder();
        boolean isNewTemplate = false;
        boolean hasHashCode = false;
        int currentLine = 0;
        HashMap<Integer, Template> hashCodes = new HashMap<Integer, Template>();
        int offset = rppCompareInput ? 3 : 0;
        for (String line : lines) {
            try {
                int idx;
                if (currentLine == 0 + offset) {
                    idx = line.indexOf(61);
                    if (idx > 0) {
                        try {
                            this.nbFiles = Integer.parseInt(line.substring(idx + 1, line.length() - 1).trim());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        this.nbFiles = 1;
                        this.nbTemplates = 0;
                    }
                }
                if (currentLine == 1 + offset && (idx = line.indexOf(61)) > 0) {
                    try {
                        this.nbModifiedFiles = Integer.parseInt(line.substring(idx + 1, line.length() - 1).trim());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (currentLine == 2 + offset && (idx = line.indexOf(61)) > 0) {
                    try {
                        this.nbTemplates = Integer.parseInt(line.substring(idx + 1, line.length() - 1).trim());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (currentLine == 3 + offset && (idx = line.indexOf(61)) > 0) {
                    try {
                        this.nbDifferences = Integer.parseInt(line.substring(idx + 1, line.length() - 1).trim());
                        report.setNbRealDifferences(this.nbDifferences);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!isNewTemplate && line.startsWith("Template" + SEMI_COLON)) {
                    hasHashCode = line.contains(String.valueOf(SEMI_COLON) + "HashCode" + SEMI_COLON);
                }
                if (line.length() > 0 && this.isNewTemplateLine(line)) {
                    isNewTemplate = true;
                }
                if (isNewTemplate) {
                    builder.append(line);
                }
                if (isNewTemplate && line.endsWith("\"") || line.endsWith("\"" + SEMI_COLON)) {
                    String nextLine;
                    if (currentLine < lines.size() - 1 && !Character.isDigit((nextLine = lines.get(currentLine + 1)).charAt(0))) {
                        ++currentLine;
                        continue;
                    }
                    String currentFullLine = builder.toString();
                    int end = currentFullLine.indexOf(SEMI_COLON);
                    Template template = new Template(Integer.parseInt(currentFullLine.substring(0, end)));
                    int start = end + 1;
                    end = currentFullLine.indexOf(SEMI_COLON, start);
                    start = end + 1;
                    end = currentFullLine.indexOf(SEMI_COLON, start);
                    template.setNature(currentFullLine.substring(start, end).trim());
                    start = end + 1;
                    end = currentFullLine.indexOf(SEMI_COLON, start);
                    template.setNbDeleted(Integer.parseInt(currentFullLine.substring(start, end)));
                    start = end + 1;
                    end = currentFullLine.indexOf(SEMI_COLON, start);
                    template.setNbAdded(Integer.parseInt(currentFullLine.substring(start, end)));
                    start = end + 1;
                    boolean alreadyUsedHasCode = false;
                    Template alreadyUsedHasCodeTemplate = null;
                    if (hasHashCode) {
                        end = currentFullLine.indexOf(SEMI_COLON, start);
                        String hCode = currentFullLine.substring(start, end);
                        template.setHashCode(Integer.parseInt(hCode));
                        alreadyUsedHasCodeTemplate = (Template)hashCodes.get(template.getHashCode());
                        if (alreadyUsedHasCodeTemplate == null) {
                            hashCodes.put(template.getHashCode(), template);
                        } else {
                            alreadyUsedHasCode = true;
                        }
                        start = end + 1;
                        end = currentFullLine.indexOf(String.valueOf(SEMI_COLON) + "\"", start);
                    } else {
                        end = currentFullLine.indexOf(String.valueOf(SEMI_COLON) + "\"", start);
                    }
                    if (end == -1) {
                        template.setDeleted(currentFullLine.substring(start, currentFullLine.length() - 1));
                        template.setAdded("");
                    } else {
                        String deleted = currentFullLine.substring(start, end);
                        String added = currentFullLine.substring(end + 1);
                        template.setDeleted(deleted);
                        template.setAdded(added);
                    }
                    if (!hasHashCode) {
                        StringBuilder tmp = new StringBuilder();
                        tmp.append(template.getNature());
                        tmp.append('#');
                        tmp.append(Report.stripCode(template.getDeleted().replaceAll("\\s+", "")));
                        tmp.append('#');
                        tmp.append(Report.stripCode(template.getAdded().replaceAll("\\s+", "")));
                        template.setHashCode(tmp.toString().hashCode());
                        alreadyUsedHasCodeTemplate = (Template)hashCodes.get(template.getHashCode());
                        if (alreadyUsedHasCodeTemplate == null) {
                            hashCodes.put(template.getHashCode(), template);
                        } else {
                            alreadyUsedHasCode = true;
                        }
                    }
                    if (alreadyUsedHasCode) {
                        template.setHasDuplicates(true);
                        alreadyUsedHasCodeTemplate.setHasDuplicates(true);
                        if (Report.debug) {
                            System.err.println("HashCode " + template.getHashCode() + " is already used !!!!! -> \n" + "\tCurrent Number : " + template.getNumber() + "\n" + "\tCurrent Deleted : " + template.getDeleted() + "\n" + "\tCurrent Added : " + template.getAdded() + "\n" + "\tPrevouis Number : " + alreadyUsedHasCodeTemplate.getNumber() + "\n" + "\tPrevouis Deleted : " + alreadyUsedHasCodeTemplate.getDeleted() + "\n" + "\tPrevouis Added : " + alreadyUsedHasCodeTemplate.getAdded() + "\n");
                        }
                    }
                    report.getTemplates().add(template);
                    builder = new StringBuilder();
                    isNewTemplate = false;
                } else if (isNewTemplate) {
                    builder.append(EOL);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Cannot decode template : " + line, e);
            }
            ++currentLine;
            if (!this.isCanceled()) continue;
            return;
        }
        if (Report.debug) {
            System.out.println("Templates found : " + report.getNbTemplates());
        }
        long endTime = System.currentTimeMillis();
        if (Report.debug) {
            System.out.println("Decode Templates done in : " + (endTime - startTime) / 1000L);
        }
    }

    private boolean isNewTemplateLine(String line) {
        if (line.length() > 0 && Character.isDigit(line.charAt(0))) {
            int i = 1;
            while (i < line.length()) {
                char c = line.charAt(i);
                if (!Character.isDigit(c)) {
                    return c == SEMI_COLON;
                }
                ++i;
            }
        }
        return false;
    }

    private void decodeDiffList(Report report, List<String> lines, List<String> overviewLines, boolean optimize, boolean rppCompareInput) throws Exception {
        this.beginTask("Decodes differences list (" + this.getNbDifferences() + ") ...", this.getNbDifferences());
        long startTime = System.currentTimeMillis();
        this.cololsToEntittiesNames.clear();
        this.nbSameDiffs = 0;
        boolean isNewCobol = false;
        StringBuilder builder = new StringBuilder();
        int currentLine = 0;
        for (String line : lines) {
            if (line.length() > 0 && Character.isDigit(line.charAt(0))) {
                isNewCobol = true;
            }
            if (isNewCobol) {
                builder.append(String.valueOf(line) + "\n");
            }
            if (isNewCobol && line.endsWith("\"") || line.endsWith("\"" + SEMI_COLON)) {
                if (currentLine < lines.size() - 1) {
                    String nextLine = lines.get(currentLine + 1);
                    String nbDiff = "EMPTY";
                    if (builder.indexOf(";") > 0) {
                        nbDiff = builder.substring(0, builder.indexOf(";"));
                        int nbDiffInt = Integer.parseInt(nbDiff);
                        nbDiff = Integer.toString(++nbDiffInt);
                    }
                    if (!Character.isDigit(nextLine.charAt(0)) || !nextLine.startsWith(nbDiff)) {
                        ++currentLine;
                        continue;
                    }
                }
                String currentFullLine = builder.toString();
                int start = currentFullLine.indexOf(SEMI_COLON);
                if ((start = currentFullLine.indexOf(SEMI_COLON, start + 1)) > 1) {
                    String fullName;
                    int end = currentFullLine.indexOf(SEMI_COLON, start + 1);
                    String curTmpl = currentFullLine.substring(start + 1, end);
                    int templateNumber = -1;
                    try {
                        templateNumber = Integer.parseInt(curTmpl);
                    }
                    catch (Exception e) {
                        System.out.println("ERROR : cannot decode template for this line : " + currentFullLine);
                        throw e;
                    }
                    Template template = report.getTemplate(templateNumber);
                    start = end + 1;
                    end = currentFullLine.indexOf(SEMI_COLON, start);
                    String type = currentFullLine.substring(start, end);
                    boolean isProcedure = false;
                    if (PROCEDURE.equals(type.toUpperCase())) {
                        isProcedure = true;
                    }
                    start = end + 1;
                    end = currentFullLine.indexOf(SEMI_COLON, start);
                    if (rppCompareInput) {
                        start = end + 1;
                        end = currentFullLine.indexOf(SEMI_COLON, start);
                    }
                    if ((fullName = currentFullLine.substring(start, end)).endsWith(".pac")) {
                        fullName = fullName.replace(".pac", "");
                    } else if (fullName.endsWith(".bak")) {
                        fullName = fullName.replace(".bak", "");
                    } else if (fullName.endsWith(".before.val")) {
                        fullName = fullName.replace(".before.val", ".cbl");
                    }
                    String fileName = Cobol.getCobolFileName(fullName);
                    String designId = this.designIds.get(fileName);
                    if (template != null) {
                        String[] value;
                        Cobol cobol = template.getCobol(fileName);
                        if (cobol == null) {
                            cobol = new Cobol(fileName);
                            cobol.setTemplate(template);
                            template.getCobols().add(cobol);
                        }
                        if ((value = this.cololsToEntittiesNames.get(fileName)) != null) {
                            cobol.setEntityName(value[1]);
                            cobol.setLibraryName(value[0]);
                        } else {
                            for (String overString : overviewLines) {
                                if (!overString.contains(fullName)) continue;
                                String[] result = this.decodeOverviewLine(overString, false);
                                if (result[1] == null) {
                                    System.err.println("Cannot decode : " + overString);
                                    cobol.setEntityName(fileName);
                                    result[1] = fileName;
                                } else {
                                    cobol.setEntityName(result[1]);
                                }
                                cobol.setLibraryName(result[0]);
                                this.cololsToEntittiesNames.put(fileName, result);
                                break;
                            }
                        }
                        cobol.setDesignId(designId);
                        if (rppCompareInput) {
                            start = currentFullLine.indexOf(SEMI_COLON, end + 1);
                        } else {
                            start = currentFullLine.indexOf("RPP generated cobol");
                            if (start == -1) {
                                start = currentFullLine.indexOf("RPP cobol after generation");
                            }
                        }
                        if (start > 0) {
                            int comma;
                            start = currentFullLine.indexOf(String.valueOf(SEMI_COLON) + "\"", start + 1);
                            String mia = null;
                            String rpp = null;
                            String indexesMia = null;
                            String indexesRpp = null;
                            if (!optimize && end > 0) {
                                start = currentFullLine.indexOf(".bak[");
                                start = start < 0 ? currentFullLine.indexOf("cbl[") + 4 : (start += 5);
                                end = currentFullLine.indexOf("]:");
                                if (start > end) {
                                    start = currentFullLine.indexOf("bms[") + 4;
                                }
                                indexesMia = currentFullLine.substring(start, end);
                                start = end + 2;
                                end = currentFullLine.indexOf("\"" + SEMI_COLON + "\"", start);
                                int tmpEnd = currentFullLine.indexOf("\"\"" + SEMI_COLON + "\"\"", start);
                                if (tmpEnd == end - 1) {
                                    end = currentFullLine.indexOf("\";\"", end + 1);
                                }
                                if (end > 0) {
                                    mia = currentFullLine.substring(start, end);
                                    start = currentFullLine.indexOf("[", end) + 1;
                                    end = currentFullLine.indexOf("]:", start);
                                    indexesRpp = currentFullLine.substring(start, end);
                                    rpp = currentFullLine.substring(end += 2, currentFullLine.length() - 2);
                                } else {
                                    mia = currentFullLine.substring(start + 2);
                                }
                            }
                            if (mia != null && mia.startsWith("\n")) {
                                mia = mia.substring(1);
                            }
                            if (rpp != null && rpp.startsWith("\n")) {
                                rpp = rpp.substring(1);
                            }
                            if (mia != null) {
                                mia = mia.replaceAll("\"\"", "\"");
                            }
                            if (rpp != null) {
                                rpp = rpp.replaceAll("\"\"", "\"");
                            }
                            boolean cropEndOfLine = false;
                            if (cobol.getFilename() != null && cobol.getFilename().toLowerCase().endsWith(".cbl")) {
                                String result = System.getProperty("markAtEndOfLine");
                                cropEndOfLine = result == null || "true".equals(result);
                            }
                            Difference difference = new Difference(cobol, mia, rpp, isProcedure, cropEndOfLine);
                            if (indexesMia != null && !rppCompareInput) {
                                comma = indexesMia.indexOf(44);
                                difference.setStartMia(Integer.parseInt(indexesMia.substring(0, comma)));
                                difference.setEndMia(Integer.parseInt(indexesMia.substring(comma + 1)));
                            }
                            if (indexesRpp != null) {
                                comma = indexesRpp.indexOf(44);
                                difference.setStartRpp(Integer.parseInt(indexesRpp.substring(0, comma)));
                                difference.setEndRpp(Integer.parseInt(indexesRpp.substring(comma + 1)));
                            }
                            if (filterSameMiaRppCode && rpp != null && mia != null && this.samePacbaseCobols(rpp, mia)) {
                                ++this.nbSameDiffs;
                            } else {
                                cobol.getDifferences().add(difference);
                            }
                            this.advanceTask(1);
                        }
                        if (filterSameMiaRppCode && cobol.getDifferences().isEmpty()) {
                            template.getCobols().remove(cobol);
                        }
                    }
                }
                builder = new StringBuilder();
                isNewCobol = false;
            }
            ++currentLine;
            line = null;
            if (!this.isCanceled()) continue;
            return;
        }
        if (!this.cobolsToIgnore.isEmpty()) {
            for (Template template : report.getTemplates()) {
                ArrayList<Cobol> cobolToRemove = new ArrayList<Cobol>();
                for (Cobol cobol : template.getCobols()) {
                    if (this.cobolsToIgnore.contains(cobol.getFilename())) {
                        cobolToRemove.add(cobol);
                        continue;
                    }
                    if (!this.cobolsToIgnore.contains(Cobol.getCobolFileName(cobol.getFilename()))) continue;
                    cobolToRemove.add(cobol);
                }
                template.getCobols().removeAll(cobolToRemove);
            }
        }
        this.countTemplates(report);
        ArrayList<Template> templateToRemove = new ArrayList<Template>();
        for (Template template : report.getTemplates()) {
            if (!template.getCobols().isEmpty()) continue;
            templateToRemove.add(template);
            if (!Report.debug) continue;
            System.out.println("Template with no cobol : " + template.toString());
        }
        report.getTemplates().removeAll(templateToRemove);
        this.countTemplates(report);
        long endTime = System.currentTimeMillis();
        this.endTask();
        if (Report.debug) {
            System.out.println("Decode Diff List done in : " + (endTime - startTime) / 1000L);
        }
    }

    private String[] decodeOverviewLine(String line, boolean searchError) {
        int idx2;
        String tmp;
        String[] result = new String[2];
        int idx = -1;
        if (!searchError && (idx = line.indexOf(DESIGN_PATTERN)) > 0 && (idx = (tmp = line.substring(idx + DESIGN_PATTERN.length())).indexOf(46)) > 0 && (idx = (tmp = tmp.substring(idx + 1)).indexOf(47)) > 0 && (idx2 = tmp.lastIndexOf(46)) > 0) {
            result[0] = tmp.substring(0, idx);
            result[1] = tmp.substring(idx + 1, idx2);
            return result;
        }
        idx = line.indexOf("RPP generated cobol");
        if (idx < 0) {
            idx = line.indexOf("RPP cobol after generation");
        }
        if (idx < 0) {
            String[] items = line.split(String.valueOf(SEMI_COLON));
            if (items.length != 7) {
                return result;
            }
            File file = new File(items[1].replace(".pac", "").replace('\\', '/'));
            if (file.getName().indexOf(46) < 0 || file.getParentFile() == null) {
                return result;
            }
            if (file.getAbsolutePath().contains("Rpp_ReGenerated_Backup") || file.getAbsolutePath().contains(".bak") || file.getAbsolutePath().contains(".before.val")) {
                String projetName = file.getParentFile().getParentFile().getParentFile().getName().replace(".COB", "");
                if ("com.ibm.pdpbase.junit.Rpp_Customer_Base_Test".equals(projetName)) {
                    projetName = file.getParentFile().getParentFile().getName().replace(".COB", "");
                } else if (projetName.contains("Rpp_ReGenerated_Backup")) {
                    projetName = file.getParentFile().getParentFile().getName().replace(".COB", "");
                }
                idx = projetName.indexOf(46);
                if (idx > 0) {
                    projetName = projetName.substring(idx + 1);
                }
                result[0] = projetName;
            } else {
                result[0] = file.getParentFile().getName();
            }
            boolean hasRppFolder = false;
            if ("rpp".equals(result[0])) {
                hasRppFolder = true;
                idx = line.indexOf("rpp");
                String tmp2 = line.substring(0, idx - 1);
                if ((idx = tmp2.lastIndexOf(46)) > 0) {
                    result[0] = tmp2.substring(idx + 1);
                }
            }
            String entityName = file.getName().substring(0, file.getName().indexOf(46));
            idx = entityName.indexOf(95);
            if (!hasRppFolder && idx > 0) {
                entityName = entityName.substring(0, idx);
            }
            result[1] = entityName;
            return result;
        }
        tmp = line.substring(idx);
        idx = tmp.indexOf(34);
        if ((tmp = tmp.substring(idx + 2)).length() < 5) {
            if (searchError) {
                result[0] = line;
            }
            result[1] = BAD_CONSTANT;
            return result;
        }
        tmp = tmp.substring(5);
        result[0] = tmp.substring(0, 3).trim();
        idx = tmp.indexOf(47);
        if (idx == -1) {
            if (searchError) {
                result[0] = line;
            }
            result[1] = BAD_CONSTANT;
            return result;
        }
        if ((tmp = tmp.substring(idx + 6)).length() < 6) {
            if (searchError) {
                result[0] = line;
            }
            result[1] = BAD_CONSTANT;
            return result;
        }
        result[1] = tmp.substring(0, 6).trim();
        try {
            if (searchError) {
                idx = tmp.indexOf("'\"" + SEMI_COLON + "\"'");
                if (idx > 0) {
                    tmp = tmp.substring(idx + ("'\"" + SEMI_COLON + "\"'").length());
                    idx = tmp.indexOf(32);
                    tmp = tmp.substring(idx + 1);
                    String lib = tmp.substring(0, 3).trim();
                    idx = tmp.indexOf(47);
                    tmp = tmp.substring(idx + 6);
                    String code = tmp.substring(0, 6).trim();
                    result[0] = !lib.equals(result[0]) || !code.equals(result[1]) ? line : null;
                } else {
                    result[0] = line;
                }
            }
        }
        catch (Exception exception) {
            result[0] = line;
            result[1] = BAD_CONSTANT;
            return result;
        }
        return result;
    }

    public static List<String> readOptimizedDiffFile(File aFile) throws Exception {
        ArrayList<String> contents = new ArrayList<String>();
        BufferedReader input = new BufferedReader(new FileReader(aFile));
        try {
            String line = null;
            while ((line = input.readLine()) != null) {
                if (line.trim().length() <= 0 || line.length() <= 0 || !Character.isDigit(line.charAt(0))) continue;
                contents.add(String.valueOf(line) + "\"");
            }
        }
        finally {
            input.close();
        }
        return contents;
    }

    private boolean samePacbaseCobols(String referenceCobol, String modifiedCobol) {
        PacbaseCobolDifferencerWithSignificantDots differencer = new PacbaseCobolDifferencerWithSignificantDots(referenceCobol, modifiedCobol);
        return differencer.sameCobols();
    }

    public int getNbIgnoredFiles() {
        return this.cobolsToIgnore == null ? 0 : this.cobolsToIgnore.size();
    }

    public int getNbModifiedFiles() {
        return this.nbModifiedFiles;
    }

    public int getNbTemplates() {
        return this.nbTemplates;
    }

    public int getNbDifferences() {
        return this.nbDifferences;
    }

    public static List<String> readFile(File aFile) throws Exception {
        ArrayList<String> contents = new ArrayList<String>();
        if (!aFile.exists()) {
            return contents;
        }
        BufferedReader input = new BufferedReader(new FileReader(aFile));
        try {
            String line = null;
            while ((line = input.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                contents.add(line);
            }
        }
        finally {
            input.close();
        }
        return contents;
    }

    public static File getPatternFileJava(String patternDirName, String fileName) {
        File file = null;
        String patternFileName = String.valueOf(patternDirName) + "/" + fileName;
        file = new File(patternFileName);
        return file;
    }

    public static File getPlugingFileNameJava(String fileName) {
        String currentDir = System.getProperty("user.dir");
        return new File(String.valueOf(currentDir) + "/../com.ibm.pdp.cobolcompare.tools/" + fileName);
    }

    public void beginTask(String taskName, int total) {
    }

    public void endTask() {
    }

    protected boolean isCanceled() {
        return false;
    }

    public void advanceTask(int n) {
    }

    public static void main(String[] args) {
        String reportFolder = args[0];
        ReportAnalyser reportAnalyser = new ReportAnalyser(reportFolder);
        Report report = new Report();
        try {
            reportAnalyser.analyze(report, false, false, false, true, true, null);
            report.applyPatterns(reportFolder, false, false, false, false, false, null, false, false, true);
            report.exportMetaTemplatesStat(reportFolder);
        }
        catch (Exception exception) {}
    }
}

