/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.telemetry.mqtt.utility.internal.ui;

import com.ibm.mq.telemetry.mqtt.utility.internal.Messages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MessageViewDialog
extends TrayDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.telemetry.mqtt.utility/src/com/ibm/mq/telemetry/mqtt/utility/internal/ui/MessageViewDialog.java";
    private static final int WIDTH_HINT = 350;
    private static final int HEIGHT_HINT_ROWS = 6;
    private String event;
    private String topic;
    private String message;
    private String qos;
    private String retained;
    private String time;
    private Text clientId;

    public MessageViewDialog(Shell shell, String event, String topic, String message, String qos, String retained, String time) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setBlockOnOpen(true);
        this.event = event;
        this.topic = topic;
        this.message = message;
        this.qos = qos;
        this.retained = retained;
        this.time = time;
    }

    public Control createDialogArea(Composite composite) {
        Composite parent = (Composite)super.createDialogArea(composite);
        Group msgGroup = new Group(parent, 0);
        msgGroup.setText(Messages.MessageViewDialog_MessageViewGroup);
        GridData gridData = new GridData(4, 4, true, true);
        msgGroup.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        msgGroup.setLayout((Layout)gridLayout);
        Label eventLabel = new Label((Composite)msgGroup, 0);
        eventLabel.setText(Messages.MessageViewDialog_EventLabel);
        Text eventText = new Text((Composite)msgGroup, 2052);
        eventText.setText(this.event);
        eventText.setEditable(false);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 350;
        eventText.setLayoutData((Object)gridData);
        if (this.topic.length() > 0) {
            Label topicLabel = new Label((Composite)msgGroup, 0);
            topicLabel.setText(Messages.MessageViewDialog_TopicLabel);
            Text topicText = new Text((Composite)msgGroup, 2306);
            topicText.setEditable(false);
            topicText.setText(this.topic);
            gridData = new GridData(4, 0x1000000, true, false);
            gridData.widthHint = 350;
            gridData.heightHint = topicText.getLineHeight();
            topicText.setLayoutData((Object)gridData);
        }
        if (this.message.length() > 0 || this.event.equals(Messages.MQTTClientUtility_PublishedStatus) || this.event.equals(Messages.MQTTClientUtility_ReceivedStatus)) {
            Label messageLabel = new Label((Composite)msgGroup, 0);
            messageLabel.setText(Messages.MessageViewDialog_MessageLabel);
            gridData = new GridData(1, 1, false, false);
            messageLabel.setLayoutData((Object)gridData);
            Text messageText = new Text((Composite)msgGroup, 2818);
            messageText.setEditable(false);
            messageText.setText(this.message);
            gridData = new GridData(4, 4, true, true);
            gridData.heightHint = messageText.getLineHeight() * 6;
            gridData.widthHint = 350;
            messageText.setLayoutData((Object)gridData);
        }
        if (this.qos.length() > 0) {
            Label qosLabel = new Label((Composite)msgGroup, 0);
            qosLabel.setText(Messages.MessageViewDialog_QualityOfServiceLabel);
            Text qosText = new Text((Composite)msgGroup, 2052);
            qosText.setText(this.qos);
            qosText.setEditable(false);
            gridData = new GridData(4, 0x1000000, true, false);
            qosText.setLayoutData((Object)gridData);
        }
        if (this.retained.length() > 0) {
            Label retainedLabel = new Label((Composite)msgGroup, 32);
            retainedLabel.setText(Messages.MessageViewDialog_RetainedLabel);
            Text retainedText = new Text((Composite)msgGroup, 2052);
            retainedText.setText(this.retained);
            retainedText.setEditable(false);
            gridData = new GridData(4, 0x1000000, true, false);
            retainedText.setLayoutData((Object)gridData);
        }
        if (this.time.length() > 0) {
            Label timeLabel = new Label((Composite)msgGroup, 32);
            timeLabel.setText(Messages.MessageViewDialog_TimeLabel);
            Text timeText = new Text((Composite)msgGroup, 2052);
            timeText.setText(this.time);
            timeText.setEditable(false);
            gridData = new GridData(4, 0x1000000, true, false);
            timeText.setLayoutData((Object)gridData);
        }
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        this.okPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.MessageViewDialog_DialogTitle);
    }
}

