/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.telemetry.mqtt.utility.internal.ui;

import com.ibm.mq.telemetry.mqtt.utility.internal.Messages;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ConnectOptionsDialog
extends TrayDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.telemetry.mqtt.utility/src/com/ibm/mq/telemetry/mqtt/utility/internal/ui/ConnectOptionsDialog.java";
    private boolean cleanSession;
    private String willTopic;
    private String willPayload;
    private int willQos;
    private boolean willRetained;
    private Button cleanButton;
    private Text lwatTopic;
    private Text lwatMsg;
    private Combo qosChoice;
    private Button pubRetainedButton;

    public ConnectOptionsDialog(Shell shell, boolean cleanSession, String willTopic, String willPayload, int willQos, boolean willRetained) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setBlockOnOpen(true);
        this.cleanSession = cleanSession;
        this.willTopic = willTopic;
        this.willPayload = willPayload;
        this.willQos = willQos;
        this.willRetained = willRetained;
    }

    public Control createDialogArea(Composite composite) {
        Composite parent = (Composite)super.createDialogArea(composite);
        Group connectGroup = new Group(parent, 0);
        connectGroup.setText(Messages.ConnectOptionsDialog_ConnectionOptionsGroup);
        GridData gridData = new GridData(4, 4, true, true);
        connectGroup.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        connectGroup.setLayout((Layout)gridLayout);
        Text connIntroText = new Text((Composite)connectGroup, 66);
        connIntroText.setEditable(false);
        connIntroText.setText(Messages.ConnectOptionsDialog_IntroText);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        connIntroText.setLayoutData((Object)gridData);
        this.cleanButton = new Button((Composite)connectGroup, 32);
        this.cleanButton.setText(Messages.ConnectOptionsDialog_CleanSessionButton);
        this.cleanButton.setSelection(this.cleanSession);
        gridData = new GridData();
        gridData.horizontalIndent = 5;
        this.cleanButton.setLayoutData((Object)gridData);
        new Label((Composite)connectGroup, 0);
        Group lwatGroup = new Group((Composite)connectGroup, 0);
        lwatGroup.setText(Messages.ConnectOptionsDialog_LastWillGroup);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        lwatGroup.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        lwatGroup.setLayout((Layout)gridLayout);
        Text lwatIntroText = new Text((Composite)lwatGroup, 66);
        lwatIntroText.setEditable(false);
        lwatIntroText.setText(Messages.ConnectOptionsDialog_LastWillIntroText);
        GridData labelGridData = new GridData(4, 1, true, false);
        labelGridData.horizontalSpan = 2;
        labelGridData.widthHint = 10;
        lwatIntroText.setLayoutData((Object)labelGridData);
        new Label((Composite)lwatGroup, 0).setText(Messages.ConnectOptionsDialog_LastWillTopicLabel);
        this.lwatTopic = new Text((Composite)lwatGroup, 2052);
        this.lwatTopic.setText(this.willTopic);
        gridData = new GridData(4, 1, true, false);
        this.lwatTopic.setLayoutData((Object)gridData);
        new Label((Composite)lwatGroup, 0).setText(Messages.ConnectOptionsDialog_LastWillQoSLabel);
        this.qosChoice = new Combo((Composite)lwatGroup, 8);
        gridData = new GridData(4, 1, true, false);
        this.qosChoice.setLayoutData((Object)gridData);
        this.qosChoice.add(Messages.MQTTClientUtility_QoS_0);
        this.qosChoice.add(Messages.MQTTClientUtility_QoS_1);
        this.qosChoice.add(Messages.MQTTClientUtility_QoS_2);
        this.qosChoice.select(this.willQos);
        new Label((Composite)lwatGroup, 0).setText(Messages.ConnectOptionsDialog_LastWillMessageLabel);
        this.lwatMsg = new Text((Composite)lwatGroup, 2050);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 50;
        this.lwatMsg.setLayoutData((Object)gridData);
        this.lwatMsg.setText(this.willPayload);
        this.pubRetainedButton = new Button((Composite)lwatGroup, 32);
        this.pubRetainedButton.setText(Messages.ConnectOptionsDialog_LastWillReatinedButton);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.pubRetainedButton.setLayoutData((Object)gridData);
        this.pubRetainedButton.setSelection(this.willRetained);
        parent.pack();
        labelGridData.widthHint = lwatIntroText.getBounds().width;
        parent.pack();
        return parent;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ConnectOptionsDialog_DialogTitle);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "com.ibm.mq.telemetry.mqtt.utility.Connect_Options");
    }

    protected void okPressed() {
        this.cleanSession = this.cleanButton.getSelection();
        this.willTopic = this.lwatTopic.getText();
        this.willPayload = this.lwatMsg.getText();
        this.willQos = this.qosChoice.getSelectionIndex();
        this.willRetained = this.pubRetainedButton.getSelection();
        super.okPressed();
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public String getWillTopic() {
        return this.willTopic;
    }

    public String getWillPayload() {
        return this.willPayload;
    }

    public int getWillQos() {
        return this.willQos;
    }

    public boolean getWillRetained() {
        return this.willRetained;
    }
}

