/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.telemetry.mqtt.utility.internal.ui;

import com.ibm.mq.telemetry.mqtt.utility.internal.Messages;
import com.ibm.mq.telemetry.mqtt.utility.internal.ui.MQTTClientUtility;
import com.ibm.mq.telemetry.mqtt.utility.internal.ui.MessageViewDialog;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ClientHistorySection {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.telemetry.mqtt.utility/src/com/ibm/mq/telemetry/mqtt/utility/internal/ui/ClientHistorySection.java";
    private int messageColWidth;
    private Button viewButton;
    private Table receivedTable;
    private Button scrollToggle;
    private MQTTClientUtility utility;
    private Color colorDisabled;
    private static final int EVENT_COL = 0;
    private static final int TOPIC_COL = 1;
    private static final int MESSAGE_COL = 2;
    private static final int QOS_COL = 3;
    private static final int RETAIN_COL = 4;
    private static final int TIME_COL = 5;

    public ClientHistorySection(MQTTClientUtility utility) {
        this.utility = utility;
    }

    public void createHistoryGroup(Composite parent) {
        final Group receiveGroup = new Group(parent, 0);
        receiveGroup.setText(Messages.ClientHistorySection_HistoryGroup);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        receiveGroup.setLayoutData((Object)gridData);
        receiveGroup.setLayout((Layout)new GridLayout(1, false));
        this.receivedTable = new Table((Composite)receiveGroup, 67590);
        this.receivedTable.setLinesVisible(true);
        this.receivedTable.setHeaderVisible(true);
        this.utility.registerContextHelp((Control)this.receivedTable, "com.ibm.mq.telemetry.mqtt.utility.Client_History");
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.receivedTable.getItemHeight() * 3 + this.receivedTable.getHeaderHeight();
        this.receivedTable.setLayoutData((Object)gridData);
        String[] status = new String[]{Messages.MQTTClientUtility_ConnectedStatus, Messages.MQTTClientUtility_ConnectFailedStatus, Messages.MQTTClientUtility_ConnectionLostStatus, Messages.MQTTClientUtility_ExceptionStatus, Messages.MQTTClientUtility_ReceivedStatus, Messages.MQTTClientUtility_PublishedStatus, Messages.MQTTClientUtility_PublishFailedStatus, Messages.MQTTClientUtility_SubscribedStatus, Messages.MQTTClientUtility_SubscribeFailedStatus, Messages.MQTTClientUtility_UnsubscribedStatus, Messages.MQTTClientUtility_UnsubscribeFailedStatus};
        String longestStatus = status[0];
        int i = 1;
        while (i < status.length) {
            if (status[i].length() > longestStatus.length()) {
                longestStatus = status[i];
            }
            ++i;
        }
        String timeExample = DateFormat.getInstance().format(new Date());
        String[] titles = new String[]{longestStatus, Messages.ClientHistorySection_TopicColumn, Messages.ClientHistorySection_MessageColumn, Messages.ClientHistorySection_QoSColumn, Messages.ClientHistorySection_RetainedColumn, timeExample};
        int i2 = 0;
        while (i2 < titles.length) {
            TableColumn column = new TableColumn(this.receivedTable, 0);
            column.setText(titles[i2]);
            column.setMoveable(true);
            column.pack();
            ++i2;
        }
        if (SWT.getPlatform().toLowerCase().contains("gtk")) {
            TableColumn extra = new TableColumn(this.receivedTable, 0);
            extra.setText("");
            extra.pack();
        }
        this.receivedTable.getColumn(5).setText(Messages.ClientHistorySection_TimeColumn);
        this.receivedTable.getColumn(0).setText(Messages.ClientHistorySection_EventColumn);
        this.receivedTable.getColumn(3).setToolTipText(Messages.ClientHistorySection_QoS_Full);
        this.receivedTable.getColumn(4).setToolTipText(Messages.ClientHistorySection_Retain_Full);
        this.receivedTable.getColumn(5).setToolTipText(Messages.ClientHistorySection_Time_Full);
        this.messageColWidth = this.receivedTable.getColumn(2).getWidth();
        this.receivedTable.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                int sel = ClientHistorySection.this.receivedTable.getSelectionIndex();
                int ind = -1;
                if (sel != -1) {
                    ScrollBar vb = ClientHistorySection.this.receivedTable.getVerticalBar();
                    if (vb != null) {
                        if (sel >= ClientHistorySection.this.receivedTable.getTopIndex() && sel <= ClientHistorySection.this.receivedTable.getTopIndex() + vb.getThumb()) {
                            ind = sel;
                        }
                    } else {
                        ind = sel;
                    }
                } else if (ClientHistorySection.this.receivedTable.getItems().length > 0) {
                    ind = ClientHistorySection.this.receivedTable.getTopIndex();
                }
                if (ind != -1) {
                    ClientHistorySection.this.receivedTable.setSelection(ind);
                }
            }
        });
        this.receivedTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = (TableItem)e.item;
                String event = item.getText(0);
                if (event.length() > 0) {
                    ClientHistorySection.this.viewButton.setEnabled(true);
                } else {
                    ClientHistorySection.this.viewButton.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TableItem item = (TableItem)e.item;
                String event = item.getText(0);
                if (event.length() > 0) {
                    String topic = item.getText(1);
                    String msg = item.getText(2);
                    String qos = item.getText(3);
                    String retain = item.getText(4);
                    String time = item.getText(5);
                    MessageViewDialog options = new MessageViewDialog(ClientHistorySection.this.utility.getShell(), event, topic, msg, qos, retain, time);
                    options.open();
                }
            }
        });
        receiveGroup.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = receiveGroup.getClientArea();
                Point size = ClientHistorySection.this.receivedTable.computeSize(-1, -1);
                ScrollBar vBar = ClientHistorySection.this.receivedTable.getVerticalBar();
                int width = area.width - ((ClientHistorySection)ClientHistorySection.this).receivedTable.computeTrim((int)0, (int)0, (int)0, (int)0).width - vBar.getSize().x;
                if (size.y > area.height + ClientHistorySection.this.receivedTable.getHeaderHeight()) {
                    Point vBarSize = vBar.getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = ClientHistorySection.this.receivedTable.getSize();
                if (oldSize.x > area.width) {
                    TableColumn[] cols = ClientHistorySection.this.receivedTable.getColumns();
                    int restWidth = cols[0].getWidth() + cols[3].getWidth() + cols[4].getWidth() + cols[5].getWidth();
                    int remaining = width - restWidth;
                    if (remaining >= 2 * ClientHistorySection.this.messageColWidth) {
                        cols[1].setWidth(remaining / 2);
                        cols[2].setWidth(remaining / 2);
                    }
                    ClientHistorySection.this.receivedTable.setSize(area.width, area.height);
                } else {
                    ClientHistorySection.this.receivedTable.setSize(area.width, area.height);
                    TableColumn[] cols = ClientHistorySection.this.receivedTable.getColumns();
                    int restWidth = cols[0].getWidth() + cols[3].getWidth() + cols[4].getWidth() + cols[5].getWidth();
                    int remaining = width - restWidth;
                    if (remaining >= 2 * ClientHistorySection.this.messageColWidth) {
                        cols[1].setWidth(remaining / 2);
                        cols[2].setWidth(remaining / 2);
                    }
                }
            }
        });
        Composite buttonComp = new Composite((Composite)receiveGroup, 0);
        gridData = new GridData(0x1000000, 1, true, false);
        gridData.horizontalSpan = 2;
        buttonComp.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttonComp.setLayout((Layout)gridLayout);
        this.viewButton = new Button(buttonComp, 8);
        this.viewButton.setText(Messages.ClientHistorySection_ViewMessageButton);
        this.viewButton.setEnabled(false);
        this.utility.registerContextHelp((Control)this.viewButton, "com.ibm.mq.telemetry.mqtt.utility.View_Message");
        this.viewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items;
                if (ClientHistorySection.this.receivedTable != null && !ClientHistorySection.this.receivedTable.isDisposed() && (items = ClientHistorySection.this.receivedTable.getSelection()).length > 0) {
                    String event = items[0].getText(0);
                    String topic = items[0].getText(1);
                    String msg = items[0].getText(2);
                    String qos = items[0].getText(3);
                    String retain = items[0].getText(4);
                    String time = items[0].getText(5);
                    MessageViewDialog options = new MessageViewDialog(ClientHistorySection.this.utility.getShell(), event, topic, msg, qos, retain, time);
                    options.open();
                }
            }
        });
        Button clearButton = new Button(buttonComp, 8);
        clearButton.setText(Messages.ClientHistorySection_ClearHistoryButton);
        this.utility.registerContextHelp((Control)clearButton, "com.ibm.mq.telemetry.mqtt.utility.Clear_History");
        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ClientHistorySection.this.receivedTable != null && !ClientHistorySection.this.receivedTable.isDisposed()) {
                    ClientHistorySection.this.receivedTable.removeAll();
                    ClientHistorySection.this.viewButton.setEnabled(false);
                }
            }
        });
        this.scrollToggle = new Button(buttonComp, 32);
        this.scrollToggle.setText(Messages.ClientHistorySection_ScrollLockButton);
        this.utility.registerContextHelp((Control)this.scrollToggle, "com.ibm.mq.telemetry.mqtt.utility.Scroll_Lock");
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (ClientHistorySection.this.colorDisabled != null) {
                    ClientHistorySection.this.colorDisabled.dispose();
                }
            }
        });
    }

    public void addToTable(String event, String message, String topic, String qos, String retained) {
        String time = DateFormat.getInstance().format(new Date());
        TableItem item = new TableItem(this.receivedTable, 0);
        item.setText(0, event);
        item.setText(1, topic);
        item.setText(2, message);
        item.setText(3, qos);
        item.setText(4, retained);
        item.setText(5, time);
        if (this.colorDisabled == null) {
            this.colorDisabled = new Color((Device)this.receivedTable.getDisplay(), 227, 227, 227);
        }
        if (topic.length() == 0) {
            item.setBackground(1, this.colorDisabled);
        }
        if (message.length() == 0 && !event.equals(Messages.MQTTClientUtility_PublishedStatus) && !event.equals(Messages.MQTTClientUtility_ReceivedStatus)) {
            item.setBackground(2, this.colorDisabled);
        }
        if (qos.length() == 0) {
            item.setBackground(3, this.colorDisabled);
        }
        if (retained.length() == 0) {
            item.setBackground(4, this.colorDisabled);
        }
        if (!this.scrollToggle.getSelection()) {
            this.receivedTable.showItem(item);
        }
    }

    public int getTableShrinkHeight() {
        int heightNow = this.receivedTable.getBounds().height;
        int minHeight = this.receivedTable.getHeaderHeight() + this.receivedTable.getItemHeight() + 4;
        return heightNow - minHeight;
    }
}

