/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf.event;

import com.ibm.mq.MQException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.pcf.MQCFBS;
import com.ibm.mq.pcf.MQCFIL;
import com.ibm.mq.pcf.MQCFIN;
import com.ibm.mq.pcf.MQCFST;
import com.ibm.mq.pcf.PCFConstants;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFParameter;
import com.ibm.mq.pcf.event.ContentFilter;
import com.ibm.mq.pcf.event.PCFFilter;
import com.ibm.mq.pcf.event.PCFQueryTemplate;
import com.ibm.mq.pcf.event.Selector;
import java.util.ArrayList;

public class PCFQuery {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.pcf.event/src/com/ibm/mq/pcf/event/PCFQuery.java";
    public static final String ALL_NAMES = "*";
    public static final byte[] ALL_BINARY_NAMES = new byte[0];
    public static final int ALL_TYPES = -1;
    public static final int[] ALL_ATTRS = new int[]{1009};
    final PCFQueryTemplate template;
    final Object[] values;
    final ContentFilter contentFilter;
    final PCFFilter valueFilter;
    private int responseRestartPoint = -1;
    private int maxResponses = -1;
    public static final PCFQueryTemplate INQUIRE_Q_MGR = new PCFQueryTemplate(2, new PCFParameter[]{new MQCFIL(1001, ALL_ATTRS)}, 0, 2015);
    public static final PCFQueryTemplate INQUIRE_Q = new PCFQueryTemplate(13, 2016, 20, 1001, 1002, 1009, 2085);
    public static final PCFQueryTemplate INQUIRE_Q_STATUS = new PCFQueryTemplate(41, new PCFParameter[]{new MQCFST(2016, "*"), new MQCFIN(1103, 1104), new MQCFIL(1026, ALL_ATTRS)}, 4091, 2016, 13);
    public static final PCFQueryTemplate RESET_Q_STATS = new PCFQueryTemplate(17, 2016, 2085);
    public static final PCFQueryTemplate INQUIRE_CHLAUTH_RECS = new PCFQueryTemplate(204, 3501, 1352, 0, 1355, 1009, 2085);
    public static final PCFQueryTemplate INQUIRE_CHANNEL = new PCFQueryTemplate(25, 3501, 1511, 5, 1015, 1009, 4032);
    public static final PCFQueryTemplate INQUIRE_CHANNEL_STATUS = new PCFQueryTemplate(42, new PCFParameter[]{new MQCFST(3501, "*"), new MQCFIN(1523, 1011), new MQCFIL(1524, ALL_ATTRS)}, 3065, 3501, 25);
    public static final PCFQueryTemplate INQUIRE_AUTH_INFO = new PCFQueryTemplate(83, 2045, 2085);
    public static final PCFQueryTemplate INQUIRE_NAMELIST = new PCFQueryTemplate(36, 2010, 2085);
    public static final PCFQueryTemplate INQUIRE_PROCESS = new PCFQueryTemplate(7, 2012, 2085);
    public static final PCFQueryTemplate INQUIRE_CONNECTION = new PCFQueryTemplate(85, new PCFParameter[]{new MQCFBS(7007, ALL_BINARY_NAMES), new MQCFIN(1110, 1112), new MQCFIL(1107, ALL_ATTRS)}, 2085, 7006);
    public static final PCFQueryTemplate INQUIRE_CF_STRUC_STATUS = new PCFQueryTemplate(116, 2039, 1135, 1137, -1, -1, 2085);
    public static final PCFQueryTemplate INQUIRE_LISTENER_STATUS = new PCFQueryTemplate(98, new PCFParameter[]{new MQCFST(3554, "*"), new MQCFIL(1223, ALL_ATTRS)}, 2085);
    public static final PCFQueryTemplate INQUIRE_SERVICE_STATUS = new PCFQueryTemplate(154, new PCFParameter[]{new MQCFST(2077, "*"), new MQCFIL(1225, ALL_ATTRS)}, 2085);
    public static final PCFQueryTemplate INQUIRE_Q_MGR_STATUS = new PCFQueryTemplate(161, new PCFParameter[]{new MQCFIL(1229, ALL_ATTRS)}, 0, 2015);

    private static Object[] getParameterValues(PCFQueryTemplate template, PCFParameter[] parameters) {
        Object[] values = new Object[template.getSelectorCount()];
        int i = 0;
        while (i < parameters.length) {
            PCFParameter p = parameters[i];
            if (p != null) {
                int index = template.getSelectorIndex(p.getParameter());
                try {
                    if (template.getSelector(index).getType() == p.getType()) {
                        values[index] = p.getValue();
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new IllegalArgumentException("Parameter " + i + " does not fit query template" + " (template does not contain parameter id " + p.getParameter() + ")");
                }
            }
            ++i;
        }
        return values;
    }

    private static ContentFilter getContentFilter(PCFQueryTemplate template, Object[] values) {
        int index = template.getAttrsSelectorIndex();
        if (index < 0) {
            return ContentFilter.getNullFilter();
        }
        int[] wildcardAttrs = (int[])template.getSelector(index).getWildcardValue();
        if (wildcardAttrs != null && wildcardAttrs.length == 1) {
            return ContentFilter.getFilter((int[])values[index], wildcardAttrs[0]);
        }
        return ContentFilter.getFilter((int[])values[index], 1009);
    }

    private static PCFFilter getValueFilter(PCFQueryTemplate template, PCFFilter filter) {
        if (filter == null || filter.getParameter() == -1) {
            return PCFFilter.getNullFilter();
        }
        if (filter.getParameter() == template.getNameId()) {
            throw new IllegalArgumentException("Invalid parameter ID for filter: " + filter.getParameter() + " (filter cannot apply to object name)");
        }
        return filter;
    }

    public PCFQuery(PCFQueryTemplate template) {
        this(template, (String)null);
    }

    public PCFQuery(PCFQueryTemplate template, PCFFilter filter) {
        this(template, ALL_NAMES, filter);
    }

    public PCFQuery(PCFQueryTemplate template, String name) {
        this(template, name, PCFFilter.getNullFilter());
    }

    public PCFQuery(PCFQueryTemplate template, byte[] name) {
        this(template, name, PCFFilter.getNullFilter());
    }

    public PCFQuery(PCFQueryTemplate template, String name, PCFFilter filter) {
        this(template, name, -1, null, filter);
    }

    public PCFQuery(PCFQueryTemplate template, byte[] name, PCFFilter filter) {
        this(template, name, -1, null, filter);
    }

    public PCFQuery(PCFQueryTemplate template, int type) {
        this(template, type, PCFFilter.getNullFilter());
    }

    public PCFQuery(PCFQueryTemplate template, int type, PCFFilter filter) {
        this(template, ALL_NAMES, type, null, filter);
    }

    public PCFQuery(PCFQueryTemplate template, int[] attrs) {
        this(template, attrs, PCFFilter.getNullFilter());
    }

    public PCFQuery(PCFQueryTemplate template, int[] attrs, PCFFilter filter) {
        this(template, ALL_NAMES, -1, attrs, filter);
    }

    public PCFQuery(PCFQueryTemplate template, String name, int[] attrs, PCFFilter filter) {
        this(template, name, -1, attrs, filter);
    }

    public PCFQuery(PCFQueryTemplate template, byte[] name, int[] attrs, PCFFilter filter) {
        this(template, name, -1, attrs, filter);
    }

    public PCFQuery(PCFQueryTemplate template, int type, int[] attrs, PCFFilter filter) {
        this(template, ALL_NAMES, type, attrs, filter);
    }

    private PCFQuery(PCFQueryTemplate template, Object name, int type, int[] attrs, PCFFilter filter) {
        Object[] values = new Object[template.getSelectorCount()];
        if (template.getNameSelectorIndex() >= 0) {
            values[template.getNameSelectorIndex()] = name;
        }
        if (template.getTypeSelectorIndex() >= 0 && type != -1) {
            values[template.getTypeSelectorIndex()] = type;
        }
        if (template.getAttrsSelectorIndex() >= 0) {
            values[template.getAttrsSelectorIndex()] = attrs;
        }
        this.template = template;
        this.values = values;
        this.contentFilter = PCFQuery.getContentFilter(template, values);
        this.valueFilter = PCFQuery.getValueFilter(template, filter);
    }

    public PCFQuery(PCFQueryTemplate template, PCFParameter[] parameters, PCFFilter filter) {
        Object[] values = new Object[template.getSelectorCount()];
        int i = 0;
        while (i < parameters.length) {
            PCFParameter p = parameters[i];
            if (p != null) {
                int index = template.getSelectorIndex(p.getParameter());
                try {
                    values[index] = p.getValue();
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new IllegalArgumentException("parameters [" + i + "] does not fit query template" + " (template does not contain parameter id " + p.getParameter() + ")");
                }
            }
            ++i;
        }
        this.template = template;
        this.values = values;
        this.contentFilter = PCFQuery.getContentFilter(template, values);
        this.valueFilter = PCFQuery.getValueFilter(template, filter);
    }

    PCFQuery(PCFQuery originalQuery, int[] newAttrs) {
        this.template = originalQuery.template;
        this.values = originalQuery.values;
        this.contentFilter = newAttrs == null ? ContentFilter.getNullFilter() : ContentFilter.getFilter(newAttrs);
        this.valueFilter = originalQuery.valueFilter;
    }

    PCFQuery(PCFQuery originalQuery, PCFQuery mergeAttrs) {
        this(originalQuery, mergeAttrs.getAttrs());
    }

    public static void traceMQRequest(Trace t, PCFMessage pcfmsg) {
        String commandName = String.valueOf(PCFConstants.lookup((int)pcfmsg.getCommand(), (String)"MQCMD_.*")) + "(" + pcfmsg.getCommand() + ")";
        String generalDetail = "Request command=" + commandName;
        if (Trace.isTracing) {
            t.data(65, "PCFQuery.traceMQRequest", 900, generalDetail);
            t.data(65, "PCFQuery.traceMQRequest", 900, pcfmsg.toString());
        }
    }

    public static void traceMQException(Trace t, MQException mqe) {
        PCFException pcfe = null;
        if (mqe instanceof PCFException) {
            pcfe = (PCFException)((Object)mqe);
        } else if (mqe.exceptionSource instanceof PCFException) {
            pcfe = (PCFException)((Object)mqe.exceptionSource);
        }
        if (pcfe != null && pcfe.exceptionSource instanceof PCFMessage[]) {
            PCFMessage[] msgs = (PCFMessage[])pcfe.exceptionSource;
            String commandName = String.valueOf(PCFConstants.lookup((int)msgs[0].getCommand(), (String)"MQCMD_.*")) + "(" + msgs[0].getCommand() + ")";
            String reasonName = String.valueOf(PCFConstants.lookupReasonCode((int)mqe.reasonCode)) + "(" + mqe.reasonCode + ")";
            String generalDetail = "Response to command=" + commandName + ",reason=" + reasonName + ",exception source msgs=" + msgs.length;
            if (Trace.isTracing) {
                t.data(65, "PCFQuery.traceMQException", 900, generalDetail);
            }
            int i = 0;
            while (i < msgs.length) {
                String msgDetail = "exception source msg[" + i + "]\n" + msgs[i].toString() + "\n";
                try {
                    int value = msgs[i].getIntParameterValue(1012);
                    msgDetail = String.valueOf(msgDetail) + "\tReferenced Paramater ID = " + PCFConstants.lookupParameter((int)value) + "(" + value + ")\n";
                }
                catch (Exception exception) {}
                if (Trace.isTracing) {
                    t.data(65, "PCFQuery.traceMQException", 900, msgDetail);
                }
                ++i;
            }
        }
    }

    public PCFQueryTemplate getTemplate() {
        return this.template;
    }

    public int getCommand() {
        return this.template.getCommand();
    }

    public String getName() {
        Object value = this.resolveValue(this.template.getNameSelectorIndex());
        if (value == null) {
            return null;
        }
        return value instanceof byte[] ? MQCFBS.asHexString((byte[])((byte[])value)) : value.toString();
    }

    public int getType() {
        Object value = this.resolveValue(this.template.getTypeSelectorIndex());
        if (value == null) {
            return -1;
        }
        return (Integer)value;
    }

    public int[] getAttrs() {
        return this.contentFilter == ContentFilter.nullContentFilter ? ALL_ATTRS : this.contentFilter.getParameters();
    }

    ContentFilter getContentFilter() {
        return this.contentFilter;
    }

    Object getValue(int index) {
        return this.values[index];
    }

    Object resolveValue(int index) {
        if (index < 0) {
            return null;
        }
        if (this.values[index] != null) {
            return this.values[index];
        }
        return this.template.getSelector(index).getWildcardValue();
    }

    public PCFFilter getFilter() {
        return this.valueFilter;
    }

    final PCFMessage[] filter(PCFMessage[] responses) throws PCFException {
        ArrayList<PCFMessage> list = new ArrayList<PCFMessage>();
        int i = 0;
        while (i < responses.length) {
            PCFMessage response = responses[i];
            if (response != null && this.matchesObject(response)) {
                list.add(response);
            }
            ++i;
        }
        return list.toArray(new PCFMessage[list.size()]);
    }

    final boolean matches(PCFMessage response, boolean filter) throws PCFException {
        return response != null && this.matchesObject(response) && (!filter || this.valueFilter.matches(response));
    }

    final boolean matchesObject(PCFMessage response) throws PCFException {
        boolean match = response != null;
        int i = 0;
        while (i < this.values.length && match) {
            Object value = this.values[i];
            Selector selector = this.template.getSelector(i);
            if (value != null && selector.getRole() == 1) {
                match = selector.matches(response, value);
            }
            ++i;
        }
        return match;
    }

    final boolean matchesContentChange(PCFMessage response, PCFMessage previous) {
        return response != null && previous != null && !this.contentFilter.matches(response, previous);
    }

    public PCFMessage createPCFRequest(boolean includeFilter) {
        PCFMessage request = new PCFMessage(this.template.getCommand());
        int count = this.template.getSelectorCount();
        int i = 0;
        while (i < count) {
            this.template.getSelector(i).write(request, this.values[i]);
            ++i;
        }
        if (includeFilter) {
            this.getFilter().write(request);
        }
        if (this.responseRestartPoint > 0) {
            request.addParameter((PCFParameter)new MQCFIN(231, this.responseRestartPoint));
        }
        if (this.maxResponses > 0) {
            request.addParameter((PCFParameter)new MQCFIN(230, this.maxResponses));
        }
        return request;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append("\n   - command: " + this.template.getCommand());
        sb.append("\n   - values: {");
        int i = 0;
        while (i < this.values.length) {
            sb.append(this.values[i]);
            sb.append(", ");
            ++i;
        }
        if (this.values.length > 0) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        sb.append("\n   - content filter: " + this.contentFilter);
        sb.append("\n   - value filter: " + this.valueFilter);
        return new String(sb);
    }

    public int getResponseRestartPoint() {
        return this.responseRestartPoint;
    }

    public void setResponseRestartPoint(int responseRestartPoint) {
        this.responseRestartPoint = responseRestartPoint;
    }

    public int getMaxResponses() {
        return this.maxResponses;
    }

    public void setMaxResponses(int maxResponses) {
        this.maxResponses = maxResponses;
    }

    @Deprecated
    public static interface Template {
        public static final int NULL_ID = -1;

        public int getCommand();

        public int getNameId();

        public int getTypeId();

        public int getTypeWildcard();

        public int getAttrsId();

        public int getAttrsWildcard();

        public int getIgnoreReasonCode();

        public void setIgnoreReasonCode(int var1);

        @Deprecated
        public boolean getSuppressName();

        public boolean isBinaryName();

        public int getResponseNameId();

        public void setResponseNameId(int var1);

        public Object getKey(PCFMessage var1);

        public String getObjectName(PCFMessage var1);

        public int getParentObjectType();

        public void setParentObjectType(int var1);
    }
}

