/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf.event;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.UiDisplayData;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFMessageAgent;
import com.ibm.mq.pcf.event.ErrorListener;
import com.ibm.mq.pcf.event.ListenerAdapter;
import com.ibm.mq.pcf.event.ListenerManager;
import com.ibm.mq.pcf.event.PCFEvent;
import com.ibm.mq.pcf.event.PCFListener;
import com.ibm.mq.pcf.event.PCFQuery;
import com.ibm.mq.pcf.event.PCFQueryTemplate;
import com.ibm.mq.pcf.event.PCFStatusEvent;
import com.ibm.mq.pcf.event.PCFSummaryEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PCFMonitorAgent
extends PCFMessageAgent {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.pcf.event/src/com/ibm/mq/pcf/event/PCFMonitorAgent.java";
    final Hashtable<PCFQueryTemplate, ListenerManager> listenerTable = new Hashtable();
    final Vector<ErrorListener> errorListeners = new Vector();
    RefreshListener refreshListener;
    String qmgrName;
    String hostname;
    int port;
    String channel;
    String targetQueue;
    String targetQmanager;
    int pollInterval = 30000;
    boolean sendSummaryEvents;
    protected MonitorThread monitorThread;
    protected boolean external;
    protected boolean reconnecting;
    protected boolean closing = false;
    private boolean accessCommandServerQueueError = false;
    private static final String ERROR_MESSAGE = "*** Warning *** PCF/INQ command running on UI thread";

    public PCFMonitorAgent(Trace t) {
    }

    public PCFMonitorAgent(Trace t, MQQueueManager qmgr) throws MQException {
        super(qmgr);
    }

    public PCFMonitorAgent(Trace t, String qmgrName) throws MQException {
        super(qmgrName);
    }

    public PCFMonitorAgent(Trace t, String host, int port, String channel) throws MQException {
        super(host, port, channel);
    }

    protected synchronized void open(Trace t, MQQueueManager qmgr, String queue, String qm, boolean ext) throws MQException {
        this.qmgrName = qmgr.getName();
        this.hostname = MQEnvironment.hostname;
        this.port = MQEnvironment.port;
        this.channel = MQEnvironment.channel;
        this.targetQueue = queue;
        this.targetQmanager = qm;
        this.external = ext;
        super.open(this.qmanager, this.targetQueue, this.targetQmanager, this.external);
    }

    public void addPCFListener(Trace t, PCFListener listener, PCFQuery query) {
        this.addPCFListener(t, listener, query, 7);
    }

    public void addPCFListener(Trace t, final PCFListener listener, PCFQuery query, final int types) {
        if (query.template.getParentObjectType() == -1) {
            this.getListenerManager(t, query.getTemplate()).addListener(t, new ListenerAdapter(listener, query){

                @Override
                protected void entryAdded(PCFMessage message, Object key, int childIndex, boolean last, long timestamp) throws Exception {
                    if ((types & 1) == 1) {
                        PCFEvent event = new PCFEvent(this, 1, message, this.query.getTemplate().getObjectName(message), last, timestamp);
                        event.setKey(key);
                        listener.handleEvent(event);
                    }
                }

                @Override
                protected void entryRemoved(PCFMessage message, Object key, int childIndex, boolean last, long timestamp) throws Exception {
                    if ((types & 2) == 2) {
                        PCFEvent event = new PCFEvent(this, 2, message, this.query.getTemplate().getObjectName(message), last, timestamp);
                        event.setKey(key);
                        listener.handleEvent(event);
                    }
                }

                @Override
                protected void entryChanged(PCFMessage message, Object key, int childIndex, boolean last, long timestamp) throws Exception {
                    if ((types & 4) == 4) {
                        PCFEvent event = new PCFEvent(this, 4, message, this.query.getTemplate().getObjectName(message), last, timestamp);
                        event.setKey(key);
                        listener.handleEvent(event);
                    }
                }

                @Override
                protected void summary(int command, int count, boolean last, long timestamp) throws Exception {
                    listener.handleEvent(new PCFSummaryEvent((Object)this, command, count, last, timestamp));
                }
            });
        } else {
            this.getListenerManager(t, query.getTemplate()).addListener(t, new ListenerAdapter(listener, query){

                @Override
                protected void entryAdded(PCFMessage message, Object key, int childIndex, boolean last, long timestamp) throws Exception {
                    if ((types & 1) == 1) {
                        PCFStatusEvent event = new PCFStatusEvent(this, 1, message, this.query.getTemplate().getObjectName(message), last, timestamp, childIndex);
                        event.setKey(key);
                        listener.handleEvent(event);
                    }
                }

                @Override
                protected void entryRemoved(PCFMessage message, Object key, int childIndex, boolean last, long timestamp) throws Exception {
                    if ((types & 2) == 2) {
                        PCFStatusEvent event = new PCFStatusEvent(this, 2, message, this.query.getTemplate().getObjectName(message), last, timestamp, childIndex);
                        event.setKey(key);
                        listener.handleEvent(event);
                    }
                }

                @Override
                protected void entryChanged(PCFMessage message, Object key, int childIndex, boolean last, long timestamp) throws Exception {
                    if ((types & 4) == 4) {
                        PCFStatusEvent event = new PCFStatusEvent(this, 4, message, this.query.getTemplate().getObjectName(message), last, timestamp, childIndex);
                        event.setKey(key);
                        listener.handleEvent(event);
                    }
                }

                @Override
                protected void summary(int command, int count, boolean last, long timestamp) throws Exception {
                    listener.handleEvent(new PCFSummaryEvent((Object)this, command, count, last, timestamp));
                }
            });
        }
    }

    public PCFMessage[] snapshot(Trace t, PCFQuery query, boolean update) throws IOException, MQException, PCFException {
        this.isCommandServerRunning(t);
        return this.getListenerManager(t, query.getTemplate()).snapshot(t, query, update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorListener(Trace t, ErrorListener listener) {
        Vector<ErrorListener> vector = this.errorListeners;
        synchronized (vector) {
            if (listener != null && !this.errorListeners.contains(listener)) {
                this.errorListeners.addElement(listener);
            }
        }
    }

    public void removeErrorListener(Trace t, ErrorListener listener) {
        this.errorListeners.removeElement(listener);
    }

    private void notifyErrorListeners(Trace t, MQException mqe) {
        block3: {
            try {
                ErrorListener[] listeners = this.getErrorListeners(t);
                int i = 0;
                while (i < listeners.length) {
                    listeners[i].onError(mqe);
                    ++i;
                }
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block3;
                t.data(65, "PCFMonitorAgent.notifyErrorListeners", 900, "Uncaught exception in error notification:" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ErrorListener[] getErrorListeners(Trace t) {
        Object[] array;
        Vector<ErrorListener> vector = this.errorListeners;
        synchronized (vector) {
            array = new ErrorListener[this.errorListeners.size()];
            this.errorListeners.copyInto(array);
        }
        return array;
    }

    public void removeListener(Trace t, Object listener) {
        Enumeration<ListenerManager> e = this.getListenerManagers(t);
        while (e.hasMoreElements()) {
            e.nextElement().removeListener(listener, null);
        }
    }

    public void removeListener(Trace t, PCFListener listener, PCFQuery query) {
        if (query == null) {
            this.removeListener(t, listener);
        } else {
            ListenerManager manager = this.getListenerManager(t, query.getTemplate(), false);
            if (manager != null) {
                manager.removeListener(listener, query);
            }
        }
    }

    void removeListener(Trace t, Object listener, PCFQueryTemplate template) {
        ListenerManager manager = this.getListenerManager(t, template, false);
        if (manager != null) {
            manager.removeListener(listener, null);
        }
    }

    public synchronized void start(Trace t) {
        if (this.monitorThread == null) {
            this.closing = false;
            this.monitorThread = new MonitorThread();
            this.monitorThread.start();
            this.monitorThread.setName("PCFMonitorAgent starting for " + this.qmgrName);
        }
    }

    public synchronized void start(Trace t, String name) {
        if (this.monitorThread == null) {
            this.closing = false;
            this.monitorThread = new MonitorThread();
            this.monitorThread.start();
            this.monitorThread.setName(name);
        }
    }

    public synchronized void stop(Trace t) {
        this.closing = true;
        if (this.monitorThread != null) {
            this.monitorThread.interrupt();
        }
        this.monitorThread = null;
    }

    public synchronized void disconnect(Trace t) throws MQException {
        if (!this.reconnecting) {
            this.stop(t);
        }
        super.disconnect();
    }

    protected synchronized void reconnect(Trace t) throws MQException {
        if (!this.external) {
            try {
                this.reconnecting = true;
                MQEnvironment.hostname = this.hostname;
                MQEnvironment.port = this.port;
                MQEnvironment.channel = this.channel;
                super.open(new MQQueueManager(this.qmgrName), this.targetQueue, this.targetQmanager, false);
            }
            finally {
                this.reconnecting = false;
            }
        }
    }

    public void refresh(Trace t) {
        this.refresh(t, false);
    }

    protected synchronized void refresh(Trace t, boolean async) {
        RefreshListener rl;
        Enumeration<ListenerManager> e = this.getListenerManagers(t);
        int sent = 0;
        if (async && (rl = this.refreshListener) != null) {
            rl.refreshStarted();
        }
        while (e.hasMoreElements()) {
            ListenerManager manager = e.nextElement();
            try {
                try {
                    this.isCommandServerRunning(t);
                    sent += manager.send(t);
                }
                catch (MQException mqe) {
                    if (Trace.isTracing) {
                        t.data(65, "PCFMonitorAgent.refresh", 300, "MQException reason code = " + mqe.reasonCode);
                    }
                    this.stop(t);
                    throw mqe;
                }
            }
            catch (MQException mqe) {
                this.notifyErrorListeners(t, mqe);
            }
            catch (IOException iOException) {
                this.notifyErrorListeners(t, new MQException(2, 2195, (Object)this));
            }
        }
        if (Trace.isTracing) {
            t.data(65, "PCFMonitorAgent.refresh", 300, "Sent count = " + sent);
        }
        if (sent == 0) {
            this.refreshPing(t);
        }
        if (async && (rl = this.refreshListener) != null) {
            rl.refreshComplete();
        }
    }

    public void refresh(Trace t, PCFListener listener) {
        this.refresh(t, listener, false);
    }

    protected synchronized void refresh(Trace t, PCFListener listener, boolean async) {
        RefreshListener rl;
        Enumeration<ListenerManager> e = this.getListenerManagers(t);
        int sent = 0;
        if (async && (rl = this.refreshListener) != null) {
            rl.refreshStarted();
        }
        while (e.hasMoreElements()) {
            ListenerManager manager = e.nextElement();
            ListenerAdapter[] adapters = manager.getListenerAdapters();
            int i = 0;
            while (i < adapters.length) {
                if (adapters[i].getListener() == listener) {
                    try {
                        try {
                            this.isCommandServerRunning(t);
                            sent = manager.send(t, adapters[i]);
                        }
                        catch (MQException mqe) {
                            if (Trace.isTracing) {
                                t.data(65, "PCFMonitorAgent.refresh", 300, "MQException reason code = " + mqe.reasonCode);
                            }
                            this.stop(t);
                            throw mqe;
                        }
                    }
                    catch (MQException mqe) {
                        this.notifyErrorListeners(t, mqe);
                    }
                    catch (IOException iOException) {
                        this.notifyErrorListeners(t, new MQException(2, 2195, (Object)this));
                    }
                }
                ++i;
            }
        }
        if (Trace.isTracing) {
            t.data(65, "PCFMonitorAgent.refresh", 300, "Sent count = " + sent);
        }
        if (sent == 0) {
            this.refreshPing(t);
        }
        if (async && (rl = this.refreshListener) != null) {
            rl.refreshComplete();
        }
    }

    protected void refreshPing(Trace t) {
        try {
            PCFMessage request = new PCFMessage(2);
            try {
                this.isCommandServerRunning(t);
                super.send(request);
            }
            catch (MQException mqe) {
                if (Trace.isTracing) {
                    t.data(65, "PCFMonitorAgent.refreshPing", 300, "MQException reason code = " + mqe.reasonCode);
                }
                this.stop(t);
                throw mqe;
            }
        }
        catch (MQException mqe) {
            this.notifyErrorListeners(t, mqe);
        }
        catch (IOException iOException) {
            this.notifyErrorListeners(t, new MQException(2, 2195, (Object)this));
        }
    }

    public void refreshAsync(Trace t) {
        final Trace t1 = t;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                PCFMonitorAgent.this.refresh(t1, true);
            }
        });
        thread.setName("PCFMonitorAgent refreshing");
        thread.start();
    }

    public void refreshAsync(Trace t, final PCFListener listener) {
        final Trace t1 = t;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                PCFMonitorAgent.this.refresh(t1, listener, true);
            }
        });
        thread.setName("PCFMonitorAgent refreshing for " + listener.toString());
        thread.start();
    }

    public void setPollInterval(Trace t, int seconds) {
        if (seconds >= 0) {
            this.pollInterval = seconds * 1000;
        }
        if (Trace.isTracing) {
            t.data(65, "PCFMonitorAgent.setPollInterval", 300, "Poll interval = " + this.pollInterval + " for " + this.qmgrName);
        }
        if (this.monitorThread != null && this.monitorThread.isAlive()) {
            if (Trace.isTracing) {
                t.data(65, "PCFMonitorAgent.setPollInterval", 300, "Interrupting monitor thread for " + this.qmgrName);
            }
            this.monitorThread.interrupt(false);
        }
    }

    public boolean isRunning(Trace t) {
        MonitorThread thread = this.monitorThread;
        return thread != null && thread.isAlive();
    }

    public void setRefreshListener(Trace t, RefreshListener listener) {
        this.refreshListener = listener;
    }

    public PCFMessage[] update(Trace t, PCFMessage request) throws PCFException, MQException, IOException {
        this.isCommandServerRunning(t);
        PCFMessage[] responses = super.send(request);
        this.refresh(t);
        return responses;
    }

    final Enumeration<ListenerManager> getListenerManagers(Trace t) {
        return this.listenerTable.elements();
    }

    final ListenerManager getListenerManager(Trace t, PCFQueryTemplate template) {
        return this.getListenerManager(t, template, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ListenerManager getListenerManager(Trace t, PCFQueryTemplate template, boolean create) {
        Hashtable<PCFQueryTemplate, ListenerManager> hashtable = this.listenerTable;
        synchronized (hashtable) {
            ListenerManager manager = this.listenerTable.get(template);
            if (manager == null && create) {
                manager = new ListenerManager(this, template);
                this.listenerTable.put(template, manager);
            }
            return manager;
        }
    }

    public boolean getSendSummaryEvents() {
        return this.sendSummaryEvents;
    }

    public void setSendSummaryEvents(boolean value) {
        this.sendSummaryEvents = value;
    }

    public void isCommandServerRunning(Trace t) throws MQException {
        boolean running;
        block6: {
            running = true;
            if (Thread.currentThread().getId() == UiDisplayData.getUiThreadId() && Trace.isTracing) {
                t.data(65, "PCFMonitorAgent.isCommandServerRunning", 900, ERROR_MESSAGE);
                t.data(65, "PCFMonitorAgent.isCommandServerRunning", 900, t.getJavaStack());
            }
            try {
                if (this.adminQueue != null && !this.accessCommandServerQueueError && this.adminQueue.getOpenInputCount() < 1) {
                    running = false;
                }
            }
            catch (MQException e) {
                if (e.getReason() == 2035) {
                    this.accessCommandServerQueueError = true;
                }
                if (!Trace.isTracing) break block6;
                t.data(65, "PCFMonitorAgent.isCommandServerRunning", 300, e.getMessage());
            }
        }
        if (!running) {
            throw new MQException(2, 2322, (Object)this);
        }
    }

    class MonitorThread
    extends Thread {
        private boolean isInterruptWaiting = false;
        private boolean isInterruptible = false;

        MonitorThread() {
        }

        @Override
        public void run() {
            while (!PCFMonitorAgent.this.closing) {
                try {
                    this.isInterruptible = false;
                    RefreshListener rl = PCFMonitorAgent.this.refreshListener;
                    if (rl != null) {
                        rl.refreshStarted();
                    }
                    PCFMonitorAgent.this.refresh(Trace.getDefault());
                    rl = PCFMonitorAgent.this.refreshListener;
                    if (rl != null) {
                        rl.refreshComplete();
                    }
                    this.isInterruptible = true;
                    if (this.isInterruptWaiting) {
                        this.interrupt();
                    }
                    Thread.sleep(PCFMonitorAgent.this.pollInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        @Override
        public void interrupt() {
            this.interrupt(true);
        }

        public void interrupt(boolean deferOnFail) {
            if (this.isInterruptible) {
                super.interrupt();
                this.isInterruptWaiting = false;
            } else {
                this.isInterruptWaiting = this.isInterruptWaiting || deferOnFail;
            }
        }
    }

    public static interface RefreshListener {
        public void refreshStarted();

        public void refreshComplete();
    }
}

