/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf.event;

import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import java.io.Serializable;
import java.util.EventObject;

public class PCFEvent
extends EventObject
implements Serializable {
    public static final int EVENT_SUMMARY = 0;
    public static final int OBJECT_ADDED = 1;
    public static final int OBJECT_REMOVED = 2;
    public static final int OBJECT_CHANGED = 4;
    final PCFMessage message;
    final String objectName;
    final int command;
    final int type;
    final boolean last;
    final long timestamp;
    private Object key;

    public PCFEvent(Object source, int type, PCFMessage message, String objectName, boolean last) throws PCFException {
        this(source, type, message, objectName, last, System.currentTimeMillis());
    }

    public PCFEvent(Object source, int type, PCFMessage message, String objectName, boolean last, long timestamp) throws PCFException {
        super(source);
        this.type = type;
        this.message = message;
        this.objectName = objectName;
        this.command = message.getCommand();
        this.last = last;
        this.timestamp = timestamp;
    }

    protected PCFEvent(Object source, int type, int command, boolean last, long timestamp) {
        super(source);
        this.type = type;
        this.message = null;
        this.objectName = null;
        this.command = command;
        this.last = last;
        this.timestamp = timestamp;
    }

    public PCFMessage getPCFMessage() {
        return this.message;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public int getCommand() {
        return this.command;
    }

    public int getType() {
        return this.type;
    }

    public boolean isLast() {
        return this.last;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    void setKey(Object key) {
        this.key = key;
    }

    public Object getKey() {
        return this.key;
    }

    public Object getParameterValue(int parameter) {
        return this.message.getParameterValue(parameter);
    }

    public int getIntParameterValue(int parameter) throws PCFException {
        return this.message.getIntParameterValue(parameter);
    }

    public String getStringParameterValue(int parameter) throws PCFException {
        return this.message.getStringParameterValue(parameter);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + " (" + this.objectName + "):\n" + this.message;
    }
}

