/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf.event;

import com.ibm.mq.headers.internal.HexString;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.event.OffsetListIterator;
import com.ibm.mq.pcf.event.PCFQuery;
import com.ibm.mq.pcf.event.ResponseTableEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class CompoundResponseTableEntry
extends ResponseTableEntry {
    private final List responses = new ArrayList();
    private int index = 0;

    public CompoundResponseTableEntry(PCFMessage response, Object key, long timestamp, int responseNameId, boolean binary) {
        this.response = new PCFMessage(response.getCommand());
        this.key = key;
        if (binary) {
            String s = HexString.hexString((byte[])((byte[])response.getParameterValue(responseNameId)));
            this.response.addParameter(responseNameId, s);
        } else {
            this.response.addParameter(responseNameId, (String)response.getParameterValue(responseNameId));
        }
        this.timestamp = timestamp;
        this.responses.add(response);
    }

    @Override
    public boolean isUpdate(long timestamp) {
        if (timestamp != this.timestamp) {
            this.timestamp = timestamp;
            this.index = 0;
        }
        return this.index >= this.responses.size() - 1;
    }

    @Override
    public boolean isDeleted(long timestamp, PCFQuery query, boolean filteredAtServer) throws PCFException {
        if (timestamp != this.timestamp && (query == null || query.matches(this.response, filteredAtServer))) {
            this.index = 0;
            return true;
        }
        return this.index < this.responses.size();
    }

    @Override
    public void next() {
        if (this.index < this.responses.size()) {
            ++this.index;
        }
    }

    @Override
    public boolean matches(PCFMessage response) {
        return this.index < this.responses.size() && this.matches(response, (PCFMessage)this.responses.get(this.index));
    }

    @Override
    public PCFMessage getPrev(PCFMessage response) {
        if (this.index < this.responses.size()) {
            PCFMessage prev = (PCFMessage)this.responses.get(this.index);
            if (this.matches(response, prev)) {
                return response;
            }
            return prev;
        }
        return null;
    }

    @Override
    public void set(PCFMessage response) {
        if (this.index < this.responses.size()) {
            this.responses.set(this.index, response);
        } else {
            this.responses.add(response);
        }
    }

    public void set(PCFMessage response, long timestamp) {
        this.responses.add(response);
    }

    @Override
    public int getChildIndex() {
        return this.index;
    }

    @Override
    public Iterator iterator() {
        return new OffsetListIterator(this.responses, this.index < this.responses.size() ? this.index : 0);
    }

    @Override
    public void clearDeleted() {
        if (this.index > 0) {
            while (this.responses.size() > this.index) {
                this.responses.remove(this.index);
            }
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + " [" + this.responses.size() + " responses" + ", index: " + this.index + ", timestamp: " + this.timestamp + "]";
    }
}

