/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.utils;

import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.NativeCalls;
import java.io.File;

public final class QueryValue {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.commonservices/src/java/com/ibm/mq/commonservices/internal/utils/QueryValue.java";
    public static final int XCSQUERYVALUE = 0;
    public static final int XCSQUERYVALUEFORSUBPOOL = 1;
    public static final int XCSMQVERSION = 1;
    public static final int XCSBUILDLEVEL = 2;
    public static final int XCSBUILDTYPE = 3;
    public static final int XCSCODETITLE = 4;
    public static final int XCSEXECLIB = 11;
    public static final int XCSDLL_LIB = 13;
    public static final int XCSINSTALL_PATH = 14;
    public static final int XCSJAVA_LIB = 20;
    public static final int XCSECLIPSE_LIB = 21;
    public static final int XCSJAVA_BIN = 27;
    public static final int XCSGENERAL_DATA_PATH = 29;
    public static final int XCSUSERID = 1;
    public static final int XCSPID = 2;
    public static final int XCSACCOUNTING_CODE = 5;
    public static final int XCSDATALIB = 6;
    public static final int XCSPID_STRING = 11;
    public static final int XCSSECURITY_ID = 15;
    public static final int XCSCREATORPID = 16;
    public static final int XCSQMGR_LIB = 17;
    public static final int XCSERROR_PATH = 19;
    public static final int XCSINSTALL_NAME = 42;
    public static final int XCSPRODUCTTITLE = 52;
    public static final int XCSOS_UNREGISTERED = 62;
    public static final int XCSPRA_SUPPORTED_VERSION = 1;
    public static final String LONG_APPLIANCE_NAME = "IBM MQ Appliance";
    private static final String EXITS_DIR = "exits";

    public static String queryInstallDir(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 0, 14);
    }

    public static String queryJavaLib(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 0, 20);
    }

    public static String queryGeneralDataLib(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 0, 29);
    }

    public static String queryCMVCLevel(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 0, 2);
    }

    public static String queryJavaBin(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 0, 27);
    }

    public static String queryEclipseDir(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 0, 21);
    }

    public static String queryDllDir(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 0, 13);
    }

    public static String queryExecDir(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 0, 11);
    }

    public static int queryVersion(Trace t) throws CommonServicesException {
        String value = null;
        int version = 0;
        try {
            value = QueryValue.parseVersion(t, NativeCalls.queryValue(t, 0, 1));
            version = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            if (Trace.isTracing) {
                t.data(64, "QueryValue.queryVersion", 900, "Error converting version : " + value);
            }
        }
        catch (CommonServicesException e) {
            throw e;
        }
        return version;
    }

    public static String queryVersionAsString(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 0, 1);
    }

    public static String queryBuildType(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 0, 3);
    }

    public static String parseVersion(Trace t, String value) {
        StringBuffer sb = new StringBuffer();
        char c = value.charAt(0);
        if (Character.isDigit(c)) {
            sb.append(c);
        }
        if (Character.isDigit(c = value.charAt(2))) {
            sb.append(c);
        }
        if (Character.isDigit(c = value.charAt(4))) {
            sb.append(c);
        }
        if (sb.length() != 3) {
            return "";
        }
        return sb.toString();
    }

    public static String queryExitsDir(Trace t) throws CommonServicesException {
        return String.valueOf(QueryValue.queryGeneralDataLib(t)) + File.separator + EXITS_DIR + File.separator;
    }

    public static String queryInstallName(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 0, 42);
    }

    public static boolean isMQAppliance(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 0, 52).equals(LONG_APPLIANCE_NAME);
    }

    public static boolean isOSUnregistered(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 0, 62).equals("true");
    }

    private QueryValue() {
    }
}

