/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.trace;

import com.ibm.mq.commonservices.Common;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.RASProperties;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;

public class FFST {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.commonservices/src/java/com/ibm/mq/commonservices/internal/trace/FFST.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    private static final int LINE_LENGTH = 76;
    private RASProperties properties = null;
    private int componentID = 0;
    private int functionID = 0;
    private int probeID = 0;
    private int reasonCode = 0;
    private int insert1 = 0;
    private int insert2 = 0;
    private String insert3 = "";
    private String insert4 = "";
    private String insert5 = "";
    private OutputStreamWriter fileStreamWriter = null;
    private PrintWriter consoleWriter = null;
    private int[] traceHistory = null;
    private int nextTraceHistory = 0;
    public int currentCompId = -1;
    public String[] currentNames = null;

    public FFST(Trace t, RASProperties props, int[] history, int next) {
        this.properties = props;
        this.traceHistory = history;
        this.nextTraceHistory = next;
        if (this.properties.isTracingToFile() && this.properties.isFFDCPathnameValid()) {
            try {
                this.fileStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.properties.getFFDCFilename(), true), "UTF8");
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (this.properties.isTracingToConsole()) {
            try {
                this.consoleWriter = new PrintWriter(new OutputStreamWriter((OutputStream)System.err, "UTF8"));
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
        }
    }

    public synchronized void writeFFST(Trace t, int compID, int funID, int pID, int rc, int ins1, int ins2, String ins3, String ins4, String ins5) {
        this.componentID = compID;
        this.functionID = funID;
        this.probeID = pID;
        this.reasonCode = rc;
        this.insert1 = ins1;
        this.insert2 = ins2;
        this.insert3 = ins3;
        this.insert4 = ins4;
        this.insert5 = ins5;
        if (this.fileStreamWriter != null || this.consoleWriter != null) {
            this.generateHeader(t);
            this.generateStack(t);
            this.generateHistory(t);
            if (this.fileStreamWriter != null) {
                try {
                    this.fileStreamWriter.flush();
                    this.fileStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
            if (this.consoleWriter != null) {
                this.consoleWriter.flush();
            }
        }
    }

    private void generateHeader(Trace t) {
        this.write(t, this.formatString("-", 76, "+", "-"));
        this.write(t, this.formatString(" ", 76, "|", " "));
        this.write(t, this.formatString("IBM MQ First Failure Sympton Report", 76, "|", " "));
        this.write(t, this.formatString("=========================================", 76, "|", " "));
        this.write(t, this.formatString(" ", 76, "|", " "));
        this.write(t, this.formatString("Date/Time       :- " + new Date(), 76, "|", " "));
        this.write(t, this.formatString("Host name       :- localhost", 76, "|", " "));
        this.write(t, this.formatString("Vendor          :- IBM", 76, "|", " "));
        this.write(t, this.formatString("Probe id        :- " + this.probeID, 76, "|", " "));
        this.write(t, this.formatString("Component id    :- " + this.componentID, 76, "|", " "));
        this.write(t, this.formatString("Function id     :- " + this.functionID, 76, "|", " "));
        this.write(t, this.formatString("Reason code     :- " + this.reasonCode, 76, "|", " "));
        if (this.insert1 != 0) {
            this.write(t, this.formatString("Arith1          :- " + this.insert1, 76, "|", " "));
        }
        if (this.insert2 != 0) {
            this.write(t, this.formatString("Arith2          :- " + this.insert2, 76, "|", " "));
        }
        if (this.insert3 != null && !this.insert3.equals("")) {
            this.write(t, this.formatString("Comment1        :- " + this.insert3, 76, "|", " "));
        }
        if (this.insert4 != null && !this.insert4.equals("")) {
            this.write(t, this.formatString("Comment2        :- " + this.insert4, 76, "|", " "));
        }
        if (this.insert5 != null && !this.insert5.equals("")) {
            this.write(t, this.formatString("Comment3        :- " + this.insert5, 76, "|", " "));
        }
        this.write(t, this.formatString(" ", 76, "|", " "));
        this.write(t, this.formatString("-", 76, "+", "-"));
    }

    private void generateStack(Trace t) {
        this.write(t, "");
        this.write(t, "Java function stack");
        this.write(t, t.getJavaStack());
    }

    private void generateHistory(Trace t) {
        this.write(t, "");
        this.write(t, "Java trace history");
        int indent = 1;
        int i = this.nextTraceHistory;
        while (i < 250) {
            switch (this.traceHistory[i]) {
                case 0: {
                    if (this.traceHistory[i + 1] == 0) break;
                    this.write(t, String.valueOf(this.formatString("-", ++indent, "-")) + "{ " + this.getFullName(this.traceHistory[i + 1], this.traceHistory[i + 2]));
                    break;
                }
                case 1: {
                    if (this.traceHistory[i + 1] == 0) break;
                    this.write(t, String.valueOf(this.formatString("-", indent, "-")) + "} " + this.getFullName(this.traceHistory[i + 1], this.traceHistory[i + 2]) + " rc=" + this.traceHistory[i + 3]);
                    --indent;
                }
            }
            i += 4;
        }
        i = 0;
        while (i < this.nextTraceHistory) {
            switch (this.traceHistory[i]) {
                case 0: {
                    if (this.traceHistory[i + 1] == 0) break;
                    this.write(t, String.valueOf(this.formatString("-", ++indent, "-")) + "{ " + this.getFullName(this.traceHistory[i + 1], this.traceHistory[i + 2]));
                    break;
                }
                case 1: {
                    if (this.traceHistory[i + 1] == 0) break;
                    this.write(t, String.valueOf(this.formatString("-", indent, "-")) + "} " + this.getFullName(this.traceHistory[i + 1], this.traceHistory[i + 2]) + " rc=" + this.traceHistory[i + 3]);
                    --indent;
                }
            }
            i += 4;
        }
    }

    private void write(Trace t, String s) {
        if (this.properties.isTracingToFile()) {
            try {
                this.fileStreamWriter.write(String.valueOf(s) + Common.LINE_SEPARATOR);
            }
            catch (IOException iOException) {}
        }
        if (this.properties.isTracingToConsole()) {
            this.consoleWriter.println(s);
        }
    }

    private String formatString(String s, int length, String delimeter, String pad) {
        StringBuffer sb = new StringBuffer(s);
        int actualLength = s.length();
        if (actualLength > length) {
            return String.valueOf(delimeter) + pad + s.substring(actualLength - length) + pad + delimeter;
        }
        int j = actualLength;
        while (j < length) {
            sb.append(pad);
            ++j;
        }
        return String.valueOf(delimeter) + pad + sb.toString() + pad + delimeter;
    }

    private String formatString(String s, int length, String pad) {
        int len = length;
        StringBuffer sb = new StringBuffer(s);
        int actualLength = s.length();
        if (len < 1) {
            len = actualLength;
        }
        if (actualLength > len) {
            return s.substring(actualLength - len);
        }
        int j = actualLength;
        while (j < len) {
            sb.append(pad);
            ++j;
        }
        return sb.toString();
    }

    private String getFullName(int compId, int funId) {
        if (this.currentCompId != compId) {
            this.currentNames = CommonServices.getListOfNames(compId);
            if (this.currentNames == null) {
                HashMap<String, Integer> hm = CommonServices.getHashMapOfNames(compId);
                if (hm != null) {
                    this.currentNames = new String[hm.size()];
                    Set<String> k = hm.keySet();
                    for (String name : k) {
                        Integer ii = hm.get(name);
                        this.currentNames[ii.intValue()] = name;
                    }
                } else {
                    return "***Unknown class/method name (" + compId + "/" + funId + ") ***";
                }
            }
            this.currentCompId = compId;
        }
        String name = null;
        try {
            name = this.currentNames[funId];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "***Unknown class/method name (" + compId + "/" + funId + ") ***";
        }
        catch (NullPointerException nullPointerException) {
            return "***Unknown class/method name (" + compId + "/" + funId + ") ***";
        }
        return name;
    }
}

