/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.trace;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class EventTraceFormatter
extends Formatter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.commonservices/src/java/com/ibm/mq/commonservices/internal/trace/EventTraceFormatter.java";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final String LINE_SEPARATOR;

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        LINE_SEPARATOR = System.getProperty("line.separator");
    }

    @Override
    public String format(LogRecord record) {
        StringBuffer buffer = new StringBuffer();
        buffer = buffer.append(String.valueOf(DATE_FORMAT.format(new Date(record.getMillis()))) + " ");
        buffer = buffer.append(" " + this.formatThreadId(record.getThreadID()) + "  ");
        switch (record.getLevel().intValue()) {
            case 500: {
                buffer = buffer.append("  >> " + record.getMessage() + LINE_SEPARATOR);
                break;
            }
            case 400: {
                buffer = buffer.append("  -> " + record.getMessage() + LINE_SEPARATOR);
                break;
            }
            case 300: {
                buffer = buffer.append("  << " + record.getMessage() + LINE_SEPARATOR);
                break;
            }
            case 800: {
                buffer = buffer.append("  >- " + record.getMessage() + LINE_SEPARATOR);
            }
        }
        return buffer.toString();
    }

    private String formatThreadId(int i) {
        String threadId = String.valueOf(i);
        switch (threadId.length()) {
            case 1: {
                return "   " + threadId;
            }
            case 2: {
                return "  " + threadId;
            }
            case 3: {
                return " " + threadId;
            }
        }
        return threadId;
    }
}

