/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.console;

import com.ibm.mq.commonservices.internal.trace.Trace;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ConsoleCommandParser {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.commonservices/src/java/com/ibm/mq/commonservices/internal/console/ConsoleCommandParser.java";
    private static final String PARAMETER_DELIMETER = " ";
    private static final String STRING_DELIMETER = "\"";
    private String stringDelimeter = "\"";
    private String[] parsedCommand = null;

    public ConsoleCommandParser(Trace t, String input) {
        this(t, input, STRING_DELIMETER);
    }

    public ConsoleCommandParser(Trace t, String input, String strDelim) {
        this.stringDelimeter = strDelim;
        this.parsedCommand = this.parseCommand(t, input);
    }

    private String[] parseCommand(Trace t, String cmd) {
        String[] ret = null;
        ArrayList<String> a = new ArrayList<String>(10);
        String key = null;
        StringTokenizer st2 = new StringTokenizer(cmd, PARAMETER_DELIMETER, false);
        while (st2.hasMoreTokens()) {
            key = st2.nextToken();
            if (key.startsWith(this.stringDelimeter)) {
                if (!(key = key.substring(1)).endsWith(this.stringDelimeter)) {
                    while (st2.hasMoreTokens()) {
                        String s = st2.nextToken();
                        key = String.valueOf(key) + PARAMETER_DELIMETER + s;
                        if (!s.endsWith(this.stringDelimeter)) continue;
                        key = key.substring(0, key.length() - 1);
                        break;
                    }
                } else {
                    key = key.substring(0, key.length() - 1);
                }
            }
            a.add(key);
        }
        ret = new String[a.size()];
        a.toArray(ret);
        return ret;
    }

    public String[] getParsedCommand() {
        return this.parsedCommand;
    }
}

