/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.console;

import com.ibm.mq.commonservices.Common;
import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.console.ConsoleCommandParser;
import com.ibm.mq.commonservices.internal.console.ConsoleStderrReader;
import com.ibm.mq.commonservices.internal.console.ConsoleStdinWriter;
import com.ibm.mq.commonservices.internal.console.ConsoleStdoutReader;
import com.ibm.mq.commonservices.internal.console.IConsoleCommandListener;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.QueryValue;
import java.io.IOException;
import java.util.ArrayList;

public class ConsoleCommand
extends Thread {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.commonservices/src/java/com/ibm/mq/commonservices/internal/console/ConsoleCommand.java";
    private String[] input;
    private Process process;
    private String command;
    private IConsoleCommandListener listener;
    private Object listenerId;
    private ArrayList<Integer> expectedExitValues;
    private String[] environmentVars;

    public ConsoleCommand(Trace t, Object id, IConsoleCommandListener ccl, String cmd) {
        String installDir;
        block9: {
            this.input = null;
            this.process = null;
            this.command = null;
            this.listener = null;
            this.listenerId = null;
            this.expectedExitValues = new ArrayList();
            this.environmentVars = null;
            this.command = cmd;
            this.listener = ccl;
            this.listenerId = id;
            installDir = null;
            try {
                installDir = QueryValue.queryInstallDir(t);
            }
            catch (CommonServicesException e) {
                if (!Trace.isTracing) break block9;
                t.data(64, "ConsoleCommand.ConsoleCommand", e.toString());
            }
        }
        switch (CommonServices.PLATFORM_ID) {
            case 1: {
                if (installDir == null || installDir.length() <= 0) break;
                String baseCmd = this.command;
                String args = "";
                int ind = this.command.indexOf(32);
                if (ind > 0 && ind < this.command.length() - 1) {
                    baseCmd = this.command.substring(0, ind);
                    args = this.command.substring(ind + 1);
                }
                this.command = "\"" + installDir + "\\bin\\" + baseCmd + "\" " + args;
                break;
            }
            case 3: 
            case 5: {
                if (installDir != null && installDir.length() > 0) {
                    this.command = String.valueOf(installDir) + "/bin/" + this.command;
                    break;
                }
                this.command = "/usr/bin/" + this.command;
                break;
            }
        }
        this.setDaemon(true);
        if (Trace.isTracing) {
            t.data(64, "ConsoleCommand.ConsoleCommand", 300, "Command : " + this.command);
        }
    }

    public ConsoleCommand(Trace t, Object id, IConsoleCommandListener ccl, String cmd, String[] env) {
        this(t, id, ccl, cmd);
        this.environmentVars = env;
    }

    public ConsoleCommand(Trace t, Object id, IConsoleCommandListener ccl, String cmd, String[] env, String[] args) {
        this(t, id, ccl, cmd);
        this.environmentVars = env;
        this.input = args;
    }

    @Override
    public void run() {
        Trace t;
        int exitValue;
        block5: {
            exitValue = 0;
            t = Trace.getDefault();
            this.setName("WMQ console command " + this.command);
            try {
                if (this.listener != null) {
                    this.listener.stdout(t, this.listenerId, this.command);
                }
                ConsoleCommandParser ccp = new ConsoleCommandParser(t, this.command);
                String[] cmdLine = ccp.getParsedCommand();
                this.process = this.environmentVars != null ? Runtime.getRuntime().exec(cmdLine, this.environmentVars) : Runtime.getRuntime().exec(cmdLine);
                ConsoleStdoutReader outputReaderThread = new ConsoleStdoutReader(this);
                outputReaderThread.start();
                ConsoleStderrReader errorReaderThread = new ConsoleStderrReader(this);
                errorReaderThread.start();
                ConsoleStdinWriter inputWriterThread = new ConsoleStdinWriter(this, this.input);
                inputWriterThread.start();
                exitValue = this.process.waitFor();
                Thread.yield();
                outputReaderThread.interrupt();
                errorReaderThread.interrupt();
                inputWriterThread.interrupt();
            }
            catch (IOException e) {
                t.FFST(64, "ConsoleCommand.run", 0, 0, "IO exception occurred executing command : " + this.command + Common.LINE_SEPARATOR + e.toString());
            }
            catch (InterruptedException e) {
                if (!Trace.isTracing) break block5;
                t.data(64, "ConsoleCommand.run", e.toString());
            }
        }
        if (this.listener != null) {
            this.listener.finish(t, this.listenerId, exitValue);
        }
    }

    public boolean addExitValue(int value) {
        return this.expectedExitValues.add(value);
    }

    public void cancel(Trace t) {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public IConsoleCommandListener getListener() {
        return this.listener;
    }

    public Object getListenerId() {
        return this.listenerId;
    }

    public String getCommand() {
        return this.command;
    }

    protected Process getProcess() {
        return this.process;
    }
}

