/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf.event;

import com.ibm.mq.pcf.MQCFST;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFParameter;
import com.ibm.mq.pcf.event.Selector;

public class StringSelector
extends Selector {
    final String wildcardValue;

    public StringSelector(int id) {
        this(id, "*");
    }

    public StringSelector(int id, String defaultValue) {
        super(id);
        this.wildcardValue = defaultValue;
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public boolean matches(PCFMessage response, Object value) throws PCFException {
        Object actual = response.getParameterValue(this.id);
        if (actual != null) {
            actual = ((String)actual).trim();
        }
        if (value == null) {
            return this.wildcardValue == null || this.isSubset(actual, this.wildcardValue.trim());
        }
        return actual == null || this.isSubset(actual, ((String)value).trim());
    }

    @Override
    public boolean isSubset(Object a, Object b) {
        return b == null || b.equals("*") || this.generalize(a, b).equals(b);
    }

    @Override
    public Object generalize(Object a, Object b) {
        return this.generalize((String)a, (String)b);
    }

    public String generalize(String a, String b) {
        if (a == null || a.equals("*")) {
            return "*";
        }
        if (b == null || b.equals("*")) {
            return "*";
        }
        if (a.equals(b)) {
            return a;
        }
        return this.getCommonWildcard(a, b);
    }

    private String getCommonWildcard(String a, String b) {
        int pos = 0;
        int limit = Math.min(a.length(), b.length());
        while (pos < limit && a.charAt(pos) == b.charAt(pos)) {
            ++pos;
        }
        if (pos == 0) {
            return "*";
        }
        if (a.charAt(pos - 1) == '*') {
            return a.substring(0, pos + 1);
        }
        return String.valueOf(a.substring(0, pos)) + '*';
    }

    @Override
    public void write(PCFMessage request, Object value) {
        if (value != null) {
            request.addParameter((PCFParameter)new MQCFST(this.id, (String)value));
        } else if (this.wildcardValue != null) {
            request.addParameter((PCFParameter)new MQCFST(this.id, this.wildcardValue));
        }
    }

    @Override
    public Object getWildcardValue() {
        return this.wildcardValue;
    }
}

