/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf.event;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.pcf.MQCFIN;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFParameter;
import com.ibm.mq.pcf.event.AttrsSelector;
import com.ibm.mq.pcf.event.BytesSelector;
import com.ibm.mq.pcf.event.IntegerSelector;
import com.ibm.mq.pcf.event.ProfileNameSelector;
import com.ibm.mq.pcf.event.StringSelector;

abstract class Selector {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.pcf.event/src/com/ibm/mq/pcf/event/Selector.java";
    public static final int IDENTITY = 1;
    public static final int ATTRS = 2;
    protected final int id;

    static Selector createSelector(Trace t, PCFParameter parameter) {
        switch (parameter.getType()) {
            case 3: {
                return new IntegerSelector(parameter.getParameter(), ((MQCFIN)parameter).value);
            }
            case 4: {
                return parameter.getParameter() == 3067 ? new ProfileNameSelector(parameter.getParameter(), (String)parameter.getValue()) : new StringSelector(parameter.getParameter(), (String)parameter.getValue());
            }
            case 9: {
                return new BytesSelector(parameter.getParameter(), (byte[])parameter.getValue());
            }
            case 5: {
                return new AttrsSelector(parameter.getParameter(), ((int[])parameter.getValue())[0]);
            }
        }
        throw new IllegalArgumentException("Unsupported PCFParameter type " + parameter.getType() + " for selector");
    }

    protected Selector(int id) {
        this.id = id;
    }

    public boolean isRequired() {
        return this.getWildcardValue() != null;
    }

    public int getId() {
        return this.id;
    }

    public int getRole() {
        return 1;
    }

    public abstract int getType();

    public abstract boolean matches(PCFMessage var1, Object var2) throws PCFException;

    public abstract Object getWildcardValue();

    public abstract boolean isSubset(Object var1, Object var2);

    public abstract Object generalize(Object var1, Object var2);

    public abstract void write(PCFMessage var1, Object var2);

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " [" + this.id + "=" + this.getWildcardValue() + ", type=" + this.getRole() + "]";
    }
}

