/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf.event;

import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.event.ContentFilter;
import com.ibm.mq.pcf.event.PCFFilter;
import com.ibm.mq.pcf.event.PCFQuery;
import com.ibm.mq.pcf.event.ResponseTableEntry;
import java.util.Iterator;

abstract class ListenerAdapter {
    final Object listenerObject;
    final PCFQuery query;

    protected ListenerAdapter(Object listener, PCFQuery query) {
        this.listenerObject = listener;
        this.query = query;
    }

    public Object getListener() {
        return this.listenerObject;
    }

    public ContentFilter getContentFilter() {
        return this.query.getContentFilter();
    }

    public PCFQuery getQuery() {
        return this.query;
    }

    final void fireEvents(PCFMessage[] current, PCFMessage[] previous, ResponseTableEntry[] deleted, Object[] keys, int[] indexes, long timestamp, boolean filteredAtServer, boolean summary) {
        if (!summary) {
            this.fireEvents(current, previous, deleted, keys, indexes, timestamp, filteredAtServer);
        } else {
            PCFFilter filter = filteredAtServer ? PCFFilter.getNullFilter() : this.query.valueFilter;
            int count = 0;
            int i = 0;
            while (i < deleted.length) {
                if (deleted[i] != null) {
                    Iterator it = deleted[i].iterator();
                    int j = deleted[i].getChildIndex();
                    while (it.hasNext()) {
                        PCFMessage prev = (PCFMessage)it.next();
                        try {
                            if (!this.query.matches(prev, !filteredAtServer)) continue;
                            this.fireEvent(prev, deleted[i].getKey(), true, false, j++, timestamp, false);
                            ++count;
                        }
                        catch (Exception e) {
                            System.err.println("Exception caught in event processing: ");
                            e.printStackTrace();
                        }
                    }
                }
                ++i;
            }
            i = 0;
            while (i < current.length) {
                PCFMessage curr = current[i];
                PCFMessage prev = previous[i];
                try {
                    if (this.query.matchesObject(curr)) {
                        boolean p;
                        boolean c = curr != null && filter.matches(curr);
                        boolean bl = p = prev != null && filter.matches(prev);
                        if (this.query.matchesContentChange(curr, prev)) {
                            PCFMessage m = c ? curr : prev;
                            this.fireEvent(m, keys[i], p, c, indexes[i], timestamp, false);
                            ++count;
                        } else if (prev == null && c) {
                            this.fireEvent(curr, keys[i], false, true, indexes[i], timestamp, false);
                            ++count;
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception caught in event processing: ");
                    e.printStackTrace();
                }
                ++i;
            }
            try {
                this.summary(this.query.getCommand(), count, true, timestamp);
            }
            catch (Exception e) {
                System.err.println("Exception caught in event processing: ");
                e.printStackTrace();
            }
        }
    }

    final void fireEvents(PCFMessage[] current, PCFMessage[] previous, ResponseTableEntry[] deleted, Object[] keys, int[] indexes, long timestamp, boolean filteredAtServer) {
        PCFFilter filter = filteredAtServer ? PCFFilter.getNullFilter() : this.query.valueFilter;
        PCFMessage last = null;
        boolean lastC = false;
        boolean lastP = false;
        Object lastKey = null;
        int lastIndex = 0;
        int i = 0;
        while (i < deleted.length) {
            if (deleted[i] != null) {
                Iterator it = deleted[i].iterator();
                int j = deleted[i].getChildIndex();
                while (it.hasNext()) {
                    PCFMessage prev = (PCFMessage)it.next();
                    try {
                        if (!this.query.matches(prev, !filteredAtServer)) continue;
                        if (last == null) {
                            last = prev;
                            lastP = true;
                            lastKey = deleted[i].getKey();
                            lastIndex = j++;
                            continue;
                        }
                        this.fireEvent(prev, deleted[i].getKey(), true, false, j++, timestamp, false);
                    }
                    catch (Exception e) {
                        System.err.println("Exception caught in event processing: ");
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < current.length) {
            PCFMessage curr = current[i];
            PCFMessage prev = previous[i];
            try {
                if (this.query.matchesObject(curr)) {
                    boolean p;
                    boolean c = curr != null && filter.matches(curr);
                    boolean bl = p = prev != null && filter.matches(prev);
                    if (this.query.matchesContentChange(curr, prev)) {
                        PCFMessage m;
                        PCFMessage pCFMessage = m = c ? curr : prev;
                        if (last == null) {
                            last = m;
                            lastC = c;
                            lastP = p;
                            lastKey = keys[i];
                            lastIndex = indexes[i];
                        } else {
                            this.fireEvent(m, keys[i], p, c, indexes[i], timestamp, false);
                        }
                    } else if (prev == null && c) {
                        if (last == null) {
                            last = curr;
                            lastC = true;
                            lastKey = keys[i];
                            lastIndex = indexes[i];
                        } else {
                            this.fireEvent(curr, keys[i], false, true, indexes[i], timestamp, false);
                        }
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Exception caught in event processing: ");
                e.printStackTrace();
            }
            ++i;
        }
        if (last != null) {
            this.fireEvent(last, lastKey, lastP, lastC, lastIndex, timestamp, true);
        }
    }

    private final void fireDeleted() {
    }

    private final void fireEvent(PCFMessage message, Object key, boolean p, boolean c, int childIndex, long timestamp, boolean isLast) {
        try {
            if (p && c) {
                this.entryChanged(message, key, childIndex, isLast, timestamp);
            } else if (c) {
                this.entryAdded(message, key, childIndex, isLast, timestamp);
            } else if (p) {
                this.entryRemoved(message, key, childIndex, isLast, timestamp);
            }
        }
        catch (Exception e) {
            System.err.println("Exception caught in event processing: ");
            e.printStackTrace();
        }
    }

    protected void entryAdded(PCFMessage message, Object key, int childId, boolean last, long timestamp) throws Exception {
    }

    protected void entryRemoved(PCFMessage message, Object key, int childId, boolean last, long timestamp) throws Exception {
    }

    protected void entryChanged(PCFMessage message, Object key, int childId, boolean last, long timestamp) throws Exception {
    }

    protected void summary(int command, int count, boolean last, long timestamp) throws Exception {
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " [" + this.listenerObject + ", " + this.query + ']';
    }
}

