/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf.event;

import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFParameter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;

abstract class ContentFilter
implements Serializable {
    public static final ContentFilter nullContentFilter = new ContentFilter(){

        @Override
        public PCFMessage filter(PCFMessage message) {
            return message;
        }

        @Override
        public boolean matches(PCFMessage a, PCFMessage b) {
            return false;
        }

        @Override
        public int[] getParameters() {
            return new int[0];
        }

        @Override
        public int[] merge(int[] otherParameters) {
            return otherParameters;
        }

        public String toString() {
            return "nullContentFilter";
        }
    };

    ContentFilter() {
    }

    public static int[] merge(int[] a, int b) {
        if (ContentFilter.matches(a, b)) {
            return a;
        }
        int[] merged = new int[a.length + 1];
        merged[0] = b;
        System.arraycopy(a, 0, merged, 1, a.length);
        return merged;
    }

    public static int[] merge(int[] a, int[] b) {
        Integer o;
        if (Arrays.equals(a, b)) {
            return a;
        }
        Hashtable<Integer, Integer> ht = new Hashtable<Integer, Integer>();
        int i = 0;
        while (i < a.length) {
            o = a[i];
            ht.put(o, o);
            ++i;
        }
        i = 0;
        while (i < b.length) {
            o = b[i];
            ht.put(o, o);
            ++i;
        }
        Enumeration e = ht.elements();
        int[] merged = new int[ht.size()];
        int i2 = 0;
        while (i2 < merged.length) {
            merged[i2] = (Integer)e.nextElement();
            ++i2;
        }
        return merged;
    }

    public static boolean matches(int[] a, int b) {
        boolean match = false;
        int i = 0;
        while (!match && i < a.length) {
            match = a[i] == b;
            ++i;
        }
        return match;
    }

    public static boolean matches(PCFMessage a, PCFMessage b, int[] attrs) {
        if (a == null || b == null) {
            return false;
        }
        boolean match = true;
        int i = attrs.length;
        while (match && i-- > 0) {
            Object v1 = a.getParameterValue(attrs[i]);
            Object v2 = b.getParameterValue(attrs[i]);
            boolean bl = match = v1 != null && v1.equals(v2) || v1 == null && v2 == null;
        }
        return match;
    }

    public static ContentFilter getFilter(int[] parameters, int wildcard) {
        if (parameters == null || parameters.length == 1 && parameters[0] == wildcard) {
            return ContentFilter.getNullFilter();
        }
        return ContentFilter.getFilter(parameters);
    }

    public static ContentFilter getFilter(final int[] parameters) {
        if (parameters == null) {
            return ContentFilter.getNullFilter();
        }
        return new ContentFilter(){

            @Override
            public PCFMessage filter(PCFMessage message) {
                PCFMessage newMessage = new PCFMessage(message.getCommand());
                Enumeration e = message.getParameters();
                while (e.hasMoreElements()) {
                    PCFParameter p = (PCFParameter)e.nextElement();
                    if (!this.matches(p.getParameter())) continue;
                    newMessage.addParameter(p);
                }
                return newMessage;
            }

            @Override
            public boolean matches(PCFMessage a, PCFMessage b) {
                return 2.matches(a, b, parameters);
            }

            @Override
            public int[] getParameters() {
                return (int[])parameters.clone();
            }

            @Override
            public int[] merge(int[] otherParameters) {
                return 2.merge(parameters, otherParameters);
            }

            private boolean matches(int parameter) {
                int i = parameters.length;
                boolean match = false;
                while (!match && i-- > 0) {
                    boolean bl = match = parameter == parameters[i];
                }
                return match;
            }

            public String toString() {
                StringBuffer sb = new StringBuffer(this.getClass().getName());
                sb.append(" {");
                int i = 0;
                while (i < parameters.length) {
                    sb.append(parameters[i]);
                    sb.append(", ");
                    ++i;
                }
                if (parameters.length > 0) {
                    sb.setLength(sb.length() - 2);
                }
                sb.append("}");
                return new String(sb);
            }
        };
    }

    public static ContentFilter getNullFilter() {
        return nullContentFilter;
    }

    public abstract PCFMessage filter(PCFMessage var1);

    public abstract boolean matches(PCFMessage var1, PCFMessage var2);

    public abstract int[] getParameters();

    public abstract int[] merge(int[] var1);
}

