/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.utils;

import com.ibm.mq.commonservices.Common;
import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.NativeCalls;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class QueueManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.commonservices/src/java/com/ibm/mq/commonservices/internal/utils/QueueManager.java";
    private static final String XCSPRA_DELIMIT_0 = "\n";
    private static final String XCSPRA_DELIMIT_1 = "\u000b";
    private static final String QUEUE_MANAGER_STANZA = "QueueManager";
    private static final String QUEUE_MANAGER_STANZA_KEY = "Name";
    public static final String INSTALLATION_NAME_STANZA_KEY = "InstallationName";
    private static final String DEFAULT_QUEUE_MANAGER_STANZA = "DefaultQueueManager";
    public static final String PREFIX_STANZA_KEY = "Prefix";
    public static final String DIRECTORY_STANZA_KEY = "Directory";
    public static final String DATAPATH_STANZA_KEY = "DataPath";
    public static final String EPHEMPREFIX_STANZA_KEY = "EphemeralPrefix";

    private QueueManager() {
        System.out.println("*** You should not be using this constructor ***");
    }

    public static ArrayList<String> getListOfQueueManagers(Trace t) throws CommonServicesException {
        return QueueManager.getListOfQueueManagers(t, true, false);
    }

    public static ArrayList<String> getListOfQueueManagers(Trace t, boolean includeStandy, boolean thisInstallation) throws CommonServicesException {
        ArrayList<String> queueManagers;
        block5: {
            queueManagers = new ArrayList<String>();
            try {
                String installationName = CommonServices.getInstallationName(t);
                String response = NativeCalls.getAttrs(t, null, QUEUE_MANAGER_STANZA);
                String queueManagerName = QueueManager.parseStanzaAttributes(t, QUEUE_MANAGER_STANZA, QUEUE_MANAGER_STANZA_KEY, response);
                if (queueManagerName != null) {
                    QueueManager.addQueueManagerToList(t, queueManagerName, includeStandy, thisInstallation, installationName, queueManagers);
                }
                while (queueManagerName != null) {
                    String response1 = NativeCalls.getRepeatingAttrs(t, null, QUEUE_MANAGER_STANZA, QUEUE_MANAGER_STANZA_KEY, queueManagerName);
                    if ((queueManagerName = QueueManager.parseStanzaAttributes(t, QUEUE_MANAGER_STANZA, QUEUE_MANAGER_STANZA_KEY, response1)) == null) continue;
                    QueueManager.addQueueManagerToList(t, queueManagerName, includeStandy, thisInstallation, installationName, queueManagers);
                }
            }
            catch (CommonServicesException e) {
                if (e.getReasonCode() == 268460388) break block5;
                if (Trace.isTracing) {
                    t.data(64, "QueueManager.getListOfQueueManagers", 900, "Error geting list of queue manangers" + Common.LINE_SEPARATOR + e);
                }
                throw e;
            }
        }
        return queueManagers;
    }

    private static void addQueueManagerToList(Trace t, String queueManagerName, boolean includeStandy, boolean thisInstallation, String installationName, ArrayList<String> queueManagerList) {
        if (thisInstallation) {
            String queueMangerInstllationName = QueueManager.getQueueManagerKey(t, queueManagerName, INSTALLATION_NAME_STANZA_KEY);
            if (installationName != null && installationName.equals(queueMangerInstllationName)) {
                if (!includeStandy) {
                    if (!QueueManager.isStandby(t, queueManagerName)) {
                        queueManagerList.add(queueManagerName);
                    }
                } else {
                    queueManagerList.add(queueManagerName);
                }
            }
        } else if (!includeStandy) {
            if (!QueueManager.isStandby(t, queueManagerName)) {
                queueManagerList.add(queueManagerName);
            }
        } else {
            queueManagerList.add(queueManagerName);
        }
    }

    private static boolean isStandby(Trace t, String qm) {
        boolean standby = false;
        int i = NativeCalls.getQueueManagerStatus(t, qm);
        switch (i) {
            case 13: 
            case 14: {
                standby = true;
            }
        }
        return standby;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getQueueManagerKey(Trace t, String qm, String key) {
        String prefix = null;
        try {
            String response1;
            String response = NativeCalls.getAttrs(t, null, QUEUE_MANAGER_STANZA);
            String repeatingValue = QueueManager.parseStanzaAttributes(t, QUEUE_MANAGER_STANZA, QUEUE_MANAGER_STANZA_KEY, response);
            if (repeatingValue != null && repeatingValue.equals(qm)) {
                String pr = QueueManager.parseStanzaAttributes(t, QUEUE_MANAGER_STANZA, key, response);
                return pr;
            }
            do {
                if (repeatingValue != null) continue;
                return prefix;
            } while ((repeatingValue = QueueManager.parseStanzaAttributes(t, QUEUE_MANAGER_STANZA, QUEUE_MANAGER_STANZA_KEY, response1 = NativeCalls.getRepeatingAttrs(t, null, QUEUE_MANAGER_STANZA, QUEUE_MANAGER_STANZA_KEY, repeatingValue))) == null || !repeatingValue.equals(qm));
            String pr = QueueManager.parseStanzaAttributes(t, QUEUE_MANAGER_STANZA, key, response1);
            return pr;
        }
        catch (CommonServicesException e) {
            if (!Trace.isTracing) return prefix;
            t.data(64, "QueueManager.getQueueManagerKey", 900, "Error geting list of queue manangers" + Common.LINE_SEPARATOR + e);
        }
        return prefix;
    }

    public static String getDefaultQueueManager(Trace t) throws CommonServicesException {
        String defaultQueueManager = null;
        try {
            String response = NativeCalls.getAttrs(t, null, DEFAULT_QUEUE_MANAGER_STANZA);
            defaultQueueManager = QueueManager.parseStanzaAttributes(t, DEFAULT_QUEUE_MANAGER_STANZA, QUEUE_MANAGER_STANZA_KEY, response);
        }
        catch (CommonServicesException e) {
            if (Trace.isTracing) {
                t.data(64, "QueueManager.getDefaultQueueManager", 900, "Error geting default queue mananger name" + Common.LINE_SEPARATOR + e);
            }
            throw e;
        }
        return defaultQueueManager;
    }

    public static boolean isQueueManagerRunning(Trace t, String qmgr) {
        return NativeCalls.isQueueManagerRunning(t, qmgr);
    }

    public static boolean isLocalQueueManager(Trace t, String qmgr, boolean thisInstallation) throws CommonServicesException {
        boolean isLocal = false;
        try {
            ArrayList<String> list = QueueManager.getListOfQueueManagers(t, true, thisInstallation);
            int i = 0;
            while (i < list.size()) {
                if (list.get(i).equals(qmgr)) {
                    isLocal = true;
                    break;
                }
                ++i;
            }
        }
        catch (CommonServicesException e) {
            if (Trace.isTracing) {
                t.data(64, "QueueManager.isLocalQueueManager", 900, "Error determining local queue mananger name" + Common.LINE_SEPARATOR + e);
            }
            throw e;
        }
        return isLocal;
    }

    private static String parseStanzaAttributes(Trace t, String stanzaName, String repeatingKey, String attrs) throws CommonServicesException {
        String fid = "QueueManager.parseStanzaAttributes";
        String repeatingValue = null;
        String attributeString = null;
        if (attrs != null) {
            StringTokenizer st1 = new StringTokenizer(attrs, XCSPRA_DELIMIT_1);
            try {
                if (XCSPRA_DELIMIT_1.indexOf(attrs.charAt(0)) == -1 && st1.hasMoreTokens()) {
                    attributeString = st1.nextToken();
                    StringTokenizer st2 = new StringTokenizer(attributeString, XCSPRA_DELIMIT_0, true);
                    while (st2.hasMoreTokens()) {
                        String key = st2.nextToken();
                        if (st2.hasMoreTokens()) {
                            st2.nextToken();
                            String value = st2.nextToken();
                            if (value.equals(XCSPRA_DELIMIT_0)) {
                                value = "";
                            } else {
                                st2.nextToken();
                            }
                            if (!key.equals(repeatingKey)) continue;
                            repeatingValue = value;
                            continue;
                        }
                        if (!Trace.isTracing) continue;
                        t.data(64, fid, 900, "No attribute matching for " + stanzaName + ":" + key);
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                if (Trace.isTracing) {
                    t.data(64, fid, 900, "NoSuchElementException error for " + stanzaName + ", string=" + attributeString);
                }
                throw new CommonServicesException(CommonServices.getSystemMessage("AMQ4172"), "AMQ4172", 50014, 0, 30);
            }
        }
        return repeatingValue;
    }
}

