/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.utils;

import com.ibm.mq.commonservices.Common;
import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.monitor.TraceMonitor;
import com.ibm.mq.commonservices.internal.trace.AMQLogger;
import com.ibm.mq.commonservices.internal.trace.Detail;
import com.ibm.mq.commonservices.internal.trace.EventLogger;
import com.ibm.mq.commonservices.internal.trace.Names;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.trace.TraceFormatter;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.commonservices.internal.utils.NativeCalls;
import com.ibm.mq.commonservices.internal.utils.QueryValue;
import com.ibm.mq.commonservices.internal.utils.RASProperties;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CommonServices {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.commonservices/src/java/com/ibm/mq/commonservices/internal/utils/CommonServices.java";
    private static final String MQENVIRONMENT_CLASS = "com.ibm.mq.MQEnvironment";
    private static final String MQENVIRONMENT_ENABLE_TRACE_METHOD = "enableTracing";
    private static final String MQENVIRONMENT_DISABLE_TRACE_METHOD = "disableTracing";
    private static Class mqEnvironment = null;
    public static boolean isWMQJavaEnabled = false;
    public static final int PLATFORM_ID = CommonServices.determinePlatform();
    public static final String SYSTEM_MESSAGE_FILE = "com.ibm.mq.commonservices.internal.utils.systemMessages";
    public static final String PLATFORM_MODULE_EXTENSION = CommonServices.getPlatformModuleExtension();
    public static boolean isCommonServicesAvailable = false;
    public static boolean isExtendedCommonServicesAvailable = false;
    public static boolean isServerJniLibraryAvailable = false;
    public static boolean isJLogTraceAvailable = false;
    public static int buildType = 32;
    private static Logger traceLogger = null;
    private static ConsoleHandler consoleHandler = null;
    private static FileHandler traceFileHandler = null;
    private static File workingDir = null;
    public static String handlesFilename = null;
    private static String traceFilename = null;
    private static int traceFileSize = 0;
    private static int traceFileCount = 0;
    private static EventLogger dmEventLogger = null;
    private static EventLogger uiEventLogger = null;
    public static boolean traceEnabled = false;
    private static Message systemMessage = null;
    public static Hashtable<Integer, EventLogger> eventLoggers = new Hashtable(2);
    private static final String TRACE_LOGGER_ID = "com.ibm.mq.commonservices";
    private static int mqInstallType = -1;
    private static boolean mqjbnd = false;
    private static final String errorsDirectoryName = "errors";
    private static final String traceDirectoryName = "trace";
    public static final String DEFAULT_AMQ_KEY = "AMQ4999";
    private static Hashtable<Integer, String[]> traceNames = new Hashtable();
    private static Hashtable<Integer, HashMap<String, Integer>> traceNamesHashTable = new Hashtable();
    private static RASProperties rasProperties = new RASProperties();
    private static AMQLogger amqLogger = null;
    private static TraceMonitor traceMonitor = null;
    private static boolean isProcessInit = false;
    private static final boolean fIsSSLFIPSSupported = false;

    static {
        CommonServices.registerTraceNames(64, Names.getMethodNames());
    }

    private CommonServices() {
    }

    public static Message loadSystemMessages(Trace t) throws CommonServicesException {
        Message msgFile = null;
        try {
            msgFile = new Message(t, SYSTEM_MESSAGE_FILE);
        }
        catch (Exception e) {
            if (Trace.isTracing) {
                t.data(64, "CommonServices.loadSystemMessages", 900, "Error loading system messages : " + e.toString());
            }
            throw new CommonServicesException(t, "Error loading system messages file com.ibm.mq.commonservices.internal.utils.systemMessages", "AMQ4578", 50026, 0, 40);
        }
        return msgFile;
    }

    public static void processInitialize(Trace t) throws CommonServicesException {
        CommonServices.processInitialize(t, true);
    }

    public static void processInitialize(Trace t, boolean fullLoad) throws CommonServicesException {
        if (!isProcessInit) {
            isProcessInit = true;
            systemMessage = CommonServices.loadSystemMessages(t);
            CommonServices.processRASProperties(t);
            isJLogTraceAvailable = CommonServices.loadJLogServices(t);
            mqInstallType = 3;
            if (CommonServices.checkCommonServices(t)) {
                isCommonServicesAvailable = fullLoad ? (isExtendedCommonServicesAvailable = CommonServices.loadExtendedCommonServices(t)) : CommonServices.loadCommonServices(t);
            } else {
                throw new CommonServicesException(t, CommonServices.getSystemMessage(t, "AMQ4547"), "AMQ4547", 50018, 0, 40);
            }
            if (isCommonServicesAvailable) {
                traceMonitor = CommonServices.getTraceMonitor(t, fullLoad);
                buildType = CommonServices.determineBuildType(t);
                if (fullLoad) {
                    if (CommonServices.loadServerJniLibrary(t)) {
                        mqInstallType = 1;
                        t.data(64, "CommonServices.processInitialize", 800, "Server install of MQ available.");
                    } else if (CommonServices.checkClientDll(t)) {
                        mqInstallType = 2;
                        t.data(64, "CommonServices.processInitialize", 800, "Client install of MQ available.");
                    } else {
                        mqInstallType = 3;
                        t.data(64, "CommonServices.processInitialize", 900, "No install of MQ available.");
                    }
                }
                mqjbnd = CommonServices.checkJavaDll(t);
            }
            if (isCommonServicesAvailable) {
                try {
                    int rc = NativeCalls.xcsProcInit(0);
                    if (rc != 0) {
                        if (Trace.isTracing) {
                            t.data(64, "CommonServices.processInitialize", 900, "Error " + rc + " from xcsProcessInitialize()");
                        }
                        isCommonServicesAvailable = false;
                        throw new CommonServicesException(t, CommonServices.getSystemMessage(t, "AMQ4577"), "AMQ4577", 50018, 0, 40);
                    }
                }
                catch (UnsatisfiedLinkError ule) {
                    if (Trace.isTracing) {
                        t.data(64, "CommonServices.processInitialize", 900, "Error loading common services\n" + ule.toString());
                    }
                    isCommonServicesAvailable = false;
                    throw new CommonServicesException(t, CommonServices.getSystemMessage(t, "AMQ4579"), "AMQ4579", 50018, 0, 40);
                }
            }
            if (Trace.isTracing) {
                t.dataBox(64, "CommonServices.processInitialize", new String[]{"Plug-in name     : com.ibm.mq.commonservices"});
            }
        } else if (Trace.isTracing) {
            t.data(64, "CommonServices.processInitialize", 900, "Common services process initialize already called");
        }
    }

    private static boolean checkCommonServices(Trace t) throws CommonServicesException {
        boolean retValue = true;
        if (PLATFORM_ID != 1) {
            String javaPath;
            String javaLibraryPath;
            StringTokenizer strTok;
            String nativePath;
            String jniLibraryName = CommonServices.getJniLibName(t);
            String nativeLibraryPath = CommonServices.getNativeLibPath(t);
            String pathSep = CommonServices.getSystemProperty(t, "path.separator", null);
            if (nativeLibraryPath != null && pathSep != null && (nativePath = CommonServices.getFilePath(t, jniLibraryName, strTok = new StringTokenizer(nativeLibraryPath, pathSep))).length() > 0 && (javaLibraryPath = CommonServices.getSystemProperty(t, "java.library.path", null)) != null && (javaPath = CommonServices.getFilePath(t, jniLibraryName, strTok = new StringTokenizer(javaLibraryPath, pathSep))).length() > 0) {
                try {
                    File ldFilePath = new File(nativePath).getCanonicalFile();
                    File javaFilePath = new File(javaPath).getCanonicalFile();
                    retValue = ldFilePath.equals(javaFilePath);
                }
                catch (IOException e) {
                    throw new CommonServicesException(t, CommonServices.getSystemMessage(t, "AMQ4547"), e, "AMQ4547", 50018, 0, 40);
                }
            }
        }
        return retValue;
    }

    private static String getNativeLibPath(Trace t) {
        String nativeLibraryPath = null;
        switch (PLATFORM_ID) {
            case 3: {
                nativeLibraryPath = CommonServices.getSystemEnv(t, "LIBPATH");
                break;
            }
            case 28: {
                nativeLibraryPath = CommonServices.getSystemEnv(t, "DYLD_LIBRARY_PATH");
                break;
            }
            case 1: {
                nativeLibraryPath = CommonServices.getSystemEnv(t, "PATH");
                break;
            }
            default: {
                nativeLibraryPath = CommonServices.getSystemEnv(t, "LD_LIBRARY_PATH");
            }
        }
        return nativeLibraryPath;
    }

    private static String getJniLibName(Trace t) {
        String jniLibraryName = null;
        switch (PLATFORM_ID) {
            case 28: {
                jniLibraryName = "libmqjx_r.dylib";
                break;
            }
            case 1: {
                jniLibraryName = "amqjxcoa.dll";
                break;
            }
            default: {
                jniLibraryName = "libmqjx_r.so";
            }
        }
        return jniLibraryName;
    }

    private static boolean checkJavaDll(Trace t) {
        boolean retValue = false;
        String libraryName = null;
        switch (PLATFORM_ID) {
            case 1: {
                libraryName = "mqjbnd";
                break;
            }
            default: {
                libraryName = "mqjbnd";
            }
        }
        retValue = CommonServices.checkDLL(t, libraryName);
        return retValue;
    }

    private static boolean checkClientDll(Trace t) {
        boolean retValue = false;
        String libraryName = null;
        switch (PLATFORM_ID) {
            case 1: {
                libraryName = "mqic";
                break;
            }
            default: {
                libraryName = "mqic_r";
            }
        }
        retValue = CommonServices.checkDLL(t, libraryName);
        return retValue;
    }

    public static boolean processTerminate(Trace t) {
        new Thread(){

            @Override
            public void run() {
                Trace trace;
                block8: {
                    trace = Trace.getDefault();
                    if (Trace.isTracing) {
                        trace.data(64, "CommonServices.processTerminate", 300, "Closing common services");
                    }
                    this.setName("IBM MQ closing common services");
                    try {
                        int rc = NativeCalls.xcsProcTerm(0);
                        if (rc != 0 && Trace.isTracing) {
                            trace.data(64, "CommonServices.processTerminate", 900, "Error " + rc + " terminating common services");
                        }
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        if (!Trace.isTracing) break block8;
                        trace.data(64, "CommonServices.processTerminate", 900, "Error terminating common services");
                    }
                }
                if (traceMonitor != null) {
                    traceMonitor.close(trace);
                }
                if (amqLogger != null) {
                    amqLogger.close(trace);
                }
                if (consoleHandler != null) {
                    consoleHandler.close();
                }
                if (traceFileHandler != null) {
                    traceFileHandler.close();
                }
            }
        }.start();
        return true;
    }

    public static boolean threadInitialize(Trace t) {
        if (isCommonServicesAvailable) {
            try {
                int rc = NativeCalls.xcsThreadInit(0);
                if (rc != 0) {
                    if (Trace.isTracing) {
                        t.data(64, "CommonServices.threadInitialize", 900, "Error " + rc + "initializing common services");
                    }
                    return false;
                }
            }
            catch (UnsatisfiedLinkError ule) {
                if (Trace.isTracing) {
                    t.data(64, "CommonServices.threadInitialize", 900, "Error initializing common services\n" + ule.toString());
                }
                return false;
            }
        }
        return true;
    }

    public static boolean threadTerminate(Trace t) {
        boolean retValue = true;
        try {
            int rc = NativeCalls.xcsThreadTerm(0);
            if (rc != 0) {
                if (Trace.isTracing) {
                    t.data(64, "CommonServices.threadTerminate", 900, "Error " + rc + "terminating common services");
                }
                return false;
            }
        }
        catch (UnsatisfiedLinkError ule) {
            if (Trace.isTracing) {
                t.data(64, "CommonServices.threadTerminate", 900, "Error terminating common services\n" + ule.toString());
            }
            return false;
        }
        return retValue;
    }

    public static String getPlatformModuleExtension() {
        String extension = ".so";
        switch (PLATFORM_ID) {
            case 1: {
                extension = ".dll";
                break;
            }
            case 3: {
                extension = ".a";
                break;
            }
            case 28: {
                extension = ".dylib";
                break;
            }
        }
        return extension;
    }

    public static boolean loadCommonServices(Trace t) {
        boolean retValue = false;
        if (isCommonServicesAvailable) {
            if (Trace.isTracing) {
                t.data(64, "CommonServices.loadCommonServices", 300, "Common services already loaded");
            }
            return true;
        }
        String jniLibraryName = null;
        switch (PLATFORM_ID) {
            case 1: {
                jniLibraryName = "amqjxcoa";
                break;
            }
            default: {
                jniLibraryName = "mqjx_r";
            }
        }
        retValue = CommonServices.loadDLL(t, jniLibraryName);
        return retValue;
    }

    public static boolean loadExtendedCommonServices(Trace t) {
        boolean retValue = false;
        if (isExtendedCommonServicesAvailable) {
            if (Trace.isTracing) {
                t.data(64, "CommonServices.loadExtendedCommonServices", 300, "Extended common services already loaded");
            }
            return true;
        }
        String jniLibraryName = null;
        switch (PLATFORM_ID) {
            case 1: {
                jniLibraryName = "amqjxx";
                break;
            }
            default: {
                jniLibraryName = "mqjxx_r";
            }
        }
        retValue = CommonServices.loadDLL(t, jniLibraryName);
        return retValue;
    }

    public static boolean loadServerJniLibrary(Trace t) {
        boolean retValue = false;
        if (isServerJniLibraryAvailable) {
            if (Trace.isTracing) {
                t.data(64, "CommonServices.loadServerJniLibrary", 300, "Server JNI Library already loaded");
            }
            return true;
        }
        String jniLibraryName = null;
        switch (PLATFORM_ID) {
            case 1: {
                jniLibraryName = "amqjxds";
                break;
            }
            default: {
                jniLibraryName = "mqjxds_r";
            }
        }
        retValue = CommonServices.loadDLL(t, jniLibraryName);
        return retValue;
    }

    public static boolean checkDLL(Trace t, String dllName) {
        boolean retValue = false;
        String prefix = "";
        String mappedName = System.mapLibraryName(dllName);
        String libPath = CommonServices.getSystemProperty(t, "java.library.path", null);
        String pathSep = CommonServices.getSystemProperty(t, "path.separator", null);
        if (libPath != null) {
            StringTokenizer strTok = new StringTokenizer(libPath, pathSep);
            if (mappedName.startsWith("lib") && !dllName.startsWith("lib")) {
                prefix = "lib";
            }
            if (!(retValue = CommonServices.fileExists(t, mappedName, strTok))) {
                if (mappedName.endsWith(".so")) {
                    strTok = new StringTokenizer(libPath, pathSep);
                    retValue = CommonServices.fileExists(t, String.valueOf(prefix) + dllName + ".a", strTok);
                    if (!retValue) {
                        strTok = new StringTokenizer(libPath, pathSep);
                        retValue = CommonServices.fileExists(t, String.valueOf(prefix) + dllName + ".dylib", strTok);
                    }
                } else if (mappedName.endsWith(".a")) {
                    strTok = new StringTokenizer(libPath, pathSep);
                    retValue = CommonServices.fileExists(t, String.valueOf(prefix) + dllName + ".so", strTok);
                } else if (mappedName.endsWith(".dylib")) {
                    strTok = new StringTokenizer(libPath, pathSep);
                    retValue = CommonServices.fileExists(t, String.valueOf(prefix) + dllName + ".so", strTok);
                }
            }
        }
        return retValue;
    }

    protected static String getSystemProperty(Trace t, String propertyName, String defaultValue) {
        String returnValue = defaultValue;
        final String propertyName_final = propertyName;
        final String defaultValue_final = defaultValue;
        try {
            returnValue = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return System.getProperty(propertyName_final, defaultValue_final);
                }
            });
        }
        catch (AccessControlException ace) {
            t.data(64, "CommonServices.getSystemProperty", "AccessControlException reading " + propertyName + ": " + ace.getMessage());
        }
        return returnValue;
    }

    protected static String getSystemEnv(Trace t, final String environmentName) {
        String returnValue = null;
        try {
            returnValue = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return System.getenv(environmentName);
                }
            });
        }
        catch (AccessControlException ace) {
            t.data(64, "CommonServices.getSystemEnv", "AccessControlException reading " + environmentName + ": " + ace.getMessage());
        }
        return returnValue;
    }

    private static boolean fileExists(Trace t, final String name, final StringTokenizer list) {
        boolean retValue = false;
        Boolean retValue_obj = (Boolean)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                boolean canRead = false;
                while (list.hasMoreTokens()) {
                    String path = list.nextToken();
                    String filename = String.valueOf(path) + File.separator + name;
                    File ftst = new File(filename);
                    try {
                        canRead = ftst.canRead();
                    }
                    catch (AccessControlException accessControlException) {}
                    if (canRead) break;
                }
                return canRead;
            }
        });
        if (retValue_obj != null) {
            retValue = retValue_obj;
        }
        return retValue;
    }

    private static String getFilePath(Trace t, final String name, final StringTokenizer list) {
        String filePath = "";
        String retValue_obj = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                String foundPath = "";
                boolean found = false;
                while (list.hasMoreTokens() && !found) {
                    String path = list.nextToken();
                    String filename = String.valueOf(path) + File.separator + name;
                    File ftst = new File(filename);
                    try {
                        if (!ftst.canRead()) continue;
                        found = true;
                        foundPath = path;
                    }
                    catch (AccessControlException accessControlException) {}
                }
                return foundPath;
            }
        });
        if (retValue_obj != null) {
            filePath = retValue_obj;
        }
        return filePath;
    }

    public static boolean loadDLL(Trace t, String dllName) {
        boolean retValue;
        block6: {
            retValue = false;
            try {
                System.loadLibrary(dllName);
                retValue = true;
            }
            catch (UnsatisfiedLinkError ule) {
                if (Trace.isTracing) {
                    t.data(64, "CommonServices.loadDLL", 1000, "Error loading runtime library : " + ule.toString());
                }
                if (rasProperties.isTracingSystemErr()) {
                    System.err.println(ule);
                }
            }
            catch (SecurityException se) {
                if (Trace.isTracing) {
                    t.data(64, "CommonServices.loadDLL", 1000, "Error loading runtime library : " + se.toString());
                }
                if (!rasProperties.isTracingSystemErr()) break block6;
                System.err.println(se);
            }
        }
        return retValue;
    }

    private static int determinePlatform() {
        int retValue = 0;
        if (Common.osName.startsWith("WINDOWS")) {
            return 1;
        }
        if (Common.osName.startsWith("AIX")) {
            return 3;
        }
        if (Common.osName.startsWith("LINUX")) {
            return 5;
        }
        if (Common.osName.startsWith("OS/390")) {
            return 9;
        }
        if (Common.osName.startsWith("Z/OS")) {
            return 9;
        }
        if (Common.osName.startsWith("MAC")) {
            return 28;
        }
        return retValue;
    }

    private static int determineBuildType(Trace t) {
        String buildTypeString;
        block8: {
            block7: {
                block6: {
                    try {
                        buildTypeString = QueryValue.queryBuildType(t);
                        if (!buildTypeString.startsWith("IKAP")) break block6;
                        return 8;
                    }
                    catch (CommonServicesException commonServicesException) {}
                }
                if (!buildTypeString.startsWith("ITST")) break block7;
                return 16;
            }
            if (!buildTypeString.startsWith("ICOL")) break block8;
            return Integer.MIN_VALUE;
        }
        if (buildTypeString.startsWith("DEBUG")) {
            return -2147483646;
        }
        return 32;
    }

    public static boolean isProductionBuild(Trace t) {
        return (buildType & Integer.MIN_VALUE) == 0;
    }

    private static boolean loadJLogServices(Trace t) {
        block6: {
            if (isJLogTraceAvailable) {
                return true;
            }
            try {
                traceLogger = Logger.getLogger(TRACE_LOGGER_ID);
                if (traceLogger != null) break block6;
                if (Trace.isTracing) {
                    t.data(64, "CommonServices.loadJLogServices", 900, "Error intializing JLog logger");
                }
                return false;
            }
            catch (Exception e) {
                if (Trace.isTracing) {
                    t.data(64, "CommonServices.loadJLogServices", 900, "Error intializing JLog logger : " + e.toString());
                }
                return false;
            }
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    traceLogger.setLevel(Level.ALL);
                    traceLogger.setUseParentHandlers(false);
                }
                catch (AccessControlException ace) {
                    System.err.println("Failed to enable trace logging: " + ace);
                }
                return null;
            }
        });
        isJLogTraceAvailable = true;
        return true;
    }

    public static boolean createEventLogger(Trace t, String name, String fileName, int id) {
        Integer key = id;
        EventLogger logger = eventLoggers.get(key);
        if (logger != null) {
            if (Trace.isTracing) {
                t.data(64, "CommonServices.createEventLogger", 900, "Creating logger " + name + "(" + id + ") already exists");
            }
            return false;
        }
        logger = new EventLogger(t, name, fileName);
        eventLoggers.put(key, logger);
        if (Trace.isTracing) {
            t.data(64, "CommonServices.createEventLogger", 900, "Creating logger " + name + "(" + id + ") created");
        }
        return true;
    }

    public static void setWorkingDir(File dir) {
        workingDir = dir;
        handlesFilename = workingDir + File.separator + "WMQ_Handles.xml";
    }

    public static File getWorkingDir(Trace t) {
        return workingDir;
    }

    public static void setJLogTraceLevel(Trace t, int i) {
        if (i == Integer.MAX_VALUE) {
            Trace.setUseJLogTrace(false);
        } else {
            Trace.setUseJLogTrace(true);
            CommonServices.setTraceComponents();
        }
        isJLogTraceAvailable = CommonServices.loadJLogServices(t);
        if (rasProperties.isTracingToFile()) {
            if (consoleHandler == null) {
                try {
                    consoleHandler = new ConsoleHandler();
                    consoleHandler.setFormatter(new TraceFormatter());
                    traceLogger.addHandler(consoleHandler);
                }
                catch (Exception e) {
                    if (Trace.isTracing) {
                        t.data(64, "CommonServices.setJLogTraceLevel", 900, "Error intializing console handler : " + e.toString());
                    }
                    return;
                }
            } else if (Trace.isTracing) {
                t.data(64, "CommonServices.setJLogTraceLevel", 300, "Old level : " + consoleHandler.getLevel());
            }
            consoleHandler.setLevel(Detail.getLevel(i));
        }
    }

    public static void setJLogTraceLevel(Trace t, final int i, String fn, int fileSize, int fileCount) {
        if (i == Integer.MAX_VALUE) {
            Trace.setUseJLogTrace(false);
        } else {
            Trace.setUseJLogTrace(true);
            CommonServices.setTraceComponents();
        }
        isJLogTraceAvailable = CommonServices.loadJLogServices(t);
        if (traceFileHandler == null) {
            if (!CommonServices.createTraceFileHandler(t, fn, fileSize, fileCount)) {
                return;
            }
        } else {
            if (Trace.isTracing) {
                t.data(64, "CommonServices.setJLogTraceLevel", 300, "Old level : " + traceFileHandler.getLevel());
            }
            if (!traceFilename.equals(fn) || traceFileSize != fileSize || traceFileCount != fileCount) {
                if (Trace.isTracing) {
                    t.data(64, "CommonServices.setJLogTraceLevel", 300, "Closing old file : " + traceFilename);
                }
                traceFileHandler.close();
                if (!CommonServices.createTraceFileHandler(t, fn, fileSize, fileCount)) {
                    return;
                }
            }
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                traceFileHandler.setLevel(Detail.getLevel(i));
                return null;
            }
        });
        traceFilename = fn;
        traceFileSize = fileSize;
        traceFileCount = fileCount;
    }

    private static boolean createTraceFileHandler(Trace t, final String fn, final int fileSize, final int fileCount) {
        try {
            Object anyException = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        traceFileHandler = new FileHandler(fn, fileSize, fileCount);
                    }
                    catch (Exception e) {
                        return e;
                    }
                    traceFileHandler.setFormatter(new TraceFormatter());
                    traceLogger.addHandler(traceFileHandler);
                    return null;
                }
            });
            if (anyException != null) {
                throw (Exception)anyException;
            }
        }
        catch (Exception e) {
            if (Trace.isTracing) {
                t.data(64, "CommonServices.createTraceFileHandler", 900, "Error intializing file handler : " + e.toString());
            }
            System.err.println("Error intializing trace file handler : " + e.toString());
            return false;
        }
        return true;
    }

    public static void setWMQTraceLevel(Trace t, int i) {
        if (i == Integer.MAX_VALUE) {
            Trace.setUseWMQTrace(false);
        } else {
            Trace.setUseWMQTrace(true);
        }
    }

    public static String getSystemMessage(Trace t, String id) {
        return CommonServices.getSystemMessage().getMessage(t, id);
    }

    public static String getSystemMessage(Trace t, String id, String insert1) {
        String[] s = new String[]{insert1};
        return CommonServices.getSystemMessage().getMessage(t, id, s);
    }

    public static String getSystemMessage(Trace t, String id, String[] inserts) {
        return CommonServices.getSystemMessage().getMessage(t, id, inserts);
    }

    public static String getSystemMessage(String id) {
        return CommonServices.getSystemMessage().getMessage(id);
    }

    public static Message getSystemMessage() {
        if (systemMessage == null) {
            try {
                systemMessage = CommonServices.loadSystemMessages(Trace.getDefault());
            }
            catch (CommonServicesException e) {
                e.printStackTrace();
            }
        }
        return systemMessage;
    }

    public static String getSystemMessage(String id, String insert1) {
        String[] s = new String[]{insert1};
        return CommonServices.getSystemMessage().getMessage(id, s);
    }

    public static String getSystemMessage(String id, String[] inserts) {
        return CommonServices.getSystemMessage().getMessage(id, inserts);
    }

    public static String getSystemMessageId(Trace t, int reasonCode) {
        String messageId = null;
        String searchKey = "RC_" + reasonCode;
        messageId = CommonServices.getSystemMessage(t, searchKey);
        if (messageId == null || messageId.length() == 0 || messageId.equals(searchKey)) {
            messageId = DEFAULT_AMQ_KEY;
        }
        return messageId;
    }

    public static int getSystemMessageSeverity(Trace t, String msgId) {
        int severity = 20;
        String searchKey = String.valueOf(msgId) + ".SEVERITY";
        String sev = CommonServices.getSystemMessage(t, searchKey);
        try {
            severity = Integer.parseInt(sev);
        }
        catch (NumberFormatException numberFormatException) {}
        return severity;
    }

    public static Logger getTraceLogger() {
        return traceLogger;
    }

    public static EventLogger getEventLogger(int id) {
        EventLogger logger = eventLoggers.get(id);
        return logger;
    }

    public static int getMqInstallType() {
        return mqInstallType;
    }

    public static EventLogger getDmEventLogger() {
        return dmEventLogger;
    }

    public static EventLogger getUiEventLogger() {
        return uiEventLogger;
    }

    public static boolean isMqjbnd() {
        return mqjbnd;
    }

    public static boolean clearWMQFFSTandTrace(Trace t) {
        String mqDir = null;
        boolean success = false;
        try {
            mqDir = QueryValue.queryGeneralDataLib(t);
        }
        catch (CommonServicesException commonServicesException) {
            return false;
        }
        if (mqDir != null) {
            File trace;
            String sep = File.separator;
            String errorsDir = String.valueOf(mqDir) + sep + errorsDirectoryName;
            String traceDir = String.valueOf(mqDir) + sep + traceDirectoryName;
            File err = new File(errorsDir);
            if (err.isDirectory()) {
                boolean result = true;
                File[] files = err.listFiles();
                int k = 0;
                while (k < files.length) {
                    if (!files[k].delete()) {
                        result = false;
                    }
                    ++k;
                }
                success = result;
            }
            if ((trace = new File(traceDir)).isDirectory()) {
                boolean result = true;
                File[] files = trace.listFiles();
                int k = 0;
                while (k < files.length) {
                    if (!files[k].delete()) {
                        result = false;
                    }
                    ++k;
                }
                if (success) {
                    success = result;
                }
            }
        }
        return success;
    }

    public static String[] getListOfNames(int key) {
        String[] table = traceNames.get(key);
        if (table == null) {
            return null;
        }
        return table;
    }

    public static boolean registerTraceNames(int id, HashMap<String, Integer> names) {
        boolean saved = false;
        Integer key = id;
        if (!traceNamesHashTable.contains(key)) {
            traceNamesHashTable.put(key, names);
            saved = true;
        }
        return saved;
    }

    public static boolean registerTraceNames(int id, String[] names) {
        boolean saved = false;
        Integer key = id;
        if (!traceNames.contains(key)) {
            traceNames.put(key, names);
            saved = true;
        }
        return saved;
    }

    public static HashMap<String, Integer> getHashMapOfNames(int key) {
        HashMap<String, Integer> table = traceNamesHashTable.get(key);
        if (table == null) {
            return null;
        }
        return table;
    }

    public static RASProperties getRASProperties() {
        if (rasProperties == null) {
            rasProperties = new RASProperties();
        }
        return rasProperties;
    }

    private static void processRASProperties(Trace t) {
        Trace.setUseWMQTrace(rasProperties.isTracingToWMQ());
        if (rasProperties.isTracingToFile()) {
            CommonServices.setJLogTraceLevel(t, rasProperties.getTraceDetail(), rasProperties.getTraceFilename(), rasProperties.getTraceFileSize(), rasProperties.getTraceFileCount());
        }
        if (rasProperties.isTracingToConsole()) {
            CommonServices.setJLogTraceLevel(t, rasProperties.getTraceDetail());
        }
        if ((rasProperties.isTracingToFile() || rasProperties.isTracingToConsole()) && amqLogger == null) {
            amqLogger = new AMQLogger(t, rasProperties);
        }
    }

    public static String setRASProperty(Trace t, String key, String value) {
        String oldValue = null;
        oldValue = rasProperties.setProperty(t, key, value);
        if (oldValue == null) {
            return null;
        }
        return oldValue;
    }

    public static void applyRASProperties(Trace t) {
        rasProperties.processProperties();
        CommonServices.processRASProperties(t);
    }

    public static boolean isSSLFIPSSupported() {
        return false;
    }

    public static boolean isTracingExplorer() {
        return rasProperties.isTracingExplorer();
    }

    public static boolean isTracingWMQJavaClasses() {
        return rasProperties.isTracingWMQJavaClasses();
    }

    public static boolean isTracingToWMQ() {
        return rasProperties.isTracingToWMQ();
    }

    public static void setTraceComponents() {
        if (rasProperties.isTracingAll() || rasProperties.isTracingExplorer()) {
            Trace.traceComponents = null;
            return;
        }
        int counter = 0;
        if (rasProperties.isTracingCommonServices()) {
            ++counter;
        }
        if (rasProperties.isTracingDataModel()) {
            ++counter;
        }
        if (rasProperties.isTracingFTA()) {
            ++counter;
        }
        if (rasProperties.isTracingPlugins()) {
            ++counter;
        }
        if (rasProperties.isTracingSoap()) {
            ++counter;
        }
        if (rasProperties.isTracingUI()) {
            ++counter;
        }
        if (rasProperties.isTracingWMQJavaClasses()) {
            counter += 3;
        }
        Trace.traceComponents = new int[counter];
        int index = 0;
        if (rasProperties.isTracingCommonServices()) {
            Trace.traceComponents[index++] = 64;
        }
        if (rasProperties.isTracingDataModel()) {
            Trace.traceComponents[index++] = 65;
        }
        if (rasProperties.isTracingFTA()) {
            Trace.traceComponents[index++] = 9;
        }
        if (rasProperties.isTracingPlugins()) {
            Trace.traceComponents[index++] = 66;
        }
        if (rasProperties.isTracingSoap()) {
            Trace.traceComponents[index++] = 49;
        }
        if (rasProperties.isTracingUI()) {
            Trace.traceComponents[index++] = 67;
        }
        if (rasProperties.isTracingWMQJavaClasses()) {
            Trace.traceComponents[index++] = 59;
            Trace.traceComponents[index++] = 60;
            Trace.traceComponents[index++] = 61;
        }
    }

    public static AMQLogger getAMQLogger() {
        return amqLogger;
    }

    public static TraceMonitor getTraceMonitor(Trace t, boolean fullLoad) {
        TraceMonitor tm = null;
        tm = traceMonitor == null && (CommonServices.isTracingToWMQ() || !fullLoad) ? new TraceMonitor(t, 10) : traceMonitor;
        return tm;
    }

    public static void stopTraceMonitor(Trace t) {
        if (traceMonitor != null) {
            traceMonitor.close(t);
            traceMonitor = null;
        }
    }

    public static void setWMQJavaTraceClass(Class cls) {
        mqEnvironment = cls;
    }

    private static Class getWMQJavaTraceClass(Trace t) {
        block3: {
            if (mqEnvironment == null) {
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    mqEnvironment = Class.forName(MQENVIRONMENT_CLASS, false, cl);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!Trace.isTracing) break block3;
                    t.data(64, "CommonServices.getWMQJavaTraceClass", 900, "Unable to find class com.ibm.mq.MQEnvironment");
                }
            }
        }
        return mqEnvironment;
    }

    public static void setWMQJavaClassesTraceLevel(Trace t, int level) {
        block16: {
            Method m = null;
            try {
                if (CommonServices.getWMQJavaTraceClass(t) != null && mqEnvironment.getName().equals(MQENVIRONMENT_CLASS)) {
                    if (level == Integer.MAX_VALUE) {
                        m = mqEnvironment.getDeclaredMethod(MQENVIRONMENT_DISABLE_TRACE_METHOD, new Class[0]);
                        isWMQJavaEnabled = false;
                        if (m != null) {
                            m.invoke(null, null);
                        } else if (Trace.isTracing) {
                            t.data(64, "CommonServices.setWMQJavaClassesTraceLevel", 900, "Unable to disable wmqjavaclasses trace - method disableTracing not found ");
                        }
                    } else if (!isWMQJavaEnabled) {
                        isWMQJavaEnabled = true;
                        m = mqEnvironment.getDeclaredMethod(MQENVIRONMENT_ENABLE_TRACE_METHOD, Integer.TYPE, OutputStream.class);
                        if (m != null) {
                            Object[] objectArray = new Object[2];
                            objectArray[0] = 1;
                            m.invoke(null, objectArray);
                        } else {
                            if (Trace.isTracing) {
                                t.data(64, "CommonServices.setWMQJavaClassesTraceLevel", 900, "Unable to enable wmqjavaclasses trace - method enableTracing not found ");
                            }
                            isWMQJavaEnabled = false;
                        }
                    } else if (Trace.isTracing) {
                        t.data(64, "CommonServices.setWMQJavaClassesTraceLevel", 900, "wmqjavaclasses trace already enabled");
                    }
                }
            }
            catch (Exception e) {
                isWMQJavaEnabled = false;
                if (Trace.isTracing) {
                    t.data(64, "CommonServices.setWMQJavaClassesTraceLevel", 900, "Error setting WMQ Java Classes trace\n" + e);
                }
            }
            catch (ExceptionInInitializerError e) {
                isWMQJavaEnabled = false;
                if (!Trace.isTracing) break block16;
                t.data(64, "CommonServices.setWMQJavaClassesTraceLevel", 900, "Error setting WMQ Java Classes trace\n" + e);
            }
        }
    }

    public static void disablePreferences() {
        System.setProperty("java.util.prefs.PreferencesFactory", "com.ibm.mq.commonservices.internal.prefs.NoPreferencesFactory");
    }

    public static String getInstallationName(Trace t) {
        String thisInstall;
        block3: {
            thisInstall = null;
            if (CommonServices.getMqInstallType() != 3) {
                try {
                    thisInstall = QueryValue.queryInstallName(t);
                }
                catch (CommonServicesException e) {
                    if (!Trace.isTracing) break block3;
                    t.data(64, "CommonServices.getInstallationName", 900, "CommonServicesException from QueryValue.queryInstallName: " + e.getMessage());
                }
            }
        }
        return thisInstall;
    }
}

