/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.console;

import com.ibm.mq.commonservices.internal.console.ConsoleCommand;
import com.ibm.mq.commonservices.internal.console.IConsoleCommandListener;
import com.ibm.mq.commonservices.internal.trace.Trace;
import java.io.PrintStream;

public class ConsoleStdinWriter
extends Thread {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.commonservices/src/java/com/ibm/mq/commonservices/internal/console/ConsoleStdinWriter.java";
    private ConsoleCommand consoleCommand = null;
    private String[] input = null;
    private IConsoleCommandListener listener = null;

    public ConsoleStdinWriter(ConsoleCommand aJob, String[] aText) {
        this.consoleCommand = aJob;
        this.input = aText;
        this.listener = this.consoleCommand.getListener();
        this.setName("WMQ stdin for " + this.consoleCommand.getCommand());
    }

    @Override
    public void run() {
        Trace t = Trace.getDefault();
        PrintStream ps = new PrintStream(this.consoleCommand.getProcess().getOutputStream());
        if (Trace.isTracing) {
            t.data(64, "ConsoleStdinWriter.run", "Sending stdin to sub-process");
        }
        try {
            try {
                if (this.input != null) {
                    int i = 0;
                    while (i < this.input.length) {
                        if (Trace.isTracing) {
                            t.data(64, "ConsoleStdinWriter.run", "input = " + this.input[i]);
                        }
                        ps.println(this.input[i]);
                        Thread.sleep(100L);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                String caller = null;
                if (this.listener != null) {
                    caller = this.listener.toString();
                }
                t.FFST(64, "ConsoleStdinWriter.run", 0, 50044, 0, 0, caller, this.consoleCommand.getCommand(), e.toString());
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (Exception e2) {
                    String caller2 = null;
                    if (this.listener != null) {
                        caller2 = this.listener.toString();
                    }
                    t.FFST(64, "ConsoleStdinWriter.run", 1, 50044, 0, 0, caller2, this.consoleCommand.getCommand(), e2.toString());
                }
            }
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception e) {
                String caller = null;
                if (this.listener != null) {
                    caller = this.listener.toString();
                }
                t.FFST(64, "ConsoleStdinWriter.run", 1, 50044, 0, 0, caller, this.consoleCommand.getCommand(), e.toString());
            }
        }
    }
}

