#!/bin/sh
wait="false"
folders=""

processargs()
{
    while [ $# -ne 0 ]
    do
        case $1 in
        -wait)
            wait="true"
            ;;
        *)
            folders="$folders $1"
        esac
        shift
    done
}

deleteFolder()
{
    if [ "$1" != "/"  ];then
        #echo "deleteFolder(): $1"
        counter=1
        while [ $counter -le 6 ] 
        do
            rm -r -f $1 2>&-
            #echo $?
            if [ $? -ne 0 ];then
                if [ "$wait" = "true" ]; then
                    if [ -d $1 ];then
                        sleep 5
                        counter=`expr $counter + 1`
                        #echo $counter
                    else 
                        return
                    fi
                else
                    return
                fi
            else
                #echo "Removed $1"
                return
            fi
        done
    fi
}

deleteFolders()
{
    for folder in $*; do
        #echo "deleteFolders():Folder: $folder"
        if [ -d "$folder" ];then
            deleteFolder $folder
        fi
    done
}


cleanup()
{
    if [ "$wait" = "true" ]; then
        # echo "Wait is true";
        # This is the background process.  Keep trying to delete
        # until successful (i.e. allow enough time for the
        # parent process to exit).

        # Delete what remains.
        deleteFolders $folders;

    else
        # echo "Wait is false"
        # Delete as much as we can now (i.e. for synchronous
        # silent uninstall).
        deleteFolders $folders

        #Fork child if any of the folders is still there
        for folder in $folders; do
            if [ -d "$folder" ];then
                $1 -wait "$folders" &
                exit 0
            fi
        done

    fi

    scriptLoc=`dirname "$1"`
    rm -r -f $scriptLoc 2>&-
}

#
# MAIN
#
cd /tmp
#echo file $0
# PROCESS COMMAND LINE PARAMETERS
processargs $*

#echo folders:"$folders"
#echo wait:"$wait"

#CLEANUP DIRECTORIES
cleanup $0

