<?xml version='1.0' encoding='UTF-8' ?>
<xsl:stylesheet version="1.0" xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:fo='http://www.w3.org/1999/XSL/Format'>
   <xsl:output method="html" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" indent="yes" />

   <xsl:template match="/">
      <html>
         <head>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
            <meta name="copyright" content="(C) Copyright IBM Corporation 2006" />
            <meta name="DC.rights.owner" content="(C) Copyright IBM Corporation 2006" />
            <meta name="security" content="public" />
            <meta name="Robots" content="index,follow" />
            <meta http-equiv="PICS-Label" content="(PICS-1.1 &quot;http://www.icra.org/ratingsv02.html&quot; l gen true r (cz 1 lz 1 nz 1 oz 1 vz 1) &quot;http://www.rsac.org/ratingsv01.html&quot; l gen true r (n 0 s 0 v 0 l 0) &quot;http://www.classify.org/safesurf/&quot; l gen true r (SS~~000 1))" />
            <meta name="DC.Type" content="concept" />
            <meta name="DC.Title" content="Peter's file" />
            <meta name="abstract" content="This file contains information about something" />
            <meta name="description" content="This file contains information about something" />
            <meta name="DC.Format" content="XHTML" />
            <meta name="DC.Identifier" content="petersfile" />
            <meta name="DC.Language" content="en-us" />
<style type='text/css'>
                         body {
                           font-family: sans-serif;font-size: 90%;
                           background-color:#FBFFFF;
                         }

                         br.big {
                            margin: 2em;
                         }
                         h1 {
                           font-size: 200%;
                           text-align: center;
                         }
                         h2 {
                           font-size: 150%;
                           text-align: center;
                         }
                         h3 {
                           font-size: 150%;
                           text-align: left;
                           margin: 0px;
                         }

                         table {
                           border-collapse: collapse;
                           border: 2 solid black;

                         }
                         th, td {
                           padding: 0.0em 0.5em;
                           vertical-align: top;
                           text-align: left;
                         }

                         table.common {
                            border-width: 0px;
                            text-align: left;
                            vertical-align: bottom;
                            width: 100%;
                         }
                         table.common th {
                            width: 33%;
                         }

                         table.common td {
                            vertical-align: bottom;
                         }

                         table.group {
                            border-width: 0px;
                            text-align: left;
                            width: 100%;
                         }
                         table.group th{
                            vertical-align: bottom;
                            width: 28%;
                         }
                         table.group td{
                            vertical-align: bottom;
                         }

                         table.packages {
                            border: 2px solid black;
                            text-align: left;
                            width: 100%;
                            border-style:outset;
                         }
                         table.packages th{
                            border: 2px double black;
                            text-align: center;
                            vertical-align: bottom;
                            background-color: #F3F9FF;
                         }
                         table.packages th.subheader{
                            border: 2px double black;
                            text-align: center;
                            vertical-align: middle;
                            background-color:#FBFFFF;
                         }
                         table.packages td{
                            border: 2px double black;
                            text-align: left;
                         }
</style>

            <title>%InstallPublication_Title</title>
         </head>

         <body>
            <ul>
               <h1>%InstallPublication_Title</h1>
               <br />
               <xsl:apply-templates select="/installInfo/location[@kind = 'self']" />
               <br class="big" />
               <xsl:if test ="count (/installInfo/property[@name='cacheLocation']) !=0" >
                <table class="common">
                <tbody>
                    <tr>
                        <th>%InstallPublication_SharedResourceDirectory</th>
                        <td>
                            <xsl:apply-templates select="/installInfo/property[@name='cacheLocation']" />
                        </td>
                    </tr>
					<tr>
                        <th>%InstallPublication_AgentDirectory</th>
                        <td>
                            <xsl:apply-templates select="/installInfo/property[@name='cic.appDataLocation']" />
                        </td>
                    </tr>
                </tbody>
              </table>
              </xsl:if>
               <br class="big" />
               <xsl:apply-templates select="/installInfo/location[@kind != 'self']">
                  <xsl:sort select="@id" />
               </xsl:apply-templates>
            </ul>
         </body>
      </html>
   </xsl:template>

<!-- ======== REPORT INSTALL LOCATION (SELF ONLY) ======= -->
   <xsl:template match="location[@kind = 'self']">
      <xsl:variable name='n' select="./package/@name" />
     <h2>
         <xsl:value-of select="concat($n,' %InstallPublication_Version ')" />
         <xsl:apply-templates select="./package/property[@name='cic.info.version']" />
         (<xsl:value-of select="./package/@version" />)
      </h2>

      <table class="common">
         <tbody>
            <tr>
               <th>%InstallPublication_Installation_Location</th>
               <td>
                  <xsl:value-of select="@path" />
               </td>
            </tr>
%InstallPublication_Architecture_Xsl
        </tbody>
      </table>
   </xsl:template>

<!-- ===== REPORT INSTALL LOCATION (ALL OFFERINGS BUT (SELF)  NOT SELF!! ===== -->
    <xsl:template match="location">
        <table class="group">
            <tbody>
                <tr>
                    <th>%InstallPublication_Package_Group_Name</th>
                    <td>
                        <h3>
                            <xsl:value-of select="@id" />
                        </h3>
                    </td>
                </tr>

                <tr>
                    <th>%InstallPublication_Package_Group_Location</th>
                    <td>
                        <xsl:value-of select="@path" />
                    </td>
                </tr>

				<xsl:if test ="@kind = 'existingEclipse'" >
                    <tr>
                        <th>%InstallPublication_Package_Group_Eclipse_IDE</th>
                        <td>
                            <xsl:apply-templates select="./property[@name='eclipseLocation']" />
                        </td>
                    </tr>
                </xsl:if>

                <tr>
                    <th>%InstallPublication_Package_Group_Languages</th>
                    <td>
                        <xsl:apply-templates select="./property[@name='cic.selector.nl']" />
                    </td>
                </tr>

%InstallPublication_Package_Group_Arch_Xsl
            </tbody>
        </table>

        <br />

        <table class="packages" >
            <tbody>
                <tr>
                    <th style="width: 46%;">%InstallPublication_Packages</th>
                    <th>%InstallPublication_Features</th>
                </tr>
                <xsl:apply-templates select="./package" />
            </tbody>
        </table>
        <br class="big" />
        <br class="big" />
    </xsl:template>

<!-- REPORT OFFERINGS -->
   <xsl:template match="package[@kind='offering']">
      <tr>
         <th class="subheader">
         <br />
         <xsl:value-of select="@name" />
         <br />
         Version
         <xsl:apply-templates select="./property[@name='cic.info.version']" />  (<xsl:value-of select="@version" />)
         <br /><br />
         %InstallPublication_Repository<br/> <xsl:apply-templates select="./property[@name='agent.sourceRepositoryLocation']" />
         <br /><br />
         <xsl:if test="count(package[@kind='fix'])!=0">
            <p style="margin-right: 30px; text-align: center;">%InstallPublication_Fixes </p>
            <ul style="margin-left: 20px;text-align: left;">
            <xsl:apply-templates select="./package[@kind='fix']" />
            </ul><br />
         </xsl:if>
         </th>
         <td>
            <br />
            <ul style="margin-left: 60px;">
               <xsl:apply-templates select="./package[@kind='feature']" />
            </ul>
            <br />
         </td>
      </tr>
   </xsl:template>

<!-- REPORT FEATURES -->
   <xsl:template match="package[@kind='feature']">
      <xsl:variable name='propKind' select="./property[@name='cic.feature.kind']" />
        <xsl:if test="$propKind/@value!='RequiredAndNotVisible'">
        <li>
            <xsl:apply-templates select="./property[@name='cic.info.name']" />
        </li>
      </xsl:if>
   </xsl:template>
   <!-- REPORT FIXES -->
   <xsl:template match="package[@kind='fix']">
      <xsl:variable name='prop' select="./property[@name='cic.info.name']" />
      <xsl:variable name='ver' select="./property[@name='cic.info.version']" />      <li>
         <xsl:value-of select="$prop/@value" /><br />
         Version <xsl:value-of select="$ver/@value" />  (<xsl:value-of select="@version" />)
      </li>
   </xsl:template>

   <!--- READ A PROPERTY VALUE -->
   <xsl:template match="property">
        <xsl:value-of select="./@value" />
   </xsl:template>
</xsl:stylesheet>
