@echo off
SETLOCAL ENABLEDELAYEDEXPANSION
SETLOCAL
SET KEY=HKLM\SOFTWARE\IBM\Installation Manager
SET PROC_KEY=HKLM\System\CurrentControlSet\Control\Session Manager\Environment
SET WOW_KEY=HKLM\SOFTWARE\Wow6432Node\IBM\Installation Manager
SET PROC_ARCH_NAME=PROCESSOR_ARCHITECTURE
SET LAUNCHER_NAME=launcher
SET APPDATALOCATION_NAME=appDataLocation
SET VERSION_NAME=version

SET IM_IMAGE_WINDOWS_X86=InstallerImage_win32_win32_x86
SET IM_IMAGE_WINDOWS_X86_64=InstallerImage_win32_win32_x86_64

SET imInstalled=false

:: Detect machine architecture
FOR /f "tokens=2,*" %%a in ('REG QUERY "%PROC_KEY%" /v %PROC_ARCH_NAME%') DO (
    SET PROC_ARCH=%%b
)

IF %PROC_ARCH%==x86 (
	SET machineIs64Bit=false
) ELSE (
	SET machineIs64Bit=true
)

:: ECHO machineIs64Bit=%machineIs64Bit%

:: Detect installed IM
REG QUERY "%KEY%" /v %APPDATALOCATION_NAME% >nul 2>&1
IF %ERRORLEVEL% EQU 1 (
	SET imInstalled=false
) ELSE (
	FOR /f "tokens=2,*" %%a in ('REG QUERY "%KEY%" /v %LAUNCHER_NAME%') DO (
    	SET launcher=%%b
	)
	IF EXIST "!launcher!" (
		FOR /f "tokens=2,*" %%a in ('REG QUERY "%KEY%" /v %VERSION_NAME%') DO (
    		SET version=%%b
		)
		SET imInstalled=true
		REG QUERY "%KEY%" /v is64bit >nul 2>&1
    	IF !ERRORLEVEL! EQU 0 (
			SET imIs64Bit=true
		) ELSE (
			SET imIs64Bit=false
		)
	) ELSE (
		ECHO Could not find IBMIM.EXE
	)
)

:: Look at another registry location, if IM has not been detected yet
IF %machineIs64Bit%==true (
	IF %imInstalled%==false (
		REG QUERY "%WOW_KEY%" /v %APPDATALOCATION_NAME% >nul 2>&1
		IF !ERRORLEVEL! EQU 1 (
			SET imInstalled=false
		) ELSE (
			FOR /f "tokens=2,*" %%a in ('REG QUERY "%WOW_KEY%" /v %LAUNCHER_NAME%') DO (
				SET launcher=%%b
			)
			IF EXIST "!launcher!" (
				FOR /f "tokens=2,*" %%a in ('REG QUERY "%WOW_KEY%" /v %VERSION_NAME%') DO (
					SET version=%%b
				)
				SET imInstalled=true
				REG QUERY "%WOW_KEY%" /v is64bit >nul 2>&1
				IF !ERRORLEVEL! EQU 0 (
					SET imIs64Bit=true
				) ELSE (
					SET imIs64Bit=false
				)
			) ELSE (
				ECHO Could not find IBMIM.EXE
			)
		)
	)
)

:: ECHO imInstalled=%imInstalled%
:: ECHO Launcher=%launcher%
:: ECHO Version=%version%
:: ECHO isIm64Bit=%imIs64Bit%

:: Detect which IM installer to launch
IF %machineIs64Bit% == false (
	SET launchInstaller=%IM_IMAGE_WINDOWS_X86%
) ELSE (
	IF %imInstalled% == false (
		SET launchInstaller=%IM_IMAGE_WINDOWS_X86_64%
	) ELSE (
		IF "%imIs64Bit%" == "false" (
			SET launchInstaller=%IM_IMAGE_WINDOWS_X86%
		) ELSE (
			SET launchInstaller=%IM_IMAGE_WINDOWS_X86_64%
		)
	)
)

:: ECHO launchInstaller=%launchInstaller%

:: Detect directory of the script
SET currDir=%~dp0

:: Run command
SET exePath="%currDir%%launchInstaller%"
:: ECHO exePath=%exePath%
START /d %exePath% install.exe

ENDLOCAL
