/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.antAdapterData.internal;

import com.ibm.cic.common.antAdapterData.ant.AntAntData;
import com.ibm.cic.common.antAdapterData.ant.PropertyAntData;
import com.ibm.cic.common.antAdapterData.internal.IXMLConstants;
import com.ibm.cic.common.commonNativeAdapterData.ICommonNativeAdapterDataParser;
import com.ibm.cic.common.commonNativeAdapterData.ICommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.NativeAdapterData;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.ArtifactCommonAttributes;
import com.ibm.cic.common.core.model.adapterdata.IAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IErrorReporter;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;

public class AntAdapterDataParser
extends ICommonNativeAdapterDataParser
implements IXMLConstants {
    private NativeAdapterData antData;
    private IErrorReporter reporter;
    private ICommonNativeAdapterDataParser.ElemStack elemStack;

    public void initialize(IInstallableUnit iu, IErrorReporter errorReporter) {
        this.antData = new NativeAdapterData();
        this.reporter = errorReporter;
        this.elemStack = new ICommonNativeAdapterDataParser.ElemStack();
        super.initialize(iu, this.antData, this.elemStack, errorReporter);
    }

    public IArtifact startArtifact(String uri, String name, String qName, Attributes attributes, String key) {
        return super.startArtifact(this.elemStack, this.reporter, uri, name, qName, attributes, key);
    }

    public void endArtifact() {
        this.elemStack.pop();
    }

    public IArtifact startArtifactNoKey(String uri, String name, String qName, Attributes attributes, ArtifactCommonAttributes aca) {
        return super.startArtifactNoKey(this.elemStack, this.reporter, uri, name, qName, attributes, aca);
    }

    public void startElement(String uri, String name, String qName, Attributes attributes) {
        this.elemStack.push((Object)new ICommonNativeAdapterDataParser.ElemStackEntry(name));
        boolean processed = this.processCommonElement(name, attributes);
        if (!processed) {
            if (name.equals("ant")) {
                this.handleAntAttributes(attributes);
            } else if ("property".equals(name)) {
                this.parsePropertyAttributes(attributes);
            } else {
                this.reporter.unexpectedElement(name, attributes);
            }
        }
    }

    public void endElement(String uri, String name, String qName) {
        this.elemStack.pop();
    }

    public void characters(String chars) {
        String name = this.elemStack.top().name;
        boolean processed = this.processCommonCharacters(name, chars);
        if (!(processed || name.equals("property") && this.isAntSubElement())) {
            this.reporter.unexpectedCharacterData(chars);
        }
    }

    public IAdapterData getAdapterData() {
        return this.antData;
    }

    public URL getSchema() {
        Bundle bundle = Platform.getBundle((String)"com.ibm.cic.common.antAdapterData");
        Path path = new Path("schema/nativeAdapterData.xsd");
        return FileLocator.find((Bundle)bundle, (IPath)path, null);
    }

    private void handleAntAttributes(Attributes attributes) {
        int approximateTime;
        String workingDirectory;
        String antfile;
        boolean hasErrors = false;
        if (!this.isPerformSubElement()) {
            this.reporter.unexpectedElement("ant", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "ant", new String[]{"antfile", "workingDirectory", "approximateTime", "target", "loglevel", "output", "description"})) {
            hasErrors = true;
        }
        if ((antfile = attributes.getValue("antfile")) == null) {
            this.reporter.checkRequiredAttribute("ant", "antfile", null);
            hasErrors = true;
        }
        if ((workingDirectory = attributes.getValue("workingDirectory")) == null) {
            workingDirectory = ".";
        }
        if ((approximateTime = this.getApproximateTime("ant", attributes)) == -1) {
            hasErrors = true;
        }
        String description = attributes.getValue("description");
        String loglvl = attributes.getValue("loglevel");
        String output = attributes.getValue("output");
        String target = attributes.getValue("target");
        if (!hasErrors) {
            AntAntData data = new AntAntData(antfile, workingDirectory, description, approximateTime, target, output, loglvl);
            data.setLineNumber(this.reporter.getLastCharactersLineNumber());
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild((ICommonNativeData)data);
            }
            this.elemStack.top().data = data;
        }
    }

    private boolean isAntSubElement() {
        return this.isSubElementOf("ant");
    }

    private void parsePropertyAttributes(Attributes attributes) {
        String propertyKey = null;
        String propertyValue = null;
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if ("name".equals(name)) {
                propertyKey = value;
            } else if ("value".equals(name)) {
                propertyValue = value;
            } else {
                this.reporter.unexpectedAttribute("property", name, value);
            }
            ++i;
        }
        this.reporter.checkRequiredAttribute("property", "name", propertyKey);
        this.reporter.checkRequiredAttribute("property", "value", propertyValue);
        PropertyAntData propertyData = new PropertyAntData(propertyKey, propertyValue);
        ICommonNativeData parent = this.elemStack.top((int)-1).data;
        if (parent != null) {
            parent.addChild((ICommonNativeData)propertyData);
        }
        this.elemStack.top().data = propertyData;
    }
}

