/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient.internal.ntlm.portable;

import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.BitUtil;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.DecodeBytes;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.MessageField;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.Messages;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.NTLMConstants;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.TargetInfo;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DecodedNTLMMessage
implements NTLMConstants {
    private final byte[] bytes;
    private final DecodeBytes decode;
    private int messageType;
    private Integer flags;
    private final ArrayList fields;
    private byte[] versionData;
    private byte[] serverChallenge;
    private TargetInfo targetInfo;

    public DecodedNTLMMessage(byte[] bytes) throws DecodeBytes.DecodeBytesException, UnsupportedEncodingException {
        this.bytes = bytes;
        this.decode = new DecodeBytes(bytes);
        this.fields = new ArrayList();
        this.decode();
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public Integer getFlags() {
        return this.flags;
    }

    public byte[] getVersionData() {
        return this.versionData;
    }

    public byte[] getServerChallenge() {
        return this.serverChallenge;
    }

    public TargetInfo getTargetInfo() {
        return this.targetInfo;
    }

    public List getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public MessageField getField(String name) {
        for (MessageField field : this.fields) {
            if (!field.getName().equalsIgnoreCase(name)) continue;
            return field;
        }
        return null;
    }

    public static DecodedNTLMMessage decodeNTLMMessage(byte[] bytes) throws DecodeBytes.DecodeBytesException, UnsupportedEncodingException {
        return new DecodedNTLMMessage(bytes);
    }

    private void decode() throws DecodeBytes.DecodeBytesException, UnsupportedEncodingException {
        try {
            byte[] expected = SIGNATURE_BYTES;
            this.decode.checkBytes("signature", expected);
            this.messageType = this.decode.getNextInt();
            switch (this.messageType) {
                case 1: {
                    this.decodeNegotiate();
                    break;
                }
                case 2: {
                    this.decodeChallenge();
                    break;
                }
                case 3: {
                    this.decodeAuthenticate();
                    break;
                }
                default: {
                    throw new DecodeBytes.DecodeBytesException(NLS.bind((String)Messages.DecodedNTLMMessage_unexpectedNTLMMessageType, (Object)this.messageType));
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw DecodedNTLMMessage.convertToDecodeBytesException(this.bytes, this.decode, e);
        }
    }

    private static DecodeBytes.DecodeBytesException convertToDecodeBytesException(byte[] bytes, DecodeBytes decode, IndexOutOfBoundsException e) {
        return new DecodeBytes.DecodeBytesException(NLS.bind((String)Messages.ChallengeMessage_exceptionDecodingChallenge, (Object[])new Object[]{bytes.length, decode.getPos(), BitUtil.bytesToHexString(BitUtil.subArray(bytes, 0, Math.min(512, bytes.length)))}), e);
    }

    private void decodeNegotiate() throws DecodeBytes.DecodeBytesException {
        this.flags = this.decode.getNextInt();
        this.fields.add(new MessageField(this.decode, "DomainName"));
        this.fields.add(new MessageField(this.decode, "Workstation"));
        if ((this.flags & 0x2000000) != 0) {
            this.versionData = this.decode.getNextBytes(8);
        }
    }

    private void decodeChallenge() throws DecodeBytes.DecodeBytesException, UnsupportedEncodingException {
        this.fields.add(new MessageField(this.decode, "TargetName"));
        this.flags = this.decode.getNextInt();
        this.serverChallenge = this.decode.getNextBytes(8);
        this.decode.getNextBytes(8);
        if ((this.flags & 0x800000) != 0) {
            this.targetInfo = TargetInfo.decodeTargetInfo(this.decode);
            this.fields.add(this.targetInfo);
        } else {
            this.targetInfo = null;
        }
        if ((this.flags & 0x2000000) != 0) {
            this.versionData = this.decode.getNextBytes(8);
        }
    }

    private void decodeAuthenticate() throws DecodeBytes.DecodeBytesException {
        this.fields.add(new MessageField(this.decode, "LmChallengeResponse"));
        this.fields.add(new MessageField(this.decode, "NtChallengeResponse"));
        this.fields.add(new MessageField(this.decode, "DomainName"));
        this.fields.add(new MessageField(this.decode, "UserName"));
        this.fields.add(new MessageField(this.decode, "Workstation"));
        this.fields.add(new MessageField(this.decode, "EncryptedRandomSessionKey"));
        this.flags = this.decode.getNextInt();
        if ((this.flags & 0x2000000) != 0) {
            this.versionData = this.decode.getNextBytes(8);
        }
    }
}

