/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient.internal.ntlm;

import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.CustomNTLMPrefsHook;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.CustomNTLMScheme;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.LoggingNTLMScheme;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.NTLMIntegrated;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.Messages;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.NTLMv1MessageGenerator;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.NTLMv2MessageGenerator;
import com.ibm.cic.common.transports.httpclient.ntlm.INTLMAuthGenerator;
import com.ibm.cic.common.transports.httpclient.ntlm.INTLMAuthGeneratorFactory;
import com.ibm.cic.common.transports.httpclient.ntlm.NTLMAuthGeneratorException;
import com.ibm.cic.common.transports.httpclient.ntlm.NTLMUserCredentials;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthPolicy;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CustomNTLM
extends ICicPreferenceConstants {
    public static final Logger log = Logger.getLogger(CustomNTLM.class);
    private static NTLMIntegrated ntlmIntegrated;
    private static INTLMAuthGeneratorFactory ntlmAuthFactory;

    public static void init(HttpClient httpClient, boolean forceProviderReinit) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        ntlmIntegrated = NTLMIntegrated.init(httpClient, ntlmIntegrated, forceProviderReinit);
        if (ntlmIntegrated.isEnabled()) {
            CustomNTLM.initCustomScheme(httpClient);
            return;
        }
        String ntlmAuthKind = CustomNTLMPrefsHook.getPreferenceProvider().getString(HTTP_NTLM_AUTH_KIND.key(), "NTLM");
        if (ntlmAuthKind.equalsIgnoreCase("LM")) {
            log.info(Messages.CustomNTLM_usingLMauth);
            CustomNTLM.initHttpClientScheme(httpClient);
            return;
        }
        int ntlmVersion = 1;
        if (!ntlmAuthKind.equalsIgnoreCase("NTLM")) {
            if (ntlmAuthKind.equalsIgnoreCase("NTLMv2")) {
                ntlmVersion = 2;
            } else {
                log.warning(Messages.CustomNTLM_unexpectedNTLMpreferenceValue, new Object[]{HTTP_NTLM_AUTH_KIND.key()});
            }
        }
        if (ntlmVersion == 1) {
            log.info(Messages.CustomNTLM_usingNTLMv1auth);
            ntlmAuthFactory = new INTLMAuthGeneratorFactory(){

                @Override
                public INTLMAuthGenerator createAuthGenerator(NTLMUserCredentials userCredentials) {
                    return new NTLMv1MessageGenerator(userCredentials, null);
                }
            };
        } else {
            log.info(Messages.CustomNTLM_usingNTLMv2auth);
            ntlmAuthFactory = new INTLMAuthGeneratorFactory(){

                @Override
                public INTLMAuthGenerator createAuthGenerator(NTLMUserCredentials userCredentials) {
                    return new NTLMv2MessageGenerator(userCredentials, null);
                }
            };
        }
        CustomNTLM.initCustomScheme(httpClient);
    }

    private static void initCustomScheme(HttpClient httpClient) {
        AuthPolicy.registerAuthScheme((String)"NTLM", CustomNTLMScheme.class);
        ArrayList<String> authPrefs = new ArrayList<String>(3);
        authPrefs.add("NTLM");
        authPrefs.add("Digest");
        authPrefs.add("Basic");
        httpClient.getParams().setParameter("http.auth.scheme-priority", authPrefs);
    }

    private static void initHttpClientScheme(HttpClient httpClient) {
        AuthPolicy.registerAuthScheme((String)"NTLM", LoggingNTLMScheme.class);
        ArrayList<String> authPrefs = new ArrayList<String>(3);
        authPrefs.add("NTLM");
        authPrefs.add("Digest");
        authPrefs.add("Basic");
        httpClient.getParams().setParameter("http.auth.scheme-priority", authPrefs);
    }

    public static INTLMAuthGenerator newNTLMMessageGenerator(HttpMethod method, NTCredentials ntcredentials) throws NTLMAuthGeneratorException {
        NTLMUserCredentials userCredentials = new NTLMUserCredentials(ntcredentials.getDomain(), ntcredentials.getUserName(), method.getParams().getCredentialCharset(), ntcredentials.getPassword());
        if (ntlmIntegrated.isEnabled()) {
            return ntlmIntegrated.newNTLMMessageGenerator(userCredentials);
        }
        return ntlmAuthFactory.createAuthGenerator(userCredentials);
    }
}

