/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.adapters.nativeAdapter.win32;

import com.ibm.cic.agent.core.commonNativeInstallAdapter.IPlatformOperationsProvider;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.PlatformOperationsProvider;
import com.ibm.cic.agent.core.nativeInstallAdapter.desktopMenu.AbstractDesktopElement;
import com.ibm.cic.agent.core.nativeInstallAdapter.desktopMenu.DesktopDirectory;
import com.ibm.cic.agent.core.nativeInstallAdapter.desktopMenu.DesktopEntry;
import com.ibm.cic.agent.core.nativeInstallAdapter.desktopMenu.DesktopMenu;
import com.ibm.cic.agent.core.nativeInstallAdapter.desktopMenu.DesktopMenuHandler;
import com.ibm.cic.agent.core.nativeInstallAdapter.desktopMenu.IOsSpecificPolicy;
import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.Messages;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class WindowsSpecificDesktopMenuPolicy
implements IOsSpecificPolicy {
    public static final String LINK_FILE_EXT = ".lnk";
    public static final String URL_FILE_EXT = ".url";
    File m_contextMenuDir;

    public File getDesktopMenuDir(DesktopMenuHandler handler) {
        if (this.m_contextMenuDir == null) {
            File newDir;
            String dirPath = AgentUserOptions.CIC_START_MENU_ROGRAMS.value();
            if (dirPath == null || dirPath.length() == 0) {
                dirPath = handler.installForAllUsers() ? handler.performVariableSubstitutions("${specialFolder:AllUsersPrograms}") : handler.performVariableSubstitutions("${specialFolder:Programs}");
            }
            if (this.directoryIsWriteable(newDir = new File(dirPath))) {
                this.m_contextMenuDir = newDir;
            }
        }
        return this.m_contextMenuDir;
    }

    public boolean directoryIsWriteable(File dir) {
        boolean return_value = false;
        File theDir = dir;
        while (theDir != null && !theDir.exists()) {
            theDir = theDir.getParentFile();
        }
        if (theDir != null && theDir.isDirectory()) {
            File testShortCut = new File(theDir, "IBMIM_dummy.lib");
            if (!testShortCut.exists()) {
                try {
                    return_value = testShortCut.createNewFile();
                }
                catch (IOException e) {
                    ExceptionUtil.debugLogToReview((Throwable)e);
                }
            } else {
                return_value = true;
            }
            if (return_value) {
                return_value = testShortCut.delete();
            }
        }
        if (!return_value) {
            DesktopMenuHandler.log.warning(Messages.directory_is_not_writeable, new Object[]{dir.getAbsolutePath()});
        } else if (!dir.exists()) {
            return_value = dir.mkdirs();
        }
        return return_value;
    }

    public File calculateContainingDir(AbstractDesktopElement parent, AbstractDesktopElement elem) {
        if (elem instanceof DesktopMenu) {
            return this.getDesktopMenuDir(elem.getHandler());
        }
        if (parent instanceof DesktopEntry) {
            throw new UnsupportedOperationException();
        }
        if (parent instanceof DesktopDirectory) {
            return new File(parent.getContainingDir(), ((DesktopDirectory)parent).getName());
        }
        return parent.getContainingDir();
    }

    public boolean createDiskFiles(DesktopDirectory dir) throws CoreException {
        if (dir.getContainingDir() == null) {
            throw new CoreException((IStatus)Statuses.WARNING.get(Messages.undefined_directory_containing_dir, new Object[]{dir.getName()}));
        }
        File newDir = new File(dir.getContainingDir(), dir.getName());
        if (!newDir.exists()) {
            if (!newDir.mkdir()) {
                throw new CoreException((IStatus)Statuses.WARNING.get(Messages.cant_create_dir, new Object[]{newDir.getAbsolutePath()}));
            }
            DesktopMenuHandler.log.debug(Messages.created_dir, new Object[]{newDir.getAbsolutePath()});
        }
        return true;
    }

    public boolean deleteDiskFiles(DesktopDirectory dir) {
        if (dir.getContainingDir() == null) {
            DesktopMenuHandler.log.warning(NLS.bind((String)Messages.undefined_directory_containing_dir, (Object)dir.getName()));
            return false;
        }
        File theDir = new File(dir.getContainingDir(), dir.getName());
        String[] n = theDir.list();
        if (n != null && n.length == 0) {
            if (!theDir.delete()) {
                DesktopMenuHandler.log.warning(Messages.cant_delete_dir, new Object[]{theDir.getAbsolutePath()});
                return false;
            }
            DesktopMenuHandler.log.debug(Messages.deleted_dir, new Object[]{theDir.getAbsolutePath()});
        }
        return true;
    }

    public boolean createDiskFiles(DesktopEntry entry) throws CoreException {
        boolean return_value;
        if (entry.getContainingDir() == null) {
            throw new CoreException((IStatus)Statuses.WARNING.get(Messages.undefined_desktop_item_containing_dir, new Object[]{entry.getName()}));
        }
        File shortcutFile = WindowsSpecificDesktopMenuPolicy.getShortcutFile(entry);
        String shortcutPath = shortcutFile.getAbsolutePath();
        try {
            IPlatformOperationsProvider provider = PlatformOperationsProvider.getProvider();
            return_value = provider.createShortcut(shortcutPath, entry.getCommand(), entry.getArguments(), entry.getIconPath(), entry.getIconIndex(), entry.getDescription(), entry.getWorkingDirectory());
        }
        catch (CoreException e) {
            boolean return_value2 = false;
            throw new CoreException((IStatus)Statuses.WARNING.get((Throwable)e, Messages.cant_create_shrtcut_file, new Object[]{shortcutPath, entry.getCommand()}));
        }
        if (!return_value) {
            throw new CoreException((IStatus)Statuses.WARNING.get(Messages.cant_create_shrtcut_file, new Object[]{shortcutPath, entry.getCommand()}));
        }
        DesktopMenuHandler.log.debug(Messages.created_file, new Object[]{shortcutPath});
        return return_value;
    }

    public boolean deleteDiskFiles(DesktopEntry entry) {
        File altShortcute;
        if (entry.getContainingDir() == null) {
            DesktopMenuHandler.log.warning(Messages.bind((String)Messages.undefined_desktop_item_containing_dir, (Object)entry.getName()));
            return false;
        }
        File shortcutFile = WindowsSpecificDesktopMenuPolicy.getShortcutFile(entry);
        boolean return_value = shortcutFile.delete();
        if (!return_value && (altShortcute = WindowsSpecificDesktopMenuPolicy.getAltShortcutFile(entry.getContainingDir(), entry.getName(), entry.getCommand())) != null) {
            return_value = altShortcute.delete();
        }
        if (!return_value) {
            DesktopMenuHandler.log.warning(Messages.cant_delete_file, new Object[]{shortcutFile.getAbsolutePath()});
        } else {
            DesktopMenuHandler.log.debug(Messages.deleted_file, new Object[]{shortcutFile.getAbsolutePath()});
        }
        return return_value;
    }

    public boolean createDiskFiles(DesktopMenu menu) {
        return true;
    }

    public boolean deleteDiskFiles(DesktopMenu menu) {
        return true;
    }

    private static File getShortcutFile(DesktopEntry entry) {
        File shortcutFolder = entry.getContainingDir();
        String name = entry.getName();
        String command = entry.getCommand();
        String nonAdminPrefix = name.startsWith(NLS.bind((String)Messages.IBM_Installation_Manager, (Object[])new Object[0])) && !CicCommonSettings.getAccessRightsMode().isAdminMode() && entry.getHandler().isAgentProfile() ? String.valueOf(NLS.bind((String)Messages.folderPrefixForNonAdmin, (Object[])new Object[0])) + " " : "";
        if ((name = String.valueOf(nonAdminPrefix) + name).endsWith(URL_FILE_EXT) || name.endsWith(LINK_FILE_EXT)) {
            return new File(shortcutFolder, name);
        }
        if (FileURLUtil.isURLString((String)command, (boolean)false)) {
            return new File(shortcutFolder, String.valueOf(name) + URL_FILE_EXT);
        }
        return new File(shortcutFolder, String.valueOf(name) + LINK_FILE_EXT);
    }

    private static File getAltShortcutFile(File shortcutFolder, String name, String command) {
        if (!name.endsWith(URL_FILE_EXT) && !name.endsWith(LINK_FILE_EXT) && FileURLUtil.isURLString((String)command, (boolean)false)) {
            return new File(shortcutFolder, String.valueOf(name) + LINK_FILE_EXT);
        }
        return null;
    }
}

