/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.adapters.nativeAdapter.win32;

import com.ibm.cic.agent.core.commonNativeInstallAdapter.IPlatformOperationsProvider;
import com.ibm.cic.common.core.utils.NativeUtils;
import com.ibm.cic.common.core.utils.RebootRequest;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;

public class WinPlatformOperationsProvider
implements IPlatformOperationsProvider {
    private static final String WIN_PLATFORM_OPERATIONS = "winPlatformOperations";
    private static final String USAGE = "WinPlatformOperationsProvider [un]install specialFilePath specialFileType";

    static {
        String dllPath = WinPlatformOperationsProvider.getDllPath();
        if (dllPath == null) {
            System.loadLibrary(WIN_PLATFORM_OPERATIONS);
        } else {
            System.load(dllPath);
        }
    }

    public boolean createShortcut(String path, String targetPath, String arguments, String iconPath, int iconIndex, String description, String workingDirectory) {
        if (path.endsWith(".url")) {
            return WinPlatformOperationsProvider.winCreateURLShortcut(path, targetPath);
        }
        return WinPlatformOperationsProvider.winCreateShortcut(path, targetPath, arguments, iconPath, iconIndex, description, workingDirectory);
    }

    public boolean installFile(String filePath, String type) {
        return WinPlatformOperationsProvider.winInstallFile(filePath, type);
    }

    public boolean uninstallFile(String filePath, String type) {
        return WinPlatformOperationsProvider.winUninstallFile(filePath, type);
    }

    public boolean regWrite(String keyOrValueName, String value, String valueType, int accessMask) {
        return NativeUtils.regWrite((String)keyOrValueName, (String)value, (String)valueType, (int)accessMask);
    }

    @Deprecated
    public boolean regWrite(String keyOrValueName, String value, String valueType) {
        return NativeUtils.regWrite((String)keyOrValueName, (String)value, (String)valueType, (int)512);
    }

    public boolean regWrite(String path, String name, String value, String valueType, int accessMask) {
        return NativeUtils.regWrite((String)path, (String)name, (String)value, (String)valueType, (int)accessMask);
    }

    @Deprecated
    public boolean regWrite(String path, String name, String value, String valueType) {
        return NativeUtils.regWrite((String)path, (String)name, (String)value, (String)valueType, (int)512);
    }

    public String[] regGetSubkeys(String key, int option, int accessMask) {
        return NativeUtils.regGetSubkeys((String)key, (int)option, (int)accessMask);
    }

    @Deprecated
    public String[] regGetSubkeys(String key, int option) {
        return NativeUtils.regGetSubkeys((String)key, (int)option, (int)512);
    }

    public String regRead(String keyOrValueName, boolean expand, int accessMask) {
        return NativeUtils.regRead((String)keyOrValueName, (boolean)expand, (int)accessMask);
    }

    @Deprecated
    public String regRead(String keyOrValueName, boolean expand) {
        return NativeUtils.regRead((String)keyOrValueName, (boolean)expand, (int)512);
    }

    public String regRead(String keyOrValueName, int accessMask) {
        String return_value = this.regRead(keyOrValueName, true, accessMask);
        return return_value;
    }

    @Deprecated
    public String regRead(String keyOrValueName) {
        String return_value = this.regRead(keyOrValueName, true, 512);
        return return_value;
    }

    @Deprecated
    public boolean regDelete(String keyOrValueName) {
        return NativeUtils.regDelete((String)keyOrValueName, (int)512);
    }

    public boolean regDelete(String keyOrValueName, int accessMask) {
        return NativeUtils.regDelete((String)keyOrValueName, (int)accessMask);
    }

    public boolean regDelete(String path, String name, int accessMask) {
        return NativeUtils.regDelete((String)path, (String)name, (int)accessMask);
    }

    @Deprecated
    public boolean regDelete(String path, String name) {
        return NativeUtils.regDelete((String)path, (String)name, (int)512);
    }

    @Deprecated
    public String regDataType(String keyOrValueName) {
        return this.regDataType(keyOrValueName, 512);
    }

    public String regDataType(String keyOrValueName, int accessMask) {
        return NativeUtils.regDataType((String)keyOrValueName, (int)accessMask);
    }

    public boolean deleteAfterReboot(String fileName) {
        boolean return_value = WinPlatformOperationsProvider.winDeleteAfterReboot(fileName);
        if (return_value) {
            RebootRequest.set();
        }
        return return_value;
    }

    public boolean moveAfterReboot(String srcFile, String destFile) {
        boolean return_value = WinPlatformOperationsProvider.winMoveAfterReboot(srcFile, destFile);
        if (return_value) {
            RebootRequest.set();
        }
        return return_value;
    }

    public boolean moveFile(String srcFile, String destFile) {
        return WinPlatformOperationsProvider.winMoveFile(srcFile, destFile);
    }

    static native boolean winCreateShortcut(String var0, String var1, String var2, String var3, int var4, String var5, String var6);

    static native boolean winCreateURLShortcut(String var0, String var1);

    static native boolean winInstallFile(String var0, String var1);

    static native boolean winUninstallFile(String var0, String var1);

    static native boolean winDeleteAfterReboot(String var0);

    static native boolean winMoveAfterReboot(String var0, String var1);

    static native boolean winMoveFile(String var0, String var1);

    static native boolean winEnvRefresh();

    private static String getDllPath() {
        String jarPath = WinPlatformOperationsProvider.getPluginJarPath();
        if (jarPath == null) {
            return null;
        }
        File jarFile = new File(jarPath);
        File jarParentFolder = jarFile.getParentFile();
        File dllFile = new File(jarParentFolder, "os\\win32\\x86\\winPlatformOperations.dll");
        String dllPath = dllFile.getPath();
        return dllPath;
    }

    private static String getPluginJarPath() {
        URL[] urls;
        ClassLoader loader = WinPlatformOperationsProvider.class.getClassLoader();
        if (!(loader instanceof URLClassLoader)) {
            return null;
        }
        URL[] uRLArray = urls = ((URLClassLoader)loader).getURLs();
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            String urlStr = url.toString().toLowerCase();
            if (urlStr.indexOf("/com.ibm.cic.agent.core.nativeinstalladapter.win32") >= 0) {
                return WinPlatformOperationsProvider.getPathFromUrl(url);
            }
            ++n2;
        }
        return null;
    }

    private static String getPathFromUrl(URL url) {
        try {
            URI uri = new URI(url.toString());
            String file = uri.getPath();
            file = file.replace('/', '\\');
            if (file.charAt(0) == '\\') {
                file = file.substring(1);
            }
            return file;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
        WinPlatformOperationsProvider provider = new WinPlatformOperationsProvider();
        if (!provider.run(args)) {
            System.exit(1);
        }
    }

    private boolean run(String[] args) {
        if (args.length != 3) {
            System.err.println(USAGE);
            return false;
        }
        String operation = args[0];
        String filePath = args[1];
        String type = args[2];
        if ("install".equals(operation)) {
            return this.installFile(filePath, type);
        }
        if ("uninstall".equals(operation)) {
            return this.uninstallFile(filePath, type);
        }
        System.err.println(USAGE);
        return false;
    }
}

