/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.adapters.nativeAdapter.win32;

import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.CommonNativeInstallAdapterPlugin;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ICommonNativeInstallOperation;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.IPlatformOperationsProvider;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.PlatformOperationsProvider;
import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.win32.DotNetHandler;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.win32.Messages;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.win32.NativeWin32AdapterPlugin;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.win32.Util;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.win32.WinPlatformOperationsProvider;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.Phases;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.nativeAdapterData.win32.SpecialFileNativeData;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class SpecialFileInstallOperation
extends ICommonNativeInstallOperation {
    private final SpecialFileNativeData data;
    private static String javaExe = null;
    private static String classpath = null;

    public SpecialFileInstallOperation(int phase, IInstallableUnit unit, InstallContext context, SpecialFileNativeData data) {
        super(phase, unit, context);
        this.data = data;
    }

    protected CommonAdapterData getData() {
        return this.data;
    }

    protected IStatus doPerform(IProgressMonitor monitor) throws CoreException {
        String[] types;
        String path = this.getPath();
        DotNetHandler handler = new DotNetHandler();
        String[] stringArray = types = handler.handle(this.getPhase(), path, this.data.getTypes());
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            this.run(path, type);
            ++n2;
        }
        return Status.OK_STATUS;
    }

    private String getPath() throws CoreException {
        String path = this.performVariableSubstitutions(this.data.getPath());
        Path p = new Path(path);
        File file = p.toFile();
        if (!file.isAbsolute()) {
            File installDir = new File(this.getInstallContext().getInstallLocation());
            file = new File(installDir, file.getPath());
        }
        if (!file.exists()) {
            throw Util.coreException(NLS.bind((String)com.ibm.cic.agent.core.commonNativeInstallAdapter.Messages.fileutils_file_not_found, (Object)file), new Object[0]);
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw Util.coreException(e, e.toString(), new Object[0]);
        }
    }

    private void run(String path, String type) throws CoreException {
        if (SpecialFileInstallOperation.getJavaExe().length() == 0 || AgentUserOptions.CIC_REGISTER_DLLS_IN_PROC.isSet()) {
            this.runInProcess(path, type);
        } else {
            this.runOutOfProcess(path, type);
        }
    }

    private void runOutOfProcess(String path, String type) throws CoreException {
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(SpecialFileInstallOperation.getJavaExe());
        cmdList.add("-classpath");
        cmdList.add(SpecialFileInstallOperation.getClasspath());
        cmdList.add(WinPlatformOperationsProvider.class.getName());
        cmdList.add(Phases.phaseToName((int)this.getPhase()));
        cmdList.add(path);
        cmdList.add(type);
        String[] cmdArray = cmdList.toArray(new String[cmdList.size()]);
        StringWriter out = new StringWriter();
        StringWriter err = new StringWriter();
        int status = PlatformUtils.runProcess((String[])cmdArray, null, null, (Writer)out, (Writer)err);
        if (status != 0) {
            String outString = out.toString();
            String errString = err.toString();
            Logger.getGlobalLogger().info("command args: {0}\n  stdout: {1}\n  stderr: {2}", new Object[]{cmdList.toString(), outString, errString});
            throw Util.coreException(NLS.bind((String)Messages.special_file_error, (Object[])new Object[]{Phases.phaseToName((int)this.getPhase()), path, type}), new Object[0]);
        }
    }

    private void runInProcess(String path, String type) throws CoreException {
        IPlatformOperationsProvider provider = PlatformOperationsProvider.getProvider();
        boolean succeeded = true;
        if (this.getPhase() == 21) {
            succeeded = provider.installFile(path, type);
        } else if (this.getPhase() == 51) {
            succeeded = provider.uninstallFile(path, type);
        }
        if (!succeeded) {
            throw Util.coreException(NLS.bind((String)Messages.special_file_error, (Object[])new Object[]{Phases.phaseToName((int)this.getPhase()), path, type}), new Object[0]);
        }
    }

    private static String getJavaExe() {
        if (javaExe == null) {
            javaExe = SpecialFileInstallOperation.findJavaExe();
        }
        return javaExe;
    }

    private static String findJavaExe() {
        File java;
        String javaHome = System.getProperty("java.home");
        if (javaHome != null && (java = new File(javaHome, "bin\\java.exe")).exists()) {
            return java.getPath();
        }
        Logger.getGlobalLogger().warning("cannot find java.exe in java.home");
        return "";
    }

    private static String getWin32NativeInstallAdapterClasspath() {
        Bundle bundle = NativeWin32AdapterPlugin.getDefault().getBundle();
        File pluginLocation = new File(PlatformUtils.getInstallLocation((Bundle)bundle));
        assert (pluginLocation.isDirectory()) : "nativeInstallAdapter.win32 is not a directory plugin";
        File binDir = new File(pluginLocation, "bin");
        if (binDir.isDirectory()) {
            return binDir.getPath();
        }
        File jarFile = new File(pluginLocation, "nativeInstallAdapterWin32.jar");
        return jarFile.getPath();
    }

    private static String getCommonNativeInstallAdapterClasspath() {
        File binDir;
        Bundle bundle = CommonNativeInstallAdapterPlugin.getDefault().getBundle();
        File pluginLocation = new File(PlatformUtils.getInstallLocation((Bundle)bundle));
        if (pluginLocation.isDirectory() && (binDir = new File(pluginLocation, "bin")).isDirectory()) {
            pluginLocation = binDir;
        }
        return pluginLocation.getPath();
    }

    private static String getClasspath() {
        if (classpath == null) {
            classpath = String.valueOf(SpecialFileInstallOperation.getWin32NativeInstallAdapterClasspath()) + File.pathSeparatorChar + SpecialFileInstallOperation.getCommonNativeInstallAdapterClasspath();
        }
        return classpath;
    }
}

