/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.adapters.nativeAdapter.win32;

import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ICommonNativeInstallOperation;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.IPlatformOperationsProvider;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.PlatformOperationsProvider;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.win32.Messages;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.win32.NativeWin32AdapterPlugin;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.Phases;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.nativeAdapterData.win32.ShortcutNativeData;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class ShortcutInstallOperation
extends ICommonNativeInstallOperation {
    private static final Logger log = Logger.getLogger(ShortcutInstallOperation.class, (Plugin)NativeWin32AdapterPlugin.getDefault());
    private final ShortcutNativeData data;

    public ShortcutInstallOperation(int phase, IInstallableUnit unit, InstallContext context, ShortcutNativeData data) {
        super(phase, unit, context);
        this.data = data;
    }

    protected CommonAdapterData getData() {
        return this.data;
    }

    protected IStatus doPerform(IProgressMonitor monitor) throws CoreException {
        String path = this.performVariableSubstitutions(this.data.getPath());
        if (this.getPhase() == 21) {
            String workingDirectory;
            String description;
            int iconIndex;
            String iconPath;
            String arguments;
            String targetPath;
            IPlatformOperationsProvider provider = PlatformOperationsProvider.getProvider();
            boolean succeeded = provider.createShortcut(path, targetPath = this.performVariableSubstitutions(this.data.getTargetPath()), arguments = this.performVariableSubstitutions(this.data.getArguments()), iconPath = this.performVariableSubstitutions(this.data.getIconPath()), iconIndex = this.data.getIconIndex(), description = this.performVariableSubstitutions(this.data.getDescription()), workingDirectory = this.performVariableSubstitutions(this.data.getWorkingDirectory()));
            return succeeded ? Status.OK_STATUS : Statuses.WARNING.get(Messages.shortcut_warning, new Object[]{Phases.phaseToName((int)this.getPhase()), path});
        }
        File f = new File(path);
        if (!f.delete()) {
            log.warning(Messages.shortcut_warning, new Object[]{Phases.phaseToName((int)this.getPhase()), path});
        }
        return Status.OK_STATUS;
    }
}

