/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.adapters.nativeAdapter.win32;

import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ICommonNativeInstallOperation;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.IPlatformOperationsProvider;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.PlatformOperationsProvider;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.win32.Messages;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.win32.Util;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.Phases;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.nativeAdapterData.win32.RegistryKeyNativeData;
import com.ibm.cic.common.nativeAdapterData.win32.RegistryNativeData;
import com.ibm.cic.common.nativeAdapterData.win32.RegistryValueNativeData;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class RegistryInstallOperation
extends ICommonNativeInstallOperation {
    private final RegistryNativeData data;
    private IPlatformOperationsProvider provider;
    private int accessMask;

    public RegistryInstallOperation(int phase, IInstallableUnit unit, InstallContext context, RegistryNativeData data) {
        super(phase, unit, context);
        this.data = data;
    }

    protected CommonAdapterData getData() {
        return this.data;
    }

    protected IStatus doPerform(IProgressMonitor monitor) throws CoreException {
        this.provider = PlatformOperationsProvider.getProvider();
        String keyPath = String.valueOf(this.performVariableSubstitutions(this.data.getName())) + '\\';
        boolean replace = this.data.replace();
        this.accessMask = this.data.getAccessMaskIntValue();
        if (this.getPhase() == 21) {
            if (replace) {
                this.provider.regDelete(keyPath, this.accessMask);
            }
            this.addRegistryValues(null, (RegistryKeyNativeData)this.data);
        } else if (this.getPhase() == 51) {
            if (replace) {
                if (!this.provider.regDelete(keyPath, this.accessMask) && !this.isDelete()) {
                    throw Util.coreException(NLS.bind((String)Messages.registry_delete_error, (Object)Phases.phaseToName((int)this.getPhase()), (Object)keyPath), new Object[0]);
                }
            } else {
                this.removeRegistryValues(null, (RegistryKeyNativeData)this.data);
            }
        }
        return Status.OK_STATUS;
    }

    private boolean isDelete() {
        return this.data.replace() && this.data.getValue() == null && this.data.getValues().length == 0 && this.data.getKeys().length == 0;
    }

    private void addRegistryValues(String path, RegistryKeyNativeData key) throws CoreException {
        RegistryKeyNativeData[] subkeys;
        RegistryValueNativeData[] values;
        String keyName = this.performVariableSubstitutions(key.getName());
        String newPath = path == null ? keyName : String.valueOf(path) + keyName;
        String newPathWithSlash = String.valueOf(newPath) + '\\';
        String defaultValue = this.performVariableSubstitutions(key.getValue());
        String defaultValueType = key.getType();
        if (defaultValue != null && !this.provider.regWrite(newPathWithSlash, defaultValue, defaultValueType, this.accessMask)) {
            throw Util.coreException(NLS.bind((String)Messages.registry_write_error, (Object)Phases.phaseToName((int)this.getPhase()), (Object)newPathWithSlash), new Object[0]);
        }
        RegistryValueNativeData[] registryValueNativeDataArray = values = key.getValues();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String valueType;
            String value;
            RegistryValueNativeData valueData = registryValueNativeDataArray[n2];
            String valueName = this.performVariableSubstitutions(valueData.getName());
            if (!this.provider.regWrite(newPath, valueName, value = this.performVariableSubstitutions(valueData.getValue()), valueType = valueData.getType(), this.accessMask)) {
                String valuePath = String.valueOf(newPathWithSlash) + valueName;
                throw Util.coreException(NLS.bind((String)Messages.registry_write_error, (Object)Phases.phaseToName((int)this.getPhase()), (Object)valuePath), new Object[0]);
            }
            ++n2;
        }
        RegistryKeyNativeData[] registryKeyNativeDataArray = subkeys = key.getKeys();
        int n3 = subkeys.length;
        n = 0;
        while (n < n3) {
            RegistryKeyNativeData subkey = registryKeyNativeDataArray[n];
            this.addRegistryValues(newPathWithSlash, subkey);
            ++n;
        }
    }

    private void removeRegistryValues(String path, RegistryKeyNativeData key) throws CoreException {
        RegistryKeyNativeData[] subkeys;
        RegistryValueNativeData[] values;
        String keyName = this.performVariableSubstitutions(key.getName());
        String newPath = path == null ? keyName : String.valueOf(path) + keyName;
        String newPathWithSlash = String.valueOf(newPath) + '\\';
        String defaultValue = this.performVariableSubstitutions(key.getValue());
        if (defaultValue != null && !this.provider.regWrite(newPathWithSlash, "", null, this.accessMask)) {
            throw Util.coreException(NLS.bind((String)Messages.registry_write_error, (Object)Phases.phaseToName((int)this.getPhase()), (Object)newPathWithSlash), new Object[0]);
        }
        RegistryValueNativeData[] registryValueNativeDataArray = values = key.getValues();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            RegistryValueNativeData valueData = registryValueNativeDataArray[n2];
            String valueName = this.performVariableSubstitutions(valueData.getName());
            if (!this.provider.regDelete(newPath, valueName, this.accessMask)) {
                String valuePath = String.valueOf(newPathWithSlash) + valueName;
                throw Util.coreException(NLS.bind((String)Messages.registry_delete_error, (Object)Phases.phaseToName((int)this.getPhase()), (Object)valuePath), new Object[0]);
            }
            ++n2;
        }
        RegistryKeyNativeData[] registryKeyNativeDataArray = subkeys = key.getKeys();
        int n3 = subkeys.length;
        n = 0;
        while (n < n3) {
            RegistryKeyNativeData subkey = registryKeyNativeDataArray[n];
            this.removeRegistryValues(newPathWithSlash, subkey);
            ++n;
        }
    }
}

