/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.adapters.nativeAdapter.win32;

import com.ibm.cic.agent.core.IInstallAdaptor;
import com.ibm.cic.agent.core.IInstallOperation;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ICommonNativeInstallAdapter;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.win32.DesktopIconWin32InstallOperation;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.win32.EnvironmentInstallOperation;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.win32.RegistryInstallOperation;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.win32.ShortcutInstallOperation;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.win32.SpecialFileInstallOperation;
import com.ibm.cic.common.commonNativeAdapterData.ICommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.PerformCommonNativeData;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.nativeAdapterData.win32.DesktopIconWin32NativeData;
import com.ibm.cic.common.nativeAdapterData.win32.EnvironmentNativeData;
import com.ibm.cic.common.nativeAdapterData.win32.RegistryNativeData;
import com.ibm.cic.common.nativeAdapterData.win32.ShortcutNativeData;
import com.ibm.cic.common.nativeAdapterData.win32.SpecialFileNativeData;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class NativeWin32InstallAdapter
extends ICommonNativeInstallAdapter
implements IInstallAdaptor {
    private static final String ID = "nativeWin32";
    private static Logger log = Logger.getLogger(NativeWin32InstallAdapter.class);

    public String getId() {
        return ID;
    }

    public IStatus preInstallConfigure(InstallableUnitPair pair, InstallContext context, IProgressMonitor monitor) {
        return this.perform(10, 40, pair, context, monitor);
    }

    public IStatus install(InstallableUnitPair pair, InstallContext context, IProgressMonitor monitor) {
        return this.perform(21, 51, pair, context, monitor);
    }

    public IStatus postInstallConfigure(InstallableUnitPair pair, InstallContext context, IProgressMonitor monitor) {
        return this.perform(30, 60, pair, context, monitor);
    }

    protected Logger getLog() {
        return log;
    }

    protected void dispatcher(int phase, IInstallableUnit unit, InstallContext context, ICommonNativeData data, IProgressMonitor monitor) throws CoreException {
        boolean processed = this.processCommonOperation(phase, unit, context, data, monitor);
        if (!processed) {
            if (data instanceof RegistryNativeData) {
                this.handleRegistryOperation(phase, unit, context, (RegistryNativeData)data, monitor);
            } else if (data instanceof ShortcutNativeData) {
                this.handleShortcutOperation(phase, unit, context, (ShortcutNativeData)data, monitor);
            } else if (data instanceof DesktopIconWin32NativeData) {
                this.handleDesktopOperation(phase, unit, context, (DesktopIconWin32NativeData)data, monitor);
            } else if (data instanceof SpecialFileNativeData) {
                this.handleSpecialFileOperation(phase, unit, context, (SpecialFileNativeData)data, monitor);
            } else if (data instanceof EnvironmentNativeData) {
                this.handleEnvironmentOperation(phase, unit, context, (EnvironmentNativeData)data, monitor);
            }
        }
    }

    private void handleRegistryOperation(int phase, IInstallableUnit unit, InstallContext context, RegistryNativeData data, IProgressMonitor monitor) throws CoreException {
        RegistryInstallOperation op = new RegistryInstallOperation(phase, unit, context, data);
        context.performOperation((IInstallOperation)op, monitor);
    }

    private void handleShortcutOperation(int phase, IInstallableUnit unit, InstallContext context, ShortcutNativeData data, IProgressMonitor monitor) throws CoreException {
        ShortcutInstallOperation op = new ShortcutInstallOperation(phase, unit, context, data);
        context.performOperation((IInstallOperation)op, monitor);
    }

    private void handleDesktopOperation(int phase, IInstallableUnit unit, InstallContext context, DesktopIconWin32NativeData data, IProgressMonitor monitor) throws CoreException {
        DesktopIconWin32InstallOperation op = new DesktopIconWin32InstallOperation(phase, unit, context, data);
        context.performOperation((IInstallOperation)op, monitor);
    }

    private void handleSpecialFileOperation(int phase, IInstallableUnit unit, InstallContext context, SpecialFileNativeData data, IProgressMonitor monitor) throws CoreException {
        SpecialFileInstallOperation op = new SpecialFileInstallOperation(phase, unit, context, data);
        context.performOperation((IInstallOperation)op, monitor);
    }

    private void handleEnvironmentOperation(int phase, IInstallableUnit unit, InstallContext context, EnvironmentNativeData data, IProgressMonitor monitor) throws CoreException {
        EnvironmentInstallOperation op = new EnvironmentInstallOperation(phase, unit, context, data);
        context.performOperation((IInstallOperation)op, monitor);
    }

    protected void customOperation(int phase, IInstallableUnit unit, InstallContext context, ICommonNativeData data, PerformCommonNativeData performData, IProgressMonitor monitor) throws CoreException {
        this.processCommonPerformOperation(phase, unit, context, data, performData, monitor);
    }
}

