/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.adapters.nativeAdapter.win32;

import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ICommonNativeInstallOperation;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.win32.WinPlatformOperationsProvider;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.nativeAdapterData.win32.EnvironmentNativeData;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class EnvironmentInstallOperation
extends ICommonNativeInstallOperation {
    private static final String ENV_ALL_USER_REG = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment\\";
    private static final String ENV_CURR_USER_REG = "HKEY_CURRENT_USER\\Environment\\";
    private static final char PATH_SEPARATOR_WIN = ';';
    private final EnvironmentNativeData data;

    public EnvironmentInstallOperation(int phase, IInstallableUnit unit, InstallContext context, EnvironmentNativeData data) {
        super(phase, unit, context);
        this.data = data;
    }

    protected CommonAdapterData getData() {
        return this.data;
    }

    protected IStatus doPerform(IProgressMonitor monitor) throws AbstractVariableSubstitution.VariableSubstitutionException {
        String name = this.performVariableSubstitutions(this.data.getName());
        String value = this.performVariableSubstitutions(this.data.getValue());
        boolean append = this.data.isAppend();
        boolean prepend = this.data.isPrepend();
        if (this.getPhase() == 21) {
            this.createEnvForWindows(name, value, append, prepend, this.data.installForAllUsers());
        } else if (this.getPhase() == 51) {
            this.removeEnvForWindows(name, value, append, prepend, this.data.installForAllUsers());
        }
        return Status.OK_STATUS;
    }

    private void createEnvForWindows(String name, String value, boolean append, boolean prepend, boolean installForAllUsers) {
        String currValue;
        WinPlatformOperationsProvider provider = new WinPlatformOperationsProvider();
        String parentKey = installForAllUsers ? ENV_ALL_USER_REG : ENV_CURR_USER_REG;
        String key = String.valueOf(parentKey) + name;
        String newValue = !append && !prepend ? value : ((currValue = provider.regRead(key, false, 512)) == null ? value : (append ? String.valueOf(currValue) + ';' + value : (prepend ? String.valueOf(value) + ';' + currValue : null)));
        if (newValue != null) {
            String type = provider.regDataType(key, 512);
            provider.regWrite(key, newValue, type, 512);
            WinPlatformOperationsProvider.winEnvRefresh();
        }
    }

    private void removeEnvForWindows(String name, String value, boolean append, boolean prepend, boolean installForAllUsers) {
        WinPlatformOperationsProvider provider = new WinPlatformOperationsProvider();
        String parentKey = installForAllUsers ? ENV_ALL_USER_REG : ENV_CURR_USER_REG;
        String key = String.valueOf(parentKey) + name;
        String currValue = provider.regRead(key, false, 512);
        if (currValue == null) {
            return;
        }
        if (!append && !prepend) {
            provider.regDelete(key, 512);
            WinPlatformOperationsProvider.winEnvRefresh();
            return;
        }
        StringTokenizer st = new StringTokenizer(currValue, String.valueOf(';'));
        StringBuffer strBuf = new StringBuffer();
        boolean emptyBuf = true;
        boolean varFound = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(value) && !varFound) {
                varFound = true;
                continue;
            }
            if (!emptyBuf) {
                strBuf.append(';');
            } else {
                emptyBuf = false;
            }
            strBuf.append(token);
        }
        if (emptyBuf) {
            provider.regDelete(key, 512);
            WinPlatformOperationsProvider.winEnvRefresh();
        } else {
            String newValue = strBuf.toString();
            if (!newValue.equals(currValue)) {
                String type = provider.regDataType(key, 512);
                provider.regWrite(key, newValue, type, 512);
                WinPlatformOperationsProvider.winEnvRefresh();
            }
        }
    }
}

