/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.adapters.nativeAdapter.win32;

import com.ibm.cic.agent.internal.adapters.nativeAdapter.win32.Messages;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.win32.NativeWin32AdapterPlugin;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.win32.Util;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.PlatformUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

public class DotNetHandler {
    private static final String FILE = "file";
    private static final String SW_GAC_INST = "-gi";
    private static final String SW_GAC_UNINST = "-gu";
    private static final String SW_REGASM_INST = "-ri";
    private static final String SW_REGASM_UNINST = "-ru";
    private static final String EXE_NAME = "DotNetHandler.exe";
    private static final int ERR_BAD_ARGS = -1;
    private static final int ERR_BAD_FILE = -2;
    private static final int ERR_REGASM_FAILED = -3;
    private static final int ERR_UNREGASM_FAILED = -4;
    private static final int ERR_GAC_INSTALL_FAILED = -5;
    private static final int ERR_GAC_UNINSTALL_FAILED = -6;
    private String fExePath;

    public String[] handle(int phase, String path, String[] types) throws CoreException {
        ArrayList<String> unhandled = new ArrayList<String>(types.length);
        boolean gac = false;
        boolean regasm = false;
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type.equals("Gacutil")) {
                gac = true;
            } else if (type.equals("Regasm")) {
                regasm = true;
            } else {
                unhandled.add(type);
            }
            ++n2;
        }
        if (regasm || gac) {
            this.fExePath = DotNetHandler.getExePath();
            if (phase == 21) {
                this.install(path, gac, regasm);
            } else if (phase == 51) {
                this.uninstall(path, gac, regasm);
            }
        }
        String[] ret = new String[unhandled.size()];
        return unhandled.toArray(ret);
    }

    public void install(String path, boolean gac, boolean regasm) throws CoreException {
        String[] cmd = this.cmdLine(path, gac, regasm, true);
        this.runProcess(cmd, path);
    }

    public void uninstall(String path, boolean gac, boolean regasm) throws CoreException {
        String[] cmd = this.cmdLine(path, gac, regasm, false);
        this.runProcess(cmd, path);
    }

    private void runProcess(String[] cmd, String assemPath) throws CoreException {
        StringWriter out = new StringWriter();
        int status = PlatformUtils.runProcess((String[])cmd, null, (File)new File(this.fExePath).getParentFile(), (Writer)out, (Writer)out);
        if (status < 0) {
            String outString = out.toString();
            throw Util.coreException(this.decodeReturnValue(status, assemPath, outString), new Object[0]);
        }
    }

    private String[] cmdLine(String path, boolean gac, boolean regasm, boolean installPhase) {
        ArrayList<String> strs = new ArrayList<String>(4);
        strs.add(this.fExePath);
        strs.add(path);
        if (installPhase) {
            if (gac) {
                strs.add(SW_GAC_INST);
            }
            if (regasm) {
                strs.add(SW_REGASM_INST);
            }
        } else {
            if (gac) {
                strs.add(SW_GAC_UNINST);
            }
            if (regasm) {
                strs.add(SW_REGASM_UNINST);
            }
        }
        String[] ret = new String[strs.size()];
        ret = strs.toArray(ret);
        return ret;
    }

    private String decodeReturnValue(int retVal, String path, String errOutput) {
        switch (retVal) {
            case -1: {
                return NLS.bind((String)Messages.DotNetHandler_errBadArg, (Object)path, (Object)errOutput);
            }
            case -2: {
                return NLS.bind((String)Messages.DotNetHandler_errBadAssembly, (Object)path, (Object)errOutput);
            }
            case -3: {
                return NLS.bind((String)Messages.DotNetHandler_errRegAsmFailed, (Object)path, (Object)errOutput);
            }
            case -4: {
                return NLS.bind((String)Messages.DotNetHandler_errUnRegAsmFailed, (Object)path, (Object)errOutput);
            }
            case -5: {
                return NLS.bind((String)Messages.DotNetHandler_errGacInstallFail, (Object)path, (Object)errOutput);
            }
            case -6: {
                return NLS.bind((String)Messages.DotNetHandler_errGacUninstallFail, (Object)path, (Object)errOutput);
            }
        }
        return NLS.bind((String)Messages.DotNetHandler_errUnkownResponse, (Object)retVal, (Object)(String.valueOf(path) + "\n" + errOutput));
    }

    private static String getExePath() throws CoreException {
        String root = DotNetHandler.getPluginPath();
        File osRoot = new File(root, "os\\Win32\\x86\\");
        File exeFile = new File(osRoot, EXE_NAME);
        String exePath = exeFile.getPath();
        return exePath;
    }

    private static String getPluginPath() throws CoreException {
        URL url = FileLocator.find((Bundle)NativeWin32AdapterPlugin.getDefault().getBundle(), (IPath)new Path(""), null);
        if (url != null) {
            try {
                return DotNetHandler.getPathFromUrl(FileLocator.resolve((URL)url));
            }
            catch (IOException e) {
                throw Util.coreException(e, Messages.DotNetHandler_errPluginRootNotFound, new Object[0]);
            }
        }
        return null;
    }

    private static String getPathFromUrl(URL url) {
        try {
            if (url.getProtocol().equals(FILE)) {
                return url.getFile();
            }
            URI uri = new URI(url.toString());
            String file = uri.getPath();
            if ((file = file.replace('/', '\\')).charAt(0) == '\\') {
                file = file.substring(1);
            }
            return file;
        }
        catch (Exception e) {
            return null;
        }
    }
}

